VERSION 5.00
Object = "{AC257169-4143-4819-B3CF-F18F23CD14EC}#1.0#0"; "FPImage.dll"
Begin VB.Form frmMain 
   BackColor       =   &H80000018&
   Caption         =   "FPImage tester"
   ClientHeight    =   7785
   ClientLeft      =   1605
   ClientTop       =   1605
   ClientWidth     =   8730
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7785
   ScaleWidth      =   8730
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame frmVeriFinger 
      Caption         =   "VeriFinger"
      Height          =   855
      Left            =   5760
      TabIndex        =   10
      Top             =   5640
      Width           =   2895
   End
   Begin VB.Frame frmScanner 
      Caption         =   "Scanner"
      Height          =   5175
      Left            =   5760
      TabIndex        =   6
      Top             =   120
      Width           =   2895
      Begin VB.ListBox lstScnStatus 
         Height          =   3375
         Left            =   120
         TabIndex        =   12
         Top             =   1680
         Width           =   2655
      End
      Begin VB.CheckBox chkScnOne 
         Caption         =   "Stop after the first image"
         Height          =   255
         Left            =   120
         TabIndex        =   9
         Top             =   960
         Width           =   2175
      End
      Begin VB.CommandButton btnStop 
         Caption         =   "Stop"
         Enabled         =   0   'False
         Height          =   375
         Left            =   1440
         TabIndex        =   8
         Top             =   360
         Width           =   1215
      End
      Begin VB.CommandButton btnStart 
         Caption         =   "Start"
         Height          =   375
         Left            =   120
         TabIndex        =   7
         Top             =   360
         Width           =   1215
      End
      Begin VB.Label labScnStatus 
         Caption         =   "Scanner Status"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   1440
         Width           =   1695
      End
   End
   Begin VB.Frame frmImage 
      Caption         =   "FPImage"
      Height          =   7575
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   4935
      Begin VB.CheckBox chkImgShowBinarizedImage 
         Caption         =   "Show binarized image"
         Height          =   255
         Left            =   2640
         TabIndex        =   13
         Top             =   6840
         Width           =   2055
      End
      Begin FPImageLibCtl.FPImage FPImage 
         Height          =   6015
         Left            =   120
         OleObjectBlob   =   "frmMain.frx":0000
         TabIndex        =   1
         Top             =   240
         Width           =   4695
      End
      Begin VB.CheckBox chkImgStretch 
         Caption         =   "Strecth image"
         Height          =   255
         Left            =   2640
         TabIndex        =   5
         Top             =   7200
         Width           =   1935
      End
      Begin VB.CheckBox chkImgVeriFinger 
         Caption         =   "Set VeriFinger"
         Height          =   255
         Left            =   120
         TabIndex        =   3
         Top             =   6840
         Width           =   1575
      End
      Begin VB.CheckBox chkImgShowFeatures 
         Caption         =   "Show features"
         Height          =   255
         Left            =   2640
         TabIndex        =   4
         Top             =   6480
         Width           =   1935
      End
      Begin VB.CheckBox chkImgScanner 
         Caption         =   "Set scanner"
         Height          =   255
         Left            =   120
         TabIndex        =   2
         Top             =   6480
         Width           =   1575
      End
   End
   Begin VB.Line lineImg2VF 
      BorderColor     =   &H80000010&
      BorderWidth     =   3
      Visible         =   0   'False
      X1              =   5040
      X2              =   5760
      Y1              =   6120
      Y2              =   6120
   End
   Begin VB.Line lineImg2Scn 
      BorderColor     =   &H80000010&
      BorderWidth     =   3
      Visible         =   0   'False
      X1              =   5040
      X2              =   5760
      Y1              =   2040
      Y2              =   2040
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim WithEvents Scanner As FPScannerUareU
Attribute Scanner.VB_VarHelpID = -1
'Dim WithEvents Scanner As FPScannerBiometrika
'Dim WithEvents Scanner As FPScannerFile
Dim VFinger As IVeriFinger

Private Sub Form_Load()
    ' Create scanner object
    Set Scanner = New FPScannerUareU
'    Set Scanner = New FPScannerBiometrika
'    Set Scanner = New FPScannerFile

    ' Set feature exraction object
    Set VFinger = New VeriFinger
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Scanner.StopCapturing
    FPImage.Scanner = Empty
    FPImage.VeriFinger = Empty
    Set VFinger = Nothing
    Set Scanner = Nothing
End Sub

Private Sub chkImgScanner_Click()
    If chkImgScanner Then
        FPImage.Scanner = Scanner
    Else
        FPImage.Scanner = Empty
    End If
    lineImg2Scn.Visible = chkImgScanner
End Sub

Private Sub chkImgVeriFinger_Click()
    If chkImgVeriFinger Then
        FPImage.VeriFinger = VFinger
    Else
        FPImage.VeriFinger = Empty
    End If
    lineImg2VF.Visible = chkImgVeriFinger
End Sub

Private Sub chkImgShowFeatures_Click()
    FPImage.ShowFeatures = chkImgShowFeatures
End Sub

Private Sub chkImgShowBinarizedImage_Click()
    FPImage.ShowBinarizedImage = chkImgShowBinarizedImage
End Sub

Private Sub chkImgStretch_Click()
    FPImage.StretchImage = chkImgStretch
End Sub

Private Sub btnStart_Click()
    If (0 = Scanner.DeviceCount) Then
        MsgBox "No scanner connected.", vbExclamation
        Exit Sub
    End If
    On Error GoTo Err_btnStart_Click
    lstScnStatus.Clear
    If chkScnOne Then
        Scanner.CaptureOneImage 0
    Else
        Scanner.StartCapturing
    End If
    btnStop.Enabled = True
    btnStart.Enabled = False
    chkScnOne.Enabled = False
    Exit Sub
Err_btnStart_Click:
    MsgBox "Error 0x" + Hex(Err.Number) + " has occured" + Chr(13) + """" + Err.Description + """", vbExclamation
End Sub

Private Sub btnStop_Click()
    On Error GoTo Err_btnStop_Click
    Scanner.StopCapturing
    btnStart.Enabled = True
    btnStop.Enabled = False
    chkScnOne.Enabled = True
    Exit Sub
Err_btnStop_Click:
    MsgBox "Error 0x" + Hex(Err.Number) + " has occured" + Chr(13) + """" + Err.Description + """", vbExclamation
End Sub

Private Sub Scanner_Image(ByVal Width As Long, ByVal Height As Long, Image As Variant)
    If chkScnOne Then
        btnStart.Enabled = True
        btnStop.Enabled = False
        chkScnOne.Enabled = True
    End If
End Sub

Private Sub Scanner_Status(ByVal Status As Long)
    Dim msg As String
    Select Case Status
    Case FPS_STATUS_WAITING_FOR_IMAGE:  msg = "Waiting ..."
    Case FPS_STATUS_IMAGE_READY:        msg = "Ready"
    Case FPS_STATUS_FINGER_TOUCHING:    msg = "Finger touching ..."
    Case FPS_STATUS_FINGER_REMOVED:     msg = "Finger removed ..."
    Case FPS_STATUS_CONNECTION_ERROR:   msg = "Finger removed ..."
    End Select
    lstScnStatus.AddItem msg, 0
    If 15 < lstScnStatus.ListCount Then
        lstScnStatus.RemoveItem 15
    End If
End Sub

Private Sub Scanner_DeviceStatus(ByVal Status As Long, ByVal ID As String)
    Dim msg As String
    Select Case Status
    Case FPS_DEVICE_STATUS_PLUGGED:         msg = "Device plugged '" + ID + "'"
    Case FPS_DEVICE_STATUS_UNPLUGGED:       msg = "Device unplugged '" + ID + "'"
    Case FPS_DEVICE_STATUS_UNKNOWN_ERROR:   msg = "Device unknown error '" + ID + "'"
    Case FPS_DEVICE_STATUS_ERROR:           msg = "Device error '" + ID + "'"
    End Select
    lstScnStatus.AddItem msg, 0
    If 15 < lstScnStatus.ListCount Then
        lstScnStatus.RemoveItem 15
    End If
End Sub


