/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

namespace XSP
{

   // one should derive of this any interface with refcounting
   class ref_interface
   {
   public:
   		virtual void addref() = 0;
   		virtual void release() = 0;
   };
   
   // for object with multiple interfaces derive of this, 
   // export the addref and release in each interface
   // the virtual destructor will cleanup the agregate object
   class ref_obj
   {
   protected:
   		uint32  ref_count;
   protected:
   		ref_obj();
   		virtual ~ref_obj();
   public:
   		inline void addref() { ++ref_count; }
   		void release();

		static  void Fail();
   };
   
   
   
   // the safe refcount handle
   template <typename T>
   class refc
   {
   		T*  obj;
   public:
   		refc() : obj(0) {}
   		refc(T* const t);		
   		refc(const refc& r);		
   		
   		inline ~refc() { release(); }
   		void release();
   		
   		refc& operator = (T* const t);	
   		refc& operator = (const refc& r);	

   		inline bool operator == (const T* const t) const { return t == obj; }	
   		inline bool operator == (const refc& r) const { return r.obj == obj; }	
   		inline bool operator != (const T* const t) const { return t != obj; }	
   		inline bool operator != (const refc& r) const { return r.obj != obj; }	
   		
   		T* operator -> () const; 
   };

   // safe pointer entirely owns the pointed object
   // ownership cannot be transfered to others
   template <typename T>
   class ptr
   {
   		T*  obj;

   private: 
   		// do not allow copying of an owned pointer (use refc instead)
         	ptr(const ptr& r);		
   		void operator = (const ptr& r);	

   public:
   		inline ptr() : obj(0) {}
   		inline explicit ptr(T* const t) : obj(t) {}		
   		
   		inline ~ptr() { delete obj; }
   		
   		inline void operator = (T* const t) { delete obj; obj = t; }	

   		inline bool operator == (T* const t) const { return t == obj; }	
   		inline bool operator == (const ptr& r) const { return r.obj == obj; }	
   		inline bool operator != (T* const t) const { return t != obj; }	
   		inline bool operator != (const ptr& r) const { return r.obj != obj; }	
   		
   		inline T* operator -> () const;
   		inline T& operator * () const; 
   		
   		inline T* get_ptr() const { return obj; }
   };


        template <typename T>
	inline T* refc<T>::operator -> () const 
	{ 
		if(obj==0)
		    ref_obj::Fail();
		return obj; 
	}
   
	template <typename T>
	refc<T>::refc(T* const t) 
	: obj(t) 
	{ 
		if (obj != 0) 
		    obj->addref();
	}		
    
        template <typename T>
	refc<T>::refc(const refc& r) 
	: obj(r.obj) 
	{ 
		if (obj != 0) 
		    obj->addref();
	}		

	template <typename T>
    void refc<T>::release() 
	{ 
   		if (obj != 0) 
   		{ 
   			T* t=obj; 
   			obj=0; 
   			t->release(); 
   		} 
   	}
    
    template <typename T>
	refc<T>& refc<T>::operator = (T* const t) 
	{ 
		if (t != obj) 
		{ //??
			if (t != 0) t->addref();
			release(); 
			obj=t; 
		} 
		return *this;
	}	
	
	template <typename T>
	refc<T>& refc<T>::operator = (const refc& r) 
	{ 
		T* tmp = r.obj;
		if (tmp != obj) 
		{ //??
			if (tmp != 0) tmp->addref();
			release(); 
			obj=tmp; 
		} 
		return *this;
	}	
  



	template <typename T>
	inline T* ptr<T>::operator -> () const 
	{ 
	    if(obj==0)
	        ref_obj::Fail();
	    return obj; 
	}
	
	template <typename T>
	inline T& ptr<T>::operator * () const 
	{ 
	    if(obj==0)
	        ref_obj::Fail();
	    return *obj; 
	}


} // namespace XSP
