/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

namespace XSP
{
    // for fast multiOS interaction both c_str and p_str must be in place conversions
    // this "little" requirement makes us need a brand new String class 
	class String 
	{
    public:
		typedef char* iterator;
		typedef const char* const_iterator;
		typedef uint32 size_type;
		typedef char value_type;
	public:
		// the empty string constant
		static const String kEmpty; 
	    
	    String();
		String(const String& s);
	    ~String();
	    
	    inline size_type length() const { return _length(); }
	    inline bool isEmpty() const { return 0 == _length(); }

		size_type capacity() const;
		void reserve(size_type z); // set capacity, preserve length, preserve content
		void resize(size_type z); // set length and capacity to z (preserve content) 
		void compact(); // resize to the current length
		void setsize(size_type z);	 // sets the length of the string no change capacity

		String& assign(const String& s);
		inline String& operator = (const String& s) { return assign(s); }
		void swap(String& s);
	    void clear();
    public:
		// number formating
		static String From_uint64(uint64 n, uint32 baseN = 10); 
		static String From_sint64(sint64 n, uint32 baseN = 10); 
		uint64 To_uint64() const;
		sint64 To_sint64() const;

		static String From_uint32(uint32 n, uint32 baseN = 10)
		{ return From_uint64(n,baseN); } 
		static String From_sint32(sint32 n, uint32 baseN = 10) 
		{ return From_sint64(n,baseN); } 
		uint32 To_uint32() const
		{ return static_cast<uint32>(To_uint64()); }
		sint32 To_sint32() const
		{ return static_cast<sint32>(To_sint64()); }

		static String From_double(double n, uint32 precision); 
		double To_double() const;
		
	public:
		// asciiZ conversion for OS interaction, very fast but only last 
		// as long as the String object is not changed
		const char* c_str() const;
		const uint8* p_str() const;
	    
	    static String From_c_str(const char* s);
	    static String From_p_str(const uint8* s);

	public:	
		void replace(iterator dstb, iterator dste, const_iterator srcb, const_iterator srce);
		inline void erase(iterator dstb, iterator dste)
		{
			replace(dstb,dste,0,0);
		}
		inline void insert(iterator dstb, const_iterator srcb, const_iterator srce)
		{
			replace(dstb, dstb, srcb,srce);
		} 
		inline void insert(iterator dstb, const String& s)
		{
			insert(dstb, s.begin(), s.end());
		} 
		inline void append(const_iterator srcb, const_iterator srce)
		{
			insert(end(), srcb,srce);
		}
		inline void append(const String& s)
		{
			append(s.begin(), s.end());
		}

		String substr(size_type pos, size_type len = (size_type)-1) const;

		value_type operator[] (size_type n) const;
		value_type& operator[] (size_type n);

		String operator+ (const String& s) const;
	public:
		// iterators			     
		inline iterator begin()
		{
			return sdata;
		}
		inline iterator end()
		{
			return sdata + _length();
		}

		inline const_iterator begin() const
		{
			return sdata;
		}
		inline const_iterator end() const
		{
			return sdata + _length();
		}

		String(iterator b, iterator e);
		String(const_iterator b, const_iterator e);
		String(const_iterator b, size_type len);

		String& assign(iterator b, iterator e) { return assign(String(b,e)); }
		String& assign(const_iterator b, const_iterator e) { return assign(String(b,e)); }
	public:
		// comparisons (brute byte by byte comparison)
		int  cmp(const String& s) const;

		inline bool operator == (const String& s) const { return 0==cmp(s); }
		inline bool operator != (const String& s) const { return 0!=cmp(s); }

		inline bool operator <= (const String& s) const { return 0<=cmp(s); }
		inline bool operator <  (const String& s) const { return 0<cmp(s); }

		inline bool operator >= (const String& s) const { return 0>=cmp(s); }
		inline bool operator >  (const String& s) const { return 0>cmp(s); }
		
	public:
		enum
		{
			_off_p    = -1,
			_off_cap  = _off_p - sizeof(uint32),
			_off_len  = _off_cap - sizeof(uint32),
			_off_ref  = _off_len - sizeof(uint32),
			_xsize    = 1 - _off_ref
		};
	private:
		value_type* sdata;
		inline uint32& _refcount() const { return *reinterpret_cast<uint32*>(sdata+_off_ref); } 
		inline uint32& _length()   const { return *reinterpret_cast<uint32*>(sdata+_off_len); } 
		inline uint32& _capacity() const { return *reinterpret_cast<uint32*>(sdata+_off_cap); } 
		inline uint8*  _p_str()    const { return reinterpret_cast<uint8*>(sdata+_off_p); } 

	public:
	    #if DEBUG 
	    	static void RunUnitTest();
	    #endif
	}; // class String
		
/*  
Special characters
[[:alnum:]] 		\p{IsAlnum}
[[:alpha:]] 		\p{IsAlpha}
[[:cntrl:]]			\p{IsCntrl}
[[:ascii:]] 		\p{IsASCII}
[[:digit:]] \d		\p{IsDigit}
[[:graph:]] 		\p{IsGraph}	  alphanum+punct
[[:lower:]]			\p{IsLower}
[[:print:]] 		\p{IsPrint}	  graph+space
[[:punct:]] 		\p{IsPunct}
[[:space:]] \s		\p{IsSpace}
[[:upper:]] 		\p{IsUpper}
[[:xdigit:]] 		\p{IsXDigit}  hexdigit
[[:blank:]]
[[:word:]] \w		\p{IsWord}
[[:unicode:]]
\a alarm
\b \f \n \r \t \v 
\e	 ESC
\x00 \x99

Special markers
()   mark match
\1   backreference to previous match
$    end line
^    start line
[] 	 any of
[^]	 any other
[-]  range
.    any
*    any times
+    once or more
?    0 or once
{1,2} specified amount of times
|    or 
/ 
\b	 word boundary
\B	 any char inside a word
\<	 word start
\>	 word end
\w	 word char
\W	 not word char
\`	 start buff
\'	 end buff
[: :]  for special characters use inside []
[= =]
(?#comment here)
(?=positive lookahead)
(?!negative lookahead)
(?:don't remember)
(?i:ignore case)
(?-i:no ignore case)
(?i) ignore case up to the end of the scope
(?m: ) multi line
(?s: ) single line
(?x: ) extended syntax
(?1yespat|nopat) conditional expression
(.*?) minimal match instead of greedy

\l	 lowercase next char
\L	 lowercase chars till \E
\u	 uppercase next char
\U	 uppercase chars till \E
\E   end case modification
\Q   quote till \E (no metachars inside)
\N{name} named char
\x{nnnn} wide hex char
\s	 space
\S	 not space
\d	 digit
\D	 not digit
\X	 combining unicode char sequence equivalent to C<(?:\PM\pM*)>
\C	 wild (match a single octet char even under utf8)

\A   start of buffer
\z	 end of buffer
\Z	 soft buffer end (\n at end of string also matches)
\G	 restart continue (match if this is a continuation point for a multiple match)
\p{propername}  like space
\P{propername}  not that named char

*/
#if defined(_REGEX_H)
	class RegExp : public jm::reg_expression<char, jm::char_regex_traits<char>, JM_DEF_ALLOC(char)>
	{
	public:
		RegExp(uint32 msgID);
		RegExp(const char* cstr);
		RegExp(const String& s);
		~RegExp();
		
		// find the match and return it
		bool Find(String::const_iterator b, String::const_iterator e);
		// find all matches and return them
	//	bool Grep(String::const_iterator b, String::const_iterator e);
		// find all matches and return the partitions they generate
	//	bool Split(String::const_iterator b, String::const_iterator e, uint32 n);
		
	public:
	    #if DEBUG 
	    	static void RunUnitTest();
	    #endif
	}; // class RegExp

#elif defined( BOOST_RE_REGEX_HPP )
	class RegExp : public boost::reg_expression<char, boost::regex_traits<char>, std::allocator<char> >
	{
	public:
		RegExp(uint32 msgID);
		RegExp(const char* cstr);
		RegExp(const String& s);
		~RegExp();
		
		// find the match and return it
		bool Find(String::const_iterator b, String::const_iterator e);
		// find all matches and return them
	//	bool Grep(String::const_iterator b, String::const_iterator e);
		// find all matches and return the partitions they generate
	//	bool Split(String::const_iterator b, String::const_iterator e, uint32 n);
		
	public:
	    #if DEBUG 
	    	static void RunUnitTest();
	    #endif
	}; // class RegExp
#endif //BOOST_RE_REGEX_HPP
	
	
	class StringMessage : public ref_obj
	{
		uint32 msgID;
		typedef std::vector<String> Params;
		Params parms;
	protected:	
		~StringMessage();
	public:
		StringMessage(uint32 msgID);
		StringMessage& Param(const String& p);
		StringMessage& Param(uint32 p);
		StringMessage& Param(sint32 p);
		StringMessage& Param(uint64 p);
		StringMessage& Param(sint64 p);

		String ToString() const;
	}; // class StringMessage
	
	// Only the numeric ID of the message is coded into the executable
	// The string message is grabbed by an external tool into a message file
	// No need to worry about the NID to be unique, just set it to 0 (zero) 
	// once the tool passes through the file it will modify the ID to a number 
	// that is unique and nice
	// Make sure not to modify the number once the tool sets it, any change might create
	// inconsistencies with versions of your app that have already been deployed 
	#define XSPMSG(NID, MSG) (NID)
	
	class StringMessages
	{
	}; // class StringMessages

} // namespace XSP


