/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

namespace XSP
{
	class LocalTime
	{
	private:
		 struct TData // 16 bytes structure
		 {
			 uint32 refcount;
			 sint32 year;
			 uint32 second;	   // second of year
			 uint32 nanosec;   // nanosec of second
			 
			 TData();
			 void addref() { ++refcount; }
			 void release();
		 };
		 // reference counted time data storage (just like a string)
		 refc<TData> tdata;

	public:
		 LocalTime(); // zero time 
	
		 LocalTime(const LocalTime& t); // copy time 
		 LocalTime& operator= (const LocalTime& t); // assign time	 
	
		 LocalTime( sint32 yr, uint32 month, uint32 dayofmonth
			 , uint32 hr, uint32 mn, uint32 sec
			 , uint32 nano =0 );
		 static LocalTime Now(); // current time constructor
		 LocalTime(sint64 t); // from normalized seconds
		 
	 	 ~LocalTime();
	
	public:
		 sint32 Year() const; 
		 uint32 Month() const; 		  // 1 based  (January == 1)
		 uint32 DayOfMonth() const;   // 1 based
		 uint32 Week() const; 		  // 0 based
		 uint32 DayOfWeek() const; 	  // 0 based  (Sunday == 0, Monday == 1, ...)
		 uint32 DayOfYear() const;	  // 0 based
		 uint32 Hour() const; 
		 uint32 Minute() const; 
		 uint32 Second() const; 
		 uint32 NanoSecond() const; 
		 bool	IsLeapYear() const;

		 String ToString() const;
	public:
		 // get seconds since year 0
		 sint64 NormalizedSeconds() const;
	
		 // add an amount of time (nanoseconds)
		 LocalTime& operator+= (sint64 ns);
		 LocalTime& operator-= (sint64 ns) { return (*this += -ns); }
		 
		 LocalTime operator+ (sint64 ns) const { LocalTime r(*this); r+=  ns; return r; }
		 LocalTime operator- (sint64 ns) const { LocalTime r(*this); r+= -ns; return r; }
	
	public:
		 bool operator == (const LocalTime& t) const;
		 bool operator != (const LocalTime& t) const { return !(*this == t); }
		 bool operator <  (const LocalTime& t) const;
		 bool operator <= (const LocalTime& t) const;
		 bool operator >  (const LocalTime& t) const { return !(*this <= t); }
		 bool operator >= (const LocalTime& t) const { return !(*this < t); }

	public: 
		 // conversions for various operating systems 
		 // some dates will not fit in this compressed format  (like dates before year 0)	
		 uint32 GetSecondsSince_1904Jan1() const; // Mac style
		 uint32 GetSecondsSince_1970Jan1() const; // Linux style
		 uint64 Get100NanoSince_1601Jan1() const; // Windows style
		 
		 static LocalTime FromSecondsSince_1904Jan1(uint32 s); // Mac style
		 static LocalTime FromSecondsSince_1970Jan1(uint32 s); // Linux style
		 static LocalTime From100NanoSince_1601Jan1(uint64 ms); // Windows style
	public:
		static void RunUnitTest();
	}; // class LocalTime
	
	
	
} // namespace XSP
