/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

#include "XSP_Core.h"

namespace XSP
{

CoreModule* CoreModule::_instance = 0;

CoreModule::CoreModule()
{
	// singleton: only allow one of these to be instantiated
	VERIFY(_instance == 0);
	if (_instance == 0)
		_instance = this;
}

CoreModule::~CoreModule()
{
	_instance = 0;
}

static const char   _kCoreCategory[] = PRODUCT_CATEGORY;
static const char   _kCoreProduct[]  = PRODUCT_NAME;
static const char   _kCoreEdition[]  = PRODUCT_EDITION;
static const char   _kCoreVersion[]  = PRODUCT_VERSION_FULL;
static const char   _kCoreFullName[] = PRODUCT_NAME_FULL;

CoreVersion::CoreVersion()
{
	productCategory = String::From_c_str(_kCoreCategory); 
	productName = String::From_c_str(_kCoreProduct);
	editionName = String::From_c_str(_kCoreEdition);
	fullVersion = String::From_c_str(_kCoreVersion);
	fullName = String::From_c_str(_kCoreFullName);

	majorVersion = PRODUCT_VERSION_MAJOR;
	minorVersion = PRODUCT_VERSION_MINOR;
	buildNumber  = PRODUCT_BUILD;
}


} // namespace XSP
