/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

#include "XSP_Core.h"

namespace XSP
{

Exception::Exception()
{
}

Exception::Exception(const refc<StringMessage>& sm)
: msg(sm)
{
}

Exception::Exception(const Exception& ex)
: msg(ex.msg)
{
	if (ex.because != 0)
		because = new Exception(*ex.because);  // deep duplicate
}

Exception::~Exception()
{
}

Exception& Exception::Because(const Exception& e)
{
	because = new Exception(e);
	return *this;
}


Exception::Exception(uint32 msgID)
: msg(new StringMessage(msgID))
{
}		
Exception& Exception::Param(const String& p)
{
	msg->Param(p);
	return *this;
}
Exception& Exception::Param(uint32 p)
{
	msg->Param(p);
	return *this;
}
Exception& Exception::Param(sint32 p)
{
	msg->Param(p);
	return *this;
}
Exception& Exception::Param(uint64 p)
{
	msg->Param(p);
	return *this;
}
Exception& Exception::Param(sint64 p)
{
	msg->Param(p);
	return *this;
}
void Exception::Raise() const
{
	#if DEBUG
		#if TARGET_API_Win32 || TARGET_API_Win32_Console
			::OutputDebugString("Throwing exception\n");
			::DebugBreak();
		#endif
	#endif
	throw *this ;
}

void Exception::RaiseVerifyError(const char* code, const VersionInfo& v) 
{ 
	Exception(XSPMSG(1,"Assertion failure in '$2;', while testing '$1;'"))
		.Param(String::From_c_str(code))
		.Param(v.FullName())
		.Raise();
}

#if DEBUG
void Exception::RaiseAssertError(const char* file, uint32 nline, 
								 const char* code, const VersionInfo& v)
{ 
	Exception(XSPMSG(2,"Assertion failure at '$1;':$2;, in '$3;', while testing '$4;'"))
		.Param(String::From_c_str(file))
		.Param(nline)
		.Param(v.FullName())
		.Param(String::From_c_str(code))
		.Raise(); 
}
#endif

Exception Exception::ExternalError(const char* code, const VersionInfo& v) 
{ 
	uint32 msgID = XSPMSG(342,"Assertion failure in '$2;', quote '$1;'");

	if (code == 0)
		XSPMSG(343,"Assertion failure in '$2;', unexpected internal failure");

	return Exception(msgID)
				.Param(String::From_c_str(code))
				.Param(v.FullName());
}

String Exception::FormatMessageToString() const
{
	String s;
	if (msg!=0) 
		s = msg->ToString();
	if (because != 0)
	{
		refc<StringMessage> bmsg(new StringMessage(
			XSPMSG(5,"$1;\n\tbecause:\n$2;")));
		bmsg->Param(s);
		bmsg->Param(because->FormatMessageToString()); // recursive
		s = bmsg->ToString();
	}
	return s;
}

} // namespace XSP


