/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

#include "XSP_Core.h"

#if DEBUG
namespace XSP
{
   
void String::RunUnitTest()
{
	UnitTest::Log("String");
	if (!String::kEmpty.isEmpty())
		UnitTest::Failed("kEmpty is not empty");
	if (0 != String::kEmpty.length())
		UnitTest::Failed("kEmpty length is not 0");

	if (String::From_c_str("a")!=String::From_c_str("a"))
		UnitTest::Failed("String a!=a");
	if (!(String::From_c_str("a")==String::From_c_str("a")))
		UnitTest::Failed("String a==a comparison failed");
	if (!(String::From_c_str("a")!=String::From_c_str("b")))
		UnitTest::Failed("String a!=b comparison failed");
	if (String::From_c_str("a")==String::From_c_str("b"))
		UnitTest::Failed("String a==b");

	if ((String() != String::kEmpty) || !(String() == String::kEmpty))
		UnitTest::Failed("String constructor does not default to empty");
	if (String::kEmpty+String::kEmpty != String::kEmpty)
		UnitTest::Failed("String kEmpty+kEmpty!=kEmpty");
	if (String::kEmpty != String::From_c_str(0))
		UnitTest::Failed("String kEmpty!=String::From_c_str(0)");

	if (String::From_c_str("abc")+String::From_c_str("defgh") != String::From_c_str("abcdefgh"))
		UnitTest::Failed("String abc+defgh!=abcdefgh");
	if (String::From_c_str("abcde").length() != 5)
		UnitTest::Failed("String len(abcde)!=5");
	if (String().assign(String::From_c_str("abcde")) != String::From_c_str("abcde"))
		UnitTest::Failed("String assign(abcde)!=abcde");

	{
		String a = String::From_c_str("a");
		String b = String::From_c_str("b");
		String aa(a);
		String bb(b);

		a.clear();
		if (!a.isEmpty())
			UnitTest::Failed("clear() is not empty");
		if (0!=a.length())
			UnitTest::Failed("clear() is not 0 length");
		if (String::kEmpty!=a)
			UnitTest::Failed("clear() is not kEmpty");
		if (a==aa)
			UnitTest::Failed("clear() == original");
		if (b!=bb)
			UnitTest::Failed("copy != original");
	}

	{
		String a1234 = String::From_uint32(1234U);
		String b1234 = String::From_uint32(0x1234U,16);
		String c1234 = String::From_c_str("1234");
		if (a1234!=c1234)
			UnitTest::Failed("From(1234U) != str(1234)");
		if (b1234!=c1234)
			UnitTest::Failed("From(0x1234U) != str(1234)");
		if (a1234.To_uint32()!=1234U)
			UnitTest::Failed("To(0x1234U) != str(1234)");
	}

	{
		String c_abc = String::From_c_str("abc");
// __GNUC__
#if __MWERKS__ 
		String p_abc = String::From_p_str("\pabc");		
#else
		String p_abc = String::From_p_str((uint8*)"\3abc");
#endif
		if (c_abc != p_abc)
			UnitTest::Failed("p(abc) != c(abc)");
		if (c_abc != String::From_c_str(c_abc.c_str()))
			UnitTest::Failed("c(abc) != c(abc)");
		if (p_abc != String::From_p_str(p_abc.p_str()))
			UnitTest::Failed("p(abc) != p(abc)");
	}	

	{
		String sr;
		sr.reserve(32);
		std::string::traits_type::copy(sr.begin(), "begin", 5);
		sr.setsize(5);
		if (sr != String::From_c_str("begin"))
			UnitTest::Failed("resize + inplace subst");

		sr.append(String::From_c_str("-end"));
		if (sr != String::From_c_str("begin-end"))
			UnitTest::Failed("resize + inplace subst + append");

		String::const_iterator p = std::find(sr.begin(), sr.end(), '-');
		if ((*p != '-') || (p != sr.begin()+5))
			UnitTest::Failed("std::find");
	}	

	{
		String cp = String::From_c_str("fgh");
		if (!(cp<=cp))
			UnitTest::Failed("fgh<=fgh");
		if (!(cp==cp))
			UnitTest::Failed("fgh==fgh");
		if (cp<cp)
			UnitTest::Failed("fgh<fgh");
		if (cp!=cp)
			UnitTest::Failed("fgh!=fgh");
		if (!(cp>=cp))
			UnitTest::Failed("fgh>=fgh");
		if (cp>cp)
			UnitTest::Failed("fgh>fgh");

		String cp2 = String::From_c_str("fgh");
		if (!(cp<=cp2))
			UnitTest::Failed("fgh<=fgh  2");
		if (!(cp==cp2))
			UnitTest::Failed("fgh==fgh  2");
		if (cp<cp2)
			UnitTest::Failed("fgh<fgh  2");
		if (cp!=cp2)
			UnitTest::Failed("fgh!=fgh  2");
		if (!(cp>=cp2))
			UnitTest::Failed("fgh>=fgh  2");
		if (cp>cp2)
			UnitTest::Failed("fgh>fgh  2");
		
		String cp3 = String::From_c_str("fgha");
		if (cp==cp3)
			UnitTest::Failed("fgh==fgha");
		if (!(cp!=cp3))
			UnitTest::Failed("fgh!=fgha");
		if (!(cp<=cp3))
			UnitTest::Failed("fgh<=fgha");
		if (!(cp<cp3))
			UnitTest::Failed("fgh<fgha");
		if (cp>=cp3)
			UnitTest::Failed("fgh>=fgha");
		if (cp>cp3)
			UnitTest::Failed("fgh>fgha");

		String cp4 = String::From_c_str("fgX");
		if (cp==cp4)
			UnitTest::Failed("fgh==fgX");
		if (!(cp!=cp4))
			UnitTest::Failed("fgh!=fgX");
		if (!(cp<=cp4))
			UnitTest::Failed("fgh<=fgX");
		if (!(cp<cp4))
			UnitTest::Failed("fgh<fgX");
		if (cp>=cp4)
			UnitTest::Failed("fgh>=fgX");
		if (cp>cp4)
			UnitTest::Failed("fgh>fgX");
	}	
}

//#ifdef BOOST_RE_REGEX_HPP
void RegExp::RunUnitTest()
{	
//std::string
//    typedef boost::reg_expression<char, boost::regex_traits<char>, std::allocator<char> > regex;
	typedef jm::reg_expression<char, jm::char_regex_traits<char>, JM_DEF_ALLOC(char)> regex;
    UnitTest::Log("Regular Expressions ");
    const String s = String::From_c_str("This is my string containing  n=${3}  words.");

    const regex re("[[:space:]]?[Nn]=\\$\\{(\\d+)\\}", jm::regbase::normal);
		    //|boost::regbase::icase);
    //	const regex re("conta");
   
//    boost::match_results<String::const_iterator> matches;
	jm::reg_match<String::const_iterator> matches;
//    if(0 != boost::regex_search(s.begin(), s.end(), matches, re, boost::match_default))
    if(0 != jm::reg_search(s.begin(), s.end(), matches, re, jm::match_default))
    {
		String rez0(matches[0].first, matches[0].second);
		String rez1(matches[1].first, matches[1].second);
		UnitTest::Log("search found '%s', containing '%s'", rez0.c_str(), rez1.c_str());
    }
    else
    {
		UnitTest::Failed("no match");
    }
}
//#endif

void LocalTime::RunUnitTest()
{
	UnitTest::Log("Time");
	LocalTime t1; // must be empty
	if (t1.tdata != 0)
		UnitTest::Failed("Time is not null by default");
    t1 = LocalTime(2003,3,12, 20,48,8, 12345);
    if (t1.Year() != 2003)
		UnitTest::Failed("year %d != 2003", t1.Year());
    if (t1.Month() != 3)
		UnitTest::Failed("month %d != 3", t1.Month());
    if (t1.DayOfMonth() != 12)
		UnitTest::Failed("day %d != 12", t1.DayOfMonth());
    if (t1.Hour() != 20)
		UnitTest::Failed("hour %d != 20", t1.Hour());
    if (t1.Minute() != 48)
		UnitTest::Failed("minute %d != 48", t1.Minute());
    if (t1.Second() != 8)
		UnitTest::Failed("second %d != 9", t1.Second());
    if (t1.DayOfWeek() != 3)
		UnitTest::Failed("day of week %d != 3", t1.DayOfWeek());
    if (t1.NanoSecond() != 12345)
		UnitTest::Failed("nanosec %d != 12345", t1.NanoSecond());

    t1 += (((6*24 +2)*60+3)*60+4)*(sint64)1000000000+ 5;
    t1 -= 12340;
    
    if (t1.DayOfMonth() != 18)
		UnitTest::Failed("day %d != 12", t1.DayOfMonth());
    if (t1.Hour() != 22)
		UnitTest::Failed("hour %d != 20", t1.Hour());
    if (t1.Minute() != 51)
		UnitTest::Failed("minute %d != 48", t1.Minute());
    if (t1.Second() != 12)
		UnitTest::Failed("second %d != 9", t1.Second());
    if (t1.DayOfWeek() != 2)
		UnitTest::Failed("day of week %d != 3", t1.DayOfWeek());
    if (t1.NanoSecond() != 10)
		UnitTest::Failed("nanosec %d != 10", t1.NanoSecond());
    t1 -= 10;
    if (t1.NanoSecond() != 0)
		UnitTest::Failed("nanosec %d != 0", t1.NanoSecond());
	
	LocalTime t2(t1.NormalizedSeconds());
    if (t1 != t2)
		UnitTest::Failed("normalized time not same");

    if (t2 != LocalTime::FromSecondsSince_1904Jan1(t1.GetSecondsSince_1904Jan1()))
		UnitTest::Failed("SecondsSince_1904Jan1");
    if (t2 != LocalTime::FromSecondsSince_1970Jan1(t1.GetSecondsSince_1970Jan1()))
		UnitTest::Failed("SecondsSince_1970Jan1");
    if (t2 != LocalTime::From100NanoSince_1601Jan1(t1.Get100NanoSince_1601Jan1()))
		UnitTest::Failed("MillisecondsSince_1601Jan1");
    
	t1 = LocalTime::Now();
    UnitTest::Log("Time Now=%s, DayOfWeek=%d",
    			t1.ToString().c_str(),
    			t1.DayOfWeek() );
}

} // namespace XSP

#endif // DEBUG
