/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

#include "XSP_Core.h"

namespace XSP
{

#if TARGET_API_Darwin || TARGET_API_MAC_Mach0 || Target_API_Linux
	//#include <sys/param.h>
	//#include <sys/types.h>
/*
    void getTicks()
    {   // only measures ticks passed within this process not within the entire system
    	rusage r;
		VERIFY(::getrusage(RUSAGE_SELF, &r) != -1);
		XSP::uint32 ticks = (r.ru_utime.tv_sec+r.ru_stime.tv_sec)   *CLK_TCK
					 	  + (r.ru_utime.tv_usec+r.ru_stime.tv_usec)  / (1000000 / CLK_TCK);
    }

    void getTime()
    {
		struct timeval daytime;
		struct timezone tzone;
		VERIFY(::gettimeofday(&daytime, &tzone) != -1);
		XSP::uint32 secondsToday = daytime.tv_sec;
		XSP::uint32 gmToday = secondsToday-tzone.tz_minuteswest;
		bool   isDaylightSavingsOn = (tzone.tz_dsttime != DST_NONE);
    }
*/

LocalTime LocalTime::Now()
{
	struct timeval tv;
	struct timezone tzone;
	VERIFY(::gettimeofday(&tv, &tzone) != -1);
	// make sure no overflows are around
	tv.tv_sec += tv.tv_usec/1000000;
	tv.tv_usec%=1000000;
	  
	struct tm stm;
	::localtime_r((time_t*)&tv.tv_sec, &stm);
	return LocalTime(1900+stm.tm_year, 1+stm.tm_mon, stm.tm_mday,
				stm.tm_hour, stm.tm_min, stm.tm_sec,
				tv.tv_usec*1000  );
}

#endif
} // namespace XSP
