
CFLAGS=-O2 -Wno-deprecated
LFLAGS=

all:  XSP_File.lib

clean:
	rm *.o *.lib

INCDIR=-I ../Includes -I ../../Core/Includes -I ../../../Libs/regexpp2/include

HEADER=-include ../../Targets/Includes/TargetAPI_Win32.h

ALL_HEADER= ../../Targets/Includes/TargetAPI_Win32.h \
	../Includes/XSP_File.h

ALL_OBJ= File.o \
	File_Carbon.o \
	File_Darwin.o \
	File_Linux.o \
	File_Win32.o \
	FileTest.o 

File.o: ../Sources/File.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

File_Win32.o: ../Sources/File_Win32.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

File_Linux.o: ../Sources/File_Linux.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

File_Carbon.o: ../Sources/File_Carbon.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

File_Darwin.o: ../Sources/File_Darwin.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

FileTest.o: ../Sources/FileTest.cpp $(ALL_HEADER)
	g++ -o $@ -c $(INCDIR) $(HEADER) $(CFLAGS) $<

XSP_File.lib: $(ALL_OBJ)
	ar rc $@ $(ALL_OBJ)
	ranlib $@
