/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write

Description:
	This module contains a set of classes to be used as the building blocks of a 
	platform independent user interface.
	
	class GUI_Module is a singleton object (the only one in the GUI) containg the 
	globally accessible objects needed or exposed by the gui framework. At this time
	the only such object is the codecFactory used to create the codec that can 
	decode an image from a file.
	
	class View
	This is the base class for all visible GUI objects. It has methods for the most 
	basic features of a UI object. It is also a container capable of parenting any 
	number of child views. This means that any view can have children views inside
	even if it was not intended such at the time that specific view was designed.
	A view contains a current state and a skin that allows it to have its looks 
	entirely redesigned without any need to change the code of the view.
	It has a set of virtual methods to be overridden by more specialized views.
		Draw - override to draw the view
		SetBounds - override to be able to react to changes of size and position
		GetPreferredSize - override to provide information about the desired size 
				of this view
		SetSkin - override and do something when the skin is changed
		SetFont - override and do something when the font is changed
    	HandleFocused - override to react to change in focus
 		HandleActivated - override to react when activated /deactivated
		HandleKeyEvent- override to react to key events
		MouseCaptureBroken - override to manage mouse capture
		HandleMouseEvent - override to react to mouse events
		MouseEnter- notification received when the mouse enters or leaves the view
		MouseCursorSetup - override to set the appropriate mouse cursor on entry
		HandleDrop - called by the drag&drop mechanism to tell the view something 
			has been dropped on it

	class WinMgr  
	There can be only one of these in your app. It manages all the windows you create 
	and the interaction of those windows with the operating system. Also stores all 
	the system color access functions. It is the embodyment of the system's 
	desktop/GUI framework. One would normally create such an object in the constructor 
	of the application.

	class Window
	A window can be created as a child of "WinMgr" or as a child of another window.
    Once a window has been created a set of properties need to be configured:
    	- the title of the window (SetTitle)
    	- the position of the window on screen (SetBounds, SetContentBoundsOnScreen)
    	- the baground color of the window (SetBgStyle)
    	- what to do when the window is closed (AddWindowListener, SetWindowClosesApp)
    The "SetWindowClosesApp" function installs a predefined listener to the window, with 
    the single purpose of translating the "window closed" notification into a 
    "quit application" event. As a result the closing of that window will determine the 
    shutdown of the entire app. This is very common behaviour for many apps but it is by 
    no means the only way to shutodown applications. If you need custom behavior, just 
    install your own window listener and proceed with some other logic to generate 
    the shutdown for the application.
    A window is also a view continer, so just like any other view can accept children 
    views to be added to it. To populate a window call "AddView". By default if only 
    one view is added to a window that view will fill the entire content of the window 
    and you need not add any logic to resize the view during the resize of the window.
	If there's more than one view added to the window you need to add a window listener 
    and implement your own "BoundsChanged" handler. We plan to make this much better 
    in the near future by adding layout managers and the ability to install them into 
    any view container.

	class Graphics
	The graphics context is available to GUI objects during Draw. It can be used to 
	draw text based on the selected font, images, lines ... 
	It is platform independent, hides away the specifics of drawing on various platforms.
	
	class OffscreenImage
	This is our internal crossplatform representation for images. Offscreen images can 
	be used as targed devices for drawing in memory and can be copied to screen during 
	draw. If you implement an image codec, the internal representation you have to 
	provide for the image is an OffscreenImage object.
	
	class UIEvent
	User events (keyboard and mouse) together with various modifiers (CTRL,ALT/OPTION, 
	SHIFT, ...) are all encapsulated into this platform independent event.
	
	class ViewSkin
	This object defines the skin to be associated with a view. Since a view can be a 
	composite of a few subviews, the skin also defines the skins for those subviews 
	as parts. Use "AddPart" to add a part to a skin. The partnames used to identify 
	parts within a skin are strings and must exacltly match the partname that the view 
	knows about.
	A view is a state machine, with user events determining transitions for the current 
	state of the view. The view designer can choose to make some or all of these states
	have a visual equivalent and therefore graphically present the view's inner state 
	to the user. To do this one has to use "AddStateSkin" to attach a specific look to 
	a specific state. The added object is a "StateSkin" and contains information like the 
	image to be drawn and the content region. The current font and font color are not 
	currently part of the skin but we plan to add them.
	
	class MouseCursor
	Is used to represent the shape of the mouse cursor.
	A couple of predefined mouse cursors are available as members of WinMgr.
	More can be created based on a cursor name (String).
	Use them during "MouseCursorSetup" virtual method inside "View".
	
	class DragDropType
	It is a fat object containing storage space for an entire drag (the entire 
	dragged variants). It is not a particularly efficient representation but it is 
	the simplest to handle in a platform independent manner. This approach may be 
	changed in the future.
	
	class TextFont
	A platform independent font object. Together with class FontName. Use font Name 
	to enumerate or select the desired font. Once opened you get a TextFont object 
	to play with.
					  
	class TextView 
	This is a text editor/viewer suporting single line/ multi line, 
	plain text/rich text. Currently only supports single byte character encodings.
	Configure it according to your needs.  Supports Drag&Drop editing.
	
	class LabelView 
	The simplest of all views, uses no skins (it has a transparent background). It 
	is a simple text label to be placed somewhere inside a container. Does not react 
	to events.
	
	class BackgroundView 
	Use this if you need to add a background image to your container.
	
	class ImageView : use this control to show pictures 
	If you already have an image in memory you can simply instruct the imageview 
	to show it with "SetImage", if you only have a filename image view can be 
	instructed to load the image from that file and show it as soon as it becomes 
	available. Supports Drag&Drop of images and filenames.
	
	class ButtonView : yes it's a button :-)
	Set the text to be shown on the face of the button, the font is has to be 
	rendered with, the alignement for the text within the button bounds. You can use 
	GetPreferredSize on the button once you have configured its content and skin.
	Don;t forget to add the button to the parent container. To make the button have 
	a "purpose" you should also add an action listener to the button and write a 
	handler for the action. 	

	class MView 
	A multi view container, always stores its children so that only the top child is 
	visible and covers the entire content area of the parent. It is used as a functional 
	element in the TabView.
	
	class TabView 
	Everybody knows what a tabview is :-)
	
	class ScrollBar: the scrollbar can be configured with a parameter, parameter range, 
	parameter page size.  The last of them , "parameter page size" should be a value
	within the parameter range and it is used to calculate the size of the thumb in the 
	scroll bar. You will rarely need to create scrollbars independently. Instead you can 
	use the scrollpage/scrollview combination. 

	class ScrollView is a container that has the ability to scroll its children
	
	class ScrollPage is a container that parents one such scrollview and 2 scroll 
	bars. Certain views like the textview, already have the ability to scroll 
	their content and therefore can be directly added to a ScrollPage.
	
	class ListView 
	
	class ComboListView it is an edit line with a dropdown list box. 
	Both the edit and the listbox can be configured independently. 
	Make sure to configure the skin for the combo with both the skin for the text 
	and the skin for the child list box. 
	
	class ToolBar

	class DialogWindow
    If your window is a dialog window you need to override "DoLayout" to reposition the 
    children within the window's content. 

	class FileView [not implemented yet]
*/




#include "XSP_GUI_Module.h"
#include "XSP_Codec.h"
#include "XSP_Graphics.h"
#include "XSP_UIEvent.h"
#include "XSP_ViewSkin.h"
#include "XSP_MouseCursor.h"
#include "XSP_DragDrop.h"
#include "XSP_TextFont.h"
#include "XSP_View.h"
#include "XSP_BackgroundView.h"
#include "XSP_ImageView.h"
#include "XSP_TextView.h"
#include "XSP_ButtonView.h"
#include "XSP_LabelView.h"
#include "XSP_OSIcon.h"
#include "XSP_Window.h"

#include "XSP_MView.h"
#include "XSP_TabView.h"
#include "XSP_ScrollView.h"
#include "XSP_ListBox.h"
#include "XSP_DropDown.h"
#include "XSP_ToolBar.h"

#include "XSP_DialogWindow.h"
#include "XSP_FileView.h"
