/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{

class ListView : public ScrollView
{
private:
	class ComponentListener;
//	refc<ButtonView::ActionListener> componentListener;
public:
	ListView();
	virtual void SetBounds(const Rect2D& bounds);
	virtual bool HandleKeyEvent( const UIEvent& ev );
	virtual Size2D GetPreferredSize();
	virtual void SetFont(const TextFont& f);
	virtual void SetSkin(const ViewSkin::owner& s);

public:
	bool HasText(const String& text);
	void AddText(const String& text);
	void RemoveText(const String& text);
	void RemoveAllText();

	void UnselectAll();
	void SelectText(const String& text, bool on);
	bool IsSelectedText(const String& text);
	const String& GetSelectedText();

	// make the selected text visible
	void ShowSelection();	
	void SelectFocused(bool on);
	
public:
	class _Selection
	{
	public:
		virtual void SelectionChanged(const String& text, bool on, ListView* lbox)=0;
	}; // class _Selection
	typedef ListenerOf<_Selection> SelectionListener;
	typedef SelectionListener::Container SelectionListeners;
	SelectionListeners selectionListeners;
    void AddSelectionListener(const SelectionListener::owner& l);

	void Notify_SelectionChanged(const String& text, bool on);

public:
		void DemoPopulate();
protected:
	virtual ~ListView();
}; // class ListView

} // namespace XSP
