/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{

class UIEvent
{
public:
	enum Origin     
	{ 
		// KeyDown is frst sent as PriorityKey through the focus chain (node has priority)
		// KeyDown is sent to the focus leaf (leaf has priority)
		// KeyDown is sent as HotKey to all children of focused container (button code)
		// if unused the container may try to use it itself (TAB to next)
		// if unused we return to parent as unused
		// KeyDown is resent as UnusedKey (TAB back to first item)
		AsciiCode=1, KeyDown, KeyUp, PriorityKey, HotKey, UnusedKey, 
		MouseMove, MouseClick, MouseUp, MouseDClick, MouseWheel
	};

	enum ButtonCode 
	{ 
		LeftMouse =1, RightMouse, MiddleMouse , 
		X1Mouse, X2Mouse 
	};

	enum Modifiers 
	{
		 ShiftState			= 0x0001, 
		 CtrlState			= 0x0002, 
		 AltOptionState		= 0x0004, 
		 OSState			= 0x0008,
		 MouseLeftState 	= 0x0010,
		 MouseRightState 	= 0x0020,
		 MouseMiddleState 	= 0x0040,
		 MouseX1State 		= 0x0080,
		 MouseX2State 		= 0x0100,
		 ContextState		= 0x0200,
		 CapsState			= 0x0400,
		 NumLockState		= 0x0800,
		 ScrollState		= 0x1000,

		 // compozites
		 KModifMask	= ShiftState|CtrlState|AltOptionState
		 			 |OSState|ContextState,
		 MouseState	= MouseLeftState|MouseRightState|MouseMiddleState
		 			 |MouseX1State|MouseX2State,
		 MModifMask	= KModifMask | MouseState
	};

public:
	uint32 origin;
	uint32 code;  // key code or mouse button code 
	uint32 modifiers;
	sint32 count; // wheel delta 120 units for one line
				  // or key repeat count
	Point2D mousePos;

public:
	UIEvent();
	#if TARGET_API_Win32 || TARGET_API_Win32_Console
		UIEvent(UINT msg, WPARAM wp, LPARAM lp);
	#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0
		UIEvent(;
	#elif TARGET_API_Darwin || TARGET_API_Linux
		UIEvent(;
	#endif
	UIEvent(const UIEvent& ev);
	UIEvent& operator= (const UIEvent& ev);
}; // class UIEvent

class KeyCodeSpec
{
public:
	KeyCodeSpec();
	~KeyCodeSpec();
	KeyCodeSpec(const KeyCodeSpec& z);
	KeyCodeSpec& operator= (const KeyCodeSpec& z);
private:
	
};

} // namespace XSP
