/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#if TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0
#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{

ColorRGB::ColorRGB(uint8 r, uint8 g, uint8 b)
{
	0[(uint8*)&rgba] = 0xffU;
	1[(uint8*)&rgba] = r;
	2[(uint8*)&rgba] = g;
	3[(uint8*)&rgba] = b;
}
ColorRGB::ColorRGB(uint8 r, uint8 g, uint8 b, uint8 a)
{
	uint64 n = 0;
	0[(uint8*)&n] = r;
	2[(uint8*)&n] = g;
	4[(uint8*)&n] = b;
	n *= 1U+a;
	0[(uint8*)&rgba] = a;
	1[(uint8*)&rgba] = 1[(uint8*)&n];
	2[(uint8*)&rgba] = 3[(uint8*)&n];
	3[(uint8*)&rgba] = 5[(uint8*)&n];
}
uint8 ColorRGB::Red() const
{
	return 1[(uint8*)&rgba];
}
uint8 ColorRGB::Green() const
{
	return 2[(uint8*)&rgba];
}
uint8 ColorRGB::Blue() const
{
	return 3[(uint8*)&rgba];
}
uint8 ColorRGB::Alpha() const
{
	return 0[(uint8*)&rgba];
}


TextFont::_Data::_Data()
: refcount(0)
, fontID(0)
, fontSize(12)
, fontStyle(0)
{
}

TextFont::_Data::~_Data()
{
}

TextFont::TextFont()
: data(new _Data())
{
	data->fontSize= ::GetDefFontSize();
	data->fontStyle  = 0;
	data->fontID = ::GetSysFont();
	Str255 fname;
	::GetFontName(data->fontID, fname);
	data->faceName = String::From_p_str(fname);
	
	Graphics g;
	g.SetFont(*this);
//	LockFont _lock(g, *this);
	::GetFontInfo(&data->metric);
}

TextFont::TextFont(const FontName& fontname)
: data(new _Data())
{
    data->faceName = fontname.faceName;
	data->fontSize = fontname.fontSize;
	data->fontStyle  = fontname.boldFont ? bold : 0;
	data->fontStyle |= fontname.italicFont ? italic : 0;
	data->fontStyle |= fontname.underlineFont ? underline : 0;
	::GetFNum(fontname.faceName.p_str(), &data->fontID);
	// FMGetFontFamilyFromName
	//Graphics g;
	//g.SetFont(*this);
	//::GetFontInfo(&data->metric);
	OSErr err = ::FetchFontInfo(data->fontID, data->fontSize, data->fontStyle, &data->metric);
	if (err != noErr)
		Exception(XSPMSG(0,"Font '$1;' cannot be loaded"))
			.Param(fontname.ToString())
			.Raise();
}

const String& TextFont::GetFaceName() const
{
    return data->faceName;
}

sint32 TextFont::GetAscent() const
{
	return data->metric.ascent;
}

sint32 TextFont::GetDescent() const
{
	return data->metric.descent;
}

sint32 TextFont::GetLeading() const
{
	return data->metric.leading;
}

sint32 TextFont::GetMaxCharWidth() const
{
	return data->metric.widMax;
}

bool   TextFont::IsItalic() const
{
	return ((data->fontStyle & italic) != 0);
}

bool   TextFont::IsUnderline() const
{
	return ((data->fontStyle & underline) != 0);
}

bool   TextFont::IsBold() const
{
	return ((data->fontStyle & bold) != 0);
}

/*
LockFont::LockFont(Graphics& g, const TextFont& f)
{
    GrafPtr p
	port = g.Port();
	::SetPort(port);
	style = ::GetPortTextFace(port);
	textSize = ::GetPortTextSize(port);
	fontID = ::GetPortTextFont(port);
//	#if TARGET_API_MAC_OS8
//		mTextStyle = thePort->txFace;
//		mTextSize = thePort->txSize;
//		mFontID = thePort->txFont;
//	#endif
	::TextFont(f.data->fontID);
	::TextFace(f.data->fontStyle);
	::TextSize(f.data->fontSize);
}

LockFont::~LockFont()
{
	::SetPort(port);
	::TextFont(fontID);
	::TextFace(style);
	::TextSize(textSize);
}

*/

OffscreenImage::_Data::_Data()
: refcount(0)
, gWorld(NULL)
{}

OffscreenImage::_Data::~_Data()
{
	if (gWorld != NULL)
	    ::DisposeGWorld(gWorld);
	gWorld = NULL;
}

OffscreenImage::OffscreenImage(sint32 u, sint32 v, PixelStyle style)
: data(new _Data())
{
	data->style = style;
    uint32 bpp = 0;
	switch(style)
	{										  
	case RGB24:			bpp = 24; break; // ToDo no alpha but 32 bpp anyway
	case RGBA32:		bpp = 32; break;
	case TrueColor565:  bpp = 16; break;
	case TrueColor555:  bpp = 16; break;
	case Index8:		bpp = 8; break;
	default:
		VERIFY(false);
	};

	Rect worldBounds;
	worldBounds.top = 0;
	worldBounds.left = 0;
	worldBounds.right = u;
	worldBounds.bottom = v;
	QDErr err = ::NewGWorld(&data->gWorld, bpp, &worldBounds, nil, nil, 0);
	if (err != noErr || data->gWorld == 0)
		Exception(XSPMSG(0,"Offscreen image cannot be created"))
			.Raise();
}


Graphics::Graphics() // status qvo
: gWorld(0), gDevice(0) 
{
 	::GetGWorld(&savedGWorld, &savedGDevice);
    gWorld = savedGWorld;
    gDevice = savedGDevice;
}

Graphics::Graphics(const OffscreenImage& img) // offscreen buffer
: gWorld(img.data->gWorld), gDevice(0) 
{
 	::GetGWorld(&savedGWorld, &savedGDevice);
	::SetGWorld(gWorld, gDevice);
}
 
Graphics::Graphics(CGrafPtr gw, GDHandle dv) 
: gWorld(gw), gDevice(dv) 
{
	ASSERT(gw != 0);
	// save the old port 
 	::GetGWorld(&savedGWorld, &savedGDevice);
	::SetGWorld(gWorld, gDevice);
}

Graphics::~Graphics()
{
	// restore the old port
	::SetGWorld(savedGWorld, savedGDevice);
}

bool Graphics::IsOffScreen() const 
{ 
	return gDevice == 0; 
}

void Graphics::SetFont(const TextFont& f)
{
	::SetGWorld(gWorld, gDevice);
	::TextFont(f.data->fontID);
	::TextFace(f.data->fontStyle);
	::TextSize(f.data->fontSize);
}

LockOffscreenImage::LockOffscreenImage(const OffscreenImage& img)
{
	Init(img.data->gWorld);
}
LockOffscreenImage::LockOffscreenImage(Graphics& g)
{
	Init(g.GetGWorld());
}
void LockOffscreenImage::Init(CGrafPtr gWorld)
{
	phandle = ::GetGWorldPixMap(gWorld);
	::LockPixels(phandle);
	memory = (uint8*) ::GetPixBaseAddr(phandle);
	VERIFY(memory != 0);

	#if TARGET_API_MAC_OS8
		BitMap& bmp = ((struct GrafPort*)gWorld)->portBits;
		rowBytes = bmp.rowBytes;
		bounds.ConvertFromRect(bmp.bounds);	  //((struct GrafPort*)gWorld)->portRect
		bpp = (rowBytes/bounds.w)*8;  // ToDo is this ok ?
	#else
		bpp = ::GetPixDepth(phandle); // number of bits in a pixel
		rowBytes = ::GetPixRowBytes(phandle); // number of bytes in a row
		Rect r;
		::GetPortBounds(gWorld, &r);
		bounds.ConvertFromRect(r);
	#endif
}

LockOffscreenImage::~LockOffscreenImage()
{
	::UnlockPixels(phandle);
}


void Graphics::DrawImage(const OffscreenImage& img, const Rect2D& src, const Rect2D& dst)
{
//	Graphics src_g(img);  // lock the src image
//	::SetGWorld(gWorld, gDevice);
//	PixMapHandle dst_pm = ::GetGWorldPixMap(gWorld);
//	uint32 dst_bpp = ::GetPixDepth(dst_pm); // number of bits in a pixel
//	sint32 dst_row = ::GetPixRowBytes(dst_pm); // number of bytes in a row

//	PixMapHandle src_pm = ::GetGWorldPixMap(img.data->gWorld);
	
	switch (img.data->style)
	{
	case OffscreenImage::RGBA32: 
		if (gDevice == 0)
		{  // src with alpha channel, dst offscreen => get the dest and merge with src
//			LockOffscreenImage dsti(*this);
//			LockOffscreenImage srci(img);
//			_DrawImage(dsti,srci, dst,src);
//			return;
	    }
	    // else we just ignore the alpha channel
	case OffscreenImage::RGB24:
	case OffscreenImage::TrueColor565:
	case OffscreenImage::TrueColor555:
	case OffscreenImage::Index8:
		{// src has no alpha, just overwrite the src  CGrafPtr
			Rect srcR; src.ConvertToRect(srcR);
			Rect dstR; dst.ConvertToRect(dstR);
			#if TARGET_API_MAC_OS8
				BitMap* dst_BMP = &(((struct GrafPort*)gWorld)->portBits);
				BitMap* src_BMP = &(((struct GrafPort*)img.data->gWorld)->portBits);
			#else
				const BitMap* dst_BMP = ::GetPortBitMapForCopyBits(gWorld);
				const BitMap* src_BMP = ::GetPortBitMapForCopyBits(img.data->gWorld);
			#endif
			if (gDevice == 0)
			{
			    LockOffscreenImage dsti(*this);	  // lock during copy
				::CopyBits( src_BMP, dst_BMP, &srcR, &dstR, srcCopy, nil);
			}
			else
				::CopyBits( src_BMP, dst_BMP, &srcR, &dstR, srcCopy, nil);
		}
		break;
	}	// switch		
}

static Pattern _solidFillPat = { {0xFF,0xFF,0xFF,0xFF, 0xFF,0xFF,0xFF,0xFF} };
void Graphics::FillRect(const ColorRGB& colr, const Rect2D& dst)
{
	 ::SetGWorld(gWorld, gDevice);
	 Rect r; dst.ConvertToRect(r);
	 ::RGBForeColor(colr.ToRGBColor());	   
//	 ::RGBBackColor(colr.rgba);
	 ::FillRect(&r, &_solidFillPat);
}

void Graphics::DrawLine(const ColorRGB& colr, const Point2D& a, const Point2D& b, uint32 thick)
{
	 ::SetGWorld(gWorld, gDevice);
	 ::PenPat(&_solidFillPat);
	 ::PenSize(thick, thick);
	 ::RGBForeColor(colr.ToRGBColor());
//	 ::RGBBackColor(colr.rgba);
	 ::MoveTo(a.x, a.y);
	 ::LineTo(b.x, b.y);
}


/*
class PixelsLock
{
	 Graphics& g;
public:
	  PixelsLock(Graphics& gr) 
	  : g(gr) 
	  {
	  	#if TARGET_API_MAC_OS8
	  		::LockPixels(g.gp->portPixMap);
	  	#else
	  		::LockPortBits(g.gp);
	  	#endif  
	  }
	 ~PixelsLock() 
	  {  
	  	#if TARGET_API_MAC_OS8
	  		::UnlockPixels(g.gp->portPixMap);
	  	#else
	  		::UnlockPortBits(g.gp);
	  	#endif  
	  }
	  Graphics& GetGraphics() { return g; }
}; // class PixelsLock


class PortLock
{
	 Graphics& g;
public:
	  PortLock(Graphics& gr) : g(gr) {  }
	 ~PortLock() {  }
	  Graphics& GetGraphics() { return g; }
}; // class PortLock
*/


WinMgr::_Data::_Data()
: refcount(0)
{
}
WinMgr::_Data::~_Data()
{
}
WinMgr::WinMgr()
{
}

Window::_Data::_Data(const WinMgr& d)
: refcount(0)
, winMgr(d)
{
}
Window::_Data::~_Data()
{
	// delete all listeners
	listeners.clear();
}

Window::Window(const WinMgr& winMgr)
{
}

Window Window::PopupChild() const
{
	return Window();
}


} // namespace XSP
#endif
