/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{


LabelView::LabelView()
{
	SetFocusable(false);
}

LabelView::~LabelView()
{
}

const String& LabelView::GetText() const
{
	return tData.text;
}

void LabelView::SetText(const String& t)
{
	tData.SetText(t);
	Refresh();
}

void LabelView::SetFont(const TextFont& t)
{
	tData.SetFont(t);
	View::SetFont(t);
}

void LabelView::SetColor(const ColorRGB& t)
{
	tData.colr = t;
	Refresh();
}

void LabelView::SetTextAlign(Rect2D::Alignment al, Rect2D::Alignment ov)
{
	tData.algn = al;
	tData.ovrf = ov;
	Refresh();
}

void LabelView::Draw(Graphics& g, const Rect2D&)
{
//	Rect2D oldClip = g.GetClipRect();
//	g.SetClipRect(GetLocalBounds());
	tData.Draw(g,GetLocalBounds());
//	g.SetClipRect(oldClip);
}



} // namespace XSP
