/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{

#if 0
#pragma mark ListView::ComponentListener
#endif

class ListView::ComponentListener : public ButtonView::ActionListener
{
	ListView* listbox;
public:
	ComponentListener(ListView* v)  : listbox(v) {}
	~ComponentListener()	      	  { CancelListener(); }
	void CancelListener() {	listbox = 0;	super::CancelListener(); }
protected:
	virtual void ActionPerform(ButtonView* button)
	{
		if (listbox == 0)
			return;
		if (!button->Is3StateButton())
			return;
		listbox->SelectText(button->GetText(), button->IsChecked());
	}
}; // ScrollComponentListener


ListView::ListView()
{
}

ListView::~ListView()
{
}

void ListView::DemoPopulate()
{
//	for (uint32 k=0; k<126; ++k)
//		AddText(String::From_c_str("List item ")+String::From_uint32(k));

	FontName::Container c;
	FontName::EnumerateAllInto(c);
    FontName::Container::iterator b = c.begin();
    FontName::Container::iterator e = c.end();
    for(; b!=e; ++b)
		AddText(b->faceName + String::From_c_str(" - ") + b->GetCharset());
}

void ListView::AddSelectionListener(const SelectionListener::owner& l)
{
	selectionListeners.Add(l);
}

void ListView::Notify_SelectionChanged(const String& text, bool on)
{
	if (selectionListeners.withinNotify)
		return;
	selectionListeners.withinNotify = true;
	for (SelectionListener::each e(selectionListeners); !e.empty(); e.pop()) 
		if (! e->IsCanceled())
			e->SelectionChanged(text, on, this);
	selectionListeners.withinNotify = false;
}

Size2D ListView::GetPreferredSize()
{
	Size2D z;
	const Children& children = GetChildren();
    Children::const_iterator b = children.begin();
    Children::const_iterator e = children.end();
    for(; b!= e; ++b)
    {
    	const View::owner& v = *b;
    	ButtonView* bv = static_cast<ButtonView*> (v.operator->());
		Size2D vz(bv->GetPreferredSize());
		if (vz.w > z.w) z.w = vz.w;
		z.h += vz.h;
	}
	return z;
}

void ListView::SetBounds(const Rect2D& bounds)
{
	Rect2D oldBounds(GetBounds());
	if (bounds == oldBounds)
		return;
	Rect2D scrollBounds(GetScrollBounds());
    if (!bounds.isEmpty() && scrollBounds.isEmpty()) 
    {   // time to initialize the components position
	    sint32 y=0;
		const Children& children = GetChildren();
	    Children::const_iterator b = children.begin();
	    Children::const_iterator e = children.end();
	    for(; b!= e; ++b)
	    {
			Rect2D vb((*b)->GetBounds());
			vb.x = 0;
			vb.y = y;
			vb.w = bounds.w;
	    	(*b)->SetBounds(vb);
	    	y += vb.h;
		}	
    }
    else if (scrollBounds.w != bounds.w)
    {   // we need to keep the width of the text items the same as the container
		const Children& children = GetChildren();
	    Children::const_iterator b = children.begin();
	    Children::const_iterator e = children.end();
	    for(; b!= e; ++b)
	    {
			Rect2D vb((*b)->GetBounds());
			vb.w = bounds.w;
	    	(*b)->SetBounds(vb);
		}	
    }
	ScrollView::SetBounds(bounds);
}

bool ListView::HandleKeyEvent( const UIEvent& ev )
{
	if ((ev.origin == UIEvent::KeyDown) && 
		(ev.code == VK_DOWN) && 
		(0 == (ev.modifiers & UIEvent::KModifMask)))
	{
		ActionFocusNextChild();
		View::owner foc = GetChild(StateFocused);
		if (foc != 0)
			MakeVisible(foc->GetBounds());
		return true;
	}

	if ((ev.origin == UIEvent::UnusedKey) && 
		(ev.code == VK_UP) && 
		(0 == (ev.modifiers & UIEvent::KModifMask)))
	{
		ActionFocusPrevChild();
		View::owner foc = GetChild(StateFocused);
		if (foc != 0)
			MakeVisible(foc->GetBounds());
		return true;
	}

	if ((ev.origin == UIEvent::UnusedKey) && 
		(ev.code == VK_RETURN) && 
		(0 == (ev.modifiers & UIEvent::KModifMask)))
	{
		View::owner foc = GetChild(StateFocused);
		if (foc != 0)
		{
			MakeVisible(foc->GetBounds());
			ButtonView* bv = static_cast<ButtonView*> (foc.operator->());
			bv->ActionFireButton();
		}
		return true;
	}

	return ScrollView::HandleKeyEvent( ev );	
}

void ListView::SelectFocused(bool on)
{
	View::owner foc = GetChild(StateFocused);
	if (foc != 0)
	{
		ButtonView* bv = static_cast<ButtonView*> (foc.operator->());
		SelectText(bv->GetText(), on);
	}
};

bool ListView::HasText(const String& text)
{
	const Children& children = GetChildren();
    Children::const_iterator b = children.begin();
    Children::const_iterator e = children.end();
    for(; b!= e; ++b)
    {
    	const View::owner& v = *b;
    	ButtonView* bv = static_cast<ButtonView*> (v.operator->());
    	if (text == bv->GetText())
    		return true;
    }
	return false;
}

void ListView::SelectText(const String& text, bool on)
{
	bool found = false;
	const Children& children = GetChildren();
    Children::const_iterator b = children.begin();
    Children::const_iterator e = children.end();
    for(; b!= e; ++b)
    {
    	const View::owner& v = *b;
    	ButtonView* bv = static_cast<ButtonView*> (v.operator->());
    	if (text == bv->GetText())
    	{
    		if (on)
	    		bv->StateSetReset(ButtonView::State3RD, 0);
	    	else
	        	bv->StateSetReset(0, ButtonView::State3RD);
    		found = true;
    		bv->Refresh();
    	}
    	else if (bv->IsStateSet(ButtonView::State3RD))
    	{
   			bv->StateSetReset(0, ButtonView::State3RD);
   			bv->Refresh();
   		}
    }
    if (found) 
		Notify_SelectionChanged(text,on);
}

void ListView::UnselectAll()
{
	bool found = false;
	const Children& children = GetChildren();
    Children::const_iterator b = children.begin();
    Children::const_iterator e = children.end();
    for(; b!= e; ++b)
    {
    	const View::owner& v = *b;
    	ButtonView* bv = static_cast<ButtonView*> (v.operator->());
    	if (bv->IsStateSet(ButtonView::State3RD))
    	{
   			bv->StateSetReset(0, ButtonView::State3RD);
   			bv->Refresh();
   			found = true;
   		}
    }
    if (found)
		Notify_SelectionChanged(String::kEmpty, false);
}

bool ListView::IsSelectedText(const String& text)
{
	const Children& children = GetChildren();
    Children::const_iterator b = children.begin();
    Children::const_iterator e = children.end();
    for(; b!= e; ++b)
    {
    	const View::owner& v = *b;
    	ButtonView* bv = static_cast<ButtonView*> (v.operator->());
    	if (text == bv->GetText())
    	{
    		return bv->IsStateSet(ButtonView::State3RD);
    	}
    }
    return false;
}

const String& ListView::GetSelectedText()
{
	const Children& children = GetChildren();
    Children::const_iterator b = children.begin();
    Children::const_iterator e = children.end();
    for(; b!= e; ++b)
    {
    	const View::owner& v = *b;
    	ButtonView* bv = static_cast<ButtonView*> (v.operator->());
    	if (bv->IsStateSet(ButtonView::State3RD))
    	{
    		return bv->GetText();
   		}
    }
    return String::kEmpty;
}

void ListView::ShowSelection()
{
	const Children& children = GetChildren();
    Children::const_iterator b = children.begin();
    Children::const_iterator e = children.end();
    for(; b!= e; ++b)
    {
    	const View::owner& v = *b;
    	ButtonView* bv = static_cast<ButtonView*> (v.operator->());
    	if (bv->IsStateSet(ButtonView::State3RD))
    	{
			MakeVisible(bv->GetBounds());
			bv->SetFocused();
			return;
   		}
    }
}

void ListView::SetFont(const TextFont& f)
{	
	if (f == GetFont())
		return;
	View::SetFont(f);
	const Children& children = GetChildren();
    Children::const_iterator b = children.begin();
    Children::const_iterator e = children.end();
    for(; b!= e; ++b)
    {
    	const View::owner& v = *b;
    	v->SetFont(f);
    }
}

void ListView::SetSkin(const ViewSkin::owner& s)
{	
	if (s == GetSkin())
		return;
	View::SetSkin(s);
	ViewSkin::owner sc=GetSkinPartOrDefault(String::From_c_str("Item"));
	const Children& children = GetChildren();
    Children::const_iterator b = children.begin();
    Children::const_iterator e = children.end();
    for(; b!= e; ++b)
    {
    	const View::owner& v = *b;
    	v->SetSkin(sc);
    }
}

void ListView::AddText(const String& text)
{
	if (HasText(text))
		return;
	
	refc<ButtonView> bv( new ButtonView() );
	bv->AddActionListener(new ListView::ComponentListener(this));
	bv->SetFont(GetFont());
	bv->SetText(text);
	bv->SetSkin(GetSkinPartOrDefault(String::From_c_str("Item")));
	bv->Set3StateButton(true); // any list item can be selected (checked)
	bv->SetFocusable(true);
    {
		Rect2D bounds(GetScrollBounds());
		if (bounds.isEmpty())
		{
			bounds = GetLocalBounds();
			bounds.h = 0;
		}
		bounds.y += bounds.h;
		bounds.h = bv->GetPreferredSize().h;
		bv->SetBounds(bounds);
    }
	AddView(bv.operator->());
}

void ListView::RemoveText(const String& text)
{
	const Children& children = GetChildren();
    Children::const_iterator b = children.begin();
    Children::const_iterator e = children.end();
    for(; b!= e; ++b)
    {
    	const View::owner& v = *b;
    	ButtonView* bv = static_cast<ButtonView*> (v.operator->());
    	if (text == bv->GetText())
    	{
    		RemoveView(v);
    		return;
    	}
    }
}

void ListView::RemoveAllText()
{
	RemoveAllChildren();
}


} // namespace XSP
