//*******************************************************//
//                                                       //
//                      DelphiFlash.com                  //
//              Copyright (c) 2004 FeatherySoft, Inc.    //
//                    info@delphiflash.com               //
//                                                       //
//*******************************************************//

//  Description:  TFlashCanvas demo
//  Last date update:  21 dec 2004

unit UTestCanvas;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleCtrls, ShockwaveFlashObjects_TLB, ShockwaveEx, ExtCtrls,
  StdCtrls, CheckLst, ExtDlgs;

type
  TTestForm = class(TForm)
    Splitter: TSplitter;
    Panel1: TPanel;
    Panel2: TPanel;
    FlashPlayer: TShockwaveFlashEx;
    PaintBox: TPaintBox;
    Bevel2: TBevel;
    Bevel3: TBevel;
    LFlash: TLabel;
    LDelphi: TLabel;
    CBShadow: TCheckBox;
    IMask: TImage;
    IDelphi: TImage;
    Panel3: TPanel;
    CBDraw: TCheckListBox;
    Bevel1: TBevel;
    DrawBG: TCheckBox;
    ShBG: TShape;
    CD: TColorDialog;
    MF: TImage;
    ODP: TOpenPictureDialog;
    EmbeddedFont: TCheckBox;
    procedure FormResize(Sender: TObject);
    procedure PaintBoxPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Panel2Resize(Sender: TObject);
    procedure CBShadowClick(Sender: TObject);
    procedure FormCanResize(Sender: TObject; var NewWidth,
      NewHeight: Integer; var Resize: Boolean);
    procedure DrawBGClick(Sender: TObject);
    procedure ShBGMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure CBDrawDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure CBDrawEndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure CBDrawClickCheck(Sender: TObject);
    procedure MFClick(Sender: TObject);
  private

  public
    W1, W2: integer;
    SSet: boolean;
    TempName: string;
    procedure DemoDraw(C: TCanvas);
  end;

var
  TestForm: TTestForm;

implementation

{$R *.dfm}
Uses SWFConst, SWFTools, FlashObjects;

type
  TTriVertex = packed record
    x: Longint;
    y: Longint;
    Red: Word;
    Green: Word;
    Blue: Word;
    Alpha: Word;
  end;

Function GradientFill (Handle: HDC; pVertex: Pointer; dwNumVertex: DWORD;
    pMesh: Pointer; dwNumMesh: DWORD; dwMode: DWORD): DWORD; stdcall; external 'msimg32.dll' name 'GradientFill';


procedure TTestForm.DemoDraw(C: TCanvas);
var
  I, il: Integer;
  AP: array [0..12] of TPoint;
  WP: array [0..2] of TPoint;
  R: TRect;
  RGN1, RGN2: THandle;
  VGr: array [0..1] of TTriVertex;
  GrR: TGradientRect;
  LF: TLogFont;
  FillBMP: TBitMap;

begin
 C.Pen.Style := psSolid;
 C.PenPos := Point (0,0);
 C.Brush.Style:=bsSolid;

 for il := 0 to CBDraw.Items.Count - 1 do
  if CBDraw.Checked[il] then
   case Longint(CBDraw.Items.Objects[il]) of
    0:begin   // LineTo
       C.Pen.Style := psSolid;
       C.Pen.Color := clBlue;
       C.MoveTo(10, 10);   // EMR_MOVETOEX
       C.LineTo(150, 120); // EMR_LINETO
       C.MoveTo(160, 10);

       C.LineTo(10, 120);
       C.MoveTo(60, 127);
       C.Pen.Style:= psDashDotDot;
       C.LineTo(286, 110);
       C.LineTo(20, 250);
       C.Pixels[120, 70]:=clBlue;
     end;

     1: begin   // Rectangle
       C.Pen.Color := clRed;
       C.Brush.Color := clSkyBlue;
//       C.Brush.Style := bsClear; // EMR_SETBKMODE
       C.Rectangle(10, 10, 100, 100);
       C.Pen.Style:= psDash;
       C.RoundRect(20, 120, 250, 200, 20, 60); // EMR_ROUNDRECT

     end;

     2: begin   // Ellipse
       C.Pen.Color := clRed;
       C.Pen.Style := psClear;
       C.Brush.Color := clGreen;
       C.Ellipse(50, 30, 150, 80);
       C.Pen.Style := psSolid;
     end;

     3: begin     // PolyLine
       C.Pen.Color := clRed;

       for I := 0 to 12 do
            AP[I]:= Point(10 + 25*i, 150 + 50 *(i mod 2));
       C.Polyline(AP);  // EMR_POLYLINE16
     end;

     4: begin     // PolyBezier
       if true then
       begin
         C.MoveTo(0, 24);   // EMR_MOVETOEX
         C.LineTo(438,24); // EMR_LINETO
         C.LineTo(438,333); // EMR_LINETO
         C.LineTo(0,333); // EMR_LINETO
         C.LineTo(0,24); // EMR_LINETO
         C.MoveTo(87, 82);   // EMR_MOVETOEX
         C.LineTo(87,273); // EMR_LINETO
         C.LineTo(358,273); // EMR_LINETO
         C.LineTo(358,82); // EMR_LINETO
         C.LineTo(87, 82);
       end else
       begin
       C.Pen.Color := clFuchsia;
         for I := 0 to 12 do AP[i]:=Point(10+25*i, 120 + 50 *(i mod 2)-5*i);
         C.Pen.Color := clOlive;
         C.PolyBezierTo(Slice(AP, 12));  //EMR_POLYBEZIER16
       end;
     end;

     5: begin      // Pie, Chord
       C.Brush.Color := clOlive;
       C.Brush.Style := bsSolid; // EMR_SETBKMODE

       // default = AD_COUNTERCLOCKWISE
       C.Pen.Color := clFuchsia;
       SetArcDirection(C.Handle, AD_CLOCKWISE	);  // EMR_SETARCDIRECTION
         C.Arc(30, 220, 50, 250, 10, 190, 30, 270); // EMR_ARC
       SetArcDirection(C.Handle, AD_COUNTERCLOCKWISE);  // EMR_SETARCDIRECTION

       C.Pie(100, 100, 300, 300, 100, 100, 300, 200);  // EMR_PIE
       C.Brush.Color := clTeal;
       C.Chord(175, 180, 270, 300, 100, 100, 350, 100); // EMR_CHORD

       C.Pen.Color := clSilver;
       C.Brush.Color := clBlue;
       C.Brush.Style := bsDiagCross; // EMR_SETBKMODE
       C.Chord(105, 180, 200, 260, 20, 100, 220, 200); // EMR_CHORD
  //     C.LineTo(220, 120);

  //     C.Arc(100, 200, 150, 300, 124, 149, 300, 300); // EMR_ARC
       C.Brush.Style := bsSolid;
     end;

     6: begin   // AngleArc
       C.Pen.Color := clOlive;
       SetArcDirection(C.Handle, AD_CLOCKWISE);  // EMR_SETARCDIRECTION
       AngleArc(C.Handle, 50, 260, 30, 110, 300); // EMR_ANGLEARC
       C.LineTo(300, 320);
     end;

     7: begin     // TextOut
       SetBkColor(C.Handle, $FFFF0432);  // EMR_SETBKCOLOR
       C.Brush.Style :=bsSolid; // EMR_SETBKMODE
       C.Font.Color := clRed;  // EMR_SETTEXTCOLOR
       C.Font.Name := 'Arial';
       C.Font.Size := 20;

       C.TextOut(20, 50, ' SAMPLE  1');   // EMR_EXTTEXTOUTW

       C.Font.Color := clGreen;
       GetObject(C.Font.Handle, SizeOf(LF), @LF);
       LF.lfEscapement := 320;
       Lf.lfHeight:= - 44;
       LF.lfWidth := 20;                // <----- WIDTH ------
       LF.lfCharSet := 178;
       DeleteObject(SelectObject(C.Handle, CreateFontIndirect(LF)));
       C.TextOut(20, 250,'Angle SAMPLE');

       C.Font.Color := clPurple;  // EMR_SETTEXTCOLOR
       C.Font.Name := 'Times New Roman';
       C.Font.Size := 18;
       C.Brush.Style := bsClear; // EMR_SETBKMODE
       C.Font.Color := clSilver;
       C.TextOut(30, 10, 'CharSpacing sample');
       SetTextCharacterExtra(C.Handle, 5);  // <<--- SPASING -----
       C.Font.Color := clRed;
       C.TextOut(30, 10, 'CharSpacing sample');    // EMR_EXTTEXTOUTW

       C.Brush.Style :=bsClear; // EMR_SETBKMODE
       C.Font.Color := clGray;  // EMR_SETTEXTCOLOR
       R := Rect(40, 100, 260, 150);
       C.RoundRect(R.Left, R.Top, R.Right, R.Bottom, 16, 16); // EMR_ROUNDRECT

       // EMR_INTERSECTCLIPRECT + EMR_EXTTEXTOUTW  + EMR_EXTSELECTCLIPRGN
       GetObject(C.Font.Handle, SizeOf(LF), @LF);
       LF.lfWidth := 20;                // <----- WIDTH ------
       SetTextCharacterExtra(C.Handle, 5);  // <<--- SPASING -----
       DeleteObject(SelectObject(C.Handle, CreateFontIndirect(LF)));
       DrawText(C.Handle, 'Align sample', -1, R, DT_CENTER + DT_VCenter + DT_SINGLELINE);

       C.Font.Color := $000080;
       C.Font.Height := 20;
       SetTextCharacterExtra(C.Handle, 10);  // <<---
       R := Rect(50, 200, 200, 350);
       DrawText(C.Handle, 'Multiline text Multiline text...'#13'multiline!', -1, R, DT_Center + DT_WORDBREAK);

     end;

     8: with IDelphi.Picture do      // BitBlt
     begin
       C.StretchDraw(Rect(170, 180, 230, 220), Bitmap);  // EMR_STRETCHBLT
       BitBlt(C.Handle, 170, 140, 30, 30, Bitmap.Canvas.Handle, 0, 0, SRCCOPY); // EMR_BITBLT
       MaskBlt(C.Handle, 170, 230, 47, 60, Bitmap.Canvas.Handle,
                0, 0, IMask.Picture.Bitmap.Handle, 0, 0, $ccaa0000); // EMR_MASKBLT
     end;

     9:begin                       // Fills
        C.Pen.Style := psDashDotDot;
        C.Brush.Color := clMedGray;
        C.Brush.Style :=  bsHorizontal;
        C.Ellipse(150, 130, 250, 180);

//        C.Pen.Style :=  psSolid;
        C.Brush.Style :=  bsFDiagonal; // bsHorizontal;
        C.Brush.Color := clRed;
        C.FillRect(Rect(120, 20, 250, 90));
        C.Rectangle(0, 0, 100, 100);

        C.Brush.Color := clGreen;
        C.Brush.Style :=  bsDiagCross;
        C.Ellipse(50, 80, 150, 130);

        FillBMP := TBitMap.Create;
        With FillBMP do
          begin
            PixelFormat  := pf24bit;
            Width := 3;
            Height := 3;
            SetPixel(Canvas.Handle, 0, 0, $FF0000);
            SetPixel(Canvas.Handle, 0, 1, $FF0000);
            SetPixel(Canvas.Handle, 1, 1, $0000FF);
            SetPixel(Canvas.Handle, 1, 0, $0000FF);
          end;
         C.Brush.Bitmap := FillBMP;
         C.Rectangle(30, 150, 150, 200);
         C.Brush.Bitmap := nil;
         FillBMP.Free;
        C.Brush.Style :=  bsSolid;
       end;
     10: begin                    // Regions
       C.Brush.Color := clSkyBlue;
       C.Brush.Style := bsSolid;
(*
       RGN1 := CreateRectRgn(50, 20, 200, 300);
       RGN2 := CreateRectRgn(100, 50, 150, 200);
       CombineRgn(RGN1, RGN1, RGN2, RGN_AND);
*)
       RGN1 := CreateEllipticRgn(50, 40, 200, 100);
       RGN2 := CreateRectRgn(100, 20, 150, 200);
       CombineRgn(RGN1, RGN1, RGN2, RGN_XOR);

       FillRGN(C.Handle, RGN1, C.Brush.Handle);  // EMR_FILLRGN
//       FrameRgn(C.Handle, RGN1, C.Brush.Handle, 1, 1); // EMR_FRAMERGN
//       InvertRgn(C.Handle, RGN1);              // EMR_INVERTRGN

       DeleteObject(RGN2);
       DeleteObject(RGN1);
     end;
     11: begin                   // GradientFill
{
      R = color shl 8 and $FF00;
      G = color and $FF00;
      B = color shr 8 and $FF00;
}
        With VGr[0] do
        begin
         x := 10; y := 200; Red := 0; Green := $FF00; Blue := 0;
        end;

       With VGr[1] do
        begin
         x := 110; y := 350; Red := $FF00; Green := 0; Blue := 0;
        end;

       GrR.UpperLeft := 0; GrR.LowerRight := 1;
       GradientFill(C.Handle, @VGr, 2, @GrR, 1, GRADIENT_FILL_RECT_h);

       With VGr[0] do
        begin
         x := 150; y := 200; Red := 0; Green := $FF00; Blue := 0;
        end;

       With VGr[1] do
        begin
         x := 250; y := 350; Red := $0; Green := 0; Blue := $FF00;
        end;
       GradientFill(C.Handle, @VGr, 2, @GrR, 1, GRADIENT_FILL_RECT_V);
     end;
     12: begin           // Path

       C.Font.Size := 42;
       C.Font.Name := 'Times New Roman';
       C.Font.Style := [fsBold];
       C.Brush.Color := clRed;
//       C.Brush.Style := bsFDiagonal;
       C.Brush.Style := bsSolid;
       C.Pen.Style:=psClear;

       BeginPath(C.Handle);

       C.Brush.Style := bsFDiagonal;
       C.TextOut(20, 20, 'IT PATH!');
       C.RoundRect(10, 100, 100, 150, 20, 20);
       C.Ellipse(120, 100, 210, 150);

       for I := 0 to 10 do
       begin
         AP[i]:=Point(10+6*(5-i)*(5-i), 170+5*(i-3)*(i-3));
       end;
       AP[11]:=Point(80, 260); AP[12] := Point(150, 230); AP[12]:=AP[0];

       C.PolyBezier(AP);  //EMR_POLYBEZIER16

       EndPath(C.Handle);

       FillPath(C.Handle);
       C.Pen.Style:=psSolid;

(*
      for I := 0 to 12 do AP[i]:=Point(10+AP[0].X+Abs(AP[0].X-AP[i].X), AP[i].Y);
       BeginPath(C.Handle);
       C.PolyBezier(AP);  //EMR_POLYBEZIER16
       EndPath(C.Handle);
       C.Brush.Style:=bsSolid;
       FillPath(C.Handle);
*)
     end;
     13: begin // normal Metafile
       C.Draw(0, 10, MF.Picture.Metafile);
     end;
     14: begin // Stretch Metafile
       C.StretchDraw(Rect(0, 10, 300, 400), MF.Picture.Metafile);
     end;

   end;

end;

procedure TTestForm.FormResize(Sender: TObject);
begin
  SSet := false;
  Panel1.Width := Round(W1 /(W1 + W2 + 3) * (ClientWidth-CBDraw.Width));
  FlashPlayer.CreateWnd;
end;

procedure TTestForm.PaintBoxPaint(Sender: TObject);
begin
  if DrawBG.Checked then
   with PaintBox.Canvas do
    begin
      Brush.Color := ShBG.Brush.Color;
      Brush.Style := bsSolid;
      Rectangle(-1, -1, ClientWidth, ClientHeight);
    end;
  DemoDraw(PaintBox.Canvas);
end;

procedure TTestForm.FormCreate(Sender: TObject);
 var il: integer;
begin
 SSet := false;
 for il := 0 to CBDraw.Items.Count - 1 do
   CBDraw.Items.Objects[il] := Pointer(LongInt(il));
 CBShadowClick(nil);
end;

procedure TTestForm.Panel2Resize(Sender: TObject);
begin
  FlashPlayer.CreateWnd;
end;

procedure TTestForm.CBShadowClick(Sender: TObject);
 var
   Movie: TFlashMovie;
   S: string;
begin
  S := ExtractFilePath(ParamStr(0)) + IntToStr(Random(9999))+ '.swf';
  Movie := TFlashMovie.Create(0, 0, Screen.Width * twips, Screen.Height * twips, 1);
  Movie.SystemCoord := scPix;
  if DrawBG.Checked then
//    Movie.BackgroundColor.RGB := SWFRGB(ShBG.Brush.Color)
    FlashPlayer.BackgroundColor := RGB(GetBValue(ShBG.Brush.Color),
                                       GetGValue(ShBG.Brush.Color),
                                       GetRValue(ShBG.Brush.Color))
   else
    FlashPlayer.BackgroundColor := $FFFFFF;

  Movie.Canvas.EmbeddedFont := EmbeddedFont.Checked;
  DemoDraw(Movie.Canvas);
  Movie.Canvas.Place(2, False);

  if CBShadow.Checked then
   with Movie.Canvas do
     begin
       //   ""  ===>
       Pen.Color := clYellow;
       Pen.Style := psSolid;
       Pen.Width := 2;
       MoveTo(0, 5); LineTo(10, 5);
       MoveTo(5, 0); LineTo(5, 10);
       // <===

       with Place(1) do
         begin
           SetTranslate(10, 3);
           ColorTransform.addA := -150;
           ColorTransform.addR := -$FF;
           ColorTransform.addG := -$FF;
           ColorTransform.addB := -$FF;
         end;
     end;

  Movie.ShowFrame;

  Movie.MakeStream;
  Movie.SaveToFile(S);
  Movie.Free;
  if fileExists(FlashPlayer.Movie) then DeleteFile(FlashPlayer.Movie);
  FlashPlayer.Movie := S;
  FlashPlayer.CreateWnd;
end;

procedure TTestForm.FormCanResize(Sender: TObject; var NewWidth,
  NewHeight: Integer; var Resize: Boolean);
begin
  if not SSet then
    begin
      SSet := true;
      W1 := Panel1.Width;
      W2 := Panel2.Width;
    end;  
end;

procedure TTestForm.DrawBGClick(Sender: TObject);
begin
  CBDrawClickCheck(nil);
end;

procedure TTestForm.ShBGMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 CD.Color := ShBG.Brush.Color;
 if CD.Execute then ShBG.Brush.Color := CD.Color;
 if DrawBG.Checked then CBDrawClickCheck(nil);
end;

procedure TTestForm.CBDrawDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  Accept := Source = CBDraw;
end;

procedure TTestForm.CBDrawEndDrag(Sender, Target: TObject; X, Y: Integer);
 var il: integer;
     b: boolean;
begin
  il := CBDraw.ItemAtPos(Point(X,Y), b);
  if b and (il<>-1) and (CBDraw.ItemIndex <> il) then
    begin
     CBDraw.Items.Move(CBDraw.ItemIndex, il);
     CBDrawClickCheck(nil);
    end;
end;

procedure TTestForm.CBDrawClickCheck(Sender: TObject);
begin
  PaintBox.Invalidate;
  CBShadowClick(nil);
end;

procedure TTestForm.MFClick(Sender: TObject);
begin
  If ODP.Execute then
   MF.Picture.Metafile.LoadFromFile(ODP.FileName);
end;

end.
