//*******************************************************//
//                                                       //
//                      DelphiFlash.com                  //
//              Copyright (c) 2004 FeatherySoft, Inc.    //
//                    info@delphiflash.com               //
//                                                       //
//*******************************************************//

//  Description: text constants indicated of SWF vocabulary
//  Last update:  27 nov 2004

unit SWFStrings;
interface
 Uses Windows, SysUtils, Classes, SWFConst;


 Function GetTagName(ID: word): string;
 Function GetActionName(ID: word): string;
 function GetClipEventFlagsName(EF: TSWFClipEvents):string;
 
implementation

Function GetTagName(ID: word): string;
begin
 case ID of
   tagEnd:  Result:='End';
   tagShowFrame:  Result:='ShowFrame';
   tagDefineShape:  Result:='DefineShape';
 //  tagFreeCharacter:  Result:='FreeCharacter';
   tagPlaceObject:  Result:='PlaceObject';
   tagRemoveObject:  Result:='RemoveObject';
   tagDefineBits:  Result:='DefineBits';
   tagDefineButton:  Result:='DefineButton';
   tagJPEGTables:  Result:='JPEGTables';
   tagSetBackgroundColor:  Result:='SetBackgroundColor';
   tagDefineFont: Result:='DefineFont';
   tagDefineText: Result:='DefineText';
   tagDoAction: Result:='DoAction';
   tagDefineFontInfo: Result:='DefineFontInfo';
   tagDefineFontInfo2: Result:='DefineFontInfo2';
   tagDefineSound: Result:='DefineSound';
   tagStartSound: Result:='StartSound';
   tagDefineButtonSound: Result:='DefineButtonSound';
   tagSoundStreamHead: Result:='SoundStreamHead';
   tagSoundStreamBlock: Result:='SoundStreamBlock';
   tagDefineBitsLossless: Result:='DefineBitsLossless';
   tagDefineBitsJPEG2: Result:='DefineBitsJPEG2';
   tagDefineShape2: Result:='DefineShape2';
   tagDefineButtonCxform: Result:='DefineButtonCxform';
   tagProtect: Result:='Protect';
   tagPlaceObject2: Result:='PlaceObject2';
   tagRemoveObject2: Result:='RemoveObject2';
   tagDefineShape3: Result:='DefineShape3';
   tagDefineText2: Result:='DefineText2';
   tagDefineButton2: Result:='DefineButton2';
   tagDefineBitsJPEG3: Result:='DefineBitsJPEG3';
   tagDefineBitsLossless2: Result:='DefineBitsLossless2';
   tagDefineEditText: Result:='DefineEditText';
   tagDefineSprite: Result:='DefineSprite';
   tagNameCharacter: Result:='NameCharacter';
   tagFrameLabel: Result:='FrameLabel';
   tagSoundStreamHead2: Result:='SoundStreamHead2';
   tagDefineMorphShape: Result:='DefineMorphShape';
   tagDefineFont2: Result:='DefineFont2';
   tagExportAssets: result:='ExportAssets';
   tagImportAssets: result:='ImportAssets';
   tagDoInitAction: Result:='DoInitAction';
   tagDefineVideoStream: Result:='DefineVideoStream';
   tagVideoFrame: Result := 'VideoFrame';
   tagEnableDebugger: Result := 'EnableDebugger';
   tagEnableDebugger2: Result := 'EnableDebugger2';
   tagExtDebuggerInfo: Result := 'ExtDebuggerInfo';
   tagErrorTag: Result := 'Error Tag';
 else Result := 'Unknown ' + IntToStr(ID);
 end;
end;

Function GetActionName(ID: word): string;
begin
 Case ID of
   // SWF 3
   ActionPlay: Result := 'ActionPlay';
   ActionStop: Result := 'ActionStop';
   ActionNextFrame: Result := 'ActionNextFrame';
   ActionPreviousFrame: Result := 'ActionPreviousFrame';
   ActionGotoFrame: Result := 'ActionGotoFrame';
   ActionGoToLabel: Result := 'ActionGoToLabel';
   ActionWaitForFrame: Result := 'ActionWaitForFrame';
   ActionGetURL: Result := 'ActionGetURL';
   ActionStopSounds: Result := 'ActionStopSounds';
   ActionToggleQuality: Result := 'ActionToggleQuality';
   ActionSetTarget: Result := 'ActionSetTarget';

   //SWF 4
   ActionAdd: Result := 'ActionAdd';
   ActionDivide: Result := 'ActionDivide';
   ActionMultiply: Result := 'ActionMultiply';
   ActionSubtract: Result := 'ActionSubtract';
   ActionEquals: Result := 'ActionEquals';
   ActionLess: Result := 'ActionLess';
   ActionAnd: Result := 'ActionAnd';
   ActionNot: Result := 'ActionNot';
   ActionOr: Result := 'ActionOr';
   ActionStringAdd: Result := 'ActionStringAdd';
   ActionStringEquals: Result := 'ActionStringEquals';
   ActionStringExtract: Result := 'ActionStringExtract';
   ActionStringLength: Result := 'ActionStringLength';
   ActionMBStringExtract: Result := 'ActionMBStringExtract';
   ActionMBStringLength: Result := 'ActionMBStringLength';
   ActionStringLess: Result := 'ActionStringLess';
   ActionPop: Result := 'ActionPop';
   ActionPush: Result := 'ActionPush';
   ActionAsciiToChar: Result := 'ActionAsciiToChar';
   ActionCharToAscii: Result := 'ActionCharToAscii';
   ActionToInteger: Result := 'ActionToInteger';
   ActionMBAsciiToChar: Result := 'ActionMBAsciiToChar';
   ActionMBCharToAscii: Result := 'ActionMBCharToAscii';
   ActionCall: Result := 'ActionCall';
   ActionIf: Result := 'ActionIf';
   ActionJump: Result := 'ActionJump';
   ActionGetVariable: Result := 'ActionGetVariable';
   ActionSetVariable: Result := 'ActionSetVariable';
   ActionGetURL2: Result := 'ActionGetURL2';
   ActionGetProperty: Result := 'ActionGetProperty';
   ActionGotoFrame2: Result := 'ActionGotoFrame2';
   ActionRemoveSprite: Result := 'ActionRemoveSprite';
   ActionSetProperty: Result := 'ActionSetProperty';
   ActionSetTarget2: Result := 'ActionSetTarget2';
   ActionStartDrag: Result := 'ActionStartDrag';
   ActionWaitForFrame2: Result := 'ActionWaitForFrame2';
   ActionCloneSprite: Result := 'ActionCloneSprite';
   ActionEndDrag: Result := 'ActionEndDrag';
   ActionGetTime: Result := 'ActionGetTime';
   ActionRandomNumber: Result := 'ActionRandomNumber';
   ActionTrace: Result := 'ActionTrace';

   //SWF 5
   ActionCallFunction: Result := 'ActionCallFunction';
   ActionCallMethod: Result := 'ActionCallMethod';
   ActionConstantPool: Result := 'ActionConstantPool';
   ActionDefineFunction: Result := 'ActionDefineFunction';
   ActionDefineLocal: Result := 'ActionDefineLocal';
   ActionDefineLocal2: Result := 'ActionDefineLocal2';
   ActionDelete: Result := 'ActionDelete';
   ActionDelete2: Result := 'ActionDelete2';
   ActionEnumerate: Result := 'ActionEnumerate';
   ActionEquals2: Result := 'ActionEquals2';
   ActionGetMember: Result := 'ActionGetMember';
   ActionInitArray: Result := 'ActionInitArray';
   ActionInitObject: Result := 'ActionInitObject';
   ActionNewMethod: Result := 'ActionNewMethod';
   ActionNewObject: Result := 'ActionNewObject';
   ActionSetMember: Result := 'ActionSetMember';
   ActionTargetPath: Result := 'ActionTargetPath';
   ActionWith: Result := 'ActionWith';
   ActionToNumber: Result := 'ActionToNumber';
   ActionToString: Result := 'ActionToString';
   ActionTypeOf: Result := 'ActionTypeOf';
   ActionAdd2: Result := 'ActionAdd2';
   ActionLess2: Result := 'ActionLess2';
   ActionModulo: Result := 'ActionModulo';
   ActionBitAnd: Result := 'ActionBitAnd';
   ActionBitLShift: Result := 'ActionBitLShift';
   ActionBitOr: Result := 'ActionBitOr';
   ActionBitRShift: Result := 'ActionBitRShift';
   ActionBitURShift: Result := 'ActionBitURShift';
   ActionBitXor: Result := 'ActionBitXor';
   ActionDecrement: Result := 'ActionDecrement';
   ActionIncrement: Result := 'ActionIncrement';
   ActionPushDuplicate: Result := 'ActionPushDuplicate';
   ActionReturn: Result := 'ActionReturn';
   ActionStackSwap: Result := 'ActionStackSwap';
   ActionStoreRegister: Result := 'ActionStoreRegister';

   //SWF 6
   ActionInstanceOf: Result := 'ActionInstanceOf';
   ActionEnumerate2: Result := 'ActionEnumerate2';
   ActionStrictEquals: Result := 'ActionStrictEquals';
   ActionGreater: Result := 'ActionGreater';
   ActionStringGreater: Result := 'ActionStringGreater';

   //SWF 7
   ActionDefineFunction2: Result := 'ActionDefineFunction2';
   ActionExtends: Result := 'ActionExtends';
   ActionCastOp: Result := 'ActionCastOp';
   ActionImplementsOp: Result := 'ActionImplementsOp';
   ActionTry: Result := 'ActionTry';
   ActionThrow: Result := 'ActionThrow';

   ActionByteCode: Result := 'ActionByteCode';

   actionOffsetWork: Result := 'Offset marker (only for work)'
   else Result := 'Unknown ' + IntToStr(ID);
 end;
end;

function GetClipEventFlagsName(EF: TSWFClipEvents):string;
begin
  if ceKeyUp in EF then result := 'OnKeyUp, ';
  if ceKeyDown in EF then result := 'OnKeyDown, ';
  if ceMouseUp in EF then result := 'OnMouseUp, ';
  if ceMouseDown in EF then result := 'OnMouseDown, ';
  if ceMouseMove in EF then result := 'OnMouseMove, ';
  if ceUnload in EF then result := 'OnUnload, ';
  if ceEnterFrame in EF then result := 'OnEnterFrame, ';
  if ceLoad in EF then result := 'OnLoad, ';
  if ceDragOver in EF then result := 'OnDragOver, ';
  if ceRollOut in EF then result := 'OnRollOut, ';
  if ceRollOver in EF then result := 'OnRollOver, ';
  if ceReleaseOutside in EF then result := 'OnReleaseOutside, ';
  if ceRelease in EF then result := 'OnRelease, ';
  if cePress in EF then result := 'OnPress, ';
  if ceInitialize in EF then result := 'OnInitialize, ';
  if ceData in EF then result := 'OnData, ';
  if ceConstruct in EF then result := 'OnConstruct, ';
  if ceKeyPress in EF then result := 'OnKeyPress, ';
  if ceDragOut in EF then result := 'OnDragOut, ';

  if Result<>'' then Delete(Result, Length(Result)-1, 2);
end;

end.
