// tabdemodlg.cpp : implementation file
//

#include "stdafx.h"

#if (!defined __EXT_MFC_NO_TAB_CTRL)

#include "profuis_controls.h"

#include "tabdemodlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTabDemoDlg dialog

CTabDemoDlg::demo_items_data_t CTabDemoDlg::g_ItemsData[] =
{
	{ _T("DevStudio"),				true  },
	
	{ _T("Help Index"),				true  },
	{ _T("Help Search"),			false },
	{ _T("Index Results"),			false },
	{ _T("Contents"),				false },
	
	{ _T("Reload"),					true  },
	{ _T("Home"),					false },
	{ _T("Browser"),				false },
	
	{ _T("Find Results 1"),			true  },
	{ _T("Find Symbol Results"),	false },
	{ _T("Find Results 2"),			false },
	{ _T("Find In Files"),			false },
	
	{ _T("Favorites"),				true  },
	{ _T("Add To Favorites"),		false },
	
	{ _T("Full Screen"),			true  },

	{ _T("Dynamic Help"),			true  },
	
	{ _T("Resource View"),			true  },
	{ _T("Solution Explorer"),		false },
	{ _T("Class View"),				false },
	
	{ _T("Toolbox"),				true  },
	{ _T("Task List"),				false },

	{ _T("Open"),					true  },
	{ _T("Save All"),				false },
};

CTabDemoDlg::CTabDemoDlg(CWnd* pParent /*=NULL*/)
	: CExtResizableDialog(CTabDemoDlg::IDD, pParent)
	, m_nDemoImageListSize( sizeof( g_ItemsData ) / sizeof( g_ItemsData[0] ) )
	, m_nDemoImageListAddIndexInner( 0 )
	, m_nDemoImageListAddIndexOuter( 0 )
{
	//{{AFX_DATA_INIT(CTabDemoDlg)
	//}}AFX_DATA_INIT

	VERIFY(
		m_ImageList.Create(
			IDR_TAB_IMAGES,
			16,
			1,
			RGB(255,0,255)
			)
		);
	ASSERT( m_ImageList.GetImageCount() >= m_nDemoImageListSize );
}


void CTabDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CExtResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTabDemoDlg)
	DDX_Control(pDX, IDC_CHECK_FOCUS_ON_HOVER, m_CheckFocusOnHover);
	DDX_Control(pDX, IDC_CHECK_FULL_WIDTHS, m_CheckFullRowWidth);
	DDX_Control(pDX, IDC_CHECK_CENTER_TEXT, m_CheckCenterText);
	DDX_Control(pDX, IDC_CHECK_AUTOHIDE_SCROLL, m_CheckAutoHideScroll);
	DDX_Control(pDX, IDC_CHECK_ENABLE_HELP, m_CheckEnableHelp);
	DDX_Control(pDX, IDC_CHECK_ENABLE_CLOSE, m_CheckEnableClose);
	DDX_Control(pDX, IDC_CHECK_SHOW_HELP, m_CheckShowHelp);
	DDX_Control(pDX, IDC_CHECK_BOLD_SELECTION, m_CheckBoldSelection);
	DDX_Control(pDX, IDC_CHECK_SHOW_CLOSE, m_CheckShowClose);
	DDX_Control(pDX, IDC_CHECK_INVERT_VERT_FONT, m_CheckInvertFont);
	DDX_Control(pDX, IDC_CHECK_EQUAL_WIDTHS, m_CheckEqualWidth);
	DDX_Control(pDX, IDC_CHECK_SHOW_BORDERS, m_CheckShowBorders);
	DDX_Control(pDX, IDC_BUTTON_ADD_TAB_10, m_BtnAdd10);
	DDX_Control(pDX, IDC_BUTTON_ADD_TAB_1, m_BtnAdd1);
	DDX_Control(pDX, IDC_BUTTON_CLEAR_TABS, m_BtnClear);
	//}}AFX_DATA_MAP

	DDX_Control( pDX, ID_TABCTRL_OUTER_TOP, m_wndTabOuterTop );
	DDX_Control( pDX, ID_TABCTRL_OUTER_BOTTOM, m_wndTabOuterBottom );
	DDX_Control( pDX, ID_TABCTRL_OUTER_LEFT, m_wndTabOuterLeft );
	DDX_Control( pDX, ID_TABCTRL_OUTER_RIGHT, m_wndTabOuterRight );
	
	DDX_Control( pDX, ID_TABCTRL_INNER_TOP, m_wndTabInnerTop );
	DDX_Control( pDX, ID_TABCTRL_INNER_BOTTOM, m_wndTabInnerBottom );
	DDX_Control( pDX, ID_TABCTRL_INNER_LEFT, m_wndTabInnerLeft );
	DDX_Control( pDX, ID_TABCTRL_INNER_RIGHT, m_wndTabInnerRight );

}


BEGIN_MESSAGE_MAP(CTabDemoDlg, CExtResizableDialog)
	//{{AFX_MSG_MAP(CTabDemoDlg)
	ON_WM_CONTEXTMENU()
	ON_BN_CLICKED(IDC_BUTTON_CLEAR_TABS, OnButtonClearTabs)
	ON_BN_CLICKED(IDC_BUTTON_ADD_TAB_1, OnButtonAddTab1)
	ON_BN_CLICKED(IDC_BUTTON_ADD_TAB_10, OnButtonAddTab10)
	ON_BN_CLICKED(IDC_CHECK_SHOW_BORDERS, OnCheckShowBorders)
	ON_BN_CLICKED(IDC_CHECK_SHOW_CLOSE, OnCheckShowClose)
	ON_BN_CLICKED(IDC_CHECK_EQUAL_WIDTHS, OnCheckEqualWidths)
	ON_BN_CLICKED(IDC_CHECK_INVERT_VERT_FONT, OnCheckInvertVertFont)
	ON_BN_CLICKED(IDC_CHECK_BOLD_SELECTION, OnCheckBoldSelection)
	ON_BN_CLICKED(IDC_CHECK_SHOW_HELP, OnCheckShowHelp)
	ON_BN_CLICKED(IDC_CHECK_ENABLE_CLOSE, OnCheckEnableClose)
	ON_BN_CLICKED(IDC_CHECK_ENABLE_HELP, OnCheckEnableHelp)
	ON_BN_CLICKED(IDC_CHECK_FULL_WIDTHS, OnCheckFullRowWidths)
	ON_BN_CLICKED(IDC_CHECK_CENTER_TEXT, OnCheckCenterText)
	ON_BN_CLICKED(IDC_CHECK_AUTOHIDE_SCROLL, OnCheckAutohideScroll)
	ON_BN_CLICKED(IDC_CHECK_FOCUS_ON_HOVER, OnCheckFocusOnHover)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTabDemoDlg message handlers

BOOL CTabDemoDlg::OnInitDialog() 
{
	if( !CExtResizableDialog::OnInitDialog() )
	{
		ASSERT( FALSE );
		return FALSE;
	}

	if( m_ImageList.GetSafeHandle() == NULL )
	{
		ASSERT( FALSE );
		return FALSE;
	}

	AddAnchor( IDC_CHECK_SHOW_BORDERS,		CSize( 100,   0) );
	AddAnchor( IDC_CHECK_SHOW_CLOSE,		CSize( 100,   0) );

	AddAnchor( IDC_CHECK_EQUAL_WIDTHS,		CSize( 100,  17) );
	AddAnchor( IDC_CHECK_ENABLE_CLOSE,		CSize( 100,  17) );
	
	AddAnchor( IDC_CHECK_FULL_WIDTHS,		CSize( 100,  34) );
	AddAnchor( IDC_CHECK_SHOW_HELP,			CSize( 100,  34) );

	AddAnchor( IDC_CHECK_CENTER_TEXT,		CSize( 100,  51) );
	AddAnchor( IDC_CHECK_ENABLE_HELP,		CSize( 100,  51) );

	AddAnchor( IDC_CHECK_AUTOHIDE_SCROLL,	CSize( 100,  68) );
	AddAnchor( IDC_CHECK_INVERT_VERT_FONT,	CSize( 100,  68) );
	
	AddAnchor( IDC_CHECK_BOLD_SELECTION,	CSize( 100,  86) );
	AddAnchor( IDC_CHECK_FOCUS_ON_HOVER,	CSize( 100,  86) );
	
	AddAnchor( IDC_BUTTON_CLEAR_TABS,		CSize( 100, 100) );
	AddAnchor( IDC_BUTTON_ADD_TAB_1,		CSize( 100, 100) );
	AddAnchor( IDC_BUTTON_ADD_TAB_10,		CSize( 100, 100) );
	
	AddAnchor( ID_TABCTRL_OUTER_TOP, __RDA_LT, __RDA_RT );
	AddAnchor( ID_TABCTRL_OUTER_BOTTOM, __RDA_LB, __RDA_RB );
	AddAnchor( ID_TABCTRL_OUTER_LEFT, __RDA_LT, __RDA_LB );
	AddAnchor( ID_TABCTRL_OUTER_RIGHT, __RDA_RT, __RDA_RB );

	AddAnchor( ID_TABCTRL_INNER_TOP, __RDA_LT, __RDA_RT );
	AddAnchor( ID_TABCTRL_INNER_BOTTOM, __RDA_LB, __RDA_RB );
	AddAnchor( ID_TABCTRL_INNER_LEFT, __RDA_LT, __RDA_LB );
	AddAnchor( ID_TABCTRL_INNER_RIGHT, __RDA_RT, __RDA_RB );
	
	EnableSaveRestore( _T("ExtResizableDialog"), _T("TabDemoDlg") );

	m_wndTabOuterTop.ModifyTabWndStyle(		0, __ETWS_ORIENT_TOP	| __ETWS_GROUPED , true );
	m_wndTabOuterBottom.ModifyTabWndStyle(	0, __ETWS_ORIENT_BOTTOM	| __ETWS_GROUPED , true );
	m_wndTabOuterLeft.ModifyTabWndStyle(	0, __ETWS_ORIENT_LEFT	| __ETWS_GROUPED , true );
	m_wndTabOuterRight.ModifyTabWndStyle(	0, __ETWS_ORIENT_RIGHT	| __ETWS_GROUPED , true );
	m_wndTabInnerTop.ModifyTabWndStyle(		0, __ETWS_ORIENT_TOP	, true );
	m_wndTabInnerBottom.ModifyTabWndStyle(	0, __ETWS_ORIENT_BOTTOM	, true );
	m_wndTabInnerLeft.ModifyTabWndStyle(	0, __ETWS_ORIENT_LEFT	, true );
	m_wndTabInnerRight.ModifyTabWndStyle(	0, __ETWS_ORIENT_RIGHT	, true );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTabDemoDlg::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	pWnd;
	
	VERIFY(
		_TrackWndSystemPopupMenu(
			&point,
			FALSE
			)
		);
}

void CTabDemoDlg::OnCheckShowBorders() 
{
DWORD dwAddExBorderStyles = WS_EX_STATICEDGE;
DWORD dwRemoveExBorderStyles = WS_EX_STATICEDGE;
	if( m_CheckShowBorders.GetCheck() )
		dwRemoveExBorderStyles = 0;
	else
		dwAddExBorderStyles = 0;
	m_wndTabOuterTop.ModifyStyleEx( dwRemoveExBorderStyles, dwAddExBorderStyles );
	m_wndTabOuterBottom.ModifyStyleEx( dwRemoveExBorderStyles, dwAddExBorderStyles );
	m_wndTabOuterLeft.ModifyStyleEx( dwRemoveExBorderStyles, dwAddExBorderStyles );
	m_wndTabOuterRight.ModifyStyleEx( dwRemoveExBorderStyles, dwAddExBorderStyles );
	m_wndTabInnerTop.ModifyStyleEx( dwRemoveExBorderStyles, dwAddExBorderStyles );
	m_wndTabInnerBottom.ModifyStyleEx( dwRemoveExBorderStyles, dwAddExBorderStyles );
	m_wndTabInnerLeft.ModifyStyleEx( dwRemoveExBorderStyles, dwAddExBorderStyles );
	m_wndTabInnerRight.ModifyStyleEx( dwRemoveExBorderStyles, dwAddExBorderStyles );

UINT nSetWindowPosFlags =
		SWP_NOMOVE|SWP_NOSIZE
		|SWP_NOZORDER|SWP_NOOWNERZORDER
		|SWP_NOACTIVATE
		|SWP_FRAMECHANGED
		;
	m_wndTabOuterTop.SetWindowPos(NULL,0,0,0,0,nSetWindowPosFlags);
	m_wndTabOuterBottom.SetWindowPos(NULL,0,0,0,0,nSetWindowPosFlags);
	m_wndTabOuterLeft.SetWindowPos(NULL,0,0,0,0,nSetWindowPosFlags);
	m_wndTabOuterRight.SetWindowPos(NULL,0,0,0,0,nSetWindowPosFlags);
	m_wndTabInnerTop.SetWindowPos(NULL,0,0,0,0,nSetWindowPosFlags);
	m_wndTabInnerBottom.SetWindowPos(NULL,0,0,0,0,nSetWindowPosFlags);
	m_wndTabInnerLeft.SetWindowPos(NULL,0,0,0,0,nSetWindowPosFlags);
	m_wndTabInnerRight.SetWindowPos(NULL,0,0,0,0,nSetWindowPosFlags);
}

void CTabDemoDlg::OnCheckShowClose() 
{
DWORD dwTabWndStyleRemove = __ETWS_SHOW_BTN_CLOSE;
DWORD dwTabWndStyleAdd = __ETWS_SHOW_BTN_CLOSE;
	if( m_CheckShowClose.GetCheck() != 0 )
		dwTabWndStyleRemove = 0;
	else
		dwTabWndStyleAdd = 0;
	m_wndTabOuterTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
}

void CTabDemoDlg::OnCheckShowHelp() 
{
DWORD dwTabWndStyleRemove = __ETWS_SHOW_BTN_HELP;
DWORD dwTabWndStyleAdd = __ETWS_SHOW_BTN_HELP;
	if( m_CheckShowHelp.GetCheck() != 0 )
		dwTabWndStyleRemove = 0;
	else
		dwTabWndStyleAdd = 0;
	m_wndTabOuterTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
}

void CTabDemoDlg::OnCheckEnableClose() 
{
DWORD dwTabWndStyleRemove = __ETWS_ENABLED_BTN_CLOSE;
DWORD dwTabWndStyleAdd = __ETWS_ENABLED_BTN_CLOSE;
	if( m_CheckEnableClose.GetCheck() != 0 )
		dwTabWndStyleRemove = 0;
	else
		dwTabWndStyleAdd = 0;
	m_wndTabOuterTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
}

void CTabDemoDlg::OnCheckEnableHelp() 
{
DWORD dwTabWndStyleRemove = __ETWS_ENABLED_BTN_HELP;
DWORD dwTabWndStyleAdd = __ETWS_ENABLED_BTN_HELP;
	if( m_CheckEnableHelp.GetCheck() != 0 )
		dwTabWndStyleRemove = 0;
	else
		dwTabWndStyleAdd = 0;
	m_wndTabOuterTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
}

void CTabDemoDlg::OnCheckEqualWidths() 
{
DWORD dwTabWndStyleRemove = __ETWS_EQUAL_WIDTHS;
DWORD dwTabWndStyleAdd = __ETWS_EQUAL_WIDTHS;
	if( m_CheckEqualWidth.GetCheck() != 0 )
		dwTabWndStyleRemove = 0;
	else
		dwTabWndStyleAdd = 0;
	m_wndTabOuterTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
}

void CTabDemoDlg::OnCheckInvertVertFont() 
{
DWORD dwTabWndStyleRemove = __ETWS_INVERT_VERT_FONT;
DWORD dwTabWndStyleAdd = __ETWS_INVERT_VERT_FONT;
	if( m_CheckInvertFont.GetCheck() != 0 )
		dwTabWndStyleRemove = 0;
	else
		dwTabWndStyleAdd = 0;
	m_wndTabOuterTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
}

void CTabDemoDlg::OnCheckBoldSelection() 
{
DWORD dwTabWndStyleRemove = __ETWS_BOLD_SELECTION;
DWORD dwTabWndStyleAdd = __ETWS_BOLD_SELECTION;
	if( m_CheckBoldSelection.GetCheck() != 0 )
		dwTabWndStyleRemove = 0;
	else
		dwTabWndStyleAdd = 0;
	m_wndTabOuterTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
}

void CTabDemoDlg::OnCheckFullRowWidths() 
{
DWORD dwTabWndStyleRemove = __ETWS_FULL_WIDTH;
DWORD dwTabWndStyleAdd = __ETWS_FULL_WIDTH;
	if( m_CheckFullRowWidth.GetCheck() != 0 )
		dwTabWndStyleRemove = 0;
	else
		dwTabWndStyleAdd = 0;
	m_wndTabOuterTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
}

void CTabDemoDlg::OnCheckCenterText() 
{
DWORD dwTabWndStyleRemove = __ETWS_CENTERED_TEXT;
DWORD dwTabWndStyleAdd = __ETWS_CENTERED_TEXT;
	if( m_CheckCenterText.GetCheck() != 0 )
		dwTabWndStyleRemove = 0;
	else
		dwTabWndStyleAdd = 0;
	m_wndTabOuterTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
}

void CTabDemoDlg::OnCheckAutohideScroll() 
{
DWORD dwTabWndStyleRemove = __ETWS_AUTOHIDE_SCROLL;
DWORD dwTabWndStyleAdd = __ETWS_AUTOHIDE_SCROLL;
	if( m_CheckAutoHideScroll.GetCheck() != 0 )
		dwTabWndStyleRemove = 0;
	else
		dwTabWndStyleAdd = 0;
	m_wndTabOuterTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
}

void CTabDemoDlg::OnCheckFocusOnHover() 
{
DWORD dwTabWndStyleRemove = __ETWS_HOVER_FOCUS;
DWORD dwTabWndStyleAdd = __ETWS_HOVER_FOCUS;
	if( m_CheckFocusOnHover.GetCheck() != 0 )
		dwTabWndStyleRemove = 0;
	else
		dwTabWndStyleAdd = 0;
	m_wndTabOuterTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabOuterRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerTop.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerBottom.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerLeft.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
	m_wndTabInnerRight.ModifyTabWndStyle( dwTabWndStyleRemove, dwTabWndStyleAdd, true );
}

void CTabDemoDlg::OnButtonClearTabs() 
{
	m_BtnClear.EnableWindow( FALSE );

	if( !m_BtnAdd1.IsWindowEnabled() )
	{
		m_BtnAdd1.EnableWindow( TRUE );
		m_BtnAdd10.EnableWindow( TRUE );
	}

	m_wndTabOuterTop.ItemRemoveAll(true);
	m_wndTabOuterBottom.ItemRemoveAll(true);
	m_wndTabOuterLeft.ItemRemoveAll(true);
	m_wndTabOuterRight.ItemRemoveAll(true);
	m_wndTabInnerTop.ItemRemoveAll(true);
	m_wndTabInnerBottom.ItemRemoveAll(true);
	m_wndTabInnerLeft.ItemRemoveAll(true);
	m_wndTabInnerRight.ItemRemoveAll(true);
}

void CTabDemoDlg::_DoAdd1( bool bUpdateTabWnd )
{
	ASSERT( m_ImageList.GetSafeHandle()	!= NULL );
	ASSERT( m_nDemoImageListSize > 0 );

	if( !m_BtnClear.IsWindowEnabled() )
		m_BtnClear.EnableWindow( TRUE );
	
	// insert 1 item into inner (non-grouped) tab controls
	ASSERT( m_nDemoImageListAddIndexInner <= m_nDemoImageListSize );
	if( m_nDemoImageListAddIndexInner == (m_nDemoImageListSize-1) )
		m_nDemoImageListAddIndexInner = 0;

	ASSERT( g_ItemsData[m_nDemoImageListAddIndexInner].m_sItemText != NULL );

HICON hIconInner = m_ImageList.ExtractIcon( m_nDemoImageListAddIndexInner );
	ASSERT( hIconInner != NULL );
	m_wndTabInnerTop.ItemInsert(
		g_ItemsData[m_nDemoImageListAddIndexInner].m_sItemText,
		hIconInner
		);
	m_wndTabInnerBottom.ItemInsert(
		g_ItemsData[m_nDemoImageListAddIndexInner].m_sItemText,
		hIconInner
		);
	m_wndTabInnerLeft.ItemInsert(
		g_ItemsData[m_nDemoImageListAddIndexInner].m_sItemText,
		hIconInner
		);
	m_wndTabInnerRight.ItemInsert(
		g_ItemsData[m_nDemoImageListAddIndexInner].m_sItemText,
		hIconInner
		);

	m_nDemoImageListAddIndexInner++;

	// insert 1 group into outer (grouped) tab controls
/*
	m_wndTabOuterTop.ItemInsert( );
	m_wndTabOuterBottom.ItemInsert( );
	m_wndTabOuterLeft.ItemInsert( );
	m_wndTabOuterRight.ItemInsert( );
*/

	ASSERT( m_nDemoImageListAddIndexOuter <= m_nDemoImageListSize );

	if( m_nDemoImageListAddIndexOuter == (m_nDemoImageListSize-1) )
		m_nDemoImageListAddIndexOuter = 0;

	for( INT nAddedToOuter = 0; true ; nAddedToOuter++ )
	{

		bool bGroupStart = 
			g_ItemsData[m_nDemoImageListAddIndexOuter].m_bGroupStart;
		if( nAddedToOuter != 0 && bGroupStart )
			break;

		DWORD dwItemStyle = 0;
		if( bGroupStart )
			dwItemStyle |= __ETWI_GROUP_START | __ETWI_IN_GROUP_ACTIVE;

		HICON hIconOuter = m_ImageList.ExtractIcon( m_nDemoImageListAddIndexOuter );
		ASSERT( hIconOuter != NULL );

		ASSERT( g_ItemsData[m_nDemoImageListAddIndexOuter].m_sItemText != NULL );
		
		m_wndTabOuterTop.ItemInsert(
			g_ItemsData[m_nDemoImageListAddIndexOuter].m_sItemText,
			hIconOuter,
			true,
			dwItemStyle
			);
		m_wndTabOuterBottom.ItemInsert(
			g_ItemsData[m_nDemoImageListAddIndexOuter].m_sItemText,
			hIconOuter,
			true,
			dwItemStyle
			);
		m_wndTabOuterLeft.ItemInsert(
			g_ItemsData[m_nDemoImageListAddIndexOuter].m_sItemText,
			hIconOuter,
			true,
			dwItemStyle
			);
		m_wndTabOuterRight.ItemInsert(
			g_ItemsData[m_nDemoImageListAddIndexOuter].m_sItemText,
			hIconOuter,
			true,
			dwItemStyle
			);

	
		if( m_nDemoImageListAddIndexOuter == (m_nDemoImageListSize-1) )
			m_nDemoImageListAddIndexOuter = 0;
		else
			m_nDemoImageListAddIndexOuter++;
	} // for( INT nAddedToOuter = 0; true ; nAddedToOuter++ )

	// update or delay-update all tab controls
	m_wndTabInnerTop.UpdateTabWnd( bUpdateTabWnd );
	m_wndTabInnerBottom.UpdateTabWnd( bUpdateTabWnd );
	m_wndTabInnerLeft.UpdateTabWnd( bUpdateTabWnd );
	m_wndTabInnerRight.UpdateTabWnd( bUpdateTabWnd );
	m_wndTabOuterTop.UpdateTabWnd( bUpdateTabWnd );
	m_wndTabOuterBottom.UpdateTabWnd( bUpdateTabWnd );
	m_wndTabOuterLeft.UpdateTabWnd( bUpdateTabWnd );
	m_wndTabOuterRight.UpdateTabWnd( bUpdateTabWnd );

	if( m_wndTabInnerTop.ItemGetCount() >= 100 )
	{
		if( m_BtnAdd1.IsWindowEnabled() )
		{
			m_BtnAdd1.EnableWindow( FALSE );
			m_BtnAdd10.EnableWindow( FALSE );
		}
	}
}

void CTabDemoDlg::OnButtonAddTab1() 
{
	_DoAdd1(true);
}

void CTabDemoDlg::OnButtonAddTab10() 
{
	for( INT i=0; i < 10; i++ )
	{
		bool bUpdateTabWnd = ( i == 9 ) ? true : false;
		_DoAdd1(bUpdateTabWnd);
	}
}

#endif // (!defined __EXT_MFC_NO_TAB_CTRL)


