/*
 * Decompiled with CFR 0.152.
 */
package stec.xpos;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import stec.pos.ByteArray;
import stec.pos.Common;
import stec.pos.ObjectStoreEnumeration;
import stec.xpos.CheckIndex;
import stec.xpos.CheckObjectStore;
import stec.xpos.Index;
import stec.xpos.IndexedObjectStore;
import stec.xpos.IndexedObjectStoreReference;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class CheckIndexedObjectStore {
    private boolean do;
    private String[] new;
    private String for;
    private String[] int;
    private boolean a = true;
    private boolean if;

    public static final void main(String[] stringArray) throws Throwable {
        Common.logo("Persistent Indexed Object Store Checker");
        if (stringArray.length < 1) {
            System.out.println("Usage: <java> stec.xpos.CheckIndexedObjectStore <options> <store>");
            System.out.println();
            System.out.println("Options:");
            System.out.println("-d            do not display progress");
            System.out.println("-l            check links");
            System.out.println("-u            display utilization");
            System.out.println("-v            verbose messages");
            return;
        }
        CheckIndexedObjectStore.check(stringArray);
    }

    public static final boolean check(String[] stringArray) throws Throwable {
        String string;
        int n;
        CheckIndexedObjectStore checkIndexedObjectStore = new CheckIndexedObjectStore();
        checkIndexedObjectStore.int = stringArray;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).charAt(0) == '-'; ++n) {
            if (string.equalsIgnoreCase("-d")) {
                checkIndexedObjectStore.a = false;
                continue;
            }
            if (string.equalsIgnoreCase("-l") || string.equalsIgnoreCase("-u")) continue;
            if (string.equalsIgnoreCase("-v")) {
                checkIndexedObjectStore.do = true;
                continue;
            }
            System.out.println("Invalid parameter: ".concat(String.valueOf(String.valueOf(string))));
            return false;
        }
        if (n >= n2) {
            System.out.println("Store was not specified.");
            return false;
        }
        try {
            if (!checkIndexedObjectStore.a(stringArray[n])) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
            throw Common.getRootCause(exception);
        }
        return true;
    }

    public static final boolean check(String[] stringArray, String[] stringArray2) {
        boolean bl = true;
        int n = stringArray2.length;
        String[] stringArray3 = new String[n + 1];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray[i];
            System.out.print(String.valueOf(String.valueOf(string)).concat(": "));
            stringArray3[n] = string;
            try {
                boolean bl2 = CheckIndexedObjectStore.check(stringArray3);
                if (bl2) {
                    System.out.println("PASSED");
                    continue;
                }
                bl = false;
                System.out.println("FAILED");
                continue;
            }
            catch (Throwable throwable) {
                bl = false;
                System.out.println("FAILED");
                throwable.printStackTrace();
            }
        }
        return bl;
    }

    private final boolean a(String string) throws Throwable {
        File file;
        if (this.do) {
            System.out.println("Checking indexed object store");
        }
        String string2 = String.valueOf(String.valueOf(string)).concat(".ios");
        if (this.do) {
            System.out.println("Indexed object store: ".concat(String.valueOf(String.valueOf(string2))));
        }
        if (!(file = new File(string2)).exists()) {
            System.out.println("Indexed object store does not exist: ".concat(String.valueOf(String.valueOf(string2))));
            return false;
        }
        if (file.isDirectory()) {
            System.out.println("Indexed object store can not be a directory: ".concat(String.valueOf(String.valueOf(string2))));
            return false;
        }
        long l = file.length();
        if (l < 7L) {
            System.out.println("Indexed object store file length is too small.");
            System.out.println("Minimum indexed object store file length: 7");
            System.out.println("Current indexed object store file length: ".concat(String.valueOf(String.valueOf(l))));
            return false;
        }
        if (IndexedObjectStore.inUse(string)) {
            System.out.println("Indexed object store is in use: ".concat(String.valueOf(String.valueOf(string))));
            return false;
        }
        if (!this.do(string)) {
            return false;
        }
        if (!this.a()) {
            return false;
        }
        return this.if(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean do(String string) throws ClassNotFoundException, IOException {
        RandomAccessFile randomAccessFile;
        block23: {
            boolean bl;
            block22: {
                boolean bl2;
                block21: {
                    boolean bl3;
                    block20: {
                        boolean bl4;
                        block19: {
                            boolean bl5;
                            block18: {
                                boolean bl6;
                                block17: {
                                    boolean bl7;
                                    block16: {
                                        if (this.do) {
                                            System.out.println("Checking indexed object store header");
                                        }
                                        randomAccessFile = new RandomAccessFile(String.valueOf(String.valueOf(string)).concat(".ios"), "rw");
                                        try {
                                            byte[] byArray = new byte[7];
                                            randomAccessFile.seek(0L);
                                            randomAccessFile.readFully(byArray, 0, byArray.length);
                                            byte by = ByteArray.getByte(byArray, 0);
                                            if (this.do) {
                                                System.out.println("Indexed object store type: ".concat(String.valueOf(String.valueOf(by))));
                                            }
                                            if (by != 16) {
                                                System.out.println("Indexed object store type mismatch.");
                                                System.out.println("Required mapper type: 16");
                                                System.out.println("Current mapper type: ".concat(String.valueOf(String.valueOf(by))));
                                                bl7 = false;
                                                Object var13_7 = null;
                                                break block16;
                                            }
                                            short s = ByteArray.getShort(byArray, 1);
                                            if (this.do) {
                                                System.out.println("Indexed object store version: ".concat(String.valueOf(String.valueOf(s))));
                                            }
                                            if (s != 256) {
                                                System.out.println("Indexed object store version mismatch.");
                                                System.out.println("Required mapper version: 256");
                                                System.out.println("Current mapper version: ".concat(String.valueOf(String.valueOf(s))));
                                                bl6 = false;
                                                break block17;
                                            }
                                            int n = ByteArray.getInt(byArray, 3);
                                            if (this.do) {
                                                System.out.println("Indexed object store index count: ".concat(String.valueOf(String.valueOf(n))));
                                            }
                                            if (n < 1) {
                                                System.out.println("Indexed object store index count must be at least one (1): ".concat(String.valueOf(String.valueOf(n))));
                                                bl5 = false;
                                                break block18;
                                            }
                                            this.for = randomAccessFile.readUTF();
                                            if (this.do) {
                                                System.out.println("Indexed object store object store filename: ".concat(String.valueOf(String.valueOf(this.for))));
                                            }
                                            this.new = new String[n];
                                            for (int i = 0; i < n; ++i) {
                                                String string2 = randomAccessFile.readUTF();
                                                if (string2.trim().length() == 0) {
                                                    System.out.println("Indexed object store index name cannot be empty.");
                                                    bl4 = false;
                                                    break block19;
                                                }
                                                String string3 = randomAccessFile.readUTF();
                                                if (string3.trim().length() == 0) {
                                                    System.out.println("Indexed object store index filename cannot be empty.");
                                                    bl3 = false;
                                                    break block20;
                                                }
                                                if (!Index.exists(string3)) {
                                                    System.out.println("Index was not found: ".concat(String.valueOf(String.valueOf(string3))));
                                                    bl2 = false;
                                                    break block21;
                                                }
                                                String string4 = randomAccessFile.readUTF();
                                                if (string4.trim().length() == 0) {
                                                    System.out.println("Indexed object store indexer class name cannot be empty.");
                                                    bl = false;
                                                    break block22;
                                                }
                                                if (!Thread.currentThread().getContextClassLoader().loadClass("stec.pos.Indexer").isAssignableFrom(Thread.currentThread().getContextClassLoader().loadClass(string4))) {
                                                    System.out.println("Indexed obejct class inder class name must implement stec.pos.Indexer: ".concat(String.valueOf(String.valueOf(string4))));
                                                }
                                                this.new[i] = string3;
                                            }
                                            break block23;
                                        }
                                        catch (Throwable throwable) {
                                            Object var13_15 = null;
                                            randomAccessFile.close();
                                            throw throwable;
                                        }
                                    }
                                    randomAccessFile.close();
                                    return bl7;
                                }
                                Object var13_8 = null;
                                randomAccessFile.close();
                                return bl6;
                            }
                            Object var13_9 = null;
                            randomAccessFile.close();
                            return bl5;
                        }
                        Object var13_10 = null;
                        randomAccessFile.close();
                        return bl4;
                    }
                    Object var13_11 = null;
                    randomAccessFile.close();
                    return bl3;
                }
                Object var13_12 = null;
                randomAccessFile.close();
                return bl2;
            }
            Object var13_13 = null;
            randomAccessFile.close();
            return bl;
        }
        Object var13_14 = null;
        randomAccessFile.close();
        if (!this.do) return true;
        System.out.println();
        return true;
    }

    private final boolean a() throws Throwable {
        if (this.do) {
            System.out.println("Checking indexed object store files");
        }
        int n = this.int.length - 1;
        this.int[n] = this.for;
        if (!CheckObjectStore.check(this.int)) {
            return false;
        }
        int n2 = this.new.length;
        for (int i = 0; i < n2; ++i) {
            this.int[n] = this.new[i];
            if (CheckIndex.check(this.int)) continue;
            return false;
        }
        if (this.do) {
            System.out.println();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean if(String string) throws Exception {
        IndexedObjectStoreReference indexedObjectStoreReference;
        block8: {
            boolean bl;
            block7: {
                if (this.do) {
                    System.out.println("Checking indexed object store entries");
                }
                indexedObjectStoreReference = IndexedObjectStore.open(string, true);
                try {
                    long l = 0L;
                    long l2 = indexedObjectStoreReference.char.size();
                    int n = indexedObjectStoreReference.try.length;
                    ObjectStoreEnumeration objectStoreEnumeration = indexedObjectStoreReference.char.keys();
                    while (objectStoreEnumeration.hasMoreElements()) {
                        ++l;
                        if (this.do && this.a) {
                            Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(l))).append(" - ").append(l2).append(": ").append((int)((double)l / (double)l2 * 100.0)).append("%"))));
                            this.if = true;
                        }
                        Object object = objectStoreEnumeration.nextElement();
                        Object object2 = indexedObjectStoreReference.char.get(object);
                        for (int i = 0; i < n; ++i) {
                            Object object3 = indexedObjectStoreReference.try[i].int.getIndexKey(object, object2);
                            if (indexedObjectStoreReference.try[i].a.contains(object3, object)) continue;
                            if (this.if) {
                                System.out.println();
                                this.if = false;
                            }
                            System.out.println("Indexed object store entry was not found in index.");
                            System.out.println("Index: ".concat(String.valueOf(String.valueOf(indexedObjectStoreReference.try[i].for))));
                            System.out.println("Object store key: ".concat(String.valueOf(String.valueOf(object))));
                            System.out.println("Object store value: ".concat(String.valueOf(String.valueOf(object2))));
                            System.out.println("Index key: ".concat(String.valueOf(String.valueOf(object3))));
                            bl = false;
                            Object var15_12 = null;
                            break block7;
                        }
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var15_14 = null;
                    indexedObjectStoreReference.close();
                    throw throwable;
                }
            }
            indexedObjectStoreReference.close();
            return bl;
        }
        Object var15_13 = null;
        indexedObjectStoreReference.close();
        if (!this.if) return true;
        System.out.println();
        this.if = false;
        return true;
    }
}

