/*
 * Copyright (c) 2001-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Vector;

import java.io.IOException;
import java.io.File;
import java.io.PrintWriter;
import java.io.CharArrayWriter;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.tree.*;
import javax.swing.event.*;

import stec.lang.QuickSort;
import javax.swing.border.*;

public class RegistryExplorer extends JFrame
{
	protected final static String RELEASE_INFO = "Servertec Registry Explorer 1.4.1 09/04/2005";
	protected final static String COPYRIGHT_INFO = "Copyright (C) 2001-2005 Servertec. All rights reserved.";

	boolean table = true;

	final String[] column_headers = {"Name", "Data"};

	QuickSortRegistry sorter = new QuickSortRegistry();

	Vector values = new Vector();

	String store_name;

	protected Registry registry;

	JPanel contentPane;
	JMenuBar jMenuBar = new JMenuBar();
	JMenu jMenuFile = new JMenu();
	JMenuItem jMenuFileExit = new JMenuItem();
	JMenu jMenuHelp = new JMenu();
	JMenuItem jMenuHelpAbout = new JMenuItem();
	BorderLayout borderLayout = new BorderLayout();
	JMenuItem jMenuEditNew = new JMenuItem();
	JMenu jMenuEdit = new JMenu();
	JMenuItem jMenuEditModify = new JMenuItem();
	JMenuItem jMenuEditDelete = new JMenuItem();
	JMenuItem jMenuEditRename = new JMenuItem();
	JSplitPane jSplitPane = new JSplitPane();
	JTable jTable = new JTable();
	DefaultMutableTreeNode root =  new DefaultMutableTreeNode();
	JScrollPane scrollpaneTable = new JScrollPane(jTable);
	TitledBorder titledBorder1;
	JButton jButtonEditModify = new JButton();
	JButton jButtonEditNew = new JButton();
	JButton jButtonEditDelete = new JButton();
	JToolBar jToolBar = new JToolBar();
	JButton jButtonHelpAbout = new JButton();
	JButton jButtonEditRename = new JButton();
	JScrollPane scrollpaneTree = new JScrollPane(jTable);
	JTree jTree = new JTree(root);

	JPopupMenu popup = new JPopupMenu();
	JMenuItem jMenuNew = new JMenuItem();
	JMenuItem jMenuModify = new JMenuItem();
	JMenuItem jMenuDelete = new JMenuItem();
	JMenuItem jMenuRename = new JMenuItem();

	RegistryExplorer_ModifyKeyDialog modify_key_dlg;
	RegistryExplorer_ModifyValueDialog modify_value_dlg;
	RegistryExplorer_DeleteDialog delete_dlg;
	RegistryExplorer_AboutDialog about_dlg;
	RegistryExplorer_MessageDialog message_dlg;

	public static final void main(String[] args) throws Throwable
	{
		System.out.println(RELEASE_INFO);
		System.out.println(COPYRIGHT_INFO);
		System.out.println();

		if(args.length < 1)
		{
			System.out.println("Syntax <javavm> RegistryExplorer <registry>");
			return;
		}

		RegistryExplorer explorer = new RegistryExplorer(args[0]);
		explorer.show();
	}

	/**Construct the frame*/
	public RegistryExplorer(String filename) throws IOException
	{
		registry = new Registry(filename);

		store_name = (new File(filename)).getCanonicalPath().replace('\\', Registry.DELIMITER_CHAR).replace('/', Registry.DELIMITER_CHAR);

		int offset = store_name.lastIndexOf(Registry.DELIMITER_CHAR);
		if(offset != -1)
		{
			store_name = store_name.substring(offset + 1);
		}

		enableEvents(AWTEvent.WINDOW_EVENT_MASK);

		jbInit();
	}
	/**Component initialization*/
	private void jbInit()
	{
		modify_key_dlg = new RegistryExplorer_ModifyKeyDialog(this);
		modify_value_dlg = new RegistryExplorer_ModifyValueDialog(this);
		delete_dlg = new RegistryExplorer_DeleteDialog(this);
		about_dlg = new RegistryExplorer_AboutDialog(this);
		message_dlg = new RegistryExplorer_MessageDialog(this);

		contentPane = (JPanel) this.getContentPane();
		titledBorder1 = new TitledBorder("");
		contentPane.setLayout(borderLayout);
		this.setSize(new Dimension(517, 407));
		this.setTitle("Servertec Registry Explorer");
		Image icon_image = Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/registry.gif"));
		this.setIconImage(icon_image);
		jMenuFile.setActionCommand("File");
		jMenuFile.setText("File");
		jMenuFile.setMnemonic(KeyEvent.VK_F);
		jMenuFileExit.setText("Exit");
		jMenuFileExit.setAccelerator(javax.swing.KeyStroke.getKeyStroke(88, java.awt.event.KeyEvent.CTRL_MASK, true));
		jMenuFileExit.setMnemonic(KeyEvent.VK_X);
		jMenuEdit.setText("Edit");
		jMenuEdit.setMnemonic(KeyEvent.VK_E);
		jMenuEditNew.setIcon(new ImageIcon(RegistryExplorer.class.getResource("icons/new.gif")));
		jMenuEditNew.setText("New");
		jMenuEditNew.setAccelerator(javax.swing.KeyStroke.getKeyStroke(155, 0, true));
		jMenuEditNew.setMnemonic(KeyEvent.VK_N);
		jMenuEditModify.setIcon(new ImageIcon(RegistryExplorer.class.getResource("icons/modify.gif")));
		jMenuEditModify.setText("Modify");
		jMenuEditModify.setMnemonic(KeyEvent.VK_M);
		jMenuEditDelete.setIcon(new ImageIcon(RegistryExplorer.class.getResource("icons/delete.gif")));
		jMenuEditDelete.setText("Delete");
		jMenuEditDelete.setAccelerator(javax.swing.KeyStroke.getKeyStroke(127, 0, true));
		jMenuEditDelete.setMnemonic(KeyEvent.VK_D);
		jMenuEditRename.setIcon(new ImageIcon(RegistryExplorer.class.getResource("icons/rename.gif")));
		jMenuEditRename.setText("Rename");
		jMenuEditRename.setMnemonic(KeyEvent.VK_R);
		jMenuHelp.setText("Help");
		jMenuHelp.setMnemonic(KeyEvent.VK_H);
		jMenuHelpAbout.setIcon(new ImageIcon(RegistryExplorer.class.getResource("icons/about.gif")));
		jMenuHelpAbout.setText("About");
		jMenuHelpAbout.setMnemonic(KeyEvent.VK_A);
		jSplitPane.setBorder(null);
		jSplitPane.setDividerSize(3);
		jSplitPane.setLastDividerLocation(10);
		jSplitPane.addMouseListener(new java.awt.event.MouseAdapter()
		{
			public void mousePressed(MouseEvent e)
			{
				jSplitPane_mousePressed(e);
			}
		});
		scrollpaneTable.setPreferredSize(new Dimension(43, 324));
		scrollpaneTable.setToolTipText("");
		scrollpaneTable.addMouseListener(new java.awt.event.MouseAdapter()
		{
			public void mousePressed(MouseEvent e)
			{
				scrollpaneTable_mousePressed(e);
			}
		});
		jButtonEditModify.setToolTipText("Modify");
		jButtonEditModify.setIcon(new ImageIcon(RegistryExplorer.class.getResource("/icons/modify.gif")));
		jButtonEditModify.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				jButtonEditModify_keyTyped(e);
			}
		});
		jButtonEditModify.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jButtonEditModify_actionPerformed(e);
			}
		});
		jButtonEditNew.setToolTipText("New");
		jButtonEditNew.setIcon(new ImageIcon(RegistryExplorer.class.getResource("/icons/new.gif")));
		jButtonEditNew.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				jButtonEditNew_keyTyped(e);
			}
		});
		jButtonEditNew.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jButtonEditNew_actionPerformed(e);
			}
		});
		jButtonEditDelete.setToolTipText("Delete");
		jButtonEditDelete.setIcon(new ImageIcon(RegistryExplorer.class.getResource("/icons/delete.gif")));
		jButtonEditDelete.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				jButtonEditDelete_keyTyped(e);
			}
		});
		jButtonEditDelete.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jButtonEditDelete_actionPerformed(e);
			}
		});
		jToolBar.setFloatable(false);
		jButtonHelpAbout.setToolTipText("About");
		jButtonHelpAbout.setIcon(new ImageIcon(RegistryExplorer.class.getResource("/icons/about.gif")));
		jButtonHelpAbout.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				jButtonHelpAbout_keyTyped(e);
			}
		});
		jButtonHelpAbout.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jButtonHelpAbout_actionPerformed(e);
			}
		});
		jButtonEditRename.setToolTipText("Rename");
		jButtonEditRename.setIcon(new ImageIcon(RegistryExplorer.class.getResource("/icons/rename.gif")));
		jButtonEditRename.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				jButtonEditRename_keyTyped(e);
			}
		});
		jButtonEditRename.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jButtonEditRename_actionPerformed(e);
			}
		});
		scrollpaneTree.setBorder(BorderFactory.createLoweredBevelBorder());
		jTree.setShowsRootHandles(true);
		jTree.addMouseListener(new java.awt.event.MouseAdapter()
		{
			public void mousePressed(MouseEvent e)
			{
				jTree_mousePressed(e);
			}
		});
		jTree.setAutoscrolls(true);
		jTree.setToolTipText("");
		jTree.setCellRenderer(new RegistryTreeRenderer());
		jMenuNew.setIcon(new ImageIcon(RegistryExplorer.class.getResource("icons/new.gif")));
		jMenuNew.setText("New");
		jMenuNew.setAccelerator(javax.swing.KeyStroke.getKeyStroke(155, 0, true));
		jMenuNew.setMnemonic(KeyEvent.VK_N);
		jMenuNew.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jMenuNew_actionPerformed(e);
			}
		});
		jTable.addMouseListener(new java.awt.event.MouseAdapter()
		{
			public void mousePressed(MouseEvent e)
			{
				jTable_mousePressed(e);
			}
			public void mouseClicked(MouseEvent e)
			{
				jTable_mouseClicked(e);
			}
		});
		jMenuModify.setIcon(new ImageIcon(RegistryExplorer.class.getResource("icons/modify.gif")));
		jMenuModify.setText("Modify");
		jMenuModify.setMnemonic(KeyEvent.VK_M);
		jMenuModify.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jMenuModify_actionPerformed(e);
			}
		});
		jMenuDelete.setIcon(new ImageIcon(RegistryExplorer.class.getResource("icons/delete.gif")));
		jMenuDelete.setText("Delete");
		jMenuDelete.setAccelerator(javax.swing.KeyStroke.getKeyStroke(127, 0, true));
		jMenuDelete.setMnemonic(KeyEvent.VK_D);
		jMenuDelete.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jMenuDelete_actionPerformed(e);
			}
		});
		jMenuRename.setIcon(new ImageIcon(RegistryExplorer.class.getResource("icons/rename.gif")));
		jMenuRename.setText("Rename");
		jMenuRename.setMnemonic(KeyEvent.VK_R);
		jMenuRename.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jMenuRename_actionPerformed(e);
			}
		});
		jTable.addFocusListener(new java.awt.event.FocusAdapter()
		{
			public void focusGained(FocusEvent e)
			{
				jTable_focusGained(e);
			}
		});
		jMenuFile.add(jMenuFileExit);
		jMenuHelp.add(jMenuHelpAbout);
		jMenuBar.add(jMenuFile);
		jMenuBar.add(jMenuEdit);
		jMenuBar.add(jMenuHelp);
		jMenuEdit.add(jMenuEditNew);
		jMenuEdit.addSeparator();
		jMenuEdit.add(jMenuEditModify);
		jMenuEdit.addSeparator();
		jMenuEdit.add(jMenuEditDelete);
		jMenuEdit.add(jMenuEditRename);
		this.setJMenuBar(jMenuBar);
		jMenuFileExit.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jMenuFileExit_actionPerformed(e);
			}
		});
		jMenuEditNew.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jMenuEditNew_actionPerformed(e);
			}
		});
		jMenuEditModify.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jMenuEditModify_actionPerformed(e);
			}
		});
		jMenuEditDelete.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jMenuEditDelete_actionPerformed(e);
			}
		});
		jMenuEditRename.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jMenuEditRename_actionPerformed(e);
			}
		});
		jMenuHelpAbout.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				jMenuHelpAbout_actionPerformed(e);
			}
		});
		contentPane.add(jSplitPane, BorderLayout.CENTER);
		jSplitPane.add(scrollpaneTable, JSplitPane.BOTTOM);
		jSplitPane.add(scrollpaneTree, JSplitPane.TOP);
		scrollpaneTree.getViewport().add(jTree, null);
		contentPane.add(jToolBar, BorderLayout.NORTH);
		jToolBar.add(jButtonEditNew);
		jToolBar.add(jButtonEditModify);
		jToolBar.add(jButtonEditDelete, null);
		jToolBar.add(jButtonEditRename, null);
		jToolBar.add(jButtonHelpAbout);
		scrollpaneTable.getViewport().add(jTable, null);

		RegistryTableModel dataModel = new RegistryTableModel()
		{
			public int getColumnCount()
			{
				return column_headers.length;
			}

			public int getRowCount()
			{
				return values.size();
			}

			public Object getValueAt(int row, int col)
			{
				Value value = (Value)values.elementAt(row);
				return (col == 0) ? value.name : value.data;
			}

			public String getColumnName(int column)
			{
				return column_headers[column];
			}

			public Class getColumnClass(int column)
			{
				return getValueAt(0, column).getClass();
			}

			public boolean isCellEditable(int row, int col)
			{
				return false;
			}

			public void update()
			{
				fireTableDataChanged();
			}
		};

		jTable.setModel(dataModel);

		ToolTipManager.sharedInstance().registerComponent(jTree);

		jTree.addTreeSelectionListener(new TreeSelectionListener()
		{
			public void valueChanged(TreeSelectionEvent e)
			{
				DefaultMutableTreeNode node = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();

				if(node == null)
				{
					updateState();
					return;
				}

				updateState();

				Key key = (Key)node.getUserObject();

				if(key == null)
				{
					values.removeAllElements();
					((RegistryTableModel)jTable.getModel()).update();
					return;
				}

				updateValues(key.path);
			}
		});

		jTree.addTreeWillExpandListener(new TreeWillExpandListener()
		{
			public void treeWillExpand(TreeExpansionEvent e)
			{
				TreePath path = e.getPath();

				DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();

				if(node == null)
				{
					return;
				}

				Key key = (Key)node.getUserObject();

				expand(node, key.path);
			}

			public void treeWillCollapse(TreeExpansionEvent e)
			{
				TreePath path = e.getPath();

				DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();

				if(node == null)
				{
					return;
				}

				node.removeAllChildren();
				node.add(new DefaultMutableTreeNode());

				Key key = (Key)node.getUserObject();

				if(key == null)
				{
					values.removeAllElements();
					((RegistryTableModel)jTable.getModel()).update();
					return;
				}

				updateValues(key.path);
			}
		});

		popup.add(jMenuNew);
		popup.add(jMenuModify);
		popup.add(jMenuDelete);
		popup.add(jMenuRename);

		jTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener()
		{
			public void valueChanged(ListSelectionEvent e)
			{
				updateState();
			}
		});

		jTree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);

		root.setUserObject(new Key(Registry.DELIMITER, store_name));
		root.add(new DefaultMutableTreeNode());
		jTree.putClientProperty("JTree.lineStyle", "Angled");
		jTree.expandRow(0);
		updateValues(Registry.DELIMITER);

		jTable.getTableHeader().setReorderingAllowed(false);

		KeyStroke stroke = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0);
		ActionListener action = new ActionListener()
		{
			public void actionPerformed(ActionEvent ev)
			{
				doModify();
			}
		};

		jTable.registerKeyboardAction(action, null, stroke, JComponent.WHEN_FOCUSED);

		stroke = KeyStroke.getKeyStroke(KeyEvent.VK_TAB, 0);
		action = new ActionListener()
		{
			public void actionPerformed(ActionEvent ev)
			{
				jButtonEditNew.grabFocus();
				table = false;
				updateState();
			}
		};
		jTable.registerKeyboardAction(action, null, stroke, JComponent.WHEN_FOCUSED);

		stroke = KeyStroke.getKeyStroke(KeyEvent.VK_TAB, Event.SHIFT_MASK);
		action = new ActionListener()
		{
			public void actionPerformed(ActionEvent ev)
			{
				jTree.grabFocus();
				table = false;
				updateState();
			}
		};
		jTable.registerKeyboardAction(action, null, stroke, JComponent.WHEN_FOCUSED);

		jTree.setSelectionRow(0);

		if(values.size() > 0)
		{
			jTable.addRowSelectionInterval(0, 0);
		}

		updateState();
	}
	/**Overridden so we can exit when window is closed*/
	protected void processWindowEvent(WindowEvent e)
	{
		super.processWindowEvent(e);
		if (e.getID() == WindowEvent.WINDOW_CLOSING)
		{
			jMenuFileExit_actionPerformed(null);
		}
	}
	/**File | Exit action performed*/
	public void jMenuFileExit_actionPerformed(ActionEvent e)
	{
		try
		{
			if(registry != null)
			{
				try
				{
					registry.close();
				}
				catch(IOException ex)
				{
					doError(ex);
				}
			}
		}
		finally
		{
			System.exit(0);
		}
	}
	/**Edit | New action performed*/
	void jMenuEditNew_actionPerformed(ActionEvent e)
	{
		doNew();
	}
	/**Edit | Modify action performed*/
	void jMenuEditModify_actionPerformed(ActionEvent e)
	{
		doModify();
	}
	/**Edit | Delete action performed*/
	void jMenuEditDelete_actionPerformed(ActionEvent e)
	{
		doDelete();
	}
	/**Edit | Rename action performed*/
	void jMenuEditRename_actionPerformed(ActionEvent e)
	{
		doRename();
	}
	/**Help | About action performed*/
	public void jMenuHelpAbout_actionPerformed(ActionEvent e)
	{
		doAbout();
	}
	void jButtonEditNew_actionPerformed(ActionEvent e)
	{
		doNew();
	}
	void jButtonEditModify_actionPerformed(ActionEvent e)
	{
		doModify();
	}
	void jButtonEditDelete_actionPerformed(ActionEvent e)
	{
		doDelete();
	}
	void jButtonEditRename_actionPerformed(ActionEvent e)
	{
		doRename();
	}
	void jButtonHelpAbout_actionPerformed(ActionEvent e)
	{
		doAbout();
	}
	private void show_dialog(JDialog dlg)
	{
		Dimension dlgSize = dlg.getPreferredSize();
		Dimension frmSize = getSize();
		Point loc = getLocation();
		dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
		dlg.setModal(true);
		dlg.show();
	}

	void doNew()
	{
		DefaultMutableTreeNode node = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();

		if(node == null)
		{
			doMessage("Key was not selected.");
			return;
		}

		Key key = (Key)node.getUserObject();

		if(table)
		{
			modify_value_dlg.old_name = null;
			modify_value_dlg.path = key.path;
			modify_value_dlg.setTitle("New Value");
			modify_value_dlg.modify = false;
			modify_value_dlg.jTextFieldName.setEnabled(true);
			modify_value_dlg.jTextFieldData.setEnabled(true);
			modify_value_dlg.buttonOk.setEnabled(false);
			modify_value_dlg.jTextFieldName.setText("");
			modify_value_dlg.jTextFieldData.setText("");
			show_dialog(modify_value_dlg);

			if(modify_value_dlg.completed)
			{
				String name = modify_value_dlg.jTextFieldName.getText().trim();

				String path;

				if(key.path.endsWith(Registry.DELIMITER))
				{
					path = key.path + name;
				}
				else
				{
					path = key.path + Registry.DELIMITER + name;
				}

				String value = modify_value_dlg.jTextFieldData.getText().trim();

				try
				{
					registry.put(path, value);

					updateValues(key.path);
				}
				catch(IOException ex)
				{
					doError(ex);
				}
			}
		}
		else
		{
			modify_key_dlg.old_key = null;
			modify_key_dlg.path = key.path;
			modify_key_dlg.setTitle("New Key");
			modify_key_dlg.buttonOk.setEnabled(false);
			modify_key_dlg.jTextFieldKey.setText("");
			show_dialog(modify_key_dlg);

			if(modify_key_dlg.completed)
			{
				String name = modify_key_dlg.jTextFieldKey.getText().trim();

				String path;

				if(key.path.endsWith(Registry.DELIMITER))
				{
					path = key.path + name + Registry.DELIMITER;
				}
				else
				{
					path = key.path + Registry.DELIMITER + name + Registry.DELIMITER;
				}

				try
				{
					registry.put(path, null);

					expand(node, key.path);
				}
				catch(IOException ex)
				{
					doError(ex);
				}
			}
		}
	}
	void doModify()
	{
		if(!table)
		{
			doMessage("Key cannot be modified.");
			return;
		}

		int selected_row = jTable.getSelectedRow();
		if(selected_row == -1)
		{
			doMessage("Value was not selected.");
			return;
		}

		Value value = (Value)values.elementAt(selected_row);

		modify_value_dlg.old_name = null;
		modify_value_dlg.path = value.path;
		modify_value_dlg.setTitle("Modify Value");
		modify_value_dlg.modify = true;
		modify_value_dlg.jTextFieldName.setEnabled(false);
		modify_value_dlg.jTextFieldData.setEnabled(true);
		modify_value_dlg.buttonOk.setEnabled(true);
		modify_value_dlg.jTextFieldName.setText(value.name);
		modify_value_dlg.jTextFieldData.setText(value.data);
		show_dialog(modify_value_dlg);

		if(modify_value_dlg.completed)
		{
			value.data = modify_value_dlg.jTextFieldData.getText().trim();

			try
			{
				registry.put(value.path + value.name, value.data);

				updateValues(value.path);

				jTable.addRowSelectionInterval(selected_row, selected_row);
			}
			catch(IOException ex)
			{
				doError(ex);
			}
		}
	}
	void doDelete()
	{
		if(table)
		{
			int selected_row = jTable.getSelectedRow();
			if(selected_row == -1)
			{
				doMessage("Value was not selected.");
				return;
			}

			Value value = (Value)values.elementAt(selected_row);

			delete_dlg.setTitle("Delete Value");
			delete_dlg.jTextFieldMessage.setText("Are you sure you want to delete this value?");
			show_dialog(delete_dlg);

			if(delete_dlg.completed)
			{
				try
				{
					registry.removeValue(value.path + value.name);

					updateValues(value.path);

					if(selected_row > 0)
					{
						selected_row--;
						jTable.addRowSelectionInterval(selected_row, selected_row);
					}
				}
				catch(IOException ex)
				{
					doError(ex);
				}
			}
		}
		else
		{
			DefaultMutableTreeNode node = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();

			if(node == null)
			{
				doMessage("Key was not selected.");
				return;
			}

			Key key = (Key)node.getUserObject();

			delete_dlg.setTitle("Delete Key");
			delete_dlg.jTextFieldMessage.setText("Are you sure you want to delete this key?");
			show_dialog(delete_dlg);

			if(delete_dlg.completed)
			{
				try
				{
					int[] selected_rows = jTree.getSelectionRows();

					registry.removeKey(key.path);

					node = (DefaultMutableTreeNode)node.getParent();

					if(node == null)
					{
						node = root;
					}

					key = (Key)node.getUserObject();

					expand(node, key.path);

					if(selected_rows[0] > 0)
					{
						selected_rows[0]--;
						jTree.setSelectionRow(selected_rows[0]);
					}
				}
				catch(IOException ex)
				{
					doError(ex);
				}
			}
		}
	}
	void doRename()
	{
		if(table)
		{
			int selected_row = jTable.getSelectedRow();
			if(selected_row == -1)
			{
				doMessage("Value was not selected.");
				return;
			}

			Value value = (Value)values.elementAt(selected_row);

			modify_value_dlg.old_name = value.name;
			modify_value_dlg.path = value.path;
			modify_value_dlg.setTitle("Rename Value");
			modify_value_dlg.modify = false;
			modify_value_dlg.jTextFieldName.setEnabled(true);
			modify_value_dlg.jTextFieldData.setEnabled(false);
			modify_value_dlg.buttonOk.setEnabled(true);
			modify_value_dlg.jTextFieldName.setText(value.name);
			modify_value_dlg.jTextFieldData.setText(value.data);
			show_dialog(modify_value_dlg);

			if(modify_value_dlg.completed)
			{
				String old_name = value.name;

				value.name = modify_value_dlg.jTextFieldName.getText().trim();

				try
				{
					registry.renameValue(value.path + old_name, value.path + value.name);

					updateValues(value.path);
				}
				catch(IOException ex)
				{
					doError(ex);
				}
			}
		}
		else
		{
			DefaultMutableTreeNode node = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();

			if(node == null)
			{
				doMessage("Key was not selected.");
				return;
			}

			Key key = (Key)node.getUserObject();

			DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();

			if(parent_node == null)
			{
				node = root;
			}

			Key parent_key = (Key)parent_node.getUserObject();

			modify_key_dlg.old_key = key.id;
			modify_key_dlg.path = parent_key.path;
			modify_key_dlg.setTitle("Rename Key");
			modify_key_dlg.buttonOk.setEnabled(true);
			modify_key_dlg.jTextFieldKey.setText(key.id);
			show_dialog(modify_key_dlg);

			if(modify_key_dlg.completed)
			{
				String name = modify_key_dlg.jTextFieldKey.getText().trim();

				String old_key = key.path;
				String new_key = old_key.substring(0, old_key.length() - key.id.length()) + name;

				try
				{
					registry.renameKey(old_key, new_key);

					key.id = name;
					key.path = new_key;

					expand(node, key.path);
				}
				catch(IOException ex)
				{
					doError(ex);
				}
			}
		}
	}
	void doAbout()
	{
		show_dialog(about_dlg);
	}
	void doError(Throwable ex)
	{
		try
		{
			ex.printStackTrace();
		}
		finally
		{
			try
			{
				if(registry != null)
				{
					try
					{
						registry.close();
					}
					catch(IOException tex)
					{
						tex.printStackTrace();
					}
					registry = null;
				}
			}
			finally
			{
				System.exit(0);
			}
		}
	}
	void doMessage(String message)
	{
		message_dlg.jTextFieldMessage.setText(message);
		show_dialog(message_dlg);
	}
	private final void updateValues(String key)
	{
		try
		{
			Vector list = registry.values(key);

			sorter.sort(list);

			if(!key.endsWith(Registry.DELIMITER))
			{
				key = key + Registry.DELIMITER;
			}

			values.removeAllElements();
			((RegistryTableModel)jTable.getModel()).update();

			DefaultMutableTreeNode node;

			String path;
			String name;

			for(int i = 0; i < list.size(); i++)
			{
				name = (String)list.elementAt(i);
				path = key + name;
				values.addElement(new Value(key, name, registry.get(path)));
			}
		}
		catch(IOException ex)
		{
			doError(ex);
		}

		jTable.clearSelection();
		((RegistryTableModel)jTable.getModel()).update();

		updateState();
	}
	private final void expand(DefaultMutableTreeNode top, String key)
	{
		top.removeAllChildren();

		try
		{
			Vector list = registry.keys(key);

			sorter.sort(list);

			if(key.endsWith(Registry.DELIMITER))
			{
				key = key.substring(0, key.length() - 1);
			}

			//values.removeAllElements();

			DefaultMutableTreeNode node;

			String path;
			String name;

			int count = list.size();

			for(int i = 0; i < count; i++)
			{
				name = (String)list.elementAt(i);
				path = key + Registry.DELIMITER + name;
				node = new DefaultMutableTreeNode(new Key(path, name));
				node.add(new DefaultMutableTreeNode());
				top.add(node);
			}
		}
		catch(IOException ex)
		{
			doError(ex);
		}

		((DefaultTreeModel)jTree.getModel()).reload(top);

		if(top == root)
		{
			jTree.setSelectionRow(0);
		}
	}

	class QuickSortRegistry extends QuickSort
	{
		public int compare(Object object1, Object object2)
		{
			String key1 = (String)object1;
			String key2 = (String)object2;

			return key1.compareTo(key2);
		}

		public int count(Object objects)
		{
			return ((Vector)objects).size();
		}

		public Object extract(Object objects, int index)
		{
			return ((Vector)objects).elementAt(index);
		}

		public void replace(Object objects, int index, Object object)
		{
			((Vector)objects).setElementAt(object, index);
		}
	}

	class RegistryTreeRenderer extends DefaultTreeCellRenderer
	{
		ImageIcon root_icon = new ImageIcon(RegistryExplorer.class.getResource("/icons/registry.gif"));

		public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus)
		{
			super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);

			if(value == root)
			{
				setIcon(root_icon);
			}
			else
			{
				Object obj = ((DefaultMutableTreeNode)value).getUserObject();
				if(obj != null)
				{
					setToolTipText(((Key)obj).path.replace(Registry.DELIMITER_CHAR, '/'));
				}

				setIcon(getClosedIcon());
			}

			return this;
		}
	}
	class Key
	{
		String id;
		String path;

		Key(String path, String id)
		{
			this.path = path;
			this.id = id;
		}

		public String toString()
		{
			return id;
		}
	}
	class Value
	{
		String path;
		String name;
		String data;

		Value(String path, String name, String data)
		{
			this.path = path;
			this.name = name;
			this.data = data;
		}
	}

	private void updateState()
	{
		DefaultMutableTreeNode node = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();

		if(node == null)
		{
			jMenuEditNew.setEnabled(false);
			jMenuNew.setEnabled(false);
			jButtonEditNew.setEnabled(false);

			jMenuEditModify.setEnabled(false);
			jMenuModify.setEnabled(false);
			jButtonEditModify.setEnabled(false);

			jMenuEditDelete.setEnabled(false);
			jMenuDelete.setEnabled(false);
			jButtonEditDelete.setEnabled(false);

			jMenuEditRename.setEnabled(false);
			jMenuRename.setEnabled(false);
			jButtonEditRename.setEnabled(false);
		}
		else
		{
			jMenuEditNew.setEnabled(true);
			jMenuNew.setEnabled(true);
			jButtonEditNew.setEnabled(true);

			if(table)
			{
				int selected_row = jTable.getSelectedRow();
				if(selected_row == -1)
				{
					jMenuEditModify.setEnabled(false);
					jMenuModify.setEnabled(false);
					jButtonEditModify.setEnabled(false);

					jMenuEditDelete.setEnabled(false);
					jMenuDelete.setEnabled(false);
					jButtonEditDelete.setEnabled(false);

					jMenuEditRename.setEnabled(false);
					jMenuRename.setEnabled(false);
					jButtonEditRename.setEnabled(false);
				}
				else
				{
					jMenuEditModify.setEnabled(true);
					jMenuModify.setEnabled(true);
					jButtonEditModify.setEnabled(true);

					jMenuEditDelete.setEnabled(true);
					jMenuDelete.setEnabled(true);
					jButtonEditDelete.setEnabled(true);

					jMenuEditRename.setEnabled(true);
					jMenuRename.setEnabled(true);
					jButtonEditRename.setEnabled(true);
				}
			}
			else
			{
				jMenuEditModify.setEnabled(false);
				jMenuModify.setEnabled(false);
				jButtonEditModify.setEnabled(false);

				jMenuEditDelete.setEnabled(true);
				jMenuDelete.setEnabled(true);
				jButtonEditDelete.setEnabled(true);

				if(node == root)
				{
					jMenuEditRename.setEnabled(false);
					jMenuRename.setEnabled(false);
					jButtonEditRename.setEnabled(false);
				}
				else
				{
					jMenuEditRename.setEnabled(true);
					jMenuRename.setEnabled(true);
					jButtonEditRename.setEnabled(true);
				}
			}
		}
	}

	private void doPopup(MouseEvent e, int x, int y)
	{
		int modifiers = e.getModifiers();
		if(modifiers == 4)
		{
			popup.show(this, x + e.getX(), y + e.getY());
		}
	}

	void jTable_mousePressed(MouseEvent e)
	{
		table = true;
		updateState();
		doPopup(e, scrollpaneTable.getX()+25, scrollpaneTable.getY()+25);
	}

	void scrollpaneTable_mousePressed(MouseEvent e)
	{
		table = true;
		updateState();
		doPopup(e, scrollpaneTable.getX()+25, scrollpaneTable.getY());
	}

	void jSplitPane_mousePressed(MouseEvent e)
	{
		table = true;
		updateState();
		doPopup(e, jTable.getX()+25, jTable.getY());
	}

	void jTree_mousePressed(MouseEvent e)
	{
		table = false;
		updateState();
		doPopup(e, jTree.getX()+25, jTree.getY());
	}

	void jMenuNew_actionPerformed(ActionEvent e)
	{
		doNew();
	}

	void jMenuModify_actionPerformed(ActionEvent e)
	{
		doModify();
	}

	void jMenuDelete_actionPerformed(ActionEvent e)
	{
		doDelete();
	}

	void jMenuRename_actionPerformed(ActionEvent e)
	{
		doRename();
	}

	void jButtonEditNew_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();
		if(chr == ' ' || chr == '\n')
		{
			doNew();
		}
	}

	void jButtonEditModify_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();
		if(chr == ' ' || chr == '\n')
		{
			doModify();
		}
	}

	void jButtonEditDelete_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();
		if(chr == ' ' || chr == '\n')
		{
			doDelete();
		}
	}

	void jButtonEditRename_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();
		if(chr == ' ' || chr == '\n')
		{
			doRename();
		}
	}

	void jButtonHelpAbout_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();
		if(chr == ' ' || chr == '\n')
		{
			doAbout();
		}
	}

	class RegistryTableModel extends AbstractTableModel
	{
		public int getColumnCount()
		{
			return column_headers.length;
		}

		public int getRowCount()
		{
			return values.size();
		}

		public Object getValueAt(int row, int col)
		{
			Value value = (Value)values.elementAt(row);
			return (col == 0) ? value.name : value.data;
		}

		public String getColumnName(int column)
		{
			return column_headers[column];
		}

		public Class getColumnClass(int column)
		{
			return getValueAt(0, column).getClass();
		}

		public boolean isCellEditable(int row, int col)
		{
			return false;
		}

		public void update()
		{
			fireTableDataChanged();
		}
	}

	void jTable_mouseClicked(MouseEvent e)
	{
		if(e.getClickCount() == 2)
		{
			doModify();
		}
	}

	void jTable_focusGained(FocusEvent e)
	{
		table = true;
		updateState();
		int selected_row = jTable.getSelectedRow();
		if(selected_row == -1)
		{
			if(values.size() > 0)
			{
				jTable.addRowSelectionInterval(0, 0);
			}
		}
		else
		{
			jTable.addRowSelectionInterval(selected_row, selected_row);
		}
	}
}