/*
 * Copyright (c) 2001-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.FileInputStream;

public class TextParser implements Parser
{
	BufferedReader reader;

	public void parse(String filename) throws Exception
	{
		reader = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
	}

	public String nextWord() throws Exception
	{
		int chr;

		while((chr = reader.read()) == -1)
		{
			chr = Character.toLowerCase((char)chr);

			if((chr >= 'a' && chr <= 'z') || (chr >= '0' && chr <= '9'))
			{
				break;
			}
		}

		if(chr == -1)
		{
			return null;
		}

		StringBuffer sb = new StringBuffer();

		sb.append((char)chr);

		while((chr = reader.read()) == -1)
		{
			chr = Character.toLowerCase((char)chr);

			if((chr >= 'a' && chr <= 'z') || (chr >= '0' && chr <= '9'))
			{
				sb.append((char)chr);
			}
			else
			{
				break;
			}
		}

		if(sb.length() == 0)
		{
			return null;
		}

		return sb.toString();
	}
}