VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cApReg"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
'local variable(s) to hold property value(s)
Private mvarRootKey As Long
Private mvarSubKey As String
Private mvarLogName As String
Private mvarRegRS As Recordset

'Registry Manager v2.1
'Description: include this dll in your application.
'It will help in managing application registry setting.
'Source code and usage demo are provided
'Only string values are supported.
'Revisions:
'v1.1
'Recordset is used for data exchange and reference added to msador15.dll

'Usage Examples
'1.Declaration:
'   Set oApReg = New cApReg
'2.Load application Registry value list:
'   oApReg.Init(Optional aRootKey As Long, Optional aSubKey As String) as long
'3.Update or create new registry value
'   oApReg.Update(tValueName, tValueData)
'4.Access the data after initialization:
'    If oApReg.FindReg(tValueName, temp) Then tValueData = temp
'5.Delete a registry:
'   oApReg.DeleteReg(tValueName)

'questions, bug report - levrom@hotmail.com
'if you like it then
' - you can sent $1 to my paypal account (levrom@hotmail.com) - optional
'else
' - you can sent angry e-mail to levrom@hotmail.com - required
'end if
'all sources are free to use on your own risk

Public Property Set RegRS(ByVal vData As Recordset)
'used when assigning an Object to the property, on the left side of a Set statement.
'Syntax: Set x.RegRS = Form1
    Set mvarRegRS = vData
End Property

Public Property Get RegRS() As Recordset
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.RegRS
    Set RegRS = mvarRegRS
End Property

Public Property Let SubKey(ByVal vData As String)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.SubKey = 5
    mvarSubKey = vData
End Property

Public Property Get SubKey() As String
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.SubKey
    SubKey = mvarSubKey
End Property

Public Property Let RootKey(ByVal vData As Long)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.KeyRoot = 5
    mvarRootKey = vData
End Property

Public Property Get RootKey() As Long
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.KeyRoot
    RootKey = mvarRootKey
End Property

Public Property Let LogName(ByVal vData As String)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.LogName = 5
    mvarLogName = vData
End Property

Public Property Get LogName() As String
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.LogName
    LogName = mvarLogName
End Property

Private Sub Class_Initialize()
  Init
End Sub

Private Sub Class_Terminate()
   RegRS.Close
   Set RegRS = Nothing
End Sub

Public Function Init(Optional aRootKey As Long = 0, Optional aSubKey As String = "*") As Boolean
' returns True if initiation went out OK, False - otherwise;
Dim strTempDir As String, temp() As String, dTemp As String
Dim p1 As Integer, j As Integer, i As Integer, IngChar As Long

On Error GoTo InitErr
  Init = False 'default value
    
  If aRootKey = 0 Then RootKey = HKEY_LOCAL_MACHINE Else RootKey = aRootKey
  If aSubKey = "*" Then SubKey = "SOFTWARE\Company\Application" Else SubKey = aSubKey
  Init = LoadReg

' get "logfile_path"
  If Not FindReg("logfile_path", strTempDir) Then
     strTempDir = String$(255, vbNull)
     IngChar = GetTempPath(255, strTempDir)
     strTempDir = Left$(strTempDir, IngChar)
     Update "logfile_path", strTempDir
  End If

  If Right(strTempDir, 1) = "\" Then ' remove last '\' if any to be consistent
      strTempDir = Left(strTempDir, Len(strTempDir) - 1)
      Update "logfile_path", strTempDir
  End If

' check if the log directory exists, otherwise - create it
  If Len(Dir(strTempDir, vbDirectory)) = 0 Then
    p1 = InStr(1, strTempDir, ":")    ' if path is given as 'c:\xxx\yyy' change to 'c:xxx\yyy'
    If p1 > 0 And InStr(1, strTempDir, ":\") <> p1 Then strTempDir = Left(strTempDir, p1) & "\" & Right(strTempDir, Len(strTempDir) - p1)
    If InStr(1, strTempDir, "\\") = 1 Then
      j = 3   'directory "\\..."
    Else
      j = 1   'directory "X:\..."
    End If
    temp = Split(strTempDir, "\")
    If IsNull(temp(0)) Then GoTo InitErr
  
    For i = 0 To UBound(temp)
      dTemp = dTemp + temp(i)
      If j = 3 Then dTemp = dTemp + "\"
      If i >= j Then If Dir(dTemp, vbDirectory) = "" Then MkDir dTemp
      If j = 1 Then dTemp = dTemp + "\"
    Next
  End If

' get logfile name
  temp = Split(SubKey, "\")
  LogName = temp(UBound(temp))
  LogName = LogName & "_" & Format(Str(Date), "YYYYMMDD") & ".log"
   
' get "debug_mode"
  If Not FindReg("debug_mode", dTemp) Then Update "debug_mode", "N"

  ' get "logfile_size"
  If Not FindReg("logfile_size", dTemp) Then Update "logfile_size", "1000"
  
InitErr:
  
End Function

Private Function LoadReg() As Boolean
' returns True if initiation went out OK, False - otherwise;
Dim lValueType As Long    ' Data Type Of A Registry Key
Dim sValue As String, sData As String
Dim lValueSize As Long, lDataSize As Long
Dim Index As Long, rc As Long
Dim ValueName As String, ValueData As String
Dim hKey As Long          ' Handle To An Open Registry Key

On Error GoTo LoadRegErr
  LoadReg = False 'default value
  
  Set RegRS = Nothing
  Set RegRS = New Recordset
  RegRS.Fields.Append "No", adInteger
  RegRS.Fields.Append "ValueName", adVarChar, 255
  RegRS.Fields.Append "ValueData", adVarChar, 255
  RegRS.Open
    
  rc = RegOpenKey(RootKey, SubKey, hKey)
  Select Case rc
  Case ERROR_KEYNOTEXIST
    LoadReg = True
  Case ERROR_SUCCESS
    
    Do
      sValue = String$(255, 0)
      lValueSize = 255
      sData = String$(255, 0)
      lDataSize = 255
      Index = RegRS.RecordCount
      rc = RegEnumValue(hKey, Index, sValue, lValueSize, 0, lValueType, sData, lDataSize)
      If rc = ERROR_SUCCESS Then
        InStr sValue, Chr(0)
        ValueName = Left$(sValue, InStr(sValue, Chr(0)) - 1)
        ValueData = Left$(sData, InStr(sData, Chr(0)) - 1)
        
        RegRS.AddNew
        RegRS!No = Index + 1
        RegRS!ValueName = ValueName
        RegRS!ValueData = ValueData
      End If
    Loop While rc = ERROR_SUCCESS
       
    LoadReg = (RegCloseKey(hKey) = ERROR_SUCCESS)
  End Select
  
LoadRegErr:
  
End Function

Public Function Update(ValueName As String, ValueData As String) As Boolean
Dim hKey As Long, rc As Long, temp As String

On Error GoTo UpdateErr
  Update = False 'default
  
  rc = RegOpenKey(RootKey, SubKey, hKey)
  If Not rc = ERROR_SUCCESS Then rc = RegCreateKey(RootKey, SubKey, hKey)
  temp = ValueData
  If Len(temp) = 0 Then temp = " "
  If rc = ERROR_SUCCESS Then rc = RegSetValueEx(hKey, ValueName, 0, 1, temp, Len(temp))
  If rc = ERROR_SUCCESS Then
    RegCloseKey (hKey)
    Update = LoadReg
  End If

UpdateErr:

End Function

Public Function FindReg(ValueName As String, ValueData As String) As Boolean

On Error GoTo FindRegErr
  FindReg = False 'default value
  RegRS.MoveFirst
  RegRS.Find "ValueName = '" + ValueName + "'"
  FindReg = Not RegRS.EOF
  If FindReg Then ValueData = RegRS!ValueData

FindRegErr:

End Function

Public Function DeleteReg(ValueName As String) As Boolean
Dim hKey As Long, rc As Long, temp As String

On Error GoTo DeleteRegErr
  DeleteReg = False 'defauilt value
  
  If FindReg(ValueName, temp) Then
    rc = RegOpenKey(RootKey, SubKey, hKey)
    
    If rc = ERROR_SUCCESS Then '2 - key doesn't exist
      rc = RegDeleteValue(hKey, ValueName)
      If rc = ERROR_SUCCESS Then
        RegCloseKey (hKey)
        RegRS.Delete adAffectCurrent
        DeleteReg = LoadReg
      End If
    End If
  End If

DeleteRegErr:

End Function

Public Sub WriteToLog(Optional path_product As String = "", Optional strn As String = "", Optional DebugFlag As Boolean = False)
' recomended format for call - App.Path, App.ProductName, log_string(next_comand,values,comment,etc)
Dim fileno As Integer, counter As Long
Dim DebugMode As String, LogPathName As String

On Error GoTo WriteToLogExit
  If Not FindReg("debug_mode", DebugMode) Then Exit Sub
  If DebugMode = "N" And DebugFlag Then Exit Sub
  If Not FindReg("logfile_path", LogPathName) Then Exit Sub
  If LogPathName = "" Then Exit Sub
On Error GoTo WriteToLogErr
  LogPathName = LogPathName + "\" + LogName
  fileno = FreeFile
  If Dir(LogPathName) = "" Then
    Open LogPathName For Output As fileno
  Else
re_open:
    Open LogPathName For Append As fileno
  End If

  Print #fileno, Now & "-" & path_product & ":-" & strn
  Close fileno

WriteToLogExit:
  Exit Sub

WriteToLogErr:
  If counter >= 100 Then GoTo WriteToLogExit
  counter = counter + 1
  GoTo re_open
  
End Sub

Public Function GetLogFile() As String
Dim fileno As Integer, strTemp As String
Dim LogPathName As String, strLogString As String, LogSize As Long

On Error GoTo GetLogFileError
  If Not FindReg("logfile_path", LogPathName) Then GoTo GetLogFileError
  LogPathName = LogPathName + "\" + LogName
  If Dir(LogPathName) = "" Then GoTo GetLogFileError
  If Not FindReg("logfile_size", strTemp) Then GoTo GetLogFileError
  LogSize = strTemp
  
  fileno = FreeFile
  Open LogPathName For Input As fileno
  Do While Not EOF(fileno) Or Len(strLogString) > LogSize
    Input #fileno, strTemp
    strLogString = strLogString & strTemp + vbCrLf
    If Len(strLogString) > LogSize Then strLogString = Right(strLogString, LogSize)
  Loop
        
GetLogFileExit:
    Close fileno
    GetLogFile = strLogString
    Exit Function
 
GetLogFileError:
    strLogString = "GetLogFile:- " & LogPathName & " is not found"
    GoTo GetLogFileExit
    
End Function

