/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

#include "XSP_Core.h"

namespace XSP
{

EventLoop::EventLoop()
: quit(false)
{
}

EventLoop::~EventLoop()
{
	Close(false); // close and don't notify ... they all had their chance
}

void EventLoop::SetErrorSink(const refc<ErrorSink>& sink)
{
	errorSink = sink;
}

void EventLoop::QuitLoop()
{
	quit = true;
}

void EventLoop::Run()
{
	while (!quit)
	{
		try
		{
			if (eventQueue.empty())
			{
				eventQueue.swap(secondQueue);
				if (eventQueue.empty())
					break; // absolutely no more events means quit
				// only secondary events are left, sleep a bit then run them
				// sleep set to hardcoded 100ms (networking might want to change this approach)
				// any GUI message wakes up the loop ahead of the timeout
				::MsgWaitForMultipleObjects(0,0,FALSE,50,QS_ALLPOSTMESSAGE|QS_ALLINPUT);
			}
			refc<Event_Abstract> ev(eventQueue.front());
			eventQueue.pop_front();	 //remove from Q
			ASSERT(ev != 0);
			ev->Enqueue(0, eventQueue.end()); // tell event it's no longer in the Q
			ev->Run();
		}
		catch(const Exception& err)
		{
			ReportError(err);
		}
		catch(const std::exception& err)
		{
			ReportError(Exception::ExternalError(
				err.what(), 
				CoreModule::_instance->coreVersion));
		}
		catch (...)
		{
			ReportError(Exception::ExternalError(
				0, 
				CoreModule::_instance->coreVersion));
		}
	}
	Close(true); // close but notify first
}

void EventLoop::Close(bool notify)
{
	// cancel all queued events, just in case any of them still owns this queue
	// we don't want to have any circular ownership at this point since we intend 
	// to allow this queue to disapear
	Q::iterator b = eventQueue.begin();
	Q::iterator e = eventQueue.end();
	for(; b!= e; ++b)
	{
		(*b)->Enqueue(0, e);
		if (notify) (*b)->Terminated();
	}

	b = secondQueue.begin();
	e = secondQueue.end();
	for(; b!= e; ++b)
	{
		(*b)->Enqueue(0, e);
		if (notify) (*b)->Terminated();
	}
	
	eventQueue.clear();
	secondQueue.clear();
}

void EventLoop::ReportError(const Exception& err)
{
	if (errorSink != 0)
		errorSink->ProcessError(err);
	else
		err.Raise(); // cannot report so I just throw again
}

void EventLoop::PostEvent(const refc<Event_Abstract>& ev, bool imediate)
{
	if (ev == 0)
		return;
	if (!imediate)
	{
		ev->Enqueue(&secondQueue, secondQueue.insert(secondQueue.end(), ev));
		return;
	}	
	// an imediate event also forces prior secondary events into the queue
	while(!secondQueue.empty())
	{
		refc<Event_Abstract> sev(secondQueue.front());
		secondQueue.pop_front();
		if (sev != 0)
			sev->Enqueue(&eventQueue, eventQueue.insert(eventQueue.end(), sev));   //?? sev or ev?
	}	
	ev->Enqueue(&eventQueue, eventQueue.insert(eventQueue.end(), ev));
}

refc<Event_Abstract> EventLoop::CreateQuitEvent()
{
	return new Event_Quit(*this);
}


#if 0
#pragma mark -
#endif

Event_Abstract::Event_Abstract()
{
	currentQueue = 0;
}

Event_Abstract::~Event_Abstract()
{
	ASSERT(currentQueue == 0);
}

void Event_Abstract::Enqueue(EventLoop::Q* q, 
							 EventLoop::Q::iterator where)
{
	currentQueue = q;
	whereInQueue = where;
}
void Event_Abstract::Cancel()
{
	if (currentQueue != 0)
	{
		currentQueue->erase(whereInQueue);
		currentQueue = 0;
	}
}
void Event_Abstract::Terminated()
{
	
}

#if 0
#pragma mark - 
#endif

Event_Quit::Event_Quit(EventLoop& loop)
: loopToQuit(loop)
{
}

void Event_Quit::Run()
{
	loopToQuit.QuitLoop();
}


} // namespace XSP
