/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

#include "XSP_Core.h"

namespace XSP
{
#if TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon 
/*
    void getMicro()
    {
    	XSP::uint64 microsecs;
    	Microseconds((UnsignedWide*)&microsecs);
    }
    void getTicks()
    {
    	XSP::uint32 ticks = ::TickCount();
    }
    void getTime()
    {
    	XSP::uint32 dt;
    	// Macintosh style:  seconds since 1904 Jan 1
    	::GetDateTime(&dt);
    	// change to Epoch 1970 Jan 1
    	dt -= ((365UL * 66UL) + 17) * 24UL * 3600UL;
    	
		MachineLocation	loc;
		::ReadLocation(&loc);
		VERIFY(loc.latitude != 0 || loc.longitude != 0 || loc.u.gmtDelta != 0);

		XSP::sint32 delta = loc.u.gmtDelta & 0x00FFFFFF;
		if (delta & 0x00800000)
			delta |= 0xFF000000;
	    XSP::uint32 gmtime = dt-delta;

		bool isDaylightSavingsOn = (loc.u.dlsDelta != 0);
    }
*/
LocalTime LocalTime::Now()
{
	uint32 dt;
	// Macintosh style localtime:  seconds since 1904 Jan 1
    uint64 micro1,micro2;
    ::Microseconds((UnsignedWide*)&micro1);
    for(;;)
    {
		::GetDateTime(&dt);
	    ::Microseconds((UnsignedWide*)&micro2);
	    // check for sync at the second level
	    if ((micro1 / 1000000) == (micro2 / 1000000))
	       break;
	    micro1 = micro2;
	}
	DateTimeRec dr;
	::SecondsToDate(dt, &dr);
	return LocalTime(dr.year, dr.month, dr.day, 
				dr.hour, dr.minute, dr.second, 
				static_cast<uint32>((micro2 % 1000000)*1000));
}


#endif
} // namespace XSP
