/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{

class OffscreenImage;
class Codec : public ref_obj
{
public:
	class _Progress
	{
	public:
		virtual void Completed(const OffscreenImage& image)=0;
		virtual void Failed(const Exception& err)=0;
	}; // class _Progress
	typedef ListenerOf<_Progress> Listener;
	typedef Listener::Container ProgressListeners;
	ProgressListeners progressListeners;
protected:
	void ReportCompleted(const OffscreenImage& image);
	void ReportError(const Exception& err);
public:
	typedef refc<Codec> owner;
protected:
	virtual ~Codec();
public:
	virtual void Decode(void* dataBuf, uint32 dataSize) = 0;
}; // class Codec

class CodecFactory : public ref_obj
{
public:
	virtual refc<Codec> CreateCodec(const FileName& filename) = 0;
}; // class CodecFactory

// this is an agent capable of loading an image from a file on disc
// once ready it will notify the client with the completed image
// if it fails it notifies the client with the error
class ImagePool : public ref_obj
{
public:
	class _Progress
	{
	public:
		virtual void Completed()=0;
		virtual void Completed(const FileName& fname, const OffscreenImage& image)=0;
		virtual void Failed(const FileName& fname, const Exception& err)=0;
	}; // class _Progress
	typedef ListenerOf<_Progress> Listener;
	typedef Listener::Container ProgressListeners;
	ProgressListeners progressListeners;
private:
	void NotifyCompleted();
	void NotifyCompleted( const FileName& fname
					    , const OffscreenImage& image );
	void NotifyFailed( const FileName& fname
					 , const Exception& err );

public:
	uint32 imageID;
	
	typedef std::map<FileName, uint32> ImageFiles;
	ImageFiles imageFiles;
	ImageFiles toLoad;

	typedef std::vector<OffscreenImage> Images;
	Images images;

private:
	class LoadMoreImage;
	friend class LoadMoreImage;
	refc<LoadMoreImage> loadMoreImage;
	void LoadMoreImageCallback();
	void LoadNextImage();
private:
	class OnCodecNotification;
	friend class OnCodecNotification;
	void ImageLoadedCallback(const OffscreenImage& image);
	void ImageFailedCallback(const Exception& err);
public:
	ImagePool();
	void Load(const FileName& fname);
	void CancelAllDownloads();

	uint32 ImageCount() const;
	const OffscreenImage& GetImage(uint32 n) const;
protected:
	~ImagePool();
}; // class ImagePool


} // namespace XSP
