/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{

#if 0
#pragma mark ScrollView::ScrollListener
#endif

class ScrollView::ScrollListener : public View::ViewListener
{
	ScrollView* scrollview;
public:
	ScrollListener(ScrollView* v)  : scrollview(v) {}
	~ScrollListener()	      	   { CancelListener(); }
	void CancelListener() {	scrollview = 0;	super::CancelListener(); }
protected:
	virtual void ViewScroll(const Size2D& scrollSize, 
							const Rect2D& bounds, 
							View* /*originView*/)
	{
		if (scrollview == 0)
			return;
		if (scrollview->IsWithinNotify())
			return; // no recursive loops

		Rect2D targR(scrollview->scrollBounds);
		Rect2D targB(scrollview->GetLocalBounds());

		sint32 x = -targR.x; // unchanged
		if (scrollSize.w > 0)
		{
			sint32 w = std::max(0L, scrollSize.w - bounds.w);
			x = std::min(w, bounds.x);
			if (x > 0) // implies w>0 too
				x = (x * (targR.w-targB.w)) / w; // scale to our space
		}
		else switch (bounds.x)
		{
		case 1:// line count 
			x += std::min(32L, long(1+targB.w/4));
			break;	
		case -1:// line count
			x -= std::min(32L, long(1+targB.w/4));
			break;	
		case 2://  page count
			x += targB.w;
			break;	
		case -2:// page count
			x -= targB.w;
			break;	
		default: // unchanged
			break;	
		}

		sint32 y = -targR.y; // unchanged
		if (scrollSize.h > 0)
		{
			sint32 h = std::max(0L, scrollSize.h - bounds.h);
			y = std::min(h, bounds.y);
			if (y > 0) // implies h>0 too
				y = (y * (targR.h-targB.h)) / h; // scale to our space
		}
		else switch (bounds.y)
		{
		case 1:// line count 
			y += std::min(32L, long(1+targB.h/4));
			break;	
		case -1:// line count
			y -= std::min(32L, long(1+targB.h/4));
			break;	
		case 2://  page count
			y += targB.h;
			break;	
		case -2:// page count
			y -= targB.h;
			break;	
		default: // unchanged
			break;	
		}
		scrollview->ScrollTo(x,y);
	}
}; // ScrollListener

ScrollView::ScrollView()
{
}

ScrollView::~ScrollView()
{
	CancelListenToScrollNotifications();
}

void ScrollView::SetBounds(const Rect2D& bounds)
{
	Rect2D oldB(GetBounds());
	if (bounds != oldB)
	{
    	View::SetBounds(bounds);
		// only need to scroll if we grow and we are reaching 
		// beyond the old edge
//	    if ((bounds.x+bounds.w > scrollBounds.x+scrollBounds.w) || 
//	    	(bounds.y+bounds.h > scrollBounds.y+scrollBounds.h))
		ComputeScrollRect();
		ScrollTo(-scrollBounds.x, -scrollBounds.y);
		// must notify because of page size change
//		NotifyChange_ViewScroll(scrollBounds.GetSize(), 
//						Rect2D(-scrollBounds.GetNW(),bounds.GetSize()) );
	}
}
void ScrollView::AddView(const owner& view)
{
	View::AddView(view);
	if (ComputeScrollRect())
		ScrollTo(-scrollBounds.x, -scrollBounds.y);
}
void ScrollView::RemoveView(const owner& view)
{
	View::RemoveView(view);
	if (ComputeScrollRect())
		ScrollTo(-scrollBounds.x, -scrollBounds.y);
}
bool ScrollView::HandleMouseEvent( const UIEvent& ev )
{
	switch (ev.origin)
	{
	case UIEvent::MouseWheel:
		if (0 == (ev.modifiers & UIEvent::ShiftState))
			ScrollTo(-scrollBounds.x, -scrollBounds.y - ev.count/10);
		else
			ScrollTo(-scrollBounds.x - ev.count/10, -scrollBounds.y);
		return true;
	};
	return false;
}

bool ScrollView::ComputeScrollRect()
{
	Rect2D ucBounds; //(GetLocalBounds());
	// compute the document boundary (union of all children)
	const Children& children = GetChildren();
	Children::const_iterator b = children.begin();
	Children::const_iterator e = children.end();
	Children::const_iterator p;
    for(p=b; p!=e; ++p)
    	ucBounds = (*p)->GetBounds().Union(ucBounds);
    if (scrollBounds != ucBounds)
    {
    	scrollBounds = ucBounds;
    	return true;
    }
    return false;
}

void ScrollView::ScrollTo(sint32 x, sint32 y)
{
	Rect2D ucBounds(scrollBounds);

	Rect2D bounds = GetLocalBounds();
    // don't move beyond the natural edges of the document
	if (x > ucBounds.w-bounds.w) x = ucBounds.w-bounds.w;
	if (x < 0) x = 0;
	if (y > ucBounds.h-bounds.h) y = ucBounds.h-bounds.h;
	if (y < 0) y = 0;

	// do we need to change anything ?!
	if ((x != -ucBounds.x) || (y != -ucBounds.y))
	{
	    // make your move :-)
		const Children& children = GetChildren();
		Children::const_iterator b = children.begin();
		Children::const_iterator e = children.end();
		Children::const_iterator p;
	    for(p=b; p!=e; ++p)
	    {
	    	Rect2D cb((*p)->GetBounds());
	    	cb.OffsetBy(-x-ucBounds.x, -y-ucBounds.y);
			(*p)->SetBounds(cb);
	    }
	    ucBounds.x = -x;
	    ucBounds.y = -y;
	    scrollBounds = ucBounds;
	    Refresh();
	}

//UnitTest::Log("ScrollView: x=%d, page=%d, total=%d", -ucBounds.x, bounds.w, ucBounds.w);	
//UnitTest::Log("            y=%d, page=%d, total=%d", -ucBounds.y, bounds.h, ucBounds.h);	

    NotifyChange_ViewScroll(ucBounds.GetSize(), 
    						Rect2D(-ucBounds.GetNW(),bounds.GetSize()) );
}

void ScrollView::MakeVisible(const Rect2D& vBounds)
{
	Rect2D bounds = GetLocalBounds();
	sint32 x = std::min(vBounds.x,
		std::max(bounds.x+bounds.w, vBounds.x+vBounds.w) - bounds.w);
	sint32 y = std::min(vBounds.y,
		std::max(bounds.y+bounds.h, vBounds.y+vBounds.h) - bounds.h);
	if ((x != bounds.x) || (y != bounds.y))
		ScrollTo(x-scrollBounds.x,y-scrollBounds.y);
}


void ScrollView::ListenToScrollNotificationsFrom(const View::owner& view)
{
	if (scrollListener == 0)
		scrollListener = new ScrollListener(this);
	view->AddListener(scrollListener);
}
void ScrollView::CancelListenToScrollNotifications()
{
	if (scrollListener != 0)
	{
		scrollListener->CancelListener(); // needed 
		scrollListener=0;
	}
}

#if 0
#pragma mark -
#pragma mark ScrollBar::ScrollListener
#endif

class ScrollBar::ScrollListener : public View::ViewListener
{
	ScrollBar* scrollbar;
public:
	ScrollListener(ScrollBar* v)  : scrollbar(v) {}
	~ScrollListener()	      	   { CancelListener(); }
	void CancelListener() {	scrollbar = 0;	super::CancelListener(); }
protected:
	virtual void ViewScroll(const Size2D& scrollSize, 
							const Rect2D& bounds, 
							View* /*originView*/)
	{
		if (scrollbar == 0)
			return;
		if (scrollbar->vertical)
		{   // we don't care about line / page scrolls
			if (scrollSize.h > 0)
				scrollbar->ScrollTo(bounds.y, bounds.h, scrollSize.h);
		}
		else
		{   // we don't care about line / page scrolls
			if (scrollSize.w > 0)
				scrollbar->ScrollTo(bounds.x, bounds.w, scrollSize.w);
		}
	}
}; // ScrollListener

#if 0
#pragma mark ScrollComponentListener
#endif

class ScrollComponentListener : public ButtonView::ActionListener
{
	ScrollBar* scrollbar;
public:
	ScrollComponentListener(ScrollBar* v)  : scrollbar(v) {}
	~ScrollComponentListener()	      	   { CancelListener(); }
	void CancelListener() {	scrollbar = 0;	super::CancelListener(); }
protected:
	virtual void ActionPerform(ButtonView* button)
	{
		if (scrollbar == 0)
			return;
		scrollbar->ComponentAction(button);
	}
}; // ScrollComponentListener


ScrollBar::ScrollBar(bool v)
: vertical(v)
{
	StateSetReset(0,StateFocusable);
	ScrollComponentListener* scl = new ScrollComponentListener(this);

	cs1 = new ButtonView();  
	View::AddView(cs1);
	cs1->SetAutoRepeatButton(true);
	cs1->AddActionListener(scl);
//	cs1->StateSetReset(PartS1,0);

	cs2 = new ButtonView();  
	View::AddView(cs2);
	cs2->SetAutoRepeatButton(true);
	cs2->AddActionListener(scl);
//	cs2->StateSetReset(PartS2,0);

	cth = new ButtonView();  
	View::AddView(cth);
	cth->AddActionListener(scl);
	cth->StateSetReset(ButtonView::StateDragable,0);

	cb1 = new ButtonView(); 
	View::AddView(cb1);
	cb1->SetAutoRepeatButton(true);
	cb1->AddActionListener(scl);
//	cb1->StateSetReset(PartB1,0);

	cb2 = new ButtonView();  
	View::AddView(cb2);
	cb2->SetAutoRepeatButton(true);
	cb2->AddActionListener(scl);
//	cb2->StateSetReset(PartB2,0);
}

ScrollBar::~ScrollBar()
{
	CancelListenToScrollNotifications();
}

void ScrollBar::SetSkin(const ViewSkin::owner& skin)
{
	View::SetSkin(skin);
	cs1->SetSkin(GetSkinPartOrDefault(String::From_c_str("s1")));
	cs2->SetSkin(GetSkinPartOrDefault(String::From_c_str("s2")));
	cth->SetSkin(GetSkinPartOrDefault(String::From_c_str("thumb")));
	cb1->SetSkin(GetSkinPartOrDefault(String::From_c_str("b1")));
	cb2->SetSkin(GetSkinPartOrDefault(String::From_c_str("b2")));
}

void ScrollBar::ListenToScrollNotificationsFrom(const View::owner& view)
{
	if (scrollListener == 0)
		scrollListener = new ScrollListener(this);
	view->AddListener(scrollListener);
}
void ScrollBar::CancelListenToScrollNotifications()
{
	if (scrollListener != 0)
	{
		scrollListener->CancelListener(); // needed 
		scrollListener=0;
	}
}

bool ScrollBar::ScrollTo(sint32 x, sint32 pagew, sint32 totalw)
{
	// normalize the values
	if (totalw < 0)
		totalw = 0;
	if (pagew > totalw)
		pagew = totalw;
	if (x > totalw-pagew)
		x = totalw-pagew;
	if (x < 0)
		x = 0;

	// maybe we don't need to do anything
	if (pos == x && pageZ == pagew && totalZ == totalw)
		return false;

	// remember the new settings
	pos   = x;
	pageZ = pagew;
	totalZ= totalw;

	PositionComponents();
	NotifyScroll(); 
//UnitTest::Log("ScrollBar: x=%d, page=%d, total=%d", pos, pageZ, totalZ);	
	return true;
}

bool ScrollBar::NotifyScroll()
{
	// make absolutely sure we don't end up with a notification loop
	if (IsWithinNotify())
		return false;
    // notify everybody about the scroll change
	Size2D scrZ;
	Rect2D page;
	if (vertical)
	{
		scrZ.h = totalZ;
		page.y = pos;
		page.h = pageZ;
	}
	else
	{
		scrZ.w = totalZ;
		page.x = pos;
		page.w = pageZ;
	}
	NotifyChange_ViewScroll(scrZ, page); 
	return true;
}

bool ScrollBar::NotifyStep(sint32 amount)
{
	// make absolutely sure we don't end up with a notification loop
	if (IsWithinNotify())
		return false;

	Size2D scrZ;
	Rect2D page;
	if (vertical)
		page.y = amount;
	else
		page.x = amount;
	NotifyChange_ViewScroll(scrZ, page); 
	return true;
}

void ScrollBar::SetBounds(const Rect2D& bounds)
{
	View::SetBounds(bounds);
	PositionComponents();
}

void ScrollBar::PositionComponents()
{
	Rect2D bounds = GetLocalBounds();
	Rect2D b1,b2,s1,s2,th;
	if (vertical) 
	{
		b1.x=s1.x=th.x=s2.x=b2.x=bounds.x;
		b1.w=s1.w=th.w=s2.w=b2.w=bounds.w;
	    b1.h = b2.h = bounds.w; // square

    	s2.y = th.y = b1.y+b1.h;
    	sint32 c = std::max(0L, bounds.h - b1.h - b2.h);
	    if (totalZ > 0)
	    {
		    th.y += pos * c / totalZ;
		    s2.y += (pos+pageZ) * c / totalZ;
	    }
    	th.h = std::min( c, std::max(bounds.w, s2.y-th.y));
	        
    	s1.y = b1.y + b1.h;
	    s1.h = th.y - s1.y;
	    
	    s2.y = th.y + th.h;
	    s2.h = std::max(0L, bounds.h - b2.h - s2.y);

	    b2.y = s2.y + s2.h;
//UnitTest::Log("Thumb: y=%d, page=%d, total=%d", th.y, th.h, bounds.h-b1.h-b2.h);	
	}
	else
	{
		b1.y=s1.y=th.y=s2.y=b2.y=bounds.y;
		b1.h=s1.h=th.h=s2.h=b2.h=bounds.h;
	    b1.w = b2.w = bounds.h; // square

    	s2.x = th.x = b1.x+b1.w;
    	sint32 c = std::max(0L, bounds.w - b1.w - b2.w);
	    if (totalZ > 0)
	    {
		    th.x += pos * c / totalZ;
		    s2.x += (pos+pageZ) * c / totalZ;
	    }
    	th.w = std::min( c, std::max(bounds.h, s2.x-th.x));
	        
    	s1.x = b1.x + b1.w;
	    s1.w = th.x - s1.x;
	    
	    s2.x = th.x + th.w;
	    s2.w = std::max(0L, bounds.w - b2.w - s2.x);

	    b2.x = s2.x + s2.w;
//UnitTest::Log("Thumb: x=%d, page=%d, total=%d", th.x, th.w, bounds.w-b1.w-b2.w);	
	}
    // are any changes really needed ? (maybe the amount of scroll we 
    // are notified of translates into a change of the scrollbar of 
    // less than a pixel, it would not make sense for us to 
    // redraw because of that
	bool rfsh = (th != cth->GetBounds())
			 || (b1 != cb1->GetBounds())
			 || (b2 != cb2->GetBounds())
			 || (s1 != cs1->GetBounds())
			 || (s2 != cs2->GetBounds());
	if (rfsh)
	{
		cb1->SetBounds(b1);
		cs1->SetBounds(s1);
		cth->SetBounds(th);
		cs2->SetBounds(s2);
		cb2->SetBounds(b2);
		if (pageZ < totalZ)
		{
			cb1->StateSetReset(0,View::StateDisabled);
			cs1->StateSetReset(0,View::StateDisabled);
			cth->StateSetReset(0,View::StateDisabled);
			cs2->StateSetReset(0,View::StateDisabled);
			cb2->StateSetReset(0,View::StateDisabled);
		}
		else
		{
			cb1->StateSetReset(View::StateDisabled,0);
			cs1->StateSetReset(View::StateDisabled,0);
			cth->StateSetReset(View::StateDisabled,0);
			cs2->StateSetReset(View::StateDisabled,0);
			cb2->StateSetReset(View::StateDisabled,0);
		}
		Refresh();
	}
}

void ScrollBar::ThumbWasDragged()
{
	Rect2D bcth(cth->GetBounds());
	Rect2D bcs1(cs1->GetBounds());
	Rect2D bcs2(cs2->GetBounds());

	sint32 p = vertical ? bcth.y-bcs1.y : bcth.x-bcs1.x;
	sint32 t = vertical ? bcs2.y+bcs2.h-bcs1.y : bcs2.x+bcs2.w-bcs1.x;
	p = ((t==0) ? 0 : p*totalZ/t);

	if (!ScrollTo(p,pageZ,totalZ))
	{ // sub logical unit move but let's not allow any derail
	    if (vertical)
	    {
	    	bcth.x = bcs1.x;
	    	bcth.w = bcs1.w;
	    	bcth.y = std::max(bcs1.y, std::min(bcs2.y+bcs2.h-bcth.h, bcth.y));
	    	bcs1.h = bcth.y - bcs1.y;
	    	bcs2.h = (bcs2.y+bcs2.h) - (bcth.y+bcth.h);
	    	bcs2.y = bcth.y + bcth.h;
	    }
	    else
	    {
	    	bcth.y = bcs1.y;
	    	bcth.h = bcs1.h;
	    	bcth.x = std::max(bcs1.x, std::min(bcs2.x+bcs2.w-bcth.w, bcth.x));
	    	bcs1.w = bcth.x - bcs1.x;
	    	bcs2.w = (bcs2.x+bcs2.w) - (bcth.x+bcth.w);
	    	bcs2.x = bcth.x + bcth.w;
	    }
		cs1->SetBounds(bcs1);
		cth->SetBounds(bcth);
		cs2->SetBounds(bcs2);
		Refresh();
	}
}
void ScrollBar::ComponentAction(ButtonView* component)
{
	     if (component == cth)	ThumbWasDragged();
	else if (component == cb1)	NotifyStep(-1);
	else if (component == cb2)	NotifyStep( 1);
	else if (component == cs1)	NotifyStep(-2);
	else if (component == cs2)	NotifyStep( 2);
}


#if 0
#pragma mark -
#endif

ScrollPage::ScrollPage()
: content(0), ver(0), hor(0)
{
}
ScrollPage::~ScrollPage()
{
}
void ScrollPage::SetContent(const View::owner& view)
{
	if (content != 0) RemoveView(content); content = 0;
	if (ver != 0) RemoveView(ver); ver = 0;
	if (hor != 0) RemoveView(hor); hor = 0;

	Rect2D bounds(GetLocalBounds());

	AddView(view);
	content= view.operator->();
//	content->SetBounds(Rect2D(Size2D(bounds.w-10, bounds.h-10)));
	// the content should have a skin of its own, we should not interfere with it
		
	ver = new ScrollBar(true);
//	ver->SetBounds(Rect2D(Point2D(bounds.w-10,0),Size2D(10,bounds.h-10)));
	ver->SetSkin(GetSkinPartOrDefault(String::From_c_str("vertical")));
	AddView(ver);  

	hor = new ScrollBar(false);
//	hor->SetBounds(Rect2D(Point2D(0,bounds.h-10),Size2D(bounds.w-10, 10)));
	hor->SetSkin(GetSkinPartOrDefault(String::From_c_str("horizontal")));
	AddView(hor);

	ver->ListenToScrollNotificationsFrom(content);
	hor->ListenToScrollNotificationsFrom(content);
	content->ListenToScrollNotificationsFrom(ver);
	content->ListenToScrollNotificationsFrom(hor);

	PositionComponents();
}		 
void ScrollPage::SetBounds(const Rect2D& bounds)
{
	if (bounds != GetBounds())
	{
		View::SetBounds(bounds);
		PositionComponents();
	}
}
void ScrollPage::SetSkin(const ViewSkin::owner& skin)
{
	View::SetSkin(skin);
	if (ver != 0) ver->SetSkin(GetSkinPartOrDefault(String::From_c_str("vertical")));
	if (hor != 0) hor->SetSkin(GetSkinPartOrDefault(String::From_c_str("vertical")));
}
void ScrollPage::SetFont(const TextFont& f)
{
	View::SetFont(f);
	if (content != 0)
		content->SetFont(f);
}

void ScrollPage::PositionComponents()
{
	Rect2D bounds(GetLocalBounds());
	sint32 z = 12;
	if (content != 0)
		content->SetBounds(Rect2D(Size2D(bounds.w-z,bounds.h-z)));
	if (ver != 0)
		ver->SetBounds(Rect2D(Point2D(bounds.w-z,0),Size2D(z,bounds.h-z)));
	if (hor != 0)
		hor->SetBounds(Rect2D(Point2D(0,bounds.h-z),Size2D(bounds.w-z,z)));
}

} // namespace XSP
