unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, FileCtrl;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    UpDown1: TUpDown;
    Button1: TButton;
    Panel2: TPanel;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses FuzzySearch;

type
  TFileMapping = class(TFileStream)
  private
    fMapHandle: THandle;
    FP: Pointer;
    FSize: integer;
    FMapMode,FViewMode: integer;
    procedure SetSize(const Value: integer); reintroduce;
  public
    constructor Create(const FileName: string; Mode: Word;
      StartOffset: integer = 0; Len: integer = 0);
    destructor Destroy; override;
    procedure Map(StartOffset: integer = 0; Len: integer = 0);
    procedure Flush;
    property Memory: Pointer read FP;
    // after set new size Map set to 0..LengthOfFile-1
    property Size: integer read FSize write SetSize;
  end;

procedure TForm1.Button1Click(Sender: TObject);
var FuzzySearch: TFuzzySearch;
    TotFiles: integer;
    TotSize: integer;
    TimerStart,TimerStop,TimeTot: TLargeInteger;
    PerformanceFrequency: TLargeInteger;

  function AddSlash(const Path: string): string; { \  }
  begin
    if (Path = '') or (Path[Length(Path)] <> '\') then Result:=Path+'\'
    else Result:=Path;
  end;

  function ValidDirName(const DirName: string): Boolean;
  begin
    Result:=(DirName <> '.') and (DirName <> '..');
  end;

  procedure ProcessFile(const FileName: string);
  var FileMapping: TFileMapping;
  begin
    FileMapping:=TFileMapping.Create(FileName,fmOpenRead);
    try
      Inc(TotFiles);
      if FuzzySearch.Match(PChar(FileMapping.Memory),FileMapping.Size) then begin
        Inc(TotSize,FuzzySearch.FoundPos);
        Memo1.Lines.Add(FileName);
        Application.ProcessMessages;
      end else
        Inc(TotSize,FileMapping.Size);
    finally
      FileMapping.Free;
    end;
  end;

  procedure ScanSubDir(const Path: string);
  var  SearchRec: TSearchRec;
       DirList: TStringList;
       j: integer;
  begin
     { find files }
     if FindFirst(Path+'*.*',faReadOnly or faArchive,SearchRec) = 0 then try
       repeat
         if SearchRec.Attr and faDirectory = 0 then
           ProcessFile(Path+SearchRec.Name);
       until FindNext(SearchRec) <> 0;
     finally
       FindClose(SearchRec);
     end;
     { find SubDirs }
     DirList:=TStringList.Create;
     try
       if FindFirst(Path+'*.*',faDirectory,SearchRec) = 0 then try
         repeat
           if ValidDirName(SearchRec.Name) then
             DirList.Add(SearchRec.Name);
         until FindNext(SearchRec) <> 0;
       finally
         FindClose(SearchRec);
       end;
       { find files in SubDirs }
       for j:=0 to DirList.Count-1 do
         ScanSubDir(Path+DirList[j]+'\');
     finally
       DirList.Free;
     end;
  end;
begin
  if Edit1.Text <> '' then try
    TotFiles:=0;
    TotSize:=0;
    Memo1.Lines.Add('Search "'+Edit1.Text+'" in '+DirectoryListBox1.Directory);
    Memo1.Lines.Add('---------------------------');
    QueryPerformanceCounter(TimerStart);
    FuzzySearch:=TFuzzySearch.Create(Edit1.Text,UpDown1.Position);
    ScanSubDir(AddSlash(DirectoryListBox1.Directory));
    QueryPerformanceCounter(TimerStop);
    QueryPerformanceFrequency(PerformanceFrequency);
    TimeTot:=Round((TimerStop - TimerStart) * 1000.0 / PerformanceFrequency);
    Memo1.Lines.Add('---------------------------');
    Memo1.Lines.Add('Total lookup '+IntToStr(TotSize)+' bytes in '+IntToStr(TotFiles)+' files');
    Memo1.Lines.Add('Search time '+FormatFloat('#,##0.00',TimeTot/1000.0)+' sec');
    Memo1.Lines.Add('Search speed '+FormatFloat('#,##0.00',TotSize*1.0/TimeTot)+' Kb/sec');
    Memo1.Lines.Add('');
  finally
    FuzzySearch.Free;
  end;
end;

//------------------------------- TFileMapping ---------------------------------

constructor TFileMapping.Create(const FileName: string; Mode: Word;
  StartOffset, Len: integer);
var savePos: integer;
begin
  if Mode <> fmCreate then
    if (Mode and fmOpenWrite) <> 0 then
      Mode:=(Mode and not fmOpenWrite) or fmOpenReadWrite;
  inherited Create(FileName,Mode);
  if Mode and fmOpenReadWrite <> 0 then begin
    FMapMode:=PAGE_READWRITE; FViewMode:=FILE_MAP_ALL_ACCESS;
  end else begin
    FMapMode:=PAGE_READONLY; FViewMode:=FILE_MAP_READ;
  end;
  fMapHandle:=0; FP:=nil;
  savePos:=FileSeek(Handle,0,1);
  FSize := FileSeek(Handle,0,2);
  FileSeek(Handle,savePos,0);
  if Handle > 0 then
    fMapHandle:=CreateFileMapping(Handle, NIL, FMapMode {OR SEC_NOCACHE}, 0, 0, NIL)
  else
    raise Exception.Create('Cannot open file '+FileName);
  Map(StartOffset, Len);
end;

procedure TFileMapping.Flush;
begin
  FlushViewOfFile(FP,0);
end;

procedure TFileMapping.SetSize(const Value: integer);
var savePos: integer;
begin
  if FSize <> Value then begin
    UnmapViewOfFile(FP);
    CloseHandle(fMapHandle);
    inherited Size:=Value;
    savePos:=FileSeek(Handle,0,1);
    FSize := FileSeek(Handle,0,2);
    FileSeek(Handle,savePos,0);
    fMapHandle:=CreateFileMapping(Handle, NIL, FMapMode {OR SEC_NOCACHE}, 0, 0, NIL);
    Map;
  end;
end;

procedure TFileMapping.Map(StartOffset, Len: integer);
begin
  if FP <> nil then
    UnmapViewOfFile(FP);
  if fMapHandle > 0 then
    FP:=MapViewOfFile(fMapHandle, FViewMode, 0, StartOffset, Len);
end;

destructor TFileMapping.Destroy;
begin
  UnmapViewOfFile(FP);
  CloseHandle(fMapHandle);
  inherited Destroy;
end;

end.
