// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "ipsink.h"
#include "doc.h"
#include "view.h"

#include "mainfrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_MYSBPANE
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction
CMainFrame::CMainFrame()
{
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// fix the caption
	DWORD x = 0;
	x |= FWS_ADDTOTITLE;
	cs.style &= ~x;
	
	// set the position
	float fClientWidth = (float)0.75;       // think of this as a percentage  of the screen that the
													// client will consume
	int hr = ::GetSystemMetrics( SM_CXSCREEN );
	int vr = ::GetSystemMetrics( SM_CYSCREEN );
	cs.cx = (int)((float)hr * fClientWidth);  // consume fClientWidth% of the x pixels
	cs.cy = (int)((float)vr * fClientWidth);  // consume fClientWidth% of the y pixels
	cs.x  = (hr - cs.cx)/2;  // centers the window
	cs.y  = (vr - cs.cy)/2;  // centers the window
	
	// call the base class and return
	BOOL b = CFrameWnd::PreCreateWindow(cs);
	return(b);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
BOOL CMainFrame::MakePaneText( int nIndex, LPCTSTR lpszNewText ) 
{
	// what is being used?
	CFont * pNow = m_wndStatusBar.GetFont();

	UINT nID = 0;
	UINT nStyle = 0;
	int cxWidth = 0;
	m_wndStatusBar.GetPaneInfo( nIndex, nID, nStyle, cxWidth );

	CWindowDC dc(this);

	// if not this then GetTextExtent is done against 700 weight, 16 point System font
	CFont * pOld = dc.SelectObject(pNow);

	CString s = lpszNewText;
	m_wndStatusBar.SetPaneInfo( nIndex, nID, nStyle, dc.GetTextExtent(s).cx+2 );

	// restore old one
	dc.SelectObject(pOld);

	return m_wndStatusBar.SetPaneText( nIndex, lpszNewText ); 
}
