/*
 * Decompiled with CFR 0.152.
 */
package stec.pos;

import java.io.File;
import java.io.IOException;
import stec.pos.ByteArray;
import stec.pos.Common;
import stec.pos.ObjectStore;
import stec.pos.ObjectStoreReference;
import stec.pos.POSException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class CheckObjectStore {
    private boolean int;
    private boolean char;
    private boolean byte;
    private boolean else = true;
    private ObjectStoreReference for;
    private long do;
    private long if;
    private long try;
    private long new;
    private long goto;
    private long a;
    private boolean case;

    public static final void main(String[] stringArray) throws Throwable {
        Common.logo("Persistent Object Store Checker");
        if (stringArray.length < 1) {
            System.out.println("Usage: <java> stec.pos.CheckObjectStore <options> <store>");
            System.out.println();
            System.out.println("Options:");
            System.out.println("-d            do not display progress");
            System.out.println("-l            check links");
            System.out.println("-u            display utilization");
            System.out.println("-v            verbose messages");
            return;
        }
        CheckObjectStore.check(stringArray);
    }

    public static final boolean check(String[] stringArray) throws Throwable {
        String string;
        int n;
        CheckObjectStore checkObjectStore = new CheckObjectStore();
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).charAt(0) == '-'; ++n) {
            if (string.equalsIgnoreCase("-d")) {
                checkObjectStore.else = false;
                continue;
            }
            if (string.equalsIgnoreCase("-l")) {
                checkObjectStore.char = true;
                continue;
            }
            if (string.equalsIgnoreCase("-u")) {
                checkObjectStore.byte = true;
                continue;
            }
            if (string.equalsIgnoreCase("-v")) {
                checkObjectStore.int = true;
                continue;
            }
            System.out.println("Invalid parameter: ".concat(String.valueOf(String.valueOf(string))));
            return false;
        }
        if (n >= n2) {
            System.out.println("Store was not specified.");
            return false;
        }
        try {
            if (!checkObjectStore.if(stringArray[n])) {
                boolean bl = false;
                return bl;
            }
            if (checkObjectStore.byte) {
                checkObjectStore.a(stringArray[n]);
            }
        }
        catch (Exception exception) {
            throw Common.getRootCause(exception);
        }
        return true;
    }

    public static final boolean check(String[] stringArray, String[] stringArray2) {
        boolean bl = true;
        int n = stringArray2.length;
        String[] stringArray3 = new String[n + 1];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray[i];
            System.out.print(String.valueOf(String.valueOf(string)).concat(": "));
            stringArray3[n] = string;
            try {
                boolean bl2 = CheckObjectStore.check(stringArray3);
                if (bl2) {
                    System.out.println("PASSED");
                    continue;
                }
                bl = false;
                System.out.println("FAILED");
                continue;
            }
            catch (Throwable throwable) {
                bl = false;
                System.out.println("FAILED");
                throwable.printStackTrace();
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean if(String string) throws IOException {
        block31: {
            boolean bl;
            block32: {
                boolean bl2;
                block30: {
                    boolean bl3;
                    block29: {
                        boolean bl4;
                        block28: {
                            boolean bl5;
                            block27: {
                                boolean bl6;
                                block26: {
                                    boolean bl7;
                                    block25: {
                                        File file;
                                        if (this.int) {
                                            System.out.println("Checking object store");
                                        }
                                        String string2 = String.valueOf(String.valueOf(string)).concat(".htmapper");
                                        if (this.int) {
                                            System.out.println("Mapper: ".concat(String.valueOf(String.valueOf(string2))));
                                        }
                                        if (!(file = new File(string2)).exists()) {
                                            System.out.println("Mapper does not exist: ".concat(String.valueOf(String.valueOf(string2))));
                                            return false;
                                        }
                                        if (file.isDirectory()) {
                                            System.out.println("Mapper can not be a directory: ".concat(String.valueOf(String.valueOf(string2))));
                                            return false;
                                        }
                                        this.if = file.length();
                                        if (this.int) {
                                            System.out.println("Mapper file length: ".concat(String.valueOf(String.valueOf(this.if))));
                                        }
                                        if (this.if < (long)27) {
                                            System.out.println("Mapper file length is too small.");
                                            System.out.println("Minimum mapper file length: 27");
                                            System.out.println("Current mapper file length: ".concat(String.valueOf(String.valueOf(this.if))));
                                            return false;
                                        }
                                        string2 = String.valueOf(String.valueOf(string)).concat(".htstore");
                                        if (this.int) {
                                            System.out.println("Store: ".concat(String.valueOf(String.valueOf(string2))));
                                        }
                                        if (!(file = new File(string2)).exists()) {
                                            System.out.println("Store does not exist: ".concat(String.valueOf(String.valueOf(string2))));
                                            return false;
                                        }
                                        if (file.isDirectory()) {
                                            System.out.println("Store can not be a directory: ".concat(String.valueOf(String.valueOf(string2))));
                                            return false;
                                        }
                                        this.do = file.length();
                                        if (this.int) {
                                            System.out.println("Store file length: ".concat(String.valueOf(String.valueOf(this.do))));
                                        }
                                        if (this.do < (long)23) {
                                            System.out.println("Store file length is too small.");
                                            System.out.println("Mimumum store file length: 23");
                                            System.out.println("Current store file length: ".concat(String.valueOf(String.valueOf(this.do))));
                                            return false;
                                        }
                                        this.for = ObjectStore.do(string);
                                        if (this.for == null) {
                                            System.out.println("Store is in use: ".concat(String.valueOf(String.valueOf(string))));
                                            return false;
                                        }
                                        try {
                                            try {
                                                if (!this.try()) {
                                                    bl7 = false;
                                                    Object var6_13 = null;
                                                    break block25;
                                                }
                                                if (!this.if()) {
                                                    bl6 = false;
                                                    break block26;
                                                }
                                                if (!this.a()) {
                                                    bl5 = false;
                                                    break block27;
                                                }
                                                if (!this.for()) {
                                                    bl4 = false;
                                                    break block28;
                                                }
                                                if (this.char) {
                                                    if (!this.do()) {
                                                        bl3 = false;
                                                        break block29;
                                                    }
                                                    if (!this.int()) {
                                                        bl2 = false;
                                                        break block30;
                                                    }
                                                }
                                                if (this.new()) break block31;
                                                bl = false;
                                                break block32;
                                            }
                                            catch (IOException iOException) {
                                                throw iOException;
                                            }
                                            catch (Exception exception) {
                                                throw new POSException(exception);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var6_21 = null;
                                            this.for.close();
                                            throw throwable;
                                        }
                                    }
                                    this.for.close();
                                    return bl7;
                                }
                                Object var6_14 = null;
                                this.for.close();
                                return bl6;
                            }
                            Object var6_15 = null;
                            this.for.close();
                            return bl5;
                        }
                        Object var6_16 = null;
                        this.for.close();
                        return bl4;
                    }
                    Object var6_17 = null;
                    this.for.close();
                    return bl3;
                }
                Object var6_18 = null;
                this.for.close();
                return bl2;
            }
            Object var6_19 = null;
            this.for.close();
            return bl;
        }
        Object var6_20 = null;
        this.for.close();
        return true;
    }

    private final boolean try() throws IOException {
        if (this.int) {
            System.out.println("Checking mapper header");
        }
        if (this.int) {
            System.out.println("Mapper type: ".concat(String.valueOf(String.valueOf(this.for.a.d.v))));
        }
        if (this.for.a.d.v != 2) {
            System.out.println("Mapper type mismatch.");
            System.out.println("Required mapper type: 2");
            System.out.println("Current mapper type: ".concat(String.valueOf(String.valueOf(this.for.a.d.v))));
            return false;
        }
        if (this.int) {
            System.out.println("Mapper version: ".concat(String.valueOf(String.valueOf(this.for.a.d.p))));
        }
        if (this.for.a.d.p != 256) {
            System.out.println("Mapper version mismatch.");
            System.out.println("Required mapper version: 256");
            System.out.println("Current mapper version: ".concat(String.valueOf(String.valueOf(this.for.a.d.p))));
            return false;
        }
        if (this.int) {
            System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(this.for.a.d.i))));
        }
        if (this.for.a.d.i < 0) {
            System.out.println("Mapper page count must be at least zero (0): ".concat(String.valueOf(String.valueOf(this.for.a.d.i))));
            return false;
        }
        if (this.int) {
            System.out.println("Mapper maximum page count: ".concat(String.valueOf(String.valueOf(this.for.a.d.case))));
        }
        if (this.for.a.d.case != -1 && this.for.a.d.i > this.for.a.d.case) {
            System.out.println("Mapper page count exceeds maximum page count.");
            System.out.println("Maximum page count: ".concat(String.valueOf(String.valueOf(this.for.a.d.case))));
            System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(this.for.a.d.i))));
            return false;
        }
        int n = this.for.a.d.byte;
        if (this.int) {
            System.out.println("Mapper free list page number: ".concat(String.valueOf(String.valueOf(n))));
        }
        if (n < -1) {
            System.out.println("Mapper free list page number is not valid: ".concat(String.valueOf(String.valueOf(n))));
            return false;
        }
        if (n >= this.for.a.d.i) {
            System.out.println("Mapper free list page number exceeds page count.");
            System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(this.for.a.d.i))));
            System.out.println("Mapper free list page number: ".concat(String.valueOf(String.valueOf(n))));
            return false;
        }
        if (this.int) {
            System.out.println("Mapper free count: ".concat(String.valueOf(String.valueOf(this.for.a.d.j))));
        }
        if (this.int) {
            System.out.println("Mapper lookup table page count: ".concat(String.valueOf(String.valueOf(this.for.a.d.else))));
        }
        if (this.for.a.d.else < 1) {
            System.out.println("Mapper lookup table page count must be at least one (1): ".concat(String.valueOf(String.valueOf(this.for.a.d.else))));
            return false;
        }
        if (this.int) {
            System.out.println("Mapper record count: ".concat(String.valueOf(String.valueOf(this.for.a.d.d))));
        }
        if (this.for.a.d.d < 0) {
            System.out.println("Mapper record count must be at least zero (0): ".concat(String.valueOf(String.valueOf(this.for.a.d.d))));
            return false;
        }
        if (this.for.a.d.d > this.for.a.d.i) {
            System.out.println("Mapper record count exceeds page count.");
            System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(this.for.a.d.i))));
            System.out.println("Mapper record count: ".concat(String.valueOf(String.valueOf(this.for.a.d.d))));
            return false;
        }
        long l = this.for.a.d.case == -1 ? (long)27 + (long)4 * (long)this.for.a.d.else + 29L * (long)this.for.a.d.i : (long)27 + (long)4 * (long)this.for.a.d.else + 29L * (long)this.for.a.d.case;
        if (Common.old_jvm) {
            if (this.if < l) {
                System.out.println("Mapper file length is too small.");
                System.out.println("Current mapper file length: ".concat(String.valueOf(String.valueOf(this.if))));
                System.out.println("Estimated mapper file length: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
        } else if (this.if != l) {
            System.out.println("Mapper file length is not correct.");
            System.out.println("Current mapper file length: ".concat(String.valueOf(String.valueOf(this.if))));
            System.out.println("Estimated mapper file length: ".concat(String.valueOf(String.valueOf(l))));
            return false;
        }
        return true;
    }

    private final boolean if() throws IOException {
        if (this.int) {
            System.out.println("Checking store header");
        }
        if (this.int) {
            System.out.println("Store type: ".concat(String.valueOf(String.valueOf(this.for.a.if))));
        }
        if (this.for.a.if != 1) {
            System.out.println("Store type mismatch.");
            System.out.println("Required store type: 1");
            System.out.println("Current store type: ".concat(String.valueOf(String.valueOf(this.for.a.if))));
            return false;
        }
        if (this.int) {
            System.out.println("Store version: ".concat(String.valueOf(String.valueOf(this.for.a.for))));
        }
        if (this.for.a.for != 256) {
            System.out.println("Store version mismatch.");
            System.out.println("Requried store version: 256");
            System.out.println("Current store version: ".concat(String.valueOf(String.valueOf(this.for.a.for))));
            return false;
        }
        if (this.int) {
            System.out.println("Store page length: ".concat(String.valueOf(String.valueOf(this.for.a.a))));
        }
        if (this.for.a.a < 1) {
            System.out.println("Store page length must be at least one (1): ".concat(String.valueOf(String.valueOf(this.for.a.a))));
            return false;
        }
        if (this.int) {
            System.out.println("Store page count: ".concat(String.valueOf(String.valueOf(this.for.a.h))));
        }
        if (this.for.a.h < 0) {
            System.out.println("Store page count must be at least zero (0): ".concat(String.valueOf(String.valueOf(this.for.a.h))));
            return false;
        }
        if (this.int) {
            System.out.println("Store maximum page count: ".concat(String.valueOf(String.valueOf(this.for.a.o))));
        }
        if (this.for.a.o != -1 && this.for.a.h > this.for.a.o) {
            System.out.println("Store page count exceeds maximum page count.");
            System.out.println("Store maximum page count: ".concat(String.valueOf(String.valueOf(this.for.a.o))));
            System.out.println("Store page count: ".concat(String.valueOf(String.valueOf(this.for.a.h))));
            return false;
        }
        int n = this.for.a.char;
        if (this.int) {
            System.out.println("Store free list page number: ".concat(String.valueOf(String.valueOf(n))));
        }
        if (n < -1) {
            System.out.println("Store free list page number is not valid ".concat(String.valueOf(String.valueOf(n))));
            return false;
        }
        if (n >= this.for.a.h) {
            System.out.println("Store free list page number exceeds page count.");
            System.out.println("Store page count: ".concat(String.valueOf(String.valueOf(this.for.a.h))));
            System.out.println("Store free list page number: ".concat(String.valueOf(String.valueOf(n))));
            return false;
        }
        if (this.int) {
            System.out.println("Store free count: ".concat(String.valueOf(String.valueOf(this.for.a.k))));
        }
        long l = this.for.a.o == -1 ? (long)23 + ((long)this.for.a.a + 5L) * (long)this.for.a.h : (long)23 + ((long)this.for.a.a + 5L) * (long)this.for.a.o;
        if (Common.old_jvm) {
            if (this.do < l) {
                System.out.println("Store file length is too small.");
                System.out.println("Current store file length: ".concat(String.valueOf(String.valueOf(this.do))));
                System.out.println("Estimated store file length: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
        } else if (this.do != l) {
            System.out.println("Store file length is not correct.");
            System.out.println("Current store file length: ".concat(String.valueOf(String.valueOf(this.do))));
            System.out.println("Estimated store file length: ".concat(String.valueOf(String.valueOf(l))));
            return false;
        }
        return true;
    }

    private final boolean a() throws IOException {
        if (this.int) {
            System.out.println("Checking mapper free list");
        }
        int n = this.for.a.d.byte;
        int n2 = 0;
        int n3 = this.for.a.d.j;
        int n4 = this.for.a.d.i;
        int n5 = -1;
        while (n != -1) {
            ++n2;
            if (this.int && this.else) {
                Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n2))).append(" - ").append(n3).append(": ").append((int)((double)n2 / (double)n3 * 100.0)).append("%"))));
                this.case = true;
            }
            if (n < 0) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Mapper page number is not valid: ".concat(String.valueOf(String.valueOf(n))));
                return false;
            }
            if (n >= n4) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Mapper page number exceeds page count.");
                System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(n4))));
                System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n))));
                return false;
            }
            this.for.a.d.int(n);
            byte[] byArray = this.for.a.d.do;
            byte by = ByteArray.getByte(byArray, 0);
            if (by != 0) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Mapper page is not available.");
                System.out.println("Mapper page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n))));
                return false;
            }
            int n6 = ByteArray.getInt(byArray, 1);
            if (n6 != n5) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Mapper previous page is not correct.");
                System.out.println("Mapper last page number: ".concat(String.valueOf(String.valueOf(n5))));
                System.out.println("Mapper previous page number: ".concat(String.valueOf(String.valueOf(n6))));
                System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n))));
                return false;
            }
            n5 = n;
            n = ByteArray.getInt(byArray, 5);
        }
        if (this.case) {
            System.out.println();
            this.case = false;
        }
        if (n2 != this.for.a.d.j) {
            System.out.println("Mapper free list page count is not correct.");
            System.out.println("Current mapper free list page count: ".concat(String.valueOf(String.valueOf(this.for.a.d.j))));
            System.out.println("Estimated mapper free list page count: ".concat(String.valueOf(String.valueOf(n2))));
            return false;
        }
        return true;
    }

    private final boolean for() throws IOException {
        if (this.int) {
            System.out.println("Checking store free list");
        }
        int n = this.for.a.char;
        int n2 = 0;
        int n3 = this.for.a.k;
        int n4 = this.for.a.h;
        while (n != -1) {
            ++n2;
            if (this.int && this.else) {
                Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n2))).append(" - ").append(n3).append(": ").append((int)((double)n2 / (double)n3 * 100.0)).append("%"))));
                this.case = true;
            }
            if (n < 0) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Store page number is not valid: ".concat(String.valueOf(String.valueOf(n))));
                return false;
            }
            if (n >= n4) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Store page number exceeds page count.");
                System.out.println("Store page count: ".concat(String.valueOf(String.valueOf(n4))));
                System.out.println("Store page number: ".concat(String.valueOf(String.valueOf(n))));
                return false;
            }
            this.for.a.new(n);
            byte by = ByteArray.getByte(this.for.a.try, 0);
            if (by != 0) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Store page number is not available.");
                System.out.println("Store page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Store page number: ".concat(String.valueOf(String.valueOf(n))));
                return false;
            }
            n = ByteArray.getInt(this.for.a.try, 1);
        }
        if (this.case) {
            System.out.println();
            this.case = false;
        }
        if (n2 != this.for.a.k) {
            System.out.println("Store free list page count is not correct.");
            System.out.println("Current store free list page count: ".concat(String.valueOf(String.valueOf(this.for.a.k))));
            System.out.println("Estimated store free list page count: ".concat(String.valueOf(String.valueOf(n2))));
            return false;
        }
        return true;
    }

    private final boolean new() throws Exception {
        int n;
        if (this.int) {
            System.out.println("Checking mapper");
        }
        int n2 = this.for.a.d.i;
        int n3 = this.for.a.d.else;
        int n4 = this.for.a.h;
        byte[] byArray = this.for.a.try;
        int n5 = 0;
        for (n = 0; n < n3; ++n) {
            int n6 = this.for.a.d.if(n);
            if (this.int && this.else) {
                Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n + 1))).append(" - ").append(n3).append(": ").append((int)((double)(n + 1) / (double)n3 * 100.0)).append("%"))));
                this.case = true;
            }
            int n7 = -1;
            while (n6 != -1) {
                Object object;
                int n8;
                int n9;
                byte by;
                if (n6 < 0) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper page number is not valid: ".concat(String.valueOf(String.valueOf(n6))));
                    return false;
                }
                if (n6 >= n2) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper page number exceeds mapper page count.");
                    System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(n2))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n6))));
                    return false;
                }
                ++n5;
                this.for.a.d.int(n6);
                byte[] byArray2 = this.for.a.d.do;
                byte by2 = ByteArray.getByte(byArray2, 0);
                if (by2 != 1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper page is not in use.");
                    System.out.println("Mapper page flags: ".concat(String.valueOf(String.valueOf(by2))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n6))));
                    return false;
                }
                int n10 = ByteArray.getInt(byArray2, 1);
                if (n10 != n7) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper previous page number is not correct.");
                    System.out.println("Mapper last page number: ".concat(String.valueOf(String.valueOf(n7))));
                    System.out.println("Mapper previous page number: ".concat(String.valueOf(String.valueOf(n10))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n6))));
                    return false;
                }
                n7 = n6;
                int n11 = ByteArray.getInt(byArray2, 17);
                if (n11 < 1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Key length must be at least one (1): ".concat(String.valueOf(String.valueOf(n11))));
                    return false;
                }
                this.try += (long)n11;
                int n12 = ByteArray.getInt(byArray2, 13);
                if (n12 == -1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Key page number was not found: ".concat(String.valueOf(String.valueOf(n6))));
                    return false;
                }
                int n13 = n12;
                while (n13 != -1) {
                    if (n13 < 0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Key page number is not valid: ".concat(String.valueOf(String.valueOf(n13))));
                        return false;
                    }
                    if (n13 >= n4) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Key page number exceeds store page count.");
                        System.out.println("Keys store page count: ".concat(String.valueOf(String.valueOf(n4))));
                        System.out.println("Key page number: ".concat(String.valueOf(String.valueOf(n13))));
                        return false;
                    }
                    this.for.a.new(n13);
                    by = ByteArray.getByte(byArray, 0);
                    if (by != 1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Key page is not in use.");
                        System.out.println("Keys store flags: ".concat(String.valueOf(String.valueOf(by))));
                        System.out.println("Key page number: ".concat(String.valueOf(String.valueOf(n13))));
                        return false;
                    }
                    n13 = ByteArray.getInt(byArray, 1);
                    ++this.goto;
                }
                byte[] byArray3 = new byte[n11];
                this.for.a.if(n12, byArray3);
                byte by3 = byArray3[0];
                switch (by3) {
                    case 0: {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Key object type cannot be null.");
                        System.out.println("Key object type: ".concat(String.valueOf(String.valueOf(by3))));
                        System.out.println("Key page number: ".concat(String.valueOf(String.valueOf(n12))));
                        return false;
                    }
                    case 1: {
                        n9 = 2;
                        break;
                    }
                    case 2: {
                        n9 = 3;
                        break;
                    }
                    case 3: {
                        n9 = 3;
                        break;
                    }
                    case 4: {
                        n9 = 5;
                        break;
                    }
                    case 5: {
                        n9 = 9;
                        break;
                    }
                    case 6: {
                        n9 = 5;
                        break;
                    }
                    case 7: {
                        n9 = 9;
                        break;
                    }
                    case 8: {
                        n9 = -1;
                        break;
                    }
                    case 9: {
                        n9 = -1;
                        break;
                    }
                    case 10: {
                        n9 = 2;
                        break;
                    }
                    case 11: {
                        n9 = -1;
                        break;
                    }
                    case 15: {
                        n9 = -1;
                        break;
                    }
                    case 12: {
                        n9 = 9;
                        break;
                    }
                    case 13: {
                        n9 = -1;
                        break;
                    }
                    case 14: {
                        n9 = -1;
                        break;
                    }
                    default: {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Key object type is not correct.");
                        System.out.println("Key object type: ".concat(String.valueOf(String.valueOf(by3))));
                        System.out.println("Key page number: ".concat(String.valueOf(String.valueOf(n12))));
                        return false;
                    }
                }
                if (n9 != -1 && n9 != n11) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Key object length is not correct.");
                    System.out.println("Estimated key object length: ".concat(String.valueOf(String.valueOf(n9))));
                    System.out.println("Current key object length: ".concat(String.valueOf(String.valueOf(n11))));
                    System.out.println("Key page number: ".concat(String.valueOf(String.valueOf(n12))));
                    return false;
                }
                int n14 = ByteArray.getInt(byArray2, 9);
                if (n14 != (n8 = this.for.a.case(object = ByteArray.decodeObject(byArray3, 0)))) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Key hash code is not correct.");
                    System.out.println("Estimated key hash code: ".concat(String.valueOf(String.valueOf(n8))));
                    System.out.println("Current key hash code: ".concat(String.valueOf(String.valueOf(n14))));
                    System.out.println("Key page number: ".concat(String.valueOf(String.valueOf(n12))));
                    return false;
                }
                int n15 = ByteArray.getInt(byArray2, 25);
                if (n15 < 1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Value length must be at least one (1): ".concat(String.valueOf(String.valueOf(n15))));
                    return false;
                }
                this.new += (long)n15;
                int n16 = ByteArray.getInt(byArray2, 21);
                if (n16 == -1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Value page number was not found: ".concat(String.valueOf(String.valueOf(n6))));
                    return false;
                }
                n13 = n16;
                while (n13 != -1) {
                    if (n13 < 0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Value page number is not valid: ".concat(String.valueOf(String.valueOf(n13))));
                        return false;
                    }
                    if (n13 >= n4) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Value page number exceeds values store page count.");
                        System.out.println("Values store page count: ".concat(String.valueOf(String.valueOf(n4))));
                        System.out.println("Value page number: ".concat(String.valueOf(String.valueOf(n13))));
                        return false;
                    }
                    this.for.a.new(n13);
                    by = ByteArray.getByte(byArray, 0);
                    if (by != 1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Value page is not in use.");
                        System.out.println("Value page flags: ".concat(String.valueOf(String.valueOf(by))));
                        System.out.println("Value page number: ".concat(String.valueOf(String.valueOf(n13))));
                        return false;
                    }
                    n13 = ByteArray.getInt(byArray, 1);
                    ++this.a;
                }
                byte[] byArray4 = new byte[n15];
                this.for.a.if(n16, byArray4);
                by3 = byArray4[0];
                switch (by3) {
                    case 0: {
                        n9 = 1;
                        break;
                    }
                    case 1: {
                        n9 = 2;
                        break;
                    }
                    case 2: {
                        n9 = 3;
                        break;
                    }
                    case 3: {
                        n9 = 3;
                        break;
                    }
                    case 4: {
                        n9 = 5;
                        break;
                    }
                    case 5: {
                        n9 = 9;
                        break;
                    }
                    case 6: {
                        n9 = 5;
                        break;
                    }
                    case 7: {
                        n9 = 9;
                        break;
                    }
                    case 8: {
                        n9 = -1;
                        break;
                    }
                    case 9: {
                        n9 = -1;
                        break;
                    }
                    case 10: {
                        n9 = 2;
                        break;
                    }
                    case 11: {
                        n9 = -1;
                        break;
                    }
                    case 15: {
                        n9 = -1;
                        break;
                    }
                    case 12: {
                        n9 = 9;
                        break;
                    }
                    case 13: {
                        n9 = -1;
                        break;
                    }
                    case 14: {
                        n9 = -1;
                        break;
                    }
                    default: {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Value object type is not correct.");
                        System.out.println("Value object type: ".concat(String.valueOf(String.valueOf(by3))));
                        System.out.println("Value object page number: ".concat(String.valueOf(String.valueOf(n16))));
                        return false;
                    }
                }
                if (n9 != -1 && n9 != n15) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Value object length is not correct.");
                    System.out.println("Estimated value object length: ".concat(String.valueOf(String.valueOf(n9))));
                    System.out.println("Current value object length: ".concat(String.valueOf(String.valueOf(n15))));
                    System.out.println("Value object page number: ".concat(String.valueOf(String.valueOf(n16))));
                    return false;
                }
                Object object2 = ByteArray.decodeObject(byArray4, 0);
                n6 = ByteArray.getInt(byArray2, 5);
            }
        }
        if (this.case) {
            System.out.println();
            this.case = false;
        }
        if (this.int) {
            System.out.println();
            n = this.for.a.do();
            System.out.println("Average key page count: ".concat(String.valueOf(String.valueOf(n == 0 ? 0.0 : (double)this.goto / (double)n))));
            System.out.println("Average value page count: ".concat(String.valueOf(String.valueOf(n == 0 ? 0.0 : (double)this.a / (double)n))));
            System.out.println("Average key length: ".concat(String.valueOf(String.valueOf(n == 0 ? 0.0 : (double)this.try / (double)n))));
            System.out.println("Average value length: ".concat(String.valueOf(String.valueOf(n == 0 ? 0.0 : (double)this.new / (double)n))));
        }
        if (n5 != this.for.a.d.d) {
            System.out.println("Mapper record count is not correct.");
            System.out.println("Current mapper record count: ".concat(String.valueOf(String.valueOf(this.for.a.d.d))));
            System.out.println("Estimated mapper record count: ".concat(String.valueOf(String.valueOf(n5))));
            return false;
        }
        return true;
    }

    private final boolean do() throws IOException {
        block70: {
            int n;
            byte by;
            byte[] byArray;
            int n2;
            int n3;
            if (this.int) {
                System.out.println("Checking mapper links");
            }
            int n4 = this.for.a.d.else;
            int n5 = this.for.a.d.i;
            int n6 = this.for.a.d.byte;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = this.for.a.d.if(n3);
                if (n2 == -1) continue;
                this.for.a.d.int(n2);
                byArray = this.for.a.d.do;
                by = ByteArray.getByte(byArray, 0);
                if (by != 1) {
                    System.out.println("Mapper lookup table base page is not in use.");
                    System.out.println("Mapper lookup table base page flags: ".concat(String.valueOf(String.valueOf(by))));
                    System.out.println("Mapper lookup table base page number: ".concat(String.valueOf(String.valueOf(n2))));
                    return false;
                }
                n = ByteArray.getInt(byArray, 1);
                if (n == -1) continue;
                System.out.println("Mapper lookup table base page has a previous page.");
                System.out.println("Mapper lookup table base page previous page number: ".concat(String.valueOf(String.valueOf(n))));
                System.out.println("Mapper lookup table base page number: ".concat(String.valueOf(String.valueOf(n2))));
                return false;
            }
            for (n3 = 0; n3 < n5; ++n3) {
                int n7;
                int n8;
                if (this.int && this.else) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n3 + 1))).append(" - ").append(n5).append(": ").append((int)((double)(n3 + 1) / (double)n5 * 100.0)).append("%"))));
                    this.case = true;
                }
                this.for.a.d.int(n3);
                byArray = this.for.a.d.do;
                by = ByteArray.getByte(byArray, 0);
                n = ByteArray.getInt(byArray, 1);
                if (n < -1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper previous page number is not correct.");
                    System.out.println("Mapper previous page number: ".concat(String.valueOf(String.valueOf(n))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                    return false;
                }
                if (n >= n5) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper previous page number exceeds mapper page count.");
                    System.out.println("Mapper previous page number: ".concat(String.valueOf(String.valueOf(n))));
                    System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(n5))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                    return false;
                }
                if (n == n3) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper previous page number cannot be the same as the current page number.");
                    System.out.println("Mapper previous page number: ".concat(String.valueOf(String.valueOf(n))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                    return false;
                }
                int n9 = ByteArray.getInt(byArray, 5);
                if (n9 < -1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper next page number is not correct.");
                    System.out.println("Mapper next page number: ".concat(String.valueOf(String.valueOf(n9))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                    return false;
                }
                if (n9 >= n5) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper next page number exceeds mapper page count.");
                    System.out.println("Mapper next page number: ".concat(String.valueOf(String.valueOf(n9))));
                    System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(n5))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                    return false;
                }
                if (n9 == n3) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper next page number cannot be the same as the current page number.");
                    System.out.println("Mapper next page number: ".concat(String.valueOf(String.valueOf(n9))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                    return false;
                }
                if (by == 0) {
                    n2 = n6;
                    n8 = 0;
                    while (n2 != -1) {
                        if (n2 == n3) {
                            ++n8;
                        }
                        this.for.a.d.int(n2);
                        byArray = this.for.a.d.do;
                        n2 = ByteArray.getInt(byArray, 5);
                    }
                    if (n8 == 0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(n3))));
                        return false;
                    }
                    if (n8 > 1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page marked as available was found multiple times on free list.");
                        System.out.println("Mapper page reference count: ".concat(String.valueOf(String.valueOf(n8))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                        return false;
                    }
                    n8 = 0;
                    for (n7 = 0; n7 < n4; ++n7) {
                        n2 = this.for.a.d.if(n7);
                        if (n3 != n2) continue;
                        ++n8;
                    }
                    if (n8 > 0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("One or more mapper lookup table pages link to this free page.");
                        System.out.println("Mapper lookup table page reference count: ".concat(String.valueOf(String.valueOf(n8))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                        return false;
                    }
                } else if (by == 1) {
                    n8 = 0;
                    for (n7 = 0; n7 < n4; ++n7) {
                        n2 = this.for.a.d.if(n7);
                        if (n3 != n2) continue;
                        ++n8;
                    }
                    if (n == -1) {
                        if (n8 == 0) {
                            if (this.case) {
                                System.out.println();
                                this.case = false;
                            }
                            System.out.println("No mapper lookup table page links to this base page: ".concat(String.valueOf(String.valueOf(n3))));
                            return false;
                        }
                        if (n8 > 1) {
                            if (this.case) {
                                System.out.println();
                                this.case = false;
                            }
                            System.out.println("More than one mapper lookup table page links to this base page.");
                            System.out.println("Mapper lookup table page reference count: ".concat(String.valueOf(String.valueOf(n8))));
                            System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                            return false;
                        }
                    } else if (n8 > 0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("One or more mapper lookup table pages link to this non base page.");
                        System.out.println("Mapper lookup table page reference count: ".concat(String.valueOf(String.valueOf(n8))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                        return false;
                    }
                    n8 = 0;
                    for (n7 = 0; n7 < n4; ++n7) {
                        n2 = this.for.a.d.if(n7);
                        while (n2 != -1) {
                            if (n2 == n3) {
                                ++n8;
                            }
                            this.for.a.d.int(n2);
                            byArray = this.for.a.d.do;
                            n2 = ByteArray.getInt(byArray, 5);
                        }
                    }
                    if (n8 == 0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page was not linked to: ".concat(String.valueOf(String.valueOf(n3))));
                        return false;
                    }
                    if (n8 > 1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page was found multiple times.");
                        System.out.println("Mapper page reference count: ".concat(String.valueOf(String.valueOf(n8))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                        return false;
                    }
                } else {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper page flags are not correct.");
                    System.out.println("Mapper page flags: ".concat(String.valueOf(String.valueOf(by))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                    return false;
                }
                int n10 = 0;
                int n11 = 0;
                for (n2 = 0; n2 < n5; ++n2) {
                    if (n2 == n3) continue;
                    this.for.a.d.int(n2);
                    byArray = this.for.a.d.do;
                    byte by2 = ByteArray.getByte(byArray, 0);
                    int n12 = ByteArray.getInt(byArray, 1);
                    int n13 = ByteArray.getInt(byArray, 5);
                    if (n12 == n3) {
                        if (by2 != by) {
                            if (this.case) {
                                System.out.println();
                                this.case = false;
                            }
                            System.out.println("Mapper page previous link is to a page whose flags are not the same.");
                            System.out.println("Next mapper page flags: ".concat(String.valueOf(String.valueOf(by2))));
                            System.out.println("Mapper page flags: ".concat(String.valueOf(String.valueOf(by))));
                            System.out.println("Next mapper page number: ".concat(String.valueOf(String.valueOf(n2))));
                            System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                            return false;
                        }
                        if (n9 == -1) {
                            if (this.case) {
                                System.out.println();
                                this.case = false;
                            }
                            System.out.println("Mapper page previous link is to a page whose next link is not to it.");
                            System.out.println("Current next mapper page number: ".concat(String.valueOf(String.valueOf(n9))));
                            System.out.println("Previous mapper page number: ".concat(String.valueOf(String.valueOf(n12))));
                            System.out.println("Next mapper page number: ".concat(String.valueOf(String.valueOf(n2))));
                            System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                            return false;
                        }
                        ++n11;
                    }
                    if (n13 != n3) continue;
                    if (by2 != by) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page next link is to a page whose flags are not the same.");
                        System.out.println("Previous mapper page flags: ".concat(String.valueOf(String.valueOf(by2))));
                        System.out.println("Mapper page flags: ".concat(String.valueOf(String.valueOf(by))));
                        System.out.println("Previous mapper page number: ".concat(String.valueOf(String.valueOf(n2))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                        return false;
                    }
                    if (n == -1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page next link is to a page whose previous link is not to it.");
                        System.out.println("Current previous mapper page number: ".concat(String.valueOf(String.valueOf(n))));
                        System.out.println("Next mapper page number: ".concat(String.valueOf(String.valueOf(n13))));
                        System.out.println("Previous mapper page number: ".concat(String.valueOf(String.valueOf(n2))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                        return false;
                    }
                    ++n10;
                }
                if (n == -1) {
                    if (n10 > 0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page does not have a previous page, but other mapper pages next page link to this page.");
                        System.out.println("Mapper previous page reference count: ".concat(String.valueOf(String.valueOf(n10))));
                        System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(n3))));
                        return false;
                    }
                } else {
                    if (n10 == 0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page has a previous page, but no mapper pages next page link to this page: ".concat(String.valueOf(String.valueOf(n3))));
                        return false;
                    }
                    if (n10 > 1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page has a previous page, but more than one (1) mapper pages next page link to this page.");
                        System.out.println("Mapper previous page reference count: ".concat(String.valueOf(String.valueOf(n10))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                        return false;
                    }
                }
                if (n9 == -1) {
                    if (n11 <= 0) continue;
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper page does not have a next page, but other mapper pages previous page link to this page.");
                    System.out.println("Mapper next page reference count: ".concat(String.valueOf(String.valueOf(n11))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                    return false;
                }
                if (n11 == 0) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper page has a next page, but no mapper pages prebious page link to this page: ".concat(String.valueOf(String.valueOf(n3))));
                    return false;
                }
                if (n11 <= 1) continue;
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Mapper page has a next page, but more than one (1) mapper pages prebious page link to this page.");
                System.out.println("Mapper next page reference count: ".concat(String.valueOf(String.valueOf(n11))));
                System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(n3))));
                return false;
            }
            if (!this.case) break block70;
            System.out.println();
            this.case = false;
        }
        return true;
    }

    private final boolean int() throws IOException {
        block31: {
            if (this.int) {
                System.out.println("Checking store links");
            }
            int n = this.for.a.d.else;
            byte[] byArray = this.for.a.try;
            int n2 = this.for.a.h;
            int n3 = this.for.a.char;
            for (int i = 0; i < n2; ++i) {
                int n4;
                if (this.int && this.else) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + 1))).append(" - ").append(n2).append(": ").append((int)((double)(i + 1) / (double)n2 * 100.0)).append("%"))));
                    this.case = true;
                }
                this.for.a.new(i);
                byte by = ByteArray.getByte(byArray, 0);
                int n5 = ByteArray.getInt(byArray, 1);
                if (n5 < -1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Store next page number is not correct.");
                    System.out.println("Store next page number: ".concat(String.valueOf(String.valueOf(n5))));
                    System.out.println("Store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n5 >= n2) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Store next page number exceeds store page count.");
                    System.out.println("Store next page number: ".concat(String.valueOf(String.valueOf(n5))));
                    System.out.println("Store page count: ".concat(String.valueOf(String.valueOf(n2))));
                    System.out.println("Store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n5 == i) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Store next page number cannot be the same as the current page number.");
                    System.out.println("Store next page number: ".concat(String.valueOf(String.valueOf(n5))));
                    System.out.println("Store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (by == 0) {
                    int n6 = n3;
                    n4 = 0;
                    while (n6 != -1) {
                        if (n6 == i) {
                            ++n4;
                        }
                        this.for.a.new(n6);
                        n6 = ByteArray.getInt(byArray, 1);
                    }
                    if (n4 == 0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Store page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (n4 > 1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Store page marked as available was found multiple times on free list.");
                        System.out.println("Store page reference count: ".concat(String.valueOf(String.valueOf(n4))));
                        System.out.println("Store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else if (by == 1) {
                    n4 = 0;
                    for (int j = 0; j < n; ++j) {
                        int n7 = this.for.a.d.if(j);
                        while (n7 != -1) {
                            this.for.a.d.int(n7);
                            byte[] byArray2 = this.for.a.d.do;
                            int n8 = ByteArray.getInt(byArray2, 13);
                            while (n8 != -1) {
                                if (n8 == i) {
                                    ++n4;
                                }
                                this.for.a.new(n8);
                                n8 = ByteArray.getInt(byArray, 1);
                            }
                            int n9 = ByteArray.getInt(byArray2, 21);
                            while (n9 != -1) {
                                if (n9 == i) {
                                    ++n4;
                                }
                                this.for.a.new(n9);
                                n9 = ByteArray.getInt(byArray, 1);
                            }
                            n7 = ByteArray.getInt(byArray2, 5);
                        }
                    }
                    if (n4 == 0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Used page was not found mapped to store entry: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (n4 > 1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Used page was found mapped to multiple store pages.");
                        System.out.println("Store page reference count: ".concat(String.valueOf(String.valueOf(n4))));
                        System.out.println("Store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Store page flags are not correct.");
                    System.out.println("Store flags: ".concat(String.valueOf(String.valueOf(by))));
                    System.out.println("Store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n5 == -1) continue;
                this.for.a.new(n5);
                byte by2 = ByteArray.getByte(byArray, 0);
                if (by2 == by) continue;
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Store page next link is to a page whose flags are not the same.");
                System.out.println("Store next page flags: ".concat(String.valueOf(String.valueOf(by2))));
                System.out.println("Store page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Store next page number: ".concat(String.valueOf(String.valueOf(n5))));
                System.out.println("Store page number: ".concat(String.valueOf(String.valueOf(i))));
                return false;
            }
            if (!this.case) break block31;
            System.out.println();
            this.case = false;
        }
        return true;
    }

    private final void a(String string) throws Exception {
        ObjectStoreReference objectStoreReference = ObjectStore.open(string, true);
        try {
            System.out.println();
            System.out.println("Lookup table utilization: ".concat(String.valueOf(String.valueOf(objectStoreReference.lookup_table_utilization() * (double)100))));
            System.out.println("Mapper page utilization: ".concat(String.valueOf(String.valueOf(objectStoreReference.a.d.i == 0 ? 0.0 : (double)objectStoreReference.a.d.d / (double)objectStoreReference.a.d.i * (double)100))));
            System.out.println("Store page utilization: ".concat(String.valueOf(String.valueOf(objectStoreReference.a.h == 0 ? 0.0 : (double)(objectStoreReference.a.h - objectStoreReference.a.k) / (double)objectStoreReference.a.h * (double)100))));
            System.out.println("Store space utilization: ".concat(String.valueOf(String.valueOf(objectStoreReference.a.h * objectStoreReference.a.a == 0 ? 0.0 : (double)(this.try + this.new) / (double)(objectStoreReference.a.h * objectStoreReference.a.a) * (double)100))));
            System.out.println("Key space utilization: ".concat(String.valueOf(String.valueOf(this.goto * (long)objectStoreReference.a.a == (long)0 ? 0.0 : (double)this.try / (double)(this.goto * (long)objectStoreReference.a.a) * (double)100))));
            System.out.println("Value space utilization: ".concat(String.valueOf(String.valueOf(this.a * (long)objectStoreReference.a.a == (long)0 ? 0.0 : (double)this.new / (double)(this.a * (long)objectStoreReference.a.a) * (double)100))));
            if (this.int) {
                System.out.println();
                System.out.println("Lookup table block usage:");
                int n = objectStoreReference.lookup_table_size();
                for (int i = 0; i < n; ++i) {
                    System.out.print(i);
                    System.out.print(' ');
                    int n2 = objectStoreReference.lookup_table_page_count(i);
                    for (int j = 0; j < n2; ++j) {
                        System.out.print('#');
                    }
                    System.out.println();
                }
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            objectStoreReference.close();
            throw throwable;
        }
        objectStoreReference.close();
    }
}

