VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{FE5E97B2-72B4-11D6-BF85-444553540000}#1.0#0"; "THUMBNAILER.OCX"
Begin VB.Form Form1 
   Caption         =   "Thumbnailer ActiveX control sample project by Inspired Creations"
   ClientHeight    =   7740
   ClientLeft      =   90
   ClientTop       =   375
   ClientWidth     =   11490
   ForeColor       =   &H8000000F&
   Icon            =   "Form1.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   7740
   ScaleWidth      =   11490
   StartUpPosition =   2  'CenterScreen
   WindowState     =   2  'Maximized
   Begin VB.Frame Frame10 
      Caption         =   "Events"
      Height          =   2910
      Left            =   8505
      TabIndex        =   59
      Top             =   60
      Width           =   2940
      Begin VB.CommandButton Command2 
         Caption         =   "Clear"
         Height          =   255
         Left            =   2190
         TabIndex        =   63
         Top             =   2385
         Width           =   675
      End
      Begin VB.CheckBox Check6 
         Caption         =   "Show ""ThumbnailAdded"" events"
         Height          =   195
         Left            =   120
         TabIndex        =   62
         Top             =   2655
         Width           =   2700
      End
      Begin VB.CheckBox Check5 
         Caption         =   "Show events"
         Height          =   195
         Left            =   120
         TabIndex        =   61
         Top             =   2400
         Value           =   1  'Checked
         Width           =   1320
      End
      Begin VB.TextBox Text6 
         Height          =   2085
         Left            =   120
         MultiLine       =   -1  'True
         ScrollBars      =   3  'Both
         TabIndex        =   60
         Top             =   270
         Width           =   2715
      End
   End
   Begin MSComDlg.CommonDialog Dlg 
      Left            =   1965
      Top             =   6660
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
   End
   Begin VB.Frame Frame8 
      Height          =   4710
      Left            =   45
      TabIndex        =   38
      Top             =   2985
      Width           =   2535
      Begin VB.Frame Frame9 
         Caption         =   "Selected Item info"
         Height          =   3585
         Left            =   45
         TabIndex        =   43
         Top             =   1080
         Width           =   2445
         Begin VB.Label Label26 
            AutoSize        =   -1  'True
            Caption         =   "Item's RECT coordinates"
            Height          =   195
            Left            =   360
            TabIndex        =   58
            Top             =   1740
            Width           =   1755
         End
         Begin VB.Line Line1 
            BorderColor     =   &H80000014&
            X1              =   60
            X2              =   2400
            Y1              =   1650
            Y2              =   1650
         End
         Begin VB.Label Label25 
            AutoSize        =   -1  'True
            Caption         =   "Index:"
            Height          =   195
            Left            =   345
            TabIndex        =   57
            Top             =   360
            Width           =   435
         End
         Begin VB.Label Label24 
            BorderStyle     =   1  'Fixed Single
            Height          =   255
            Left            =   825
            TabIndex        =   56
            Top             =   330
            Width           =   585
         End
         Begin VB.Label Label23 
            AutoSize        =   -1  'True
            Caption         =   "Bottom:"
            Height          =   195
            Left            =   525
            TabIndex        =   55
            Top             =   3255
            Width           =   540
         End
         Begin VB.Label Label22 
            BorderStyle     =   1  'Fixed Single
            Height          =   255
            Left            =   1185
            TabIndex        =   54
            Top             =   3240
            Width           =   585
         End
         Begin VB.Label Label21 
            AutoSize        =   -1  'True
            Caption         =   "Right:"
            Height          =   195
            Left            =   645
            TabIndex        =   53
            Top             =   2865
            Width           =   420
         End
         Begin VB.Label Label20 
            BorderStyle     =   1  'Fixed Single
            Height          =   255
            Left            =   1185
            TabIndex        =   52
            Top             =   2850
            Width           =   585
         End
         Begin VB.Label Label19 
            AutoSize        =   -1  'True
            Caption         =   "Top:"
            Height          =   195
            Left            =   735
            TabIndex        =   51
            Top             =   2490
            Width           =   330
         End
         Begin VB.Label Label18 
            BorderStyle     =   1  'Fixed Single
            Height          =   255
            Left            =   1185
            TabIndex        =   50
            Top             =   2460
            Width           =   585
         End
         Begin VB.Label Label17 
            AutoSize        =   -1  'True
            Caption         =   "Left:"
            Height          =   195
            Left            =   750
            TabIndex        =   49
            Top             =   2100
            Width           =   315
         End
         Begin VB.Label Label16 
            BorderStyle     =   1  'Fixed Single
            Height          =   255
            Left            =   1185
            TabIndex        =   48
            Top             =   2070
            Width           =   585
         End
         Begin VB.Label Label15 
            AutoSize        =   -1  'True
            Caption         =   "FileName:"
            Height          =   195
            Left            =   75
            TabIndex        =   47
            Top             =   660
            Width           =   705
         End
         Begin VB.Label Label14 
            BorderStyle     =   1  'Fixed Single
            Height          =   255
            Left            =   825
            TabIndex        =   46
            Top             =   630
            Width           =   1560
         End
         Begin VB.Label Label13 
            AutoSize        =   -1  'True
            Caption         =   "FullPath:"
            Height          =   195
            Left            =   165
            TabIndex        =   45
            Top             =   945
            Width           =   615
         End
         Begin VB.Label Label12 
            AutoSize        =   -1  'True
            BorderStyle     =   1  'Fixed Single
            Height          =   450
            Left            =   75
            TabIndex        =   44
            Top             =   1170
            Width           =   2295
            WordWrap        =   -1  'True
         End
      End
      Begin VB.Label Label11 
         AutoSize        =   -1  'True
         Caption         =   "Drawn files:"
         Height          =   195
         Left            =   375
         TabIndex        =   42
         Top             =   705
         Width           =   825
      End
      Begin VB.Label Label2 
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Left            =   1365
         TabIndex        =   41
         Top             =   675
         Width           =   585
      End
      Begin VB.Label Label10 
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Left            =   1365
         TabIndex        =   40
         Top             =   285
         Width           =   585
      End
      Begin VB.Label Label5 
         AutoSize        =   -1  'True
         Caption         =   "Files in Path:"
         Height          =   195
         Left            =   300
         TabIndex        =   39
         Top             =   315
         Width           =   900
      End
   End
   Begin VB.Frame Frame2 
      Height          =   2895
      Left            =   60
      TabIndex        =   2
      Top             =   75
      Width           =   8340
      Begin VB.ComboBox Combo3 
         Height          =   315
         Left            =   6360
         Style           =   2  'Dropdown List
         TabIndex        =   66
         Top             =   420
         Width           =   1800
      End
      Begin VB.Frame Frame7 
         Height          =   735
         Left            =   2325
         TabIndex        =   32
         Top             =   2025
         Width           =   3915
         Begin VB.CommandButton cmdColor 
            Caption         =   "Back Color"
            Height          =   375
            Left            =   150
            TabIndex        =   37
            Top             =   240
            Width           =   1080
         End
         Begin VB.CheckBox Check1 
            Caption         =   "Has Label"
            Height          =   255
            Left            =   1380
            TabIndex        =   36
            Top             =   165
            Value           =   1  'Checked
            Width           =   1065
         End
         Begin VB.CheckBox Check4 
            Caption         =   "Tooltips"
            Height          =   225
            Left            =   1380
            TabIndex        =   35
            Top             =   435
            Value           =   1  'Checked
            Width           =   1110
         End
         Begin VB.CheckBox Check3 
            Caption         =   "Show System"
            Height          =   225
            Left            =   2535
            TabIndex        =   34
            Top             =   435
            Value           =   1  'Checked
            Width           =   1305
         End
         Begin VB.CheckBox Check2 
            Caption         =   "Show Hidden"
            Height          =   225
            Left            =   2535
            TabIndex        =   33
            Top             =   180
            Value           =   1  'Checked
            Width           =   1305
         End
      End
      Begin VB.Frame Frame6 
         Caption         =   "Selected Item"
         Height          =   675
         Left            =   6360
         TabIndex        =   29
         Top             =   2070
         Width           =   1830
         Begin VB.CommandButton Command3 
            Caption         =   "Set it"
            Height          =   300
            Left            =   915
            TabIndex        =   31
            TabStop         =   0   'False
            Top             =   270
            Width           =   780
         End
         Begin VB.TextBox txtSelect 
            Height          =   300
            Left            =   135
            TabIndex        =   30
            TabStop         =   0   'False
            Text            =   "-1"
            Top             =   270
            Width           =   660
         End
      End
      Begin VB.Frame Frame5 
         Height          =   1410
         Left            =   4215
         TabIndex        =   24
         Top             =   600
         Width           =   2010
         Begin VB.ComboBox Combo2 
            Height          =   315
            Left            =   105
            Style           =   2  'Dropdown List
            TabIndex        =   26
            Top             =   1035
            Width           =   1800
         End
         Begin VB.ComboBox Combo1 
            Height          =   315
            Left            =   105
            Style           =   2  'Dropdown List
            TabIndex        =   25
            Top             =   420
            Width           =   1800
         End
         Begin VB.Label Label3 
            AutoSize        =   -1  'True
            Caption         =   "ThumbBorderStyle"
            Height          =   195
            Left            =   353
            TabIndex        =   28
            Top             =   180
            Width           =   1305
         End
         Begin VB.Label Label4 
            AutoSize        =   -1  'True
            Caption         =   "LabelBorderStyle"
            Height          =   195
            Left            =   405
            TabIndex        =   27
            Top             =   795
            Width           =   1200
         End
      End
      Begin VB.CommandButton Command1 
         Caption         =   "Redraw"
         Height          =   375
         Left            =   4995
         TabIndex        =   23
         Top             =   225
         Width           =   1230
      End
      Begin VB.Frame Frame4 
         Height          =   1410
         Left            =   2340
         TabIndex        =   14
         Top             =   600
         Width           =   1770
         Begin VB.TextBox Text2 
            Height          =   285
            Left            =   1125
            TabIndex        =   18
            TabStop         =   0   'False
            Text            =   "-1"
            ToolTipText     =   "Range: 20 - 200. Click Enter to apply."
            Top             =   165
            Width           =   585
         End
         Begin VB.TextBox Text3 
            Height          =   285
            Left            =   1125
            TabIndex        =   17
            TabStop         =   0   'False
            Text            =   "-1"
            ToolTipText     =   "Range: 20 - 200. Click Enter to apply."
            Top             =   465
            Width           =   585
         End
         Begin VB.TextBox Text4 
            Height          =   285
            Left            =   1125
            TabIndex        =   16
            TabStop         =   0   'False
            Text            =   "-1"
            ToolTipText     =   "Range: 1 - 10. Click Enter to apply."
            Top             =   765
            Width           =   585
         End
         Begin VB.TextBox Text5 
            Height          =   285
            Left            =   1125
            TabIndex        =   15
            TabStop         =   0   'False
            Text            =   "-1"
            ToolTipText     =   "Range: 1 - 100. Click Enter to apply."
            Top             =   1065
            Width           =   585
         End
         Begin VB.Label Label6 
            AutoSize        =   -1  'True
            Caption         =   "ThumbWidth:"
            Height          =   195
            Left            =   120
            TabIndex        =   22
            Top             =   210
            Width           =   960
         End
         Begin VB.Label Label7 
            AutoSize        =   -1  'True
            Caption         =   "ThumbSpace:"
            Height          =   195
            Left            =   75
            TabIndex        =   21
            ToolTipText     =   "Range: 1 - 200. Click Enter to apply."
            Top             =   1110
            Width           =   1005
         End
         Begin VB.Label Label8 
            AutoSize        =   -1  'True
            Caption         =   "ThumbOffset:"
            Height          =   195
            Left            =   120
            TabIndex        =   20
            Top             =   810
            Width           =   960
         End
         Begin VB.Label Label9 
            AutoSize        =   -1  'True
            Caption         =   "ThumbHeight:"
            Height          =   195
            Left            =   75
            TabIndex        =   19
            Top             =   510
            Width           =   1005
         End
      End
      Begin VB.DirListBox Dir1 
         Height          =   1665
         Left            =   180
         TabIndex        =   12
         Top             =   1110
         Width           =   2010
      End
      Begin VB.DriveListBox Drive1 
         Height          =   315
         Left            =   180
         TabIndex        =   11
         Top             =   705
         Width           =   2010
      End
      Begin VB.TextBox Text1 
         Height          =   300
         Left            =   960
         TabIndex        =   10
         ToolTipText     =   "Set the path and click Enter to apply"
         Top             =   255
         Width           =   3945
      End
      Begin VB.Frame Frame3 
         Caption         =   "Pattern"
         Height          =   1230
         Left            =   6345
         TabIndex        =   3
         Top             =   765
         Width           =   1845
         Begin VB.CheckBox chk 
            Caption         =   "*.ico"
            Height          =   225
            Index           =   7
            Left            =   135
            TabIndex        =   65
            Top             =   960
            Width           =   705
         End
         Begin VB.CheckBox chk 
            Caption         =   "*.cur"
            Height          =   225
            Index           =   6
            Left            =   1050
            TabIndex        =   64
            Top             =   960
            Width           =   705
         End
         Begin VB.CheckBox chk 
            Caption         =   "*.emf"
            Height          =   225
            Index           =   4
            Left            =   1050
            TabIndex        =   9
            Top             =   480
            Width           =   705
         End
         Begin VB.CheckBox chk 
            Caption         =   "*.jpg"
            Height          =   225
            Index           =   1
            Left            =   135
            TabIndex        =   8
            Top             =   480
            Value           =   1  'Checked
            Width           =   705
         End
         Begin VB.CheckBox chk 
            Caption         =   "*.wmf"
            Height          =   225
            Index           =   5
            Left            =   1050
            TabIndex        =   7
            Top             =   720
            Width           =   705
         End
         Begin VB.CheckBox chk 
            Caption         =   "*.dib"
            Height          =   225
            Index           =   3
            Left            =   1050
            TabIndex        =   6
            Top             =   240
            Width           =   705
         End
         Begin VB.CheckBox chk 
            Caption         =   "*.gif"
            Height          =   225
            Index           =   2
            Left            =   135
            TabIndex        =   5
            Top             =   720
            Value           =   1  'Checked
            Width           =   705
         End
         Begin VB.CheckBox chk 
            Caption         =   "*.bmp"
            Height          =   225
            Index           =   0
            Left            =   135
            TabIndex        =   4
            Top             =   240
            Value           =   1  'Checked
            Width           =   705
         End
      End
      Begin VB.Label Label27 
         AutoSize        =   -1  'True
         Caption         =   "LabelEdit"
         Height          =   195
         Left            =   6930
         TabIndex        =   67
         Top             =   165
         Width           =   660
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Set Path:"
         Height          =   195
         Left            =   195
         TabIndex        =   13
         Top             =   315
         Width           =   660
      End
   End
   Begin VB.Frame Frame1 
      Height          =   4710
      Left            =   2670
      TabIndex        =   0
      Top             =   2970
      Width           =   8775
      Begin vbThumbnailer.Thumbnailer Thumbnailer1 
         Height          =   4065
         Left            =   105
         TabIndex        =   68
         Top             =   540
         Width           =   8565
         _ExtentX        =   15108
         _ExtentY        =   7170
         ThumbOffset     =   5
      End
      Begin MSComctlLib.ProgressBar PBar 
         Height          =   270
         Left            =   120
         TabIndex        =   1
         Top             =   195
         Width           =   8550
         _ExtentX        =   15081
         _ExtentY        =   476
         _Version        =   393216
         Appearance      =   1
         Scrolling       =   1
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

Const PTN_SEPARATOR = ";"       ' Pattern string separator

Const COLOR_BTNSHADOW = 16
Const COLOR_BTNHIGHLIGHT = 20
Const COLOR_3DDKSHADOW = 21
Const COLOR_3DLIGHT = 22

Private Declare Function GetSysColor Lib "user32" _
                            (ByVal nIndex As Long) As Long

Private Sub Form_Load()

  Dim i As Integer
  Dim sTmp As String

    ' Fill the Thumbnail Bordestyle combobox
    Combo1.AddItem "thbThinRaisedLight"
    Combo1.AddItem "thbThinRaisedDark"
    Combo1.AddItem "thbThinSunkenLight"
    Combo1.AddItem "thbThinSunkenDark"
    Combo1.AddItem "thbRaised"
    Combo1.AddItem "thbSunken"
    Combo1.AddItem "thbEtched"
    Combo1.AddItem "thbBump"
    Combo1.ListIndex = Thumbnailer1.ThumbBorderStyle
    
    ' Fill the Label Bordestyle combobox
    Combo2.AddItem "thbThinRaisedLight"
    Combo2.AddItem "thbThinRaisedDark"
    Combo2.AddItem "thbThinSunkenLight"
    Combo2.AddItem "thbThinSunkenDark"
    Combo2.AddItem "thbRaised"
    Combo2.AddItem "thbSunken"
    Combo2.AddItem "thbEtched"
    Combo2.AddItem "thbBump"
    Combo2.ListIndex = Thumbnailer1.LabelBorderStyle
    
    ' Fill the LabelEdit styles combobox
    Combo3.AddItem "thlAutomatic"
    Combo3.AddItem "thlManual"
    Combo3.ListIndex = Thumbnailer1.LabelEdit
    
    ' Fill the Textboxes with the predefined values
    Text2 = Thumbnailer1.ThumbWidth
    Text3 = Thumbnailer1.ThumbHeight
    Text4 = Thumbnailer1.ThumbOffset
    Text5 = Thumbnailer1.ThumbSpace
  
    ' Make the Thumbnailer1.Pattern string
    For i = 0 To 7
        If chk(i).Value = vbChecked Then
            sTmp = sTmp & PTN_SEPARATOR & chk(i).Caption
        End If
    Next
    
    ' Remove the initial ";" from the Pattern string
    If Len(sTmp) > 0 Then
        sTmp = Right$(sTmp, Len(sTmp) - 1)
    End If
    
    ' Set the Pattern
    Thumbnailer1.Pattern = sTmp
    
    ' This will cause the thumbnails to be drawn.
    Text1 = Dir1
    
    ' Clear any printed events (PathChange etc.)
    Text6 = vbNullString

End Sub

Private Sub Form_Resize()

  On Error Resume Next
    
    Frame1.Width = Me.Width - Frame1.Left - 250
    Frame1.Height = Me.Height - Frame1.Top - 530
    Thumbnailer1.Width = Frame1.Width - 250
    Thumbnailer1.Height = Frame1.Height - 630
    PBar.Width = Frame1.Width - 250

End Sub

Private Sub Drive1_Change()

  On Error Resume Next
    
    Dir1 = Drive1

End Sub

Private Sub Dir1_Change()

    Text1 = Dir1
        
    ' The Thumbnailer1 control does the Error handling
    ' in the case of an invalid path.
    Thumbnailer1.Path = Text1

End Sub

' Path
Private Sub Text1_KeyDown(KeyCode As Integer, Shift As Integer)

    If KeyCode = vbKeyReturn Then
        ' The Thumbnailer1 control does the Error handling
        ' in the case of an invalid path.
        Thumbnailer1.Path = Text1
    End If

End Sub

' ThumbWidth (20 - 200 pixels)
Private Sub Text2_KeyDown(KeyCode As Integer, Shift As Integer)

    If KeyCode = vbKeyReturn Then
        If Not IsNumeric(Text2) Then
            Text2 = "60"
            Else
            If CLng(Text2) < 20 Then Text2 = 20
            If CLng(Text2) > 200 Then Text2 = 200
            Thumbnailer1.ThumbWidth = CLng(Text2)
        End If
    End If

End Sub

Private Sub Text2_LostFocus()

    If Not IsNumeric(Text2) Then
        Text2 = "60"
        Else
        If CLng(Text2) < 20 Then Text2 = 20
        If CLng(Text2) > 200 Then Text2 = 200
        Thumbnailer1.ThumbWidth = CLng(Text2)
    End If

End Sub

' ThumbHeight (20 - 200 pixels)
Private Sub Text3_KeyDown(KeyCode As Integer, Shift As Integer)

    If KeyCode = vbKeyReturn Then
        If Not IsNumeric(Text3) Then
            Text3 = "60"
            Else
            If CLng(Text3) < 20 Then Text3 = 20
            If CLng(Text3) > 200 Then Text3 = 200
            Thumbnailer1.ThumbHeight = CLng(Text3)
        End If
    End If

End Sub

Private Sub Text3_LostFocus()

    If Not IsNumeric(Text3) Then
        Text3 = "60"
        Else
        If CLng(Text3) < 20 Then Text3 = 20
        If CLng(Text3) > 200 Then Text3 = 200
        Thumbnailer1.ThumbHeight = CLng(Text3)
    End If

End Sub

' ThumbOffset (1 - 10 pixels)
Private Sub Text4_KeyDown(KeyCode As Integer, Shift As Integer)

    If KeyCode = vbKeyReturn Then
        If Not IsNumeric(Text4) Then
            Text4 = "1"
            Else
            If CLng(Text4) < 1 Then Text4 = 1
            If CLng(Text4) > 10 Then Text4 = 10
            Thumbnailer1.ThumbOffset = CLng(Text4)
        End If
    End If

End Sub

Private Sub Text4_LostFocus()

    If Not IsNumeric(Text4) Then
        Text4 = "1"
        Else
        If CLng(Text4) < 1 Then Text4 = 1
        If CLng(Text4) > 10 Then Text4 = 10
        Thumbnailer1.ThumbOffset = CLng(Text4)
    End If

End Sub

' ThumbSpace (1 - 100 pixels)
Private Sub Text5_KeyDown(KeyCode As Integer, Shift As Integer)

    If KeyCode = vbKeyReturn Then
        If Not IsNumeric(Text5) Then
            Text5 = "1"
            Else
            If CLng(Text5) < 1 Then Text5 = 1
            If CLng(Text5) > 100 Then Text5 = 100
            Thumbnailer1.ThumbSpace = CLng(Text5)
        End If
    End If

End Sub

Private Sub Text5_LostFocus()

    If Not IsNumeric(Text5) Then
        Text5 = "1"
        Else
        If CLng(Text5) < 1 Then Text5 = 1
        If CLng(Text5) > 100 Then Text5 = 100
        Thumbnailer1.ThumbSpace = CLng(Text5)
    End If

End Sub

' Clear events log
Private Sub Command2_Click()

    Text6 = vbNullString

End Sub

' Back color
Private Sub cmdColor_Click()

  On Error GoTo Out

    Dlg.Flags = &H3
    Dlg.Color = Thumbnailer1.BackColor
    Dlg.ShowColor
    
    ' We exclude the colors of the Thumbnails' borders
    ' otherwise the Item's highlight will not be OK.
    Select Case Thumbnailer1.ThumbBorderStyle
        Case thbThinRaisedLight, thbThinSunkenLight, thbRaised, thbEtched
            If Dlg.Color = GetSysColor(COLOR_BTNHIGHLIGHT) Or Dlg.Color = GetSysColor(COLOR_BTNSHADOW) Then
                MsgBox "Please select another color.", vbCritical, "Color not accepted"
              Exit Sub
            End If
        Case thbThinRaisedDark, thbThinSunkenDark, thbSunken, thbBump
            If Dlg.Color = GetSysColor(COLOR_3DLIGHT) Or Dlg.Color = GetSysColor(COLOR_3DDKSHADOW) Then
                MsgBox "Please select another color.", vbCritical, "Color not accepted"
              Exit Sub
            End If
        Case Else
            '
    End Select
    
    Thumbnailer1.BackColor = Dlg.Color
    ' Redraw the Thumbnails
    Thumbnailer1.Redraw
    
  Exit Sub
    
' Cancel was pressed
Out:

End Sub

' HasLabel
Private Sub Check1_Click()

    If Check1.Value = vbChecked Then
        Thumbnailer1.HasLabel = True
        Else
        Thumbnailer1.HasLabel = False
    End If
    
    ' Redraw
    Thumbnailer1.Redraw

End Sub

' ThumbBorderStyle
Private Sub Combo1_Click()

    Thumbnailer1.ThumbBorderStyle = Combo1.ListIndex
    ' Redraw
    Thumbnailer1.Redraw

End Sub

' LabelBorderStyle
Private Sub Combo2_Click()

    Thumbnailer1.LabelBorderStyle = Combo2.ListIndex
    ' Redraw
    Thumbnailer1.Redraw

End Sub

' LabelEdit
Private Sub Combo3_Click()

    Thumbnailer1.LabelEdit = Combo3.ListIndex

End Sub

' Pattern
Private Sub chk_Click(Index As Integer)

  Dim i As Integer
  Dim sTmp As String
  
    ' Loop all the checkboxes
    For i = 0 To 7
        ' Enable nay previously disabled checkboxes
        chk(i).Enabled = True
        ' Add the extension to the Pattern string
        If chk(i).Value = vbChecked Then
            sTmp = sTmp & PTN_SEPARATOR & chk(i).Caption
        End If
    Next
    
    ' ----------------------------------------------------------
    ' An empty Pattern string, although it is allowed, it is ignored
    ' by the control and does not change the existing Thumbnailer.Pattern
    
    ' If only one Checkbox is left checked
    If (chk(0) + chk(1) + chk(2) + chk(3) + chk(4) + chk(5) + chk(6) + chk(7)) = 1 Then
        ' Loop all the checkboxes
        For i = 0 To 7
            ' Find the checked one
            If chk(i) = vbChecked Then
                ' Do not allow it to be unchecked, as the current Pattern
                ' for the Thumbnailer will not actually change, if the string is empty.
                chk(i).Enabled = False
            End If
        Next
    End If
    ' ----------------------------------------------------------

    ' Remove the initial ";" from the string
    If Len(sTmp) > 0 Then
        sTmp = Right$(sTmp, Len(sTmp) - 1)
    End If

    Thumbnailer1.Pattern = sTmp
    Thumbnailer1.Redraw

End Sub

' Set Selected item
Private Sub Command3_Click()

    If Not IsNumeric(txtSelect) Then Exit Sub
    
    ' The Thumbs collection contains a Null Item (index = -1)
    ' and it is 1 index base.
    ' So the amount of Thumbnails, is (Thumbnailer1.Thumbs.Count - 2)
    If CLng(txtSelect) > (Thumbnailer1.Thumbs.Count - 2) Then GoTo Out
    
    ' Select the item
    Thumbnailer1.SelectedItem = CLng(txtSelect)
    
Out:
    ' Show the Selected Item
    txtSelect = Thumbnailer1.SelectedItem

End Sub

' ShowHidden files
Private Sub Check2_Click()

    If Check2.Value = vbChecked Then
        Thumbnailer1.ShowHidden = True
        Else
        Thumbnailer1.ShowHidden = False
    End If
    
    ' Redraw
    Thumbnailer1.Redraw

End Sub

' ShowSystem files
Private Sub Check3_Click()

    If Check3.Value = vbChecked Then
        Thumbnailer1.ShowSystem = True
        Else
        Thumbnailer1.ShowSystem = False
    End If
    
    ' Redraw
    Thumbnailer1.Redraw

End Sub

' Tooltips (filenames)
Private Sub Check4_Click()

    If Check4.Value = vbChecked Then
        Thumbnailer1.Tooltips = True
        Else
        Thumbnailer1.Tooltips = False
    End If

End Sub

' Redraw
Private Sub Command1_Click()

    ' Redraw
    Thumbnailer1.Redraw

End Sub

' Events logging
Private Sub Text6_Change()

  On Error Resume Next
  
  Dim iLegth As Long

    iLegth = Len(Text6)
    
    ' Clear the Textbox if its text reaches 2000
    ' characters to avoid "Out of memory" errors
    If iLegth > 2000 Then Text6 = vbNullString
    
    ' Force the Text6 to show the last added line
    Text6.SelStart = iLegth

End Sub

' Show events
Private Sub Check5_Click()

    If Check5.Value = vbChecked Then
        Check6.Enabled = True
        Else
        Check6.Value = vbUnchecked
        Check6.Enabled = False
    End If

End Sub



























' ################## THUMBNAILER EVENTS ###################

Private Sub Thumbnailer1_MouseDownArea(Button As Integer, Shift As Integer)

    ' Log the event
    If Check5.Value = vbChecked Then
        Text6 = Text6 & "MouseDownArea " & Button & " , " & Shift & vbCrLf
    End If

End Sub

Private Sub Thumbnailer1_MouseUpArea(Button As Integer, Shift As Integer)

    ' Log the event
    If Check5.Value = vbChecked Then
        Text6 = Text6 & "MouseUpArea " & Button & " , " & Shift & vbCrLf
    End If

End Sub

Private Sub Thumbnailer1_ClickArea()

    ' Log the event
    If Check5.Value = vbChecked Then
        Text6 = Text6 & "ClickArea" & vbCrLf
    End If

End Sub

Private Sub Thumbnailer1_DblClickArea()

    ' Log the event
    If Check5.Value = vbChecked Then
        Text6 = Text6 & "DblClickArea" & vbCrLf
    End If

End Sub

Private Sub Thumbnailer1_MouseDownItem(Thumb As Thumbnail, Button As Integer, Shift As Integer)

    ' Log the event
    If Check5.Value = vbChecked Then
        Text6 = Text6 & "MouseDownItem " & Thumb.Index & " , " & Button & " , " & Shift & vbCrLf
    End If

End Sub

Private Sub Thumbnailer1_MouseUpItem(Thumb As Thumbnail, Button As Integer, Shift As Integer)

    ' Log the event
    If Check5.Value = vbChecked Then
        Text6 = Text6 & "MouseUpItem " & Thumb.Index & " , " & Button & " , " & Shift & vbCrLf
    End If

End Sub

Private Sub Thumbnailer1_ClickItem(Thumb As Thumbnail)

    ' Log the event
    If Check5.Value = vbChecked Then
        Text6 = Text6 & "ClickItem " & Thumb.Index & vbCrLf
    End If

End Sub

Private Sub Thumbnailer1_DblClickItem(Thumb As Thumbnail)

    ' Log the event
    If Check5.Value = vbChecked Then
        Text6 = Text6 & "DblClickItem " & Thumb.Index & vbCrLf
    End If

End Sub

Private Sub Thumbnailer1_PathChange(ByVal ItemsCount As Long)

    ' Log the event
    If Check5.Value = vbChecked Then
        Text6 = Text6 & "PathChange (" & ItemsCount & " items)" & vbCrLf
    End If
    
    ' If the directory contains no images, reset everything.
    If ItemsCount = 0 Then
        PBar.Value = 0
        Label2 = vbNullString
        Label10 = "0"
        Label12 = vbNullString
        Label14 = vbNullString
        Label16 = vbNullString
        Label18 = vbNullString
        Label20 = vbNullString
        Label22 = vbNullString
        Label24 = vbNullString
    End If

End Sub

Private Sub Thumbnailer1_PatternChange(ByVal ItemsCount As Long)

    ' Log the event
    If Check5.Value = vbChecked Then
        Text6 = Text6 & "PatternChange (" & ItemsCount & " items)" & vbCrLf
    End If
    
    ' If the directory contains no images, reset everything.
    If ItemsCount = 0 Then
        PBar.Value = 0
        Label2 = vbNullString
        Label10 = "0"
        Label12 = vbNullString
        Label14 = vbNullString
        Label16 = vbNullString
        Label18 = vbNullString
        Label20 = vbNullString
        Label22 = vbNullString
        Label24 = vbNullString
    End If

End Sub

' Sets the pBar
Private Sub Thumbnailer1_BeforeDraw(ByVal ItemsCount As Long)

    ' Log the event
    If Check5.Value = vbChecked Then
        Text6 = Text6 & "BeforeDraw (Items = " & ItemsCount & ")" & vbCrLf
    End If
    
    ' Set the ProgressBar
    ' -----------------------------------------------
    ' If the directory contains images
    If ItemsCount > 0 Then
        ' Set the ProgressBar max value,
        ' one more than the last file index.
        PBar.Max = ItemsCount
        ' Initialize its Value
        PBar.Value = 0
        ' Show the ProgressBar
        PBar.Visible = True
        ' If the directory does not contain images
        Else
        ' Hide the ProgressBar
        PBar.Visible = False
        ' Initialize its Value
        PBar.Value = 0
    End If
    ' -----------------------------------------------

    ' Show the amount of items in the path
    Label10 = ItemsCount

End Sub

Private Sub Thumbnailer1_ThumbnailAdded(ByVal Index As Long)

    ' Log the event
    If Check6.Value = vbChecked Then
        Text6 = Text6 & "ThumbnailAdded (Index = " & Index & ")" & vbCrLf
    End If
    
    ' Increase the Progress Bar as soon as a new thumbnail is added
    PBar.Value = Index + 1
    ' Reset it when finished
    If Index = PBar.Max - 1 Then PBar.Value = 0
    ' Show the amount of drawn thumbnails
    Label2 = Index + 1

End Sub

Private Sub Thumbnailer1_Interrupted()

    ' Log the event
    If Check5.Value = vbChecked Then
        Text6 = Text6 & "Interrupted" & vbCrLf
    End If

End Sub

' Sets the amount label and hides the pBar
Private Sub Thumbnailer1_AfterDraw(ByVal ItemsDrawn As Long)

    ' Log the event
    If Check5.Value = vbChecked Then
        Text6 = Text6 & "AfterDraw (ItemsDrawn = " & ItemsDrawn & ")" & vbCrLf
    End If
    
    ' Hide the ProgressBar
    PBar.Visible = False
    ' Initialize its Value
    PBar.Value = 0

End Sub

Private Sub Thumbnailer1_SelChanged(NewThumb As Thumbnail)

    ' Log the event
    If Check5.Value = vbChecked Then
        Text6 = Text6 & "SelChanged (Index = " & NewThumb.Index & ")" & vbCrLf
    End If

    With NewThumb
        ' Show the info for the thumbnail
        txtSelect = .Index
        Label24 = .Index
        Label12 = .FullPath
        Label14 = .Name
        Label16 = .ThumbLeft
        Label18 = .ThumbTop
        Label20 = .ThumbRight
        If Thumbnailer1.HasLabel Then
            Label22 = .LabelBottom
            Else
            Label22 = .ThumbBottom
        End If
    End With

End Sub

