VERSION 5.00
Object = "{FBFD55C6-C23C-11D3-B65D-004005E66149}#1.0#0"; "SWIFTPRINT.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmMain 
   Caption         =   "CdList"
   ClientHeight    =   5145
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   4560
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   5145
   ScaleWidth      =   4560
   StartUpPosition =   3  'Windows Default
   Begin VB.ListBox lstHidden 
      Height          =   450
      Left            =   2760
      TabIndex        =   8
      Top             =   4440
      Visible         =   0   'False
      Width           =   615
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   3840
      Top             =   4440
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.ListBox lstSort 
      Height          =   450
      Left            =   2040
      Sorted          =   -1  'True
      TabIndex        =   7
      Top             =   4440
      Visible         =   0   'False
      Width           =   615
   End
   Begin VB.ListBox lstTracks 
      Height          =   1980
      IntegralHeight  =   0   'False
      Left            =   120
      TabIndex        =   5
      Top             =   1800
      Width           =   4335
   End
   Begin VB.ComboBox cboTitle 
      Height          =   315
      Left            =   600
      Sorted          =   -1  'True
      Style           =   2  'Dropdown List
      TabIndex        =   3
      Top             =   1080
      Width           =   3855
   End
   Begin VB.ComboBox cboArtist 
      Height          =   315
      Left            =   600
      Sorted          =   -1  'True
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   600
      Width           =   3855
   End
   Begin MSComctlLib.ImageList ImageList1 
      Left            =   120
      Top             =   4440
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   15
      MaskColor       =   12632256
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   4
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0442
            Key             =   ""
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0986
            Key             =   ""
         EndProperty
         BeginProperty ListImage3 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0ECA
            Key             =   ""
         EndProperty
         BeginProperty ListImage4 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":140E
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin MSComctlLib.Toolbar Toolbar1 
      Align           =   1  'Align Top
      Height          =   405
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   4560
      _ExtentX        =   8043
      _ExtentY        =   714
      ButtonWidth     =   609
      ButtonHeight    =   556
      Appearance      =   1
      ImageList       =   "ImageList1"
      _Version        =   393216
      BeginProperty Buttons {66833FE8-8583-11D1-B16A-00C0F0283628} 
         NumButtons      =   7
         BeginProperty Button1 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button2 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Description     =   "Open another cdplayer.ini file"
            Object.ToolTipText     =   "Open"
            ImageIndex      =   1
         EndProperty
         BeginProperty Button3 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button4 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Description     =   "Preview the CD list"
            Object.ToolTipText     =   "Preview"
            ImageIndex      =   2
         EndProperty
         BeginProperty Button5 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Description     =   "Print the CD list"
            Object.ToolTipText     =   "Print"
            ImageIndex      =   3
         EndProperty
         BeginProperty Button6 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button7 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Description     =   "About CdList..."
            Object.ToolTipText     =   "About"
            ImageIndex      =   4
         EndProperty
      EndProperty
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Track List:"
      Height          =   195
      Left            =   120
      TabIndex        =   6
      Top             =   1560
      Width           =   750
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Title:"
      Height          =   195
      Left            =   120
      TabIndex        =   4
      Top             =   1140
      Width           =   345
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Artist:"
      Height          =   195
      Left            =   120
      TabIndex        =   2
      Top             =   660
      Width           =   390
   End
   Begin SwiftPrintLib.SwiftPrint spDoc 
      Left            =   840
      Top             =   4440
      _Version        =   65536
      _ExtentX        =   1931
      _ExtentY        =   873
      _StockProps     =   0
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileOpen 
         Caption         =   "&Open"
      End
      Begin VB.Menu s3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFilePrintSetup 
         Caption         =   "Print &Setup..."
      End
      Begin VB.Menu mnuFilePreview 
         Caption         =   "P&review..."
      End
      Begin VB.Menu mnuFilePrint 
         Caption         =   "&Print..."
      End
      Begin VB.Menu s2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About..."
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim m_rgAlbums() As Album
Dim m_strFile As String

Const PrintNoPreview As Integer = 0
Const PrintPreview As Integer = 1
Const PrintDirect As Integer = 2

Const nGapBeforeItem As Long = 25
Const nGapAfterTitle As Long = 10
Const nColumns As Integer = 4

Const nSizeBold As Long = 100
Const nSizeNormal As Long = 80

Dim g_left As Long, g_top As Long, g_right As Long, g_bottom As Long, g_center As Long
Dim g_nBoldHeight As Long, g_nNormalHeight As Long
Dim g_rgCol(2 * nColumns - 1) As Long

Private Sub Form_Load()
    On Error GoTo errHandler
    
    'initialise SwiftPrint
    spDoc.DocBegin
    spDoc.WindowOwner = Me.hWnd
    
    'load the data file
    Dim strFile As String, lLen As Long
    strFile = Space(256)
    lLen = GetWindowsDirectory(strFile, 256)
    strFile = left(strFile, lLen)
    strFile = strFile & "\cdplayer.ini"
    LoadData strFile
    
    Exit Sub
    
errHandler:
    Select Case Err.Number
    Case SP_E_NOPRINTER
        MsgBox "No printer is installed.  Please install a printer."
    Case Else
        MsgBox "Error occurred: " & Err.Description
    End Select
    End
End Sub

Private Sub Form_Resize()
    'resize the elements of the form, enforce a minimum height and width
    
    ' width
    If Me.Width > cboArtist.left + 2250 Then
        cboArtist.Width = Me.Width - cboArtist.left - 250
        cboTitle.Width = Me.Width - cboTitle.left - 250
        lstTracks.Width = Me.Width - lstTracks.left - 250
    Else
        Me.Width = cboArtist.left + 2250
    End If
    
    'height
    If Me.Height > lstTracks.top + 1850 Then
        lstTracks.Height = Me.Height - lstTracks.top - 850
    Else
        Me.Height = lstTracks.top + 1850
    End If
End Sub

Private Sub LoadData(strFile As String)
    On Error GoTo errHandler
    
    'ensure that the file exists
    If Dir(strFile) = "" Then
        Err.Raise vbObjectError, "", "Unable to load data from " & strFile
    End If
    
    'clear out the current data
    m_strFile = LCase(strFile)
    cboArtist.Clear
    cboTitle.Clear
    lstTracks.Clear
    
    'get all of the section names from the file, we don't know how big the
    'buffer will need to be to get all of these strings, so we dynamically
    'grow it until we have a buffer large enough or we can't be bothered
    Dim lSize As Long, lIniSize As Long
    Dim strSectionNames As String
    lSize = 512
    Do
        lSize = lSize * 2
        strSectionNames = Space(lSize)
        lIniSize = GetIniSectionNames(strSectionNames, lSize, m_strFile)
    Loop Until lIniSize <> lSize - 2 Or lSize > 32000
    strSectionNames = left(strSectionNames, lIniSize)
    
    'the section names are returned in a string with nulls separating each
    'name, and a double null at the end of the string.  We want to parse this
    'string and create our internal structure mapping artist/title to a
    'section within the file
    Dim nIdx As Long, strSection As String, strArtist As String, strTitle As String
    Dim nArrayMax As Long, nArrayIdx As Long, nLen As Long
    nArrayMax = 0
    nArrayIdx = nArrayMax - 1
    nIdx = 1
    Do While nIdx < Len(strSectionNames) And Mid(strSectionNames, nIdx, 1) <> Chr$(0)
        'grow the size of the array if necessary, we do this in blocks to avoid
        'fragmenting memory and minimize the number of reallocations
        If nArrayIdx = nArrayMax - 1 Then
            nArrayMax = nArrayMax + 10
            ReDim Preserve m_rgAlbums(nArrayMax)
        End If
        
        'get the section name
        strSection = Mid(strSectionNames, nIdx, InStr(nIdx, strSectionNames, Chr$(0)) - nIdx)
        nIdx = nIdx + Len(strSection) + 1
        
        'get the artist and title from this section
        strArtist = Space(256)
        nLen = GetIniString(strSection, "artist", "", strArtist, 256, m_strFile)
        strArtist = left(strArtist, nLen)
        
        strTitle = Space(256)
        nLen = GetIniString(strSection, "title", "", strTitle, 256, m_strFile)
        strTitle = left(strTitle, nLen)
        
        'store this section name into the array
        If Len(strArtist) > 0 And Len(strTitle) > 0 Then
            nArrayIdx = nArrayIdx + 1
            With m_rgAlbums(nArrayIdx)
                .strSection = strSection
                .strArtist = strArtist
                .strTitle = strTitle
            End With
        End If
    Loop
    
    'resize our array to have only the correct number of items as it actually stores
    If nArrayIdx >= 0 Then
        ReDim Preserve m_rgAlbums(nArrayIdx)
    End If
    
    'we need to sort this array on artist and then title to ensure that
    'we can access the data quickly and we don't insert duplicate artist/titles
    'into the lists
    SortAlbums
    
    'fill the artist combo box with unique entries from the list
    Dim strLastArtist As String
    For nArrayIdx = 0 To UBound(m_rgAlbums)
        If m_rgAlbums(nArrayIdx).strArtist <> strLastArtist Then
            strLastArtist = m_rgAlbums(nArrayIdx).strArtist
            cboArtist.AddItem strLastArtist
        End If
    Next
    
    'select the first artist, this will throw some events which will fill out the
    'rest of the data on the main screen
    cboArtist.ListIndex = 0
    
    'set our caption on success to show the file we've loaded
    Me.Caption = m_strFile & " - CdList"
    spDoc.WindowTitle = Me.Caption
    
    Exit Sub
errHandler:
    Me.Caption = "CdList"
    spDoc.WindowTitle = Me.Caption
    MsgBox Err.Description
    Resume Next
End Sub

Private Sub SortAlbums()
    Dim nIdx As Long, strItem As String
    
    'we use the invisible listbox lstSort to do the sorting for us
    lstSort.Clear
    For nIdx = 0 To UBound(m_rgAlbums)
        strItem = m_rgAlbums(nIdx).strArtist & Chr$(1) & m_rgAlbums(nIdx).strTitle & Chr$(1) & m_rgAlbums(nIdx).strSection
        lstSort.AddItem strItem
    Next
    
    'blow away the section array now
    ReDim m_rgAlbums(lstSort.ListCount - 1)
    
    'add these items back into the array
    Dim nTitleIdx As Long, nSectionIdx As Long
    Dim strLastArtistTitle As String, nLastCount As Long
    For nIdx = 0 To lstSort.ListCount - 1
        'get the indexes of the separate fields
        strItem = lstSort.List(nIdx)
        nTitleIdx = InStr(strItem, Chr$(1))
        nSectionIdx = InStr(nTitleIdx + 1, strItem, Chr$(1))
        
        'ensure that we always have unique names for combination of artist/title
        If left(strItem, nSectionIdx) = strLastArtistTitle Then
            nLastCount = nLastCount + 1
        Else
            nLastCount = 1
        End If
        strLastArtistTitle = left(strItem, nSectionIdx)
         
        'add this item to the array
        With m_rgAlbums(nIdx)
            .strArtist = left(strItem, nTitleIdx - 1)
            If nLastCount = 1 Then
                .strTitle = Mid(strItem, nTitleIdx + 1, nSectionIdx - nTitleIdx - 1)
            Else
                .strTitle = Mid(strItem, nTitleIdx + 1, nSectionIdx - nTitleIdx - 1) & " (" & nLastCount & ")"
            End If
            .strSection = Mid(strItem, nSectionIdx + 1)
        End With
    Next
End Sub

Private Sub cboArtist_Click()
    Dim nIdx As Long, strArtist As String
    
    'when an artist is selected we fill out the title combobox
    'with all of the albums that this artist has
    cboTitle.Clear
    strArtist = cboArtist.List(cboArtist.ListIndex)
    For nIdx = 0 To UBound(m_rgAlbums)
        If m_rgAlbums(nIdx).strArtist = strArtist Then
            cboTitle.AddItem m_rgAlbums(nIdx).strTitle
        ElseIf m_rgAlbums(nIdx).strArtist > strArtist Then
            'we have added all of this artists albums
            Exit For
        End If
    Next
    cboTitle.ListIndex = 0
End Sub

Private Sub cboTitle_Click()
    Dim nIdx As Long, strArtist As String, strTitle As String, strTrack As String
    Dim strSection As String, nLen As Long, strKey As String, strDefault As String

    'when a title is selected we fill out the tracks listbox
    'with all of the tracks that this album has
    strArtist = cboArtist.List(cboArtist.ListIndex)
    strTitle = cboTitle.List(cboTitle.ListIndex)
    
    'find the section that this artist/title is in
    For nIdx = 0 To UBound(m_rgAlbums)
        If m_rgAlbums(nIdx).strArtist = strArtist And m_rgAlbums(nIdx).strTitle = strTitle Then
            strSection = m_rgAlbums(nIdx).strSection
            Exit For
        End If
    Next
    
    'if we haven't found the section we have a problem houston
    If strSection = "" Then
        MsgBox "Couldn't load tracks for this artist/title"
        Exit Sub
    End If
    
    'load the tracks for this artist/title
    LoadTracks strSection, lstTracks
End Sub

Private Sub LoadTracks(strSection As String, lst As ListBox)
    Dim nIdx As Long, strTrack As String, strKey As String, nLen As Long
    
    lst.Clear
    nIdx = 0
    Do
        strTrack = Space(256)
        strKey = CStr(nIdx)
        nLen = GetIniString(strSection, strKey, "", strTrack, 256, m_strFile)
        If nLen > 0 Then
            strTrack = left(strTrack, nLen)
            lst.AddItem nIdx + 1 & " - " & strTrack
        End If
        nIdx = nIdx + 1
    Loop While nLen > 0
End Sub

Private Sub mnuFileExit_Click()
    End
End Sub

Private Sub mnuFileOpen_Click()
    On Error GoTo errHandler
    
    'open the cdplayer.ini file from another location
    CommonDialog1.CancelError = True
    CommonDialog1.Flags = cdlOFNHideReadOnly + cdlOFNFileMustExist + cdlOFNLongNames
    CommonDialog1.Filter = "cdplayer.ini|cdplayer.ini"
    CommonDialog1.FilterIndex = 1
    
    'show the open box and load the data if a file has been selected
    CommonDialog1.ShowOpen
    LoadData CommonDialog1.FileName
    Exit Sub
    
errHandler:
    'User pressed the Cancel button
    Exit Sub
End Sub

Private Sub mnuFilePreview_Click()
    PrintData PrintPreview
End Sub

Private Sub mnuFilePrint_Click()
    PrintData PrintNoPreview
End Sub

Private Sub mnuFilePrintSetup_Click()
    spDoc.DoPrintSetup
End Sub

Private Sub mnuHelpAbout_Click()
    MsgBox _
        "CdList - Lists the artists, titles and tracks for all albums in " & _
        "your cdplayer.ini file" + vbCrLf + _
        "Report writing sample for SwiftPrint (c) Brodie Thiesfield, 1999 - 2000"
End Sub

Private Sub Toolbar1_ButtonClick(ByVal Button As MSComctlLib.Button)
    Select Case LCase(Button.ToolTipText)
    Case "open"
        mnuFileOpen_Click
    Case "print"
        PrintData PrintDirect
    Case "preview"
        mnuFilePreview_Click
    Case "about"
        mnuHelpAbout_Click
    End Select
End Sub

Private Sub spDoc_StateChange(ByVal NewState As Long)
    'it is also necessary to handle the state change event, the code provided
    'here will probably be all that you require, hiding and disabling this
    'application at the most appropriate times
    Select Case NewState
    Case SP_IDLE
        Me.Enabled = True
        Me.Visible = True
        Me.ZOrder
        Me.SetFocus
    Case SP_PRINTPREVIEW
        Me.Enabled = False
        Me.Visible = False
    Case SP_PRINTSETUP, SP_PRINT, SP_PRINTING
        Me.Enabled = False
        Me.Visible = True
    End Select
End Sub

Private Sub PrintData(nPrintStyle As Integer)
    'find out what they want to print
    frmPrint.Show vbModal, Me
    If frmPrint.m_bCancelled Then
        Exit Sub
    End If
    
    'clear the document out in preparation for a new one
    spDoc.DocBegin
    spDoc.Units = SPUN_LOMETRIC
    
    'determine what sort of printing to do
    If frmPrint.optAll = True Then
        PrintAllItems
    ElseIf frmPrint.optAllTitleOnly = True Then
        PrintAllNoDetail
    Else
        PrintSingleItem
    End If
    
    'do the printing
    Select Case nPrintStyle
    Case PrintNoPreview
        spDoc.DoPrint
    Case PrintPreview
        spDoc.DoPrintPreview
    Case PrintDirect
        spDoc.DoPrintDirect
    End Select
End Sub

Private Sub PrintAllItems()
    Dim bFirstOnPage As Boolean, nIdx As Long
    
    'progress
    Load frmProgress
    frmProgress.progress.Min = 0
    frmProgress.progress.Value = frmProgress.progress.Min
    frmProgress.progress.Max = UBound(m_rgAlbums)
    frmProgress.Show 0, Me
    
    'ensure that both forms are refreshed and visible
    DoEvents
    Me.Refresh
    frmProgress.Refresh
    
    'first item on the page
    PrintPageOutline
    bFirstOnPage = True
    
    nIdx = 0
    Do While nIdx <= UBound(m_rgAlbums)
        frmProgress.progress.Value = nIdx
        LoadTracks m_rgAlbums(nIdx).strSection, lstHidden
        If Not PrintItem(bFirstOnPage, CStr(nIdx + 1) & ":  " & m_rgAlbums(nIdx).strArtist, m_rgAlbums(nIdx).strTitle, lstHidden) Then
            spDoc.Page = spDoc.Page + 1
            bFirstOnPage = True
            PrintPageOutline
        Else
            nIdx = nIdx + 1
            bFirstOnPage = False
        End If
    Loop
    
    'write the page numbers now we know the total number of pages
    For nIdx = 1 To spDoc.NumPages
        spDoc.Page = nIdx
        PrintPageNumber
    Next
    
    'hide the progess bar
    frmProgress.progress.Value = frmProgress.progress.Max
    frmProgress.Hide
End Sub

Private Sub PrintAllNoDetail()
    Dim nIdx As Long, strText As String
    
    'progress
    Load frmProgress
    frmProgress.progress.Min = 0
    frmProgress.progress.Value = frmProgress.progress.Min
    frmProgress.progress.Max = UBound(m_rgAlbums)
    frmProgress.Show 0, Me
    
    'ensure that both forms are refreshed and visible
    DoEvents
    Me.Refresh
    frmProgress.Refresh
    
    'prepare for output
    PrintPageOutline
    spDoc.SetFont "Arial", nSizeBold, SPFS_POINTS, 0
    spDoc.TextAlign = SPTA_TOP + SPTA_LEFT + SPTA_NOUPDATECP
    
    nIdx = 0
    Do While nIdx < UBound(m_rgAlbums)
        frmProgress.progress.Value = nIdx
        
        'output a new page if this item won't fit on the current page
        If spDoc.y + g_nNormalHeight > g_bottom Then
            spDoc.Page = spDoc.Page + 1
            PrintPageOutline
            spDoc.SetFont "Arial", nSizeBold, SPFS_POINTS, 0
            spDoc.TextAlign = SPTA_TOP + SPTA_LEFT + SPTA_NOUPDATECP
        End If
        
        'draw the artist and title
        strText = CStr(nIdx + 1) & ":  " & m_rgAlbums(nIdx).strArtist & "  -  " & m_rgAlbums(nIdx).strTitle
        spDoc.TextOutClip g_left, spDoc.y, strText, g_left, spDoc.y, g_right, spDoc.y + g_nBoldHeight
        spDoc.y = spDoc.y + (1.1 * g_nBoldHeight)
        
        nIdx = nIdx + 1
    Loop
    
    'write the page numbers now we know the total number of pages
    For nIdx = 1 To spDoc.NumPages
        spDoc.Page = nIdx
        PrintPageNumber
    Next
    
    'hide the progess bar
    frmProgress.progress.Value = frmProgress.progress.Max
    frmProgress.Hide
End Sub

Private Sub PrintSingleItem()
    'progress
    Load frmProgress
    frmProgress.progress.Min = 0
    frmProgress.progress.Value = frmProgress.progress.Min
    frmProgress.progress.Max = 1
    frmProgress.Show 0, Me
    
    'ensure that both forms are refreshed and visible
    DoEvents
    Me.Refresh
    frmProgress.Refresh
    
    'print this item
    PrintPageOutline
    PrintPageNumber
    PrintItem True, cboArtist.List(cboArtist.ListIndex), cboTitle.List(cboTitle.ListIndex), lstTracks
    
    'hide the progess bar
    frmProgress.progress.Value = frmProgress.progress.Max
    frmProgress.Hide
End Sub

Private Sub PrintPageNumber()
    Dim left As Long, right As Long, top As Long, bottom As Long
    
    'get the printable space on the page, then set the margins to 10mm or
    'the printable area whichever is greatest
    spDoc.GetPrintableArea left, top, right, bottom
    left = Max(left, 60)
    top = Max(top, 60)
    right = Min(right - 30, spDoc.PageWidth - 60)
    bottom = Min(bottom, spDoc.PageHeight - 60)

    spDoc.SetFont "Arial", 80, SPFS_POINTS, 0
    spDoc.TextAlign = SPTA_RIGHT + SPTA_TOP + SPTA_NOUPDATECP
    spDoc.TextOut right - 10, top + 10, "Page " & spDoc.Page & " of " & spDoc.NumPages
End Sub

Private Sub PrintPageOutline()
    Dim nWidth As Long
    
    'get the font heights, height is always the same regardless of text so just use "abc"
    spDoc.SetPen SPPN_SOLID, 2, RGB(0, 0, 0)
    spDoc.SetFont "Arial", nSizeBold, SPFS_POINTS + SPFO_BOLD, 0
    spDoc.GetTextExtent "abc", nWidth, g_nBoldHeight
    spDoc.SetFont "Arial", nSizeNormal, SPFS_POINTS, 0
    spDoc.GetTextExtent "abc", nWidth, g_nNormalHeight
    
    'get the printable space on the page, then set the margins to 10mm or
    'the printable area whichever is greatest
    spDoc.GetPrintableArea g_left, g_top, g_right, g_bottom
    g_left = Max(g_left, 60)
    g_top = Max(g_top, 60)
    g_right = Min(g_right - 30, spDoc.PageWidth - 60)
    g_bottom = Min(g_bottom, spDoc.PageHeight - 60)
    g_center = g_left + ((g_right - g_left) / 2)

    'calculate the columns, we draw the columns such that for n columns of width x we have
    'column gutters of x / (n+1), and so the page width is made up of n*x + (n+1)*x/(n+1)
    'or (n+1)*x.  So solving for the column width, we have page width / (n+1) = x
    Dim dColumnWidth As Double, dGutterWidth As Double, nIdx As Long
    dColumnWidth = (g_right - g_left) / (nColumns + 1)
    dGutterWidth = dColumnWidth / (nColumns + 1)
    For nIdx = 0 To 2 * nColumns - 1
        g_rgCol(nIdx) = g_left + ((Fix(nIdx / 2) + 1) * dGutterWidth) + (Fix((nIdx + 1) / 2) * dColumnWidth)
    Next
    
    spDoc.BackMode = SPBM_TRANSPARENT
    spDoc.SetBrush SPBR_NULL, 0
    spDoc.SetPen SPPN_SOLID, 4, RGB(0, 0, 0)
    
    'we have a rectangle around the page
    spDoc.Rectangle g_left, g_top, g_right, g_bottom
    spDoc.y = g_top
    
    'output the main title
    Dim nHeight As Long, nSize As Long, strText As String
    nWidth = g_right
    nSize = 100
    strText = "CD Lister"
    Do While nWidth > (g_right - g_left) / 2
        nSize = nSize - 10
        spDoc.SetFont "Arial", nSize, SPFS_UNITS, 0
        spDoc.GetTextExtent strText, nWidth, nHeight
    Loop
    spDoc.TextAlign = SPTA_CENTER + SPTA_TOP + SPTA_NOUPDATECP
    spDoc.TextOut g_center, g_top, strText
    spDoc.y = spDoc.y + nHeight
    
    'draw a line separating the header from the main page
    spDoc.LineEx g_left, spDoc.y, g_right, spDoc.y
    spDoc.y = spDoc.y + 20
    
    'we update the top of the page to be this value
    g_top = spDoc.y
    
    'draw the vertical copyright statement
    strText = "SwiftPrint, copyright (C) 1999 - 2000, Brodie Thiesfield"
    spDoc.SetFont "Arial", 65, SPFS_POINTS, 900
    spDoc.ForeColor = RGB(0, 0, 0)
    spDoc.TextAlign = SPTA_BOTTOM + SPTA_RIGHT + SPTA_NOUPDATECP
    spDoc.TextOut g_right, g_bottom, strText
    
    'move the margins of the page in 5mm each size
    g_left = g_left + 50
    g_right = g_right - 50
    g_top = g_top + 50
    g_bottom = g_bottom - 50
End Sub

Private Function PrintItem(bFirstOnPage As Boolean, strArtist As String, strTitle As String, lst As ListBox) As Boolean
    On Error GoTo errHandler

    'determine the actual height of this item
    Dim nHeight As Long
    nHeight = nGapBeforeItem + g_nBoldHeight + nGapAfterTitle
    If (lst.ListCount Mod nColumns) > 0 Then
        nHeight = nHeight + g_nNormalHeight * (Fix(lst.ListCount / nColumns) + 1)
    Else
        nHeight = nHeight + g_nNormalHeight * Fix(lst.ListCount / nColumns)
    End If
    
    'we now have to decide whether this will fit on the page.  It won't fit if this isn't
    'the first on the page (first on page will always fit otherwise we would get into an
    'infinite loop of trying to fit the item onto a page when every page is the same size)
    'and the current position plus the height of this item will go past the bottom of the
    'page
    PrintItem = True
    If Not bFirstOnPage And spDoc.y + nHeight > g_bottom Then
        PrintItem = False
        Exit Function
    End If
    
    'add the space from the item before
    Dim nBuffer As Long
    nBuffer = (g_right - g_left) / 6
    If Not bFirstOnPage Then
        spDoc.SetPen SPPN_SOLID, 0, RGB(0, 0, 0)
        spDoc.LineEx g_left + nBuffer, spDoc.y + nGapBeforeItem / 2, g_right - nBuffer, spDoc.y + nGapBeforeItem / 2
    End If
    spDoc.y = spDoc.y + nGapBeforeItem
    
    'title
    Dim strText As String
    strText = strArtist & "  -  " & strTitle
    spDoc.SetFont "Arial", nSizeBold, SPFS_POINTS + SPFO_BOLD, 0
    spDoc.TextAlign = SPTA_TOP + SPTA_LEFT + SPTA_NOUPDATECP
    spDoc.TextOutClip g_left, spDoc.y, strText, g_left, spDoc.y, g_right, spDoc.y + g_nBoldHeight
    spDoc.y = spDoc.y + g_nBoldHeight + nGapAfterTitle
    
    'tracks
    Dim nRows As Long, nRowIdx As Long, nColIdx As Long, nSong As Long
    spDoc.SetFont "Arial", nSizeNormal, SPFS_POINTS, 0
    nRows = Fix(lst.ListCount / nColumns) + IIf(lst.ListCount Mod nColumns = 0, 0, 1)
    For nRowIdx = 0 To nRows - 1
        For nColIdx = 0 To nColumns - 1
            nSong = nRows * nColIdx + nRowIdx
            If nSong < lst.ListCount Then
                spDoc.TextOutClip g_rgCol(2 * nColIdx), spDoc.y, lst.List(nSong), _
                    g_rgCol(2 * nColIdx), spDoc.y, g_rgCol(2 * nColIdx + 1), spDoc.y + g_nNormalHeight
            End If
        Next
        spDoc.y = spDoc.y + g_nNormalHeight
    Next
    spDoc.y = spDoc.y + g_nNormalHeight
    
    Exit Function
errHandler:
    MsgBox Err.Description
End Function

Private Function Max(ByVal l1 As Long, ByVal l2 As Long) As Long
    Max = IIf(l1 > l2, l1, l2)
End Function

Private Function Min(ByVal l1 As Long, ByVal l2 As Long) As Long
    Min = IIf(l1 < l2, l1, l2)
End Function

