Attribute VB_Name = "basUCalTest"
'basUCalTest is a module in the UCalTest project, which
'demonstrates the functionality of the Universal Calendar
'ActiveX Control.
'Copyright(c)1999 David Breedlove All Rights Reserved

Option Explicit

'You can set this boolean to TRUE if you want
'Options and Holidays saved to the Windows Registry
'instead of to <App.Path>\<App.Name>.ini
Dim gbUseRegistry As Boolean

'udt saves window state of frmOpt, frmRTF, and frmStats
Public Type udtWinState
    TOP As Integer
    LEFT As Integer
    HEIGHT As Integer
    WIDTH As Integer
    End Type
Global gwsOpt As udtWinState
Global gwsRtf As udtWinState
Global gwsStats As udtWinState

'constants for Calendar-Type (CTYP)
Public Const ciDEF_CTYP As Integer = 1
Public Const ciMIN_CTYP As Integer = 1
Public Const ciMAX_CTYP As Integer = 2
'   1 = Regular (Default)
'   2 = Fiscal

'constants for First-Day-of-Week (FDOW)
Public Const ciDEF_FDOW As Integer = 1
Public Const ciMIN_FDOW As Integer = 1
Public Const ciMAX_FDOW As Integer = 7
'   1 = Sunday (Default)
'   2 = Monday, ...
'   7 = Saturday

'canstants for First-Month-of-Year (FMOY)
Public Const ciDEF_FMOY As Integer = 1
Public Const ciMIN_FMOY As Integer = 1
Public Const ciMAX_FMOY As Integer = 12
'   1=January ... 12=December ?

'constants for Length-of-Fiscal-Months (LOFM) .. both have 371-day years
'              (applies ONLY to CTYP=2 .. fiscal year
Public Const ciDEF_LOFM As Integer = 1
Public Const ciMIN_LOFM As Integer = 1
Public Const ciMAX_LOFM As Integer = 2
'   1 = 4-4-5 (Default)
'   2 = 13x4

'constants for First-Week-In-Year
Public Const ciDEF_FWIY As Integer = 1
Public Const ciMIN_FWIY As Integer = 1
Public Const ciMAX_FWIY As Integer = 7
'First-Week-In-Year = # of 'yyyy' days in week to make that the
'     first-week-in-the-year
'ex: if FWIY>n and 1-1-yyyy is on nth--day-of-week, then year starts
'     with the following week
'    if FWIY=1, then 1-1-yyyy can fall on ANY day-of-the-week and
'     the year will start with that week
'    if FWIY=7, then first FULL 'yyyy' week becomes first-in-year

Public Declare Function GetPrivateProfileString Lib "kernel32" _
                                            Alias "GetPrivateProfileStringA" ( _
                                            ByVal lpApplicationName As String, _
                                            ByVal lpKeyName As Any, _
                                            ByVal lpDefault As String, _
                                            ByVal lpReturnedString As String, _
                                            ByVal nSize As Long, _
                                            ByVal lpFileName As String) As Long
Public Declare Function WritePrivateProfileString Lib "kernel32" _
                                            Alias "WritePrivateProfileStringA" ( _
                                            ByVal lpApplicationName As String, _
                                            ByVal lpKeyName As Any, _
                                            ByVal lpString As Any, _
                                            ByVal lpFileName As String) As Long

'These subroutines (LoadOptions and SaveOptions) are called to load/save options
' from/to ...
'   The Windows Registry IF gbUseRegistry is TRUE, OTHERWISE
'   <App.EXEName>.ini file in the application directory.
'You will need code like this only if Options changes are to be made AT RUNTIME.
'Otherwise you can just set Options in the Properties Window at Design Time.
'Note: To disable runtime changes to Options, be sure to set Property ContextMenu FALSE

Public Sub LoadOptions()
    Dim x As Long, lSize As Long, sHolidays As String
    Dim sOptions As String, iValue As Integer
    Dim sApp As String, sKey As String, sDefault As String, sFileName As String
    With frmCtl.UCalCtl1
        If gbUseRegistry Then
            sOptions = GetSetting("Universal Calendar", App.EXEName, "Options", "00 00 00 00 00 00 00")
            .Holidays = GetSetting("Universal Calendar", App.EXEName, "Holidays", "17|")
        Else
            sApp = App.EXEName
            sKey = "Options"
            sDefault = "00 00 00 00 00 00 00"
            lSize = 24
            sOptions = Space(lSize)
            sFileName = App.Path & "\" & App.EXEName & ".ini"
            x = GetPrivateProfileString(sApp, sKey, sDefault, sOptions, lSize, sFileName)
            sOptions = Trim(sOptions)
            sKey = "Holidays"
            sDefault = "17|"
            lSize = 16384
            sHolidays = Space(lSize)
            x = GetPrivateProfileString(sApp, sKey, sDefault, sHolidays, lSize, sFileName)
            .Holidays = Trim(sHolidays)
        End If
        iValue = Val(Mid(sOptions, 1, 1))
        .CalendarType = IIf(iValue < ciMIN_CTYP Or iValue > ciMAX_CTYP, ciDEF_CTYP, iValue)
        iValue = Val(Mid(sOptions, 2, 2))
        .FirstDayOfWeek = IIf(iValue < ciMIN_FDOW Or iValue > ciMAX_FDOW, ciDEF_FDOW, iValue)
        iValue = Val(Mid(sOptions, 4, 2))
        .FirstMonthOfYear = IIf(iValue < ciMIN_FDOW Or iValue > ciMAX_FDOW, ciDEF_FDOW, iValue)
        iValue = Val(Mid(sOptions, 7, 1))
        .LengthOfFiscalMonth = IIf(iValue < ciMIN_LOFM Or iValue > ciMAX_LOFM, ciDEF_LOFM, iValue)
        iValue = Val(Mid(sOptions, 8, 1))
        .FirstWeekInYear = IIf(iValue < ciMIN_FWIY Or iValue > ciMAX_FWIY, ciDEF_FWIY, iValue)
        iValue = Val(Mid(sOptions, 10, 2))
        .MonthRange = IIf(iValue < 1 Or iValue > 99, 4, iValue)
        iValue = Val(Mid(sOptions, 13, 2))
        .YearSpan = IIf(iValue < 1 Or iValue > 99, 12, iValue)
        iValue = Val(Mid(sOptions, 16, 1))
        .ShowDateStatistics = IIf(iValue < 0 Or iValue > 1, 0, iValue)
        iValue = Val(Mid(sOptions, 17, 1))
        .SkipToSameDayNumber = IIf(iValue < 0 Or iValue > 1, 0, iValue)
        iValue = Val(Mid(sOptions, 19, 1))
        .ContextMenu = IIf(iValue < 1 Or iValue > 4, 1, iValue)
        iValue = Val(Mid(sOptions, 20, 1))
        .HiliteHolidays = IIf(iValue < 0 Or iValue > 1, 0, iValue)
    End With
End Sub

Public Sub SaveOptions()
    Dim x As Long, sOptions As String
    With frmOpt
        sOptions = Format(.cboOptions(0).ItemData(.cboOptions(0).ListIndex), "0") & _
                   Format(.cboOptions(1).ItemData(.cboOptions(1).ListIndex), "0") & " " & _
                   Format(.cboOptions(2).ItemData(.cboOptions(2).ListIndex), "00") & " " & _
                   Format(.cboOptions(3).ItemData(.cboOptions(3).ListIndex), "0") & _
                   Format(.cboOptions(4).ItemData(.cboOptions(4).ListIndex), "0") & " " & _
                   Format(Abs(Val(.txtMonthRange.Text)), "00") & " " & _
                   Format(Abs(Val(.txtYearSpan.Text)), "00") & " " & _
                   Format(IIf(.chkStats.Value = 0, 0, 1), "0") & _
                   Format(IIf(.chkSkip.Value = 0, 0, 1), "0") & " " & _
                   Format(.cboOptions(5).ItemData(.cboOptions(5).ListIndex), "0") & _
                   Format(IIf(.chkHilite.Value = 0, 0, 1), "0")
        If gbUseRegistry Then
            SaveSetting "Universal Calendar", App.EXEName, "Options", sOptions
            SaveSetting "Universal Calendar", App.EXEName, "Holidays", .txtHolidays.Text
        Else
            x = WritePrivateProfileString(App.EXEName, "Options", sOptions, App.Path & "\" & App.EXEName & ".ini")
            x = WritePrivateProfileString(App.EXEName, "Holidays", .txtHolidays.Text, App.Path & "\" & App.EXEName & ".ini")
        End If
    End With
End Sub

Public Sub RefreshOptions()
    With frmCtl.UCalCtl1
        frmOpt.cboOptions(0).ListIndex = .CalendarType - 1
        frmOpt.cboOptions(1).ListIndex = .FirstDayOfWeek - 1
        frmOpt.cboOptions(2).ListIndex = .FirstMonthOfYear - 1
        frmOpt.cboOptions(3).ListIndex = .LengthOfFiscalMonth - 1
        frmOpt.cboOptions(4).ListIndex = .FirstWeekInYear - 1
        frmOpt.cboOptions(5).ListIndex = .ContextMenu - 1
        frmOpt.chkStats.Value = IIf(.ShowDateStatistics, 1, 0)
        frmOpt.chkSkip.Value = IIf(.SkipToSameDayNumber, 1, 0)
        frmOpt.txtYearSpan.Text = CStr(.YearSpan)
        frmOpt.txtMonthRange.Text = CStr(.MonthRange)
        frmOpt.chkHilite = IIf(.HiliteHolidays, 1, 0)
        frmOpt.txtHolidays.Text = .Holidays
    End With
End Sub
