/***********************************************************
*
*
*  Author(s):       Kevin J. Brock
*                   Symbolic Systems Resources Group
*		    Knowledge Systems Laboratory
*		    Departments of Computer Science and Medicine
*		    Stanford University
*		    Stanford, CA 94305
*                   brock@sumex-aim.stanford.edu
*
*  Copyright () 1991 by the Leland Stanford Junior University
*  
*  "This program may be distributed without restriction for non-commercial
*  use. Any sale or use of this program or adaptations thereof for commercial
*  purposes is prohibited except under license from the Stanford Office of
*  Technology Licensing."
*
***********************************************************/
#ifndef _XawSmeCascP_h
#define _XawSmeCascP_h

#include <X11/Xaw/SmeBSBP.h>
#include "SmeCasc.h"

typedef struct _SmeCascClassPart {
  XtPointer extension;
} SmeCascClassPart;

/* Full class record declaration */
typedef struct _SmeCascClassRec {
    RectObjClassPart       rect_class;
    SmeClassPart           sme_class;
    SmeBSBClassPart        sme_bsb_class;
    SmeCascClassPart       sme_casc_class;
} SmeCascClassRec;

extern SmeCascClassRec smeCascClassRec;

/* New fields for the Sme Object record */
typedef struct {
    /* resources */

  Widget menu;

    /* private resources. */

  Boolean  popped;
  char     *menu_name;
} SmeCascPart;

/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _SmeCascRec {
  ObjectPart         object;
  RectObjPart        rectangle;
  SmePart	     sme;
  SmeBSBPart         sme_bsb;
  SmeCascPart        sme_casc;
} SmeCascRec;

/************************************************************
 *
 * Private declarations.
 *
 ************************************************************/

#endif /* _XawSmeCascP_h */


