/* -*- C -*-
 *
 * Program:	ximap
 * File:        textutil.h -- manipulating text.  Text widget convenience functions
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#ifndef __ximap_textutil_h
#define __ximap_textutil_h

extern void  XbTextAppend(/* Widget, char* */);
extern void  XbTextClearBuffer(/* Widget */);
extern char* XbTextCopyBuffer(/* Widget */);
extern void XbInsertAtCurrentPoint(/* w, text */);

extern char* fixnl(/* char* */);
extern void  un_fixnl(/* char* */);

extern char* gettext_for_display(/* char* */);
extern char* gettext_for_insert(/* char* */);
extern char* gettext_for_send(/* Widget */);

extern int countnl(/* char* */);

extern char* strncut(/* char*, char*, int, int */);
extern char* strcut(/* char*, char*, int */);

extern int areDifferentStrings(/* char*, char* */);

extern void remove_eol(/* char* */);

extern void write_line(/* char**, char**, char** */);

extern void fix_line_width(/* char*, char*, int */);
extern char* copywrap(/* char * */);

#endif /* __ximap_textutil_h */
 
