{$G+,S-,R-,I-}
Unit CDFull;

{-$DEFINE MEMDEBUG}
{$DEFINE MOUSE}
Interface

Uses
 Cnt_U, XCrt, Dos, Strings, DosX, CDTCV, CDTTY
{$IFDEF MOUSE}
 ,Mou
{$ENDIF}
 ;


Type
  TScreenArray = Array[0..0] Of Char;
  TVolumeRecord = Record
    Vol, Ser : Str11;
    Time : String[5];
    CopyId : Word;
  End;
  TVolumeArray = Array[0..0] Of TVolumeRecord;
  Str13 = String[13];
  Str2 = String[2];
  PFULL_Msg = ^FULL_Msg;
  FULL_Msg = Object(TTY_Msg)
    MaxX, MaxY : Byte;
    VideoMode  : Word;
    DefCursor : Word;
    DirY, DirX, DirY2 : Byte;
    DiskIdx : Byte;
    ScreenArray, OldScreenArray : ^TScreenArray;
    VolumeArray : ^TVolumeArray;
    OldVideoPageSize, VideoPageSize, OldLastMode : Word;
    OldTextAttr, OldWhereX, OldWhereY : Byte;
    SerialNum : LongInt;

    Constructor Init;
    Destructor Done; virtual;
    Procedure Welcome(Version:String; CPUStr :String); virtual;
    Procedure PutCharXY( Screen:Pointer; X,Y:Byte; C:Char; Color: Byte);
    Procedure WriteXY(Screen:Pointer; X,Y:Word; S:String; Color:Byte);
    Procedure WriteLongXY(Screen:Pointer; X,Y:Byte; L:LongInt; Sep:Boolean; Color:Byte);
    Procedure HorLine( Screen:Pointer; Y, X1,X2:Word; C:Char; Color:Byte);
    Procedure VerLine( Screen:Pointer; X, Y1,Y2:Word; Color:Byte);
    Procedure ShowSyntax; virtual;
    Procedure NewLine; virtual;
    Procedure ClearLine; virtual;
    Procedure Error(E:Byte); virtual;
    Procedure ClearError; virtual;
    Procedure Prompt(Prm: TPrompt); virtual;
    Function  Continue:ContType; virtual;
    Function  ClearFileList : Word; virtual;
    Procedure AddFileName(Dir : DirEntryRec); virtual;
    Procedure TempUse(UseLowMem, UseXMS, UseDisk : LongInt); virtual;
    Procedure CurCopied(Reading:Boolean; T, H :Byte; N : LongInt); virtual;
    Procedure FormatStatus(F, S:Boolean); virtual;
    Procedure VerifyStatus(V:Boolean);  virtual;
    Procedure FatSelectStatus(F:Boolean);  virtual;
    Procedure TransferTime(M, S:Byte); virtual;
    Procedure DiskStat(DT:Byte; Tracks, Heads, Sectors : Word); virtual;
    Procedure InitBar(BT : BarType); virtual;
    Procedure ShowBar(SS : Word; BT : BarType); virtual;
    Function  ChangeLabel : Boolean; Virtual;
    Procedure VolumeSerial(VL : Str11; VSN : LongInt); virtual;
    Procedure GetVolumeSerial(Var VL : Str11; Var VSN : LongInt); Virtual;
    Function  Setup : Boolean; Virtual;
  End;

Implementation

Const
  HighLightColor : Byte = Blue Shl 4 + White;
  vColor   : Byte = Blue Shl 4 + Yellow;
  ErrorColor : Byte = Blue Shl 4 + LightRed;
  NormalTextColor : Byte = Blue Shl 4 + LightCyan;
  HLineChar = '';
  VLineChar = '';
  TopLeft = '';
  TopRight = '';
  BotLeft = '';
  BotRight = '';
  L01 = '';
  L02 = '';
  Bar : Array [0..4] Of Char = ('','','', '', 'B');
  HiddenChar = '';
  PhysVideo : Pointer = Nil;
  StatVideo : Pointer = Nil;
  TmpPhysVideo : Pointer = Ptr($B800,$0000);
  FormatVerifyStatus : Array[False..True] Of Char = (' ', 'x');
  HideCursor = $1000;

Const
  Alt_S  = $1F00;
  Alt_V  = $2F00;
  Alt_W  = $1100;
  Ctrl_A = $0001;
  Ctrl_B = $0002;
  F1     = $3B00;


Const
  cTracksX = 35;
  cTracksY = 5;
  cHeadsY  = cTracksY;
  cSectorsY= CtracksY;
  cVolX = 5;
  cVolY = 4;
  vVolX = cVolX+16;
  vVolY = cVolY;
  cSerX = cVolX;
  cSerY = cVolY+1;
  vSerX = vVolX;
  vSerY = cSerY;
  cMemY = 7;
  cErrorX = 5;
  cTransferX = 36;
  cTransferYT = 9;
  cTransferYB = 5;
  cCopiesX = 16;
  cCopiesY = 4;
  vCopiesX = 6;
  cVerifyY = 8;
  cFormatY = cVerifyY;
  cFatSelectY   = cVerifyY;
  vCurDateX = 17;
  vCurTimeX = 7;
  vCurDateY = 2;
  vCurTimeY = vCurDateY;
  cRWX  = 5;
  cQuitButtonX = 3;
  cQuitButtonY = 1;

Var
  Country : TCountry;

Procedure SetCursor(w : Word); Assembler;
Asm
  MOV   AH, 01h
  MOV   CX, w
  INT   10h
End;

Function GetCursor : Word; Assembler;
Asm
  MOV   AH,03h
  XOR   BH,BH
  INT   10h
  MOV   AX, CX
End;


Function NumToStr(I:LongInt; c : Byte; Sep:Boolean):String;
Var s : String;
Begin
  Str(i, s);
  If Sep Then Begin
    If i >= 1000 Then
      Insert(Country.ThousandSep[0], s, Length(s)-2);
    If i >= 1000000 Then
      Insert(Country.ThousandSep[0], s, Length(s)-6);
    If i >= 1000000000 Then
      Insert(Country.ThousandSep[0], s, Length(s)-10);
  End;
  If c > 0 Then
    While Length(s) < c Do s := ' ' + s;
  NumToStr := s;
End;

Function DateToStr(Y,M,D:Integer):String;
Const
  LeadingChar : Array[False..True] Of Char = (' ', '0');
Var
  ys, ms, ds : String[6];
Begin
  Str(Y, ys);
  ys := Copy(ys, Length(ys)-1, 2);
  Str(M, ms);
  If (Length(ms)=1) Then
    ms := LeadingChar[Country.DateFormat <> 0] + ms;
  Str(D, ds);
  If (Length(ds)=1) Then
    ds := LeadingChar[Country.DateFormat <> 1] + ds;
  Case CountryType(Lo(Country.DateFormat)) Of
    ctUsa    : DateToStr := ms + Country.DateSep[0] + ds + Country.DateSep[0] + ys;
    ctEurope : DateToStr := ds + Country.DateSep[0] + ms + Country.DateSep[0] + ys;
    ctJapan  : DateToStr := ys + Country.DateSep[0] + ms + Country.DateSep[0] + ds;
  End
End;

Function TimeToStr(H,M,S :Integer):String;
Const
  LeadingZero = True;
  AM_PM : Array[False..True] Of Char = ('a', 'p');
Var
  hs,ms,ss : String[2];
  H12 : Boolean;
  TimeS : String[9];
Begin
  H12 := Country.TimeFormat = 0;
  If Not H12 Or (H <= 12) Then
    Str(H:2, hs)
  Else
    Str(Abs(H-12):2, hs);
  Str(M, ms);
  If LeadingZero And (Length(ms)=1) Then
    ms := '0'+ms;
  Str(S, ss);
  If LeadingZero And (Length(ss)=1) Then
    ss := '0'+ss;
  TimeS := hs + Country.TimeSep[0] + ms + Country.TimeSep[0] + ss;
  If H12 Then
    TimeS := TimeS + AM_PM[H > 11];
  TimeToStr := TimeS;
End;

Procedure Full_Msg.GetVolumeSerial(Var VL : Str11; Var VSN : LongInt);
Begin
  VL := VolumeArray^[DiskIdx].Vol;
  VSN := SerialNum;
End;

Procedure Full_Msg.PutCharXY( Screen:Pointer; X,Y:Byte; C:Char; Color:Byte); Assembler;
{ MemW[Seg(Screen^):(X-1)*2+(Y-1)*MaxX*2+Ofs(Screen^)] := Color Shl 8 + Byte(C);}
Asm
    PUSH  DS
    XOR   AX, AX
    MOV   AL, Y
    DEC   AX
    SHL   AX, 1
    LES   DI, Self
    MUL   ES:[DI].MaxX
    LES   DI, Screen
    ADD   DI, AX
    XOR   AX, AX
    MOV   AL, X
    DEC   AL
    SHL   AX, 1
    ADD   DI, AX
    MOV   AH, Color
    MOV   AL, C
    CLD
    STOSW
    POP   DS
End;

Procedure Full_Msg.WriteXY(Screen:Pointer; X,Y:Word; S:String; Color:Byte); Assembler;
Asm
    PUSH  DS
    MOV   AX, Y
    DEC   AX
    SHL   AX, 1
    LES   DI, Self
    MUL   ES:[DI].MaxX
    ADD   AX, X
    ADD   AX, X
    SUB   AX, 2
    MOV   BX, AX
    MOV   AH, Color
    LDS   SI, DWORD PTR S
    LES   DI, Screen
    ADD   DI, BX
    CLD
    LODSB                             { Length S }
    OR    AL, AL
    JZ    @Done
    MOV   CL, AL
    MOV   CH, 0
@L0:
    LODSB
    STOSW
    LOOP  @L0
@Done:
    POP   DS
End;

Procedure Full_Msg.WriteLongXY(Screen:Pointer; X,Y:Byte; L:LongInt; Sep:Boolean; Color:Byte);
Begin
  WriteXY(Screen, X, Y, NumToStr(L, 0, Sep), Color);
End;

Procedure Full_Msg.HorLine( Screen:Pointer; Y, X1,X2:Word; C:Char; Color:Byte); Assembler;
Asm
    MOV  AX,Y
    DEC  AX
    SHL  AX,1
    LES  DI, Self
    MUL  ES:[DI].MaxX
    ADD  AX,X1
    ADD  AX,X1
    SUB  AX,2
    LES  DI,Screen
    ADD  DI,AX
    {}
    MOV  AL,C
    MOV  AH,Color
    MOV  CX,X2
    SUB  CX,X1
    INC  CX
    CLD
    REP STOSW
End;

Procedure Full_Msg.VerLine( Screen:Pointer; X, Y1,Y2:Word; Color:Byte); Assembler;
Asm
    MOV  AX,Y1
    DEC  AX
    SHL  AX,1
    LES  DI,Self
    MOV  BL,ES:[DI].MaxX
    MUL  BL
    ADD  AX,X
    ADD  AX,X
    SUB  AX,2
    LES  DI,Screen
    ADD  DI,AX
    {}
    MOV  DL,BL
    MOV  DH,0
    SHL  DX,1
    SUB  DX,2
    {}
    MOV  AL,VLineChar
    MOV  AH,Color
    MOV  CX,Y2
    SUB  CX,Y1
    INC  CX
    CLD
@1:
    STOSW
    ADD  DI,DX
    LOOP @1
End;

Procedure Full_Msg.InitBar(BT:BarType);
Var Ch : Char;
Begin
  Case BT Of
    bEmpty : Ch := Bar[0];
    bFull  : Ch := Bar[1];
  End;
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  HorLine(PhysVideo, MaxY-1, 3, MaxX-2, Ch, NormalTextColor);
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
End;


Constructor Full_Msg.Init;
Begin
  Inherited Init;
  GetCountryInfo(Country);
  DefCursor := GetCursor;
  VideoMode := Mem[Seg0040:$0049];
  If VideoMode In [2, 7] Then Begin
    If VideoMode = 7 Then
      TmpPhysVideo := Ptr(SegB000,$0000);
    HighLightColor := $0F;
    vColor := $0F;
    NormalTextColor := $07;
    ErrorColor := $0F;
    VideoModeC := VideoMode;
  End;
  PhysVideo := TmpPhysVideo;
  StatVideo := PhysVideo;
  OldVideoPageSize := Mem[Seg0040:$004A]*Mem[Seg0040:$0084]*2;
  GetMem(OldScreenArray, OldVideoPageSize);
  Move(PhysVideo^, OldScreenArray^, OldVideoPageSize);
  OldTextAttr := TextAttr;
  OldWhereX := WhereX;
  OldWhereY := WhereY;
  OldLastMode := LastMode;
  If Win386 Then Begin
    If (VideoModeC And CO80) <> CO80 Then
      VideoModeC := CO80 + Hi(VideoModeC) Shl 8;
  End;
  If (VideoMode <= CO40) Then
    VideoModeC := CO80;
  TextMode(VideoModeC);
  SetCursor(HideCursor);  { Hide }
  MaxX := Mem[Seg0040:$004A];
  MaxY := Mem[Seg0040:$0084] + 1;
  VideoPageSize := MaxX*MaxY*2;
  ScreenArray := PhysVideo;
  Inc(LongInt(ScreenArray), $4000);
{  GetMem(ScreenArray, VideoPageSize); }
  If VideoMode <> 7 Then
    TextAttr := HighLightColor;
  DiskIdx := 0;
  GetMem(VolumeArray, (MaxY-10-5+1)*SizeOf(TVolumeRecord));
  Randomize;
End;

Procedure Full_Msg.Welcome(Version, CPUStr :String );
Begin
  ClrScr;
  HorLine(PhysVideo, 1, 2, MaxX-1, HLineChar, NormalTextColor);
  HorLine(PhysVideo, MaxY, 2, MaxX-1,HLineChar, NormalTextColor);
  VerLine(PhysVideo, 1, 2, MaxY-1, NormalTextColor);
  VerLine(PhysVideo, MaxX, 2, MaxY-1, NormalTextColor);
  PutCharXY(PhysVideo, 1,1, TopLeft, NormalTextColor);
  PutCharXY(PhysVideo, MaxX, 1, TopRight, NormalTextColor);
  PutCharXY(PhysVideo, 1, MaxY, BotLeft, NormalTextColor);
  PutCharXY(PhysVideo, MaxX, MaxY, BotRight, NormalTextColor);
  {}
  HorLine(PhysVideo, 3, 2, MaxX-1, HLineChar, NormalTextColor);
  PutCharXY(PhysVideo, 1, 3, L01, NormalTextColor);
  PutCharXY(PhysVideo, MaxX, 3, L02, NormalTextColor);
  {}
  HorLine(PhysVideo, MaxY-2, 2, MaxX-1, HLineChar, NormalTextColor);
  PutCharXY(PhysVideo, 1, MaxY-2, L01, NormalTextColor);
  PutCharXY(PhysVideo, MaxX, MaxY-2, L02, NormalTextColor);
  {}
  InitBar(bEmpty);
  {}
  PutCharXY(PhysVideo, MaxX-cTransferX, cTransferYT, TopLeft, NormalTextColor);
  HorLine(PhysVideo, cTransferYT, MaxX-(cTransferX-1), MaxX-1, HLineChar, NormalTextColor);
  PutCharXY(PhysVideo, MaxX, cTransferYT, L02, NormalTextColor);
  VerLine(PhysVideo, MaxX-cTransferX, cTransferYT+1, MaxY-cTransferYB, NormalTextColor);
  PutCharXY(PhysVideo, MaxX-cTransferX, MaxY-cTransferYB, BotLeft, NormalTextColor);
  HorLine(PhysVideo, MaxY-cTransferYB , MaxX-(cTransferX-1), MaxX-1, HLineChar, NormalTextColor);
  PutCharXY(PhysVideo, MaxX, MaxY-cTransferYB, L02, NormalTextColor);

  WriteXY(PhysVideo, cQuitButtonX,  cQuitButtonY, '[ ]', NormalTextColor);
  WriteXY(PhysVideo, cQuitButtonX+1, cQuitButtonY, #$FE, HighLightColor);
  WriteXY(PhysVideo, 6, 2, ' CopyDisk '+ Version, NormalTextColor);
  WriteXY(PhysVideo, MaxX-35, 2, 'CPU: '+ CPUStr, NormalTextColor);

  WriteXY(PhysVideo, cVolX, cVolY, 'Volume Label  :', NormalTextColor );
  WriteXY(PhysVideo, cSerX, cSerY, 'Serial number :', NormalTextColor);
  WriteXY(PhysVideo, MaxX-cTracksX, 4, 'Drive ', NormalTextColor);
  WriteXY(PhysVideo, MaxX-cCopiesX, cCopiesY, 'Copies  :', NormalTextColor);
  WriteXY(PhysVideo, MaxX-cCopiesX+6, 4, '+-', HighLightColor);
  WriteLongXY(PhysVideo, MaxX-vCopiesX, cCopiesY, NoOfCopies, False, vColor);
  WriteXY(PhysVideo, MaxX-cTracksX, cTracksY,   'Tracks:     Heads:    Sectors:', NormalTextColor);
  WriteXY(PhysVideo, MaxX-cTracksX, cTracksY+1, 'Track:      Head:          Kb    %', NormalTextColor);
  WriteXY(PhysVideo, MaxX-35, cVerifyY, 'Verify  [ ]', NormalTextColor);
  PutCharXY(PhysVideo, MaxX-35, cVerifyY, 'V', HighLightColor);
  WriteXY(PhysVideo, MaxX-23, cFormatY, 'Format  [ ]', NormalTextColor);
  PutCharXY(PhysVideo, MaxX-23, cFormatY, 'F', HighLightColor);
  WriteXY(PhysVideo, MaxX-10, cFatSelectY, 'FatS  [ ]', NormalTextColor);
  PutCharXY(PhysVideo, MaxX-9, cFatSelectY, 'a', HighLightColor);

  VerifyStatus(Verify);
  FormatStatus(ForcedFormat, False);
  FatSelectStatus(FatSelect);
  WriteXY(PhysVideo, MaxX-35, cTransferYT+1, 'Volume      Serial     Time   Copy', NormalTextColor);
  {$IFDEF MEMDEBUG}
  WriteXY(PhysVideo, MaxX-35, 2, 'MaxAvail: ' + NumToStr(MaxAvail, 7, True), NormalTextColor);
  {$ENDIF}
{$IFDEF MOUSE}
  MouseInit;
  MouseShow;
{$ENDIF}
End;

Destructor Full_Msg.Done;
Begin
{$IFDEF MOUSE}
  MouseHide;
  MouseDeInit;
{$ENDIF}
{  FreeMem(ScreenArray, VideoPageSize);}
  TextAttr := OldTextAttr;
  TextMode(OldLastMode);
  Move(OldScreenArray^, PhysVideo^, OldVideoPageSize);
  FreeMem(OldScreenArray, OldVideoPageSize);
  GotoXY(OldWhereX, OldWhereY);
  SetCursor(DefCursor);
  Inherited Done;
End;

Procedure Full_Msg.ShowSyntax;
Begin
End;

Procedure Full_Msg.NewLine;
Begin
End;

Procedure Full_Msg.ClearLine;
Begin
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  HorLine(PhysVideo, MaxY-3, 3, MaxX-2, ' ', NormalTextColor);
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
End;

Procedure Full_Msg.Error(E:Byte);
Var
  S : String;
Begin
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  S := ExtendedError(E);
  WriteXY(PhysVideo, (MaxX-Length(S)) Div 2 -1, MaxY-4, S, ErrorColor);
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
End;

Procedure Full_Msg.ClearError;
Begin
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  HorLine(PhysVideo, MaxY-4, 3, MaxX-2, ' ', NormalTextColor);
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
End;

Procedure Full_Msg.Prompt(Prm:TPrompt);
Var s : String;
Begin
  s := '';
  Case Prm Of
    ptInsertSource     : s := tSource;
    ptText             : s := tText;
    ptInsertTarget     : s := tTarget;
    ptRemoveSource     : s := tRemoveSource;
    ptRemoveTarget     : s := tRemoveTarget;
    ptRemoveDisk       : s := tRemoveDisk;
    ptInsertNewDisk    : s := tNewDisk;
    ptErrorWrite       : s := tErrorWrite;
    ptRetryAbortIgnore : s := tRetryAbortIgnore;
    ptErrorPrompt      : s := tErrorPrompt;
    ptCopyAnother      : s := tCopyAnother;
    ptDiskTypeMisMatch : s := tDiskTypeMisMatch;
    ptVerifyError      : s := tVerifyError;
    ptNone             : s := '';
  End;
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  WriteXY(PhysVideo, (MaxX-Length(S)) Div 2 - 1, MaxY-3, s, NormalTextColor);
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
End;

Function Full_Msg.Continue:ContType;
Const
  V  : Boolean = False;
  F  : Boolean = False;
  FF : Boolean = False;
  OldContinue : ContType = ctUnknown;
Var
  Hour, Min, Second, Sec100 : Word;
  Year, Month, Day, Dow : Word;
  TimeS, S : String[9];
  LeftWasReleased : Boolean;
{$IFDEF MOUSE}
  Mbuf : TMouInfoRec;
{$ENDIF}
Begin
  Case OldContinue Of
     ctChangeLabel : If ChangeLabel Then
                       OldContinue := ctUnknown;
     ctSetup       : If Setup Then
                       OldContinue := ctUnknown;
  End;
  Continue := Inherited Continue;
  Case LastKey Of
    Alt_S  : Begin
               LastKey := 0;
               OldContinue := ctSetup;
             End;
    Alt_W  : Begin
               LastKey := 0;
               SaveSetup := True;
             End;
    Alt_V  : Begin
	       LastKey := 0;
	       OldContinue := ctChangeLabel;
	     End;
    F1     : ;
    Ctrl_A : Continue := ctNewDriveA;           { Ctrl-a }
    Ctrl_B : Continue := ctNewDriveB;           { Ctrl-b }
  End;
  GetTime(Hour, Min, Second, Sec100);
  GetDate(Year, Month, Day, Dow);
  TimeS := TimeToStr(Hour, Min, Second);
  If Second Mod 2 = 0 Then
    TimeS[3] := ' ';
  Delete(TimeS, 6, 3);
  WriteXY(PhysVideo, MaxX-(vCurTimeX), vCurTimeY, TimeS, NormalTextColor);
  WriteXY(PhysVideo,MaxX-vCurDateX, vCurTimeY, DateToStr(Year, Month, Day), NormalTextColor);
  V := Verify;
  F := ForcedFormat;
  FF := FatSelect;
{$IFDEF MOUSE}
  If MouseInstalled And MouseCheck Then Begin
    MouseGet(Mbuf);
    If (Mbuf.buttonstat And LeftBPress = LeftBPress) Then Begin
      If (Mbuf.cx+1 = cQuitButtonX+1) And (Mbuf.cy+1 = cQuitButtonY) Then Begin
	MouseHide;
	WriteXY(PhysVideo, cQuitButtonX+1 , cQuitButtonY, '*', HighLightColor);
	MouseShow;
      End;
    End;
    If (Mbuf.buttonstat And LeftBRelease = LeftBRelease) Then Begin
      If (Mbuf.cx+1 = cQuitButtonX+1) And (Mbuf.cy+1 = cQuitButtonY) Then Begin
	AskedForQuit := True;
	Continue := ctQuit;
      End;
      MouseHide;
      WriteXY(PhysVideo, cQuitButtonX+1 , cQuitButtonY, #$FE, HighLightColor);
      MouseShow;
    End;
    LeftWasReleased := (Mbuf.buttonstat And LeftBRelease = LeftBRelease);
    If LeftWasReleased Then Begin
      If (Mbuf.cx+1 In[MaxX-35..MaxX-25]) And (Mbuf.cy+1 = cVerifyY) Then
	Verify := Not Verify;
      If (Mbuf.cx+1 In[MaxX-23..MaxX-13]) And (Mbuf.cy+1 = cFormatY)
	And Not Writing Then
	  ForcedFormat := Not ForcedFormat;
      If (Mbuf.cx+1 In[MaxX-10..MaxX-2]) And (Mbuf.cy+1 = cFatSelectY) Then
	FatSelect := Not FatSelect;
      If (Mbuf.cx+1=MaxX-10) And (Mbuf.cy+1 = cCopiesY) Then
	LastKey := Ord('+');
      If (Mbuf.cx+1=MaxX-9) And (Mbuf.cy+1 = cCopiesY) Then
	LastKey := Ord('-');
      If (Mbuf.cx+1 In [cVolX..vVolX+10]) And (Mbuf.Cy+1=cVolY) Then Begin
        LastKey := 0;
        OldContinue := ctChangeLabel;
      End;
    End;
  End;
{$ENDIF}
  Case UpCase(Char(Lo(LastKey))) Of
    'A' : FatSelect := Not FatSelect;
    'V' : Verify := Not Verify;
    'F' : ForcedFormat := Not ForcedFormat And Not Writing;
    '+' : Begin
	    Inc(NoOfCopies);
	    If NoOfCopies = 0 Then NoOfCopies := 1;
	  End;
    '-' : Begin
	    Dec(NoOfCopies);
	    If NoOfCopies = 0 Then NoOfCopies := 1;
	    If NoOfCopies < DiskId Then
	      NoOfCopies := DiskId;
	  End;
    '1'..'9' : NoOfCopies := Lo(LastKey)-$30;
  End;
  MultiCopy := NoOfCopies > 1;
  If Char(Lo(LastKey)) In['-', '+', '1'..'9'] Then Begin
    Str(NoOfCopies, S);
    While Length(S) < 5 Do
      S := S + ' ';
{$IFDEF MOUSE}
    MouseHide;
{$ENDIF}
    WriteXY(PhysVideo, MaxX-vCopiesX, cCopiesY, S, vColor);
{$IFDEF MOUSE}
    MouseShow;
{$ENDIF}
  End;
  LastKey := LastKey And $FF00;
  If V Xor Verify Then
    VerifyStatus(Verify);
  If F Xor ForcedFormat Then
    FormatStatus(ForcedFormat, False);
  If FF Xor FatSelect Then
    FatSelectStatus(FatSelect);
End;

Function Full_Msg.ClearFileList:Word;
Const
  WX1 = 3;
  WY1 = 7;
  WX2 = WX1+39;
Var
  DirLines : Word;
  Y : Byte;
Begin
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  For Y := WY1 To MaxY-5 Do
    Horline(StatVideo, Y, WX1, WX2+Ord(MaxX=132)*47, ' ', HighLightColor);
  DirLines := (MaxY-4-WY1) Shl Ord(MaxX=132);
  DirY  := WY1;
  DirY2 := DirY;
  DirX  := WX1;
  ClearFileList := DirLines;
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
End;

Procedure Full_Msg.AddFileName(Dir:DirEntryRec);
Function LowerCase(S:Str13) : Str13;
Var i : Byte;
Begin
  For i := 1 To Length(s) Do
    Case s[i] Of
      'A'..'Z' : s[i] := Chr(Ord(s[i])+32);
      ''      : s[i] := '';
      ''      : s[i] := '';
      ''      : s[i] := '';
    End;
  LowerCase := s;
End;

Var
  Name, s : String[12];
  dt : DateTime;
  Time : LongInt;
Begin
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  If (DirY = MaxY-4) And (MaxX = 132) Then Begin
    Inc(DirX, 49);
    DirY := DirY2;
  End;
  Name := StrPas(Dir.Name);
  Insert(' ', Name, 9);
  Move(Dir.Time, Time, 4);
  UnPackTime(Time, Dt);
  If Dir.Attr And Directory <> Directory Then Begin
    Name := LowerCase(Name);
    If Dir.Attr And (Hidden+SysFile) In [Hidden, SysFile, Hidden+SysFile] Then Begin
      Name[1] := UpCase(Name[1]);
      Name[9] := HiddenChar;
    End;
    WriteXY(StatVideo, DirX, DirY, Name + NumToStr(Dir.Size, 11, True), NormalTextColor);
  End
  Else
    WriteXY(StatVideo, DirX, DirY, Name + '      <DIR>', NormalTextColor);
  WriteXY(StatVideo, DirX+23, DirY, ' '+DateToStr(Dt.Year, Dt.Month, Dt.Day), NormalTextColor);
  s := TimeToStr(Dt.Hour, Dt.Min, Dt.Sec);
  Delete(s, 6, 3);
  WriteXY(StatVideo, DirX+32, DirY, ' ' + S, NormalTextColor);
  Inc(DirY);
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
End;

Procedure Full_Msg.TempUse(UseLowMem, UseXMS, UseDisk : LongInt);
Var
  sm : String[4];
  cX : Byte;
Begin
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  HorLine(StatVideo, cMemY, MaxX-35, MaxX-1, ' ', HighLightColor);
  WriteXY(StatVideo,MaxX-35, cMemY,  'DOS:', NormalTextColor);
  Str(UseLowMem  Div 1024, sm);
  WriteXY(StatVideo,MaxX-28, cMemY,  sm, vColor);
  cX := MaxX-23;
  If UseXMS > 0 Then Begin
    Str(UseXMS  Div 1024, sm);
    WriteXY(StatVideo,cX,   cMemY,  'XMS:', NormalTextColor);
    WriteXY(StatVideo,cX+5, cMemY,  sm, vColor);
    Inc(cX, Length(sm) + 7);
  End;
  If UseDisk > 0 Then Begin
    Str(UseDisk  Div 1024, sm);
    WriteXY(StatVideo,cX, cMemY,  'Disk:', NormalTextColor);
    WriteXY(StatVideo,cX+6, cMemY,  sm, vColor);
    Inc(cX, Length(sm)+ 7);
  End;
  WriteXY(StatVideo, cX, cMemY, 'Kb', NormalTextColor);
{$IFDEF MEMDEBUG}
  WriteXY(PhysVideo, MaxX-35, 2, 'MaxAvail: ' + NumToStr(MaxAvail, 7, True), NormalTextColor);
{$ENDIF}
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
End;

Procedure Full_Msg.ShowBar(SS : Word; BT : BarType);
Const
  X : Word = 3;
  R : Real = 0;
Var
  X2 : Byte;
  Ch : Char;
  RR : Real;
Begin
  If SS = 0 Then Begin
    X := 3;
    R := 0;
  End
  Else Begin
{$IFDEF MOUSE}
    MouseHide;
{$ENDIF}
    ch := Bar[Ord(BT)];
    RR := SS / DeviceP^.Sectors*(MaxX-4);
    If (Frac(R+RR) > 0.5) Then
      X2 := Round(RR+Frac(R))
    Else
      X2 := Trunc(RR{+Frac(R)});
    X2 := X+X2;
    If X2 > MaxX-2 Then
      X2 := MaxX-1;
    HorLine(PhysVideo, MaxY-1, X, X2-1, Ch, NormalTextColor);
    R := R + RR;
    X := X2;
{$IFDEF MOUSE}
    MouseShow;
{$ENDIF}
  End;
End;


Procedure Full_Msg.CurCopied(Reading:Boolean; T, H :Byte; N : LongInt);
Const
  X : Byte = 3;
  NewCh : Char = #0;
Var
  ss : String[6];
  XX, i : Byte;
  P : Pointer;
  Ch : Char;
Begin
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  P := StatVideo;
  If N = 0 Then X := 3;
  WriteXY(PhysVideo, cRWX, MaxY-3, RWStatus[Reading], NormalTextColor);
  Str(T:2, ss);
  WriteXY(StatVideo, MaxX-cTracksX+8, cTracksY+1, ss, vColor);
  WriteXY(StatVideo, MaxX-cTracksX+19, cTracksY+1, Chr(H+48), vColor);
  Str(N Div 1024:6, ss);
  WriteXY(StatVideo, MaxX-cTracksX+20, cTracksY+1, ss, vColor);
  Str(N / RealDSizeS * 100 :4:0, ss);
  WriteXY(StatVideo, MaxX-6, cTracksY+1, ss, vColor);
  XX := X+Round(N / RealDSizeS * (MaxX-4));
  If N > 0 Then Begin
    If FatSelect Then Begin
      For i := X-1 To XX-1 Do Begin
        ch := Char(Mem[Seg(P^) : Ofs(P^)+MaxX*2*(MaxY-2)+(i)*2]);
        If (ch In ['', '']) Then Begin
	  NewCh := Bar[Ord(Reading)];
          PutCharXY(StatVideo, i+1, MaxY-1, Newch, NormalTextColor);
        End;
      End;
    End Else
      HorLine(StatVideo, MaxY-1, X, XX-1, Bar[Ord(Reading)], NormalTextColor);
  End;
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
End;

Procedure Full_Msg.VerifyStatus(V:Boolean);
Begin
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  PutCharXY(StatVideo, MaxX-26, cVerifyY, FormatVerifyStatus[V], NormalTextColor);
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
End;

Procedure Full_Msg.FormatStatus(F, S:Boolean);
Begin
  If F Then F := True;
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  PutCharXY(StatVideo, MaxX-14, cFormatY, FormatVerifyStatus[F], NormalTextColor);
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
  {  Write(',  Sectorshift ',DiskSizeList[DiskType].ST,':',DiskSizeList[DiskType].SH);
  WriteLn;}
End;

Procedure Full_Msg.FatSelectStatus(F:Boolean);
Begin
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  PutCharXY(StatVideo, MaxX-3, cFatSelectY, FormatVerifyStatus[F], NormalTextColor);
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
End;

Procedure Full_Msg.VolumeSerial(VL : Str11; VSN : LongInt);
Begin
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  If VL = '' Then VL := tUnlabeled;
  While Length(VL) < 11 Do
    VL := VL + ' ';
  SerialNum := VSN;
  VolumeArray^[DiskIdx].Vol := VL;
  VolumeArray^[DiskIdx].Ser := HexWord(VSN Shr 16)+'-'+HexWord(Word(VSN));
  WriteXY(StatVideo, vVolX, vVolY, VL, NormalTextColor);
  WriteXY(StatVideo, vSerX, vSerY, VolumeArray^[DiskIdx].Ser, NormalTextColor);
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
End;

Procedure Full_Msg.TransferTime(M, S:Byte);
Var
  i : Word;
  SS : String[40];
Begin
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  If DiskId > 1 Then
    Move(VolumeArray^[DiskIdx-1], VolumeArray^[DiskIdx], SizeOf(TVolumeRecord));
  VolumeArray^[DiskIdx].Time := Copy(TimeToStr(0, M, S), 4, 8);
  VolumeArray^[DiskIdx].CopyId := DiskId;
  For i := 0 To DiskIdx Do Begin
    With VolumeArray^[i] Do Begin
      Str(CopyId:4, SS);
      SS := Vol + ' ' + Ser + '  ' + Time + '  ' + SS;
    End;
    WriteXY(StatVideo, MaxX-35, cTransferYT+2+i, SS, NormalTextColor);
  End;
  If DiskIdx = MaxY-17 Then Begin
    i := 1;
    Move(VolumeArray^[i], VolumeArray^[i-1], DiskIdx*SizeOf(TVolumeRecord));
  End
  Else
    Inc(DiskIdx);
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
End;

Procedure Full_Msg.DiskStat(DT:Byte; Tracks, Heads, Sectors : Word);
Var s : String[2];
Begin
{$IFDEF MOUSE}
  MouseHide;
{$ENDIF}
  WriteXY(StatVideo, MaxX-27, 4,  SourceDrive + ':  ' + DiskSizeList[DT].S, vColor);
  WriteLongXY(StatVideo, MaxX-(cTracksX-8), cTracksY, Tracks, False, vColor);
  WriteLongXY(StatVideo, MaxX-(cTracksX-19), cHeadsY, Heads, False, vColor);
  Str(Sectors:2, s);
  WriteXY(StatVideo, MaxX-(cTracksX-31), cSectorsY, s, vColor);
{$IFDEF MOUSE}
  MouseShow;
{$ENDIF}
End;

Function Full_Msg.ChangeLabel : Boolean;
Const
  Chars : Set Of Char = [' ','A'..'Z','0'..'9'];
  Flag : Boolean = True;
  ch : Char = #0;
  VolLabel : String[11] = '';
  Color = Cyan Shl 4 + Black;
Var
  SerialNumber : Str11;
Begin
  If Flag Then Begin
    LabelChanged := False;
    SetCursor(DefCursor);
    GotoXY(vVolX, vVolY);
    ch := #0;
    VolLabel := '';
    MouseHide;
    HorLine(StatVideo, vVolY, vVolX, vVolX+10, ' ', Color);
    MouseShow;
  End;
  If KeyPressed Then Begin
    ch := ReadKey;
    If UpCase(ch) In Chars Then
      VolLabel := VolLabel + ch;
    If (ch = #8) And (Length(VolLabel) > 0) Then
      VolLabel[Length(VolLabel)] := ' ';
    MouseHide;
    WriteXY(StatVideo, vVolX, vVolY, VolLabel, Color);
    MouseShow;
    If (ch = #8) And (Length(VolLabel) > 0) Then
      Dec(VolLabel[0]);
    GotoXY(vVolX+Length(VolLabel), vVolY);
  End;
  Flag := ch In [#13, #27];
  Case ch Of
    #13 : Begin
            If VolLabel = '' Then VolLabel := tUnLabeled;
	    LabelChanged := True;
            SerialNum := LongInt(Random($FFFF)) SHL 16 + LongInt(Random($FFFF));
	  End;
    #27 : Begin
	    If VolumeArray^[DiskIdx].Vol <> tUnlabeled Then
	      VolLabel := VolumeArray^[DiskIdx].Vol
	    Else
	      VolLabel := tUnlabeled;
	  End;
  End;
  If Flag Then Begin
    While Length(VolLabel) < SizeOf(VolLabel)-1 Do
      VolLabel := VolLabel + ' ';
    SetCursor(HideCursor);
    VolumeSerial(VolLabel, SerialNum);
  End;
  ChangeLabel := Flag;
End;

Function Full_Msg.Setup;
Const
  Flag : Boolean = True;
  OldWindMax : Word = 0;
  OldWindMin : Word = 0;
  Ch : Char = #0;
Var
  P : Pointer;
Begin
{
  If Flag Then Begin
    Flag := False;
    Move(PhysVideo^, ScreenArray^, VideoPageSize);
    StatVideo := ScreenArray;
    OldWindMax := WindMax;
    OldWindMin := WindMin;
    Window(10, 5, MaxX-10, MaxY-5);
  End;
  Move(StatVideo^, PhysVideo^, VideoPageSize);
  ClrScr;
  HorLine(PhysVideo, 5, 10, MaxX-10, HLineChar, NormalTextColor);
  HorLine(PhysVideo, MaxY-5, 10, MaxX-10, HLineChar, NormalTextColor);
  VerLine(PhysVideo, 10, 6, MaxY-6, NormalTextColor);
  VerLine(PhysVideo, MaxX-10, 6, MaxY-6, NormalTextColor);
  PutCharXY(PhysVideo, 10, 5, TopLeft, NormalTextColor);
  PutCharXY(PhysVideo, MaxX-10, 5, TopRight, NormalTextColor);
  PutCharXY(PhysVideo, 10, MaxY-5, BotLeft, NormalTextColor);
  PutCharXY(PhysVideo, MaxX-10, MaxY-5, BotRight, NormalTextColor);
  If KeyPressed Then Begin
    ch := ReadKey;
    Flag := Ch = #13;
  End;
  If Flag Then Begin
    WindMax := OldWindMax;
    WindMin := OldWindMin;
    MOve(ScreenArray^, PhysVideo^, VideoPageSize);
    StatVideo := PhysVideo;
  End;
}
  Setup := Flag;
End;

End.
