{$A+,B-,D+,E-,F+,G+,I-,L+,N-,O-,R-,S-}
{$M 4096,0,4096}

Unit Cnt_U;

{ Count down Unit, now with beep }
{ Funright (f) 1993, Hans Schou }

Interface

Uses
  XCrt,
  Dos;

Const
     TicsInASec = 65536/3600;
     IntTTic = $08;
     MaxTimers = 10;
     OldTimerTicIsr : Pointer = Nil;

     BeeperOn : Boolean = False;

Type
     PBoolean = ^Boolean;
     PTimerType = ^TimerType;
     TimerType = Record
       Timer : ^LongInt;
       Done  : PBoolean;
       ScreenPos : Word;
       Cnt18 : Byte;
       Next  : PTimerType;
     End;

     BeepSetType = Record
       Hertz : Word;
       TicSound : Word;
     End;
     BeepSeq = Array[0..0] Of BeepSetType;
     PBeepSeq = ^BeepSeq;
     PBeepType = ^BeepType;
     BeepType = Record
       SetLength : Byte;
       Sequens      : Word;
       BeepSet   : PBeepSeq;
     End;

Const
   BeepStartErr : Byte = 0;
   SimpleSetLen = 2*3;
   SimpleBeep : BeepType = (
     SetLength : SimpleSetLen;
     Sequens   : 20;
     BeepSet   : Nil
   );
   SimpleSet : Array[0..Pred(SimpleSetLen)] Of BeepSetType = (
     (Hertz : 880*4;
      TicSound : 1),
     (Hertz : 0;
      TicSound : 1),
     (Hertz : 880*6;
      TicSound : 1),
     (Hertz : 0;
      TicSound : 1),
     (Hertz : 880*4;
      TicSound : 1),
     (Hertz : 0;
      TicSound : 2*18)
   );
   SmartSetLen = 6;
   SmartBeep : BeepType = (
     SetLength : SmartSetLen;
     Sequens   : 100;
     BeepSet   : Nil
   );
   SmartSet : Array[0..Pred(SmartSetLen)] Of BeepSetType = (
     (Hertz : 440;
      TicSound : 3),
     (Hertz : 0;
      TicSound : 8),
     (Hertz : 440;
      TicSound : 3),
     (Hertz : 0;
      TicSound : 8),
     (Hertz : 880;
      TicSound : 3),
     (Hertz : 0;
      TicSound : 18*15)
   );
  SuccessBeepSetLen = 12;
  SuccessBeep : BeepType = (
    SetLength : SuccessBeepSetLen;
    Sequens      : 6;
    BeepSet   : Nil
  );
  SuccessBeepSet : Array[0..Pred(SuccessBeepSetLen)] Of BeepSetType = (
    (Hertz : 220*2;
     TicSound : 1),
    (Hertz : 220*3;
     TicSound : 1),
    (Hertz : 220*4;
     TicSound : 1),
    (Hertz : 220*5;
     TicSound : 1),
    (Hertz : 220*6;
     TicSound : 1),
    (Hertz : 220*7;
     TicSound : 1),
    (Hertz : 220*8;
     TicSound : 1),
    (Hertz : 220*9;
     TicSound : 1),
    (Hertz : 220*10;
     TicSound : 1),
    (Hertz : 220*11;
     TicSound : 1),
    (Hertz : 220*12;
     TicSound : 1),
    (Hertz : 0;     { pause }
     TicSound : 18*15)
  );
   ErrorSetLen = 12;
   ErrorBeep : BeepType = (
     SetLength : ErrorSetLen;
     Sequens   : 1000;
     BeepSet   : Nil
   );
   ErrorSet : Array[0..Pred(ErrorSetLen)] Of BeepSetType = (
     (Hertz : 880*2;
      TicSound : 1),
     (Hertz : 0;
      TicSound : 1),
     (Hertz : 880*2;
      TicSound : 1),
     (Hertz : 0;
      TicSound : 1),
     (Hertz : 880*2;
      TicSound : 1),
     (Hertz : 0;
      TicSound : 1),
     (Hertz : 880*2;
      TicSound : 1),
     (Hertz : 0;
      TicSound : 1),
     (Hertz : 880*2;
      TicSound : 1),
     (Hertz : 0;
      TicSound : 1),
     (Hertz : 880*2;
      TicSound : 1),
     (Hertz : 0;
      TicSound : 18*10)
   );

Procedure BeepStart( Var NewBeep:BeepType );
Procedure BeepStop;

Procedure AddDnTimer( Var T:LongInt; Sec:Real );
Procedure AddDnTimerDone( Var T:LongInt; TimeDone:PBoolean; Sec:Real );
Procedure AddDnTimerXY( Var T:LongInt; Sec:Real; x,y:Byte );
Procedure SetDnTimer( Var T:LongInt; Sec:Real );
Function  GetDnTimer( T:LongInt ):Real;

Implementation

Type  ScreenAttr = Record
        Ch : Char;
        Color : Byte;
      End;

Const TimerTop : PTimerType = Nil;
      CurrentBeep : PBeepType = Nil;

Var   TimerList : PTimerType;
      TmpStr : String;
      Screen : Array[0..0] Of ScreenAttr Absolute $B800:$0000;

      TicCount  : Word;
      SeqsCount : Word;
      SetIndex  : Word;
      InBeep : Byte;

Procedure Cli; Inline($FA);
Procedure Sti; Inline($FB);

{ Sound.TicSustain .. NoSound.TicDelay Next }
Const
   sbSuccess    = 0;
   sbNilPointer = 1;
   sbSetLength  = 2;
   sbSequens    = 3;
   sbBeepSetNil = 4;
   sbTicSound   = 5;

Procedure BeepStart( Var NewBeep:BeepType );
Var i : Word;
Begin
  BeepStop;
  BeepStartErr := sbNilPointer;
  If @NewBeep = Nil Then
    Exit;
  With NewBeep Do Begin
    BeepStartErr := sbSetLength;
    If SetLength = 0 Then
      Exit;
    BeepStartErr := sbSequens;
    If Sequens < 1 Then
      Exit;
    BeepStartErr := sbBeepSetNil;
    If BeepSet = Nil Then
      Exit;
    BeepStartErr := sbTicSound;
    For i := 0 To Pred(SetLength) Do
      If BeepSet^[i].TicSound = 0 Then { not allowed }
        Exit;
    SeqsCount := Sequens;
    SetIndex := 0;
    TicCount := 0;
    InBeep := 0;
    BeeperOn := True;
  End;
  CurrentBeep := @NewBeep;
  BeepStartErr := sbSuccess;
End;

Procedure BeepStop;
Begin
  BeeperOn := False;
  While InBeep > 0 Do
    ;
  NoSound;
  {If TimerTop = Nil Then
    DisableDnTimer;}
End;

Procedure DoBeeper;
Begin
  With CurrentBeep^ Do
    If TicCount = 0 Then Begin { start }
      TicCount := BeepSet^[ SetIndex ].TicSound;
      Sound( BeepSet^[ SetIndex ].Hertz );
    End Else Begin
      Dec( TicCount );
      If TicCount = 0 Then Begin
        Inc( SetIndex );
        If SetIndex = SetLength Then Begin
          Dec( SeqsCount );
          If SeqsCount > 0 Then
            SetIndex := 0
          Else Begin
            NoSound;
            BeeperOn := False;
            Exit;
          End;
        End;
        TicCount := BeepSet^[ SetIndex ].TicSound;
        If BeepSet^[ SetIndex ].Hertz > 0 Then
          Sound( BeepSet^[ SetIndex ].Hertz )
        Else
          NoSound;
      End;
    End;
End;

procedure CallOldIsr(OldIsr : Pointer);
  {-Call previous ISR from an interrupt procedure. Destroys BX.}
  inline(
    $89/$E3/                 {mov bx,sp        ;set up stack frame}
    $9C/                     {pushf            ;push flags to simulate int}
    $36/$FF/$1F/             {call far ss:[bx] ;call OldIsr}
    $81/$C4/$04/$00);        {add sp,4         ;get rid of OldIsr}

Procedure CntTimerTic; Interrupt;
Var i : Byte;
Begin
  TimerList := TimerTop;
  While TimerList <> Nil Do Begin
    With TimerList^ Do Begin
      If Timer^ > 0 Then
        Dec( Timer^ )
      Else Begin
        If Done <> Nil Then
          Done^ := True;
      End;
      Dec(Cnt18);
      If Cnt18 = 0 Then Begin
        Cnt18 := 18;
        If (ScreenPos > 0) And (Timer^>=0) Then Begin
          Str( Timer^ / TicsInASec :4:0, TmpStr);
          For i := 0 To Pred(Length(TmpStr)) Do Begin
            {If TmpStr[i+1] = ' ' Then
              TmpStr[i+1] := '0';}
            Screen[ScreenPos+i].Ch := TmpStr[i+1];
          End;
        End;
      End;
    End;
    TimerList := TimerList^.Next;
  End;
  If BeeperOn Then Begin
    Inc( InBeep );
    DoBeeper;
    Dec( InBeep );
  End;
  CallOldIsr( OldTimerTicIsr );
End;

Procedure AddDnTimerDone( Var T:LongInt; TimeDone:PBoolean; Sec:Real );
Begin
  Cli;
  New( TimerList );
  With TimerList^ Do Begin
    Timer := @T;
    Done := TimeDone;
    If Done <> Nil Then
      Done^ := False;
    ScreenPos := 0;
    Next := TimerTop;
  End;
  TimerTop := TimerList;
  T := Round( TicsInASec * Sec );
  Sti;
End;

Procedure AddDnTimer( Var T:LongInt; Sec:Real );
Begin
  AddDnTimerDone( T, Nil, Sec );
End;

Procedure AddDnTimerXY( Var T:LongInt; Sec:Real; x,y:Byte );
Begin
  AddDnTimer( T, Sec );
  With TimerTop^ Do Begin
    ScreenPos := (x-1)+(y-1)*80;
    Cnt18 := 1;
  End;
End;

Procedure SetDnTimer( Var T:LongInt; Sec:Real );
Begin
  T := Round(Sec * TicsInASec);
End;

Function  GetDnTimer( T:LongInt ):Real;
Begin
  GetDnTimer := T / TicsInASec;
End;

{ Safe area }
Var OldExitProc : Pointer;

Procedure CntExitProc;
Var i : Byte;
Begin
  ExitProc := OldExitProc;
  i := 0;
  While (InBeep > 0) And (i<18) Do
    Inc(i);
  If (MemL[0:IntTTic*4]=LongInt(@CntTimerTic))
     And (OldTimerTicIsr <> Nil) Then Begin
    SetIntVec( IntTTic, OldTimerTicIsr );
    OldTimerTicIsr := Nil;
  End;
  NoSound;
End;

Begin
  OldExitProc := ExitProc;
  ExitProc := @CntExitProc;
  SimpleBeep.BeepSet := @SimpleSet;
  ErrorBeep.BeepSet := @ErrorSet;
  SuccessBeep.BeepSet := @SuccessBeepSet;
  SmartBeep.BeepSet := @SmartSet;
  CurrentBeep := @SimpleBeep;
  InBeep := 0;
  GetIntVec( IntTTic, OldTimerTicIsr );
  SetIntVec( IntTTic, @CntTimerTic );
End.
