{$G-,S-,R-,I-}
{-$DEFINE TEST}

{$IFDEF TEST}
Program CpuId;
{$ELSE}
Unit CpuId;

Interface
{$ENDIF}

Const
  ProtectedMode : Boolean = False;
  CpuStr : Array[1..5] Of String[5] = ('8088','80286','80386','80486','80586');

Var
  CPUType : Byte;

{$IFNDEF TEST}
{Returns Cputype }

Function GetCPU : Byte;
Function InProtectedMode : Boolean;

Implementation
{$ENDIF}

Type
  Str8 = String[8];

Function HexLong(L: LongInt) : Str8;
const
 hexChars: array [0..$F] of Char =
   '0123456789ABCDEF';
Var
  LL : Array[0..3] Of Byte Absolute L;
  i : Byte;
begin
  HexLong[0] :=#8;
  For i := 0 To 3 Do Begin
    HexLong[i*2+1] := hexChars[LL[3-i] shr 4];
    HexLong[i*2+2] := hexChars[LL[3-i] and $F];
  End;
End;

Const
  i8088   = 1;
  i80286  = 2;
  i80386  = 3;
  i80486  = 4;
  i80586  = 5;

{$L CPUID.OBJ}
{$F+}
Function GetCPU: Byte;              External;
Function InProtectedMode : Boolean; External;
{$F-}

Const
  MinCpu = i80286;
Var
 Reg_eAX : Longint;

Begin
  CPUType := GetCPU;
  {$IFNDEF TEST}
  If CPUType < MinCPU Then Begin
    Writeln('Need an ', CpuStr[MinCpu], '-compatible system to run this program');
    Halt(1);
  End;
  {$ENDIF}
  If CpuType > i80286 Then
    ProtectedMode := InProtectedMode;
  {$IFDEF TEST}
  Write(CpuStr[CPUType], ' in ');
  If ProtectedMode Then
    Write('Protected Mode')
  Else
    WriteLn('Real Mode');
  If CPUType = i80586 Then
     WriteLn(' eAX = ', HexLong(Reg_eAX));
  {$ENDIF}
End.

