{$G+,S-,R-,I-}
Unit DosX;

Interface

Uses Strings;

{$IFDEF WINDOWS}
   Uses WinProcs;
{$ENDIF}
{
 DiskFree: Returns ExtendedDosError, full compatibel with Dos.Diskfree
 DiskSize: Returns ExtendedDosError, full compatibel with Dos.DiskSize
 RemovableDevice: Returns 0 Removable, 1 Fixed, $F Invalid drive
 GetClusterSize                              1/6-92
 GetBootDrive                                8/3-93
 GetLogicalDrive  Returns ExtendedDosError  10/3-93
 SetLogicalDrive  Returns ExtendedDosError  10/3-93
 GetSystemSectors                           6/10-93
 DosSectorToCluster                         6/10-93
 DosSector                                  6/10-93
 ClusterToDosSector                         8/10-93
 DosSectorToPhysSector                      8/10-93
 GetCountryInfo                            26/11-93
 AbsRead                                   14/12-93
 AbsWrite                                  14/12-93
 Win386 :  Returns True if Windows is running in 386ENH
 SmartDrvInstalled Returns True if SmartDrv is present
 GetFatType                                 3/08-94

 Convert from Track, Head, Sector -> Physical DosSector
 DosSector = Track*Sectors*Heads+Head*SectorsTrack+Sector-1

 Convert from DosSector -> Cluster
 Cluster = (DosSector-SysSectors) Div SectorCluster + 2

 SysSectors = HiddenSectors (Partition Table) + BootSector + FatSector*FATs + RootDirEnt Div 16

 Physical.DiskSize = Tracks*Heads*SectorsTrack*BytesSector;
                   = Sectors*BytesSector

 DiskSize =   Physical.DiskSize - SysSectors*BytesSector

 ClusterSize = BytesSector*Sec_Sector

 DeviceParamsC : Array[0..4] Of TDeviceParams = (
   180K :  (0, 1, 2, 40, 0, 512, 1, 1, 2, 64,  360,  252, 2,  9, 1, 0, 0)
   320K :  (0, 1, 2  40, 0, 512, 2, 1, 2, 112, 640,  255, 1,  8, 2, 0, 0)
   360K :  (0, 1, 2, 40, 0, 512, 2, 1, 2, 112, 720,  253, 2,  9, 2, 0, 0)
   720K :  (0, 7, 2, 80, 0, 512, 2, 1, 2, 112, 1440, 249, 3,  9, 2, 0, 0)
   1.20M:  (0, 1, 2, 80, 0, 512, 1, 1, 2, 224, 2400, 249, 7, 15, 2, 0, 0)
   1.44M:  (0, 7, 2, 80, 0, 512, 1, 1, 2, 224, 2880, 240, 9, 18, 2, 0, 0)
   2.88M:  (0, 9, 2, 80, 0, 512, 2, 1, 2, 240, 5760, 240, 9, 36, 2, 0, 0)
}

Type
  DiskTypeRec = Record
    S  : String[5];
    C  : LongInt;
    SH : Byte;
    ST : Byte;
    DP : Array[1..24] Of Byte;
  End;

Const
  { IOCTL Commands }
  SetDevice      = $840; { Set device parameters }
  GetDevice      = $860; { Get device parameters, Physical parameters !!! }
  WriteTrack     = $841; { Write Track on logical device }
  ReadTrack      = $861; { Read Track on logical device }
  FormatTrack    = $842; { Format and verify Track on logical device }
  VerifyTrack    = $862; { Verify Track on logical device }
  SetMediaId     = $846; { Set Media Info }
  GetMediaId     = $866; { Get Media Info }
  SetFlagStatus  = $847; { Set access flag status }
  GetFlagStatus  = $867; { Get access flag status }
  SenseMediaType = $868;

  Disktypes = 7;
  DiskSizeList : Array[0..Pred(Disktypes)] Of DiskTypeRec = (
   (S: ' 320K'; C: (40*2*8)*512;  SH: 0; ST: 0;
    DP: (0,1,2,0,40,0,0,0,2,2,1,0,2,112,0,128, 2,255,1,0, 8,0,2,0)),
   (S: ' 360K'; C: (40*2*9)*512;  SH: 0; ST: 0;
    DP: (0,1,2,0,40,0,0,0,2,2,1,0,2,112,0,208, 2,253,2,0, 9,0,2,0)),
   (S: '1.20M'; C: (80*2*15)*512; SH: 1; ST: 3;
    DP: (0,1,2,0,80,0,0,0,2,1,1,0,2,224,0, 96, 9,249,7,0,15,0,2,0)),
   (S: ' 720K'; C: (80*2*9)*512;  SH: 1; ST: 2;
    DP: (0,7,2,0,80,0,0,0,2,2,1,0,2,112,0,160, 5,249,3,0, 9,0,2,0)),
   (S: '1.44M'; C: (80*2*18)*512; SH: 1; ST: 3;
    DP: (0,7,2,0,80,0,0,0,2,1,1,0,2,224,0, 64,11,240,9,0,18,0,2,0)),
   (S: '1.72M'; C: (82*2*21)*512; SH: 0; ST: 0;
    DP: (0,7,2,0,82,0,0,0,2,1,1,0,2,224,0, 116,13,240,10,0,21,0,2,0)),
   (S: '2.88M'; C: (80*2*36)*512; SH: 0; ST: 0;
    DP: (0,9,2,0,80,0,0,0,2,2,1,0,2,240,0,128,22,240,9,0,36,0,2,0))
  );
  ExtendedDosError : Byte = 0;

Type

  {
    For reference see  IBM DOS Technical Reference
    p 6-168 - 6-181

    GetDevice
    DeviceParams.SpecFunc,
        bit 0 = 0          Retrieves info about the default medium
        bit 0 = 1          Retrieves info about current medium in drive
        bit 1-7 = 0
    SetDevice
    DeviceParams.SpecFunc,
        bit 0 = 1          Build BPB request return DeviceBPB
        bit 1 = 1          Ignore all fields in ParameterBL except TrackLayout
        bit 2 = 1          TrackLayout is sequvential, no interleave
        bit 3-7 = 0

    FormatBlock.SpecFunc,
        bit 0 = 1          Format status check call
        bit 0 = 0          Format / Verify track call
        bit 1-7 = 0


  }

  CountryType = (ctUSA, ctEurope, ctJapan);
  TCountry = Record
    DateFormat : Word;
    CurrencySymbol : Array[0..4] Of Char;
    ThousandSep : Array[0..1] Of Char;
    DecimalSep : Array[0..1] Of Char;
    DateSep : Array[0..1] Of Char;
    TimeSep : Array[0..1] Of Char;
    CurrencyFormat : Byte;
    CurrencySignificant : Byte;
    TimeFormat : Byte;
    UpCaseFunc : Function : Char;
    DataListSep : Array[0..1] Of Char;
    Reserved : Array[0..9] Of Byte;
  End;

  PDeviceParams = ^DeviceParams;
  DeviceParams = Record
    SpecFunc      : Byte;
    DeviceType    : Byte;
    DeviceAttr    : Word;                 { Bit 0: Removable Device, Bit 1: ChangeLine support }
    Tracks        : Word;
    MediaType     : Byte;
    { DeviceBPB }
    BytesSector   : Word;                 { Bytes per Sector }
    Sec_Cluster   : Byte;                 { Sectors per Cluster }
    ResSectors    : Word;                 { Reserved sectors, BootRecord }
    FATs          : Byte;                 { Number of FATs }
    RootDirEnt    : Word;                 { Root dir entries }
    Sectors       : Word;                 { Total Sectors }
    Media         : Byte;                 { Media Descriptor }
    FatSectors    : Word;                 { Sectors per FAT }
    SectorsTrack  : Word;                 { Sectors per Track }
    Heads         : Word;                 { Heads }
    HiddenSectors : LongInt;              { Hidden Sectors,  Partition }
    HugeSectors   : LongInt;              { Reserved_1  DOS 3.20 / HugeSectors DOS 5.0}
    Reserved      : Array[0..5] Of Byte;  { Reserved_2  DOS 3.20 }
    { TrackLayout }
    SectorCount   : Word;                 { = SectorsTrack }
    TrackLayout   : Array[1..64*2] Of Word;
  End;
  ReadWriteBlock = Record
    SpecFunc      : Byte;                 { Must be 0 }
    Head          : Word;                 { 0..Pred(Heads) }
    Track         : Word;                 { 0..Pred(Tracks) }
    FirstSector   : Word;                 { Sector 0..Pred(sectors/track) }
    Sectors       : Word;                 { No Of Sectors to R/W }
    Buffer        : Pointer;              { Transfer addres }
  End;
  FormatBlock = Record
    SpecFunc      : Byte;                 { Must be 0 to format or verify }
    Head          : Word;                 { same as ReadWriteBlock }
    Track         : Word;                 {         do             }
  End;
  MediaInfoBlock = Record
    InfoLevel     : Word;
    SerialNum     : LongInt;
    VolLabel      : Array[0..10] Of Char; { ASCIIZ }
    FileSysType   : Array[0..7] Of Char;  { ASCIIZ }
  End;

  DirEntryRec = Record
    Name            : Array[0..10] Of Char;
    Attr            : Byte;
    Reserved        : Array[0..9] Of Byte;
    Time            : Word;
    Date            : Word;
    StartingCluster : Word;
    Size            : LongInt;
  End;

  TPhysSector = Record
    Head          : Word;                 { 0.. }
    Track         : Word;                 { 0.. }
    FirstSector   : Word;                 { Sector 0.. }
  End;
  DriveRec = Record
    Sector_Cluster : Byte;
    Bytes_Sector   : Word;
    Cluster        : Word;
    Media          : Byte;
  End;
  TControlPacket = Record        { For INT 25h / INT 26h }
    Sector : LongInt;
    Count  : Word;
    Buffer : Pointer;
  End;
  TFAT = (Fat12, Fat16);
  PZeroArray     = ^ZeroArray;
  ZeroArray      = Array[0..100] Of Byte;


Const
  WriteProtected = $13;
  DriveNotReady = $15;
  DiskDataError  = $17;
  UnknownMediaType = $1A;
  SectorNotFound   = $1B;
  NotFormatted = $1F;
Const
  BAD : Word = $FF7;              { 12 bit FAT }
  EndOfFile : Word = $FFF;        { for 16 bit FAT, add  $F000 }
  FatType : TFat = Fat12;
  FatSize : Word = 8*1024;


Var
  DeviceP    : PDeviceParams;
  RWBlock    : ReadWriteBlock;
  FVBlock    : FormatBlock;
  MediaBlock : MediaInfoBlock;
  FatInfo    : DriveRec;
  SenseMedia : Array[0..1] Of Byte;
  PhysSector : TPhysSector;

Procedure GetCountryInfo(Var CI );                       { Function 38h }
Function  ExtendedError(n :Byte) : String;
Function  IoError(n :Byte) : String;
Procedure SetDefaultDrive(Var Drive : Byte);             { Function 0Eh }
Function  GetDefaultDrive : Byte;                         { Function 19h }
Procedure GetFatInfo(Var DP: DriveRec; Drive :Byte);
Function  DiskFree(Drive : Byte) : LongInt;               { Function 36h }
Function  DiskSize(Drive : Byte) : LongInt;               { Function 36h }
Function  MemAvailable : LongInt;                         { Function 48h }
Function  GetClusterSize(Drive : Byte) : Word;            { Function 1Ch }
Function  GetBootDrive : Byte;                            { Function 3305h }
Procedure InitTrackLayout(Var DP : DeviceParams);
Function  RemovableDevice(Drive : Byte) : Byte;                { 4408h }
Function  GetDeviceInfo(Drive : Byte) : Word;                  { 4409h }
Procedure GenIoctlReq(Drive:Byte; Func:Word; Var ParamBlock); { 440Dh }
Function  GetLogicalDrive(Drive : Byte): Word;                 { 440Eh }
Function  SetLogicalDrive(Drive : Byte): Word;                 { 440Fh }
Function  QueryIOCTL(Drive: Byte; Func : Word) : Boolean;      { 4411h }
Function  DosSector(DP:PDeviceParams; Track, Head, Sector : Word) : LongInt;
Function  DosSectorToCluster(DP:PDeviceParams; DS:LongInt) : Word;
Function  ClusterToDosSector(DP:PDeviceParams; Cluster:Word) : LongInt;
Procedure DosSectorToPhysSector(DP:PDeviceParams; DS: Longint; Var PS :TPhysSector);
Function  GetSystemSectors(DP:PDeviceParams) : Word;
Procedure AbsRead(Drive:Byte; Var P : TControlPacket);
Procedure AbsWrite(Drive:Byte; Var P : TControlPacket);
Function  Win386 : Boolean;
Function  SmartDrvInstalled : Boolean;
Function  GetFatType(DP : PDeviceParams) : TFat;  { 3-8-94 }


Implementation

Const
  ExtendedErrorMsg : Array[0..27] Of PChar = (
    { $02 } 'File not found',
    { $03 } 'Path not found',
    { $04 } 'No handle available',
    { $05 } 'Access denied',
    { $06 } 'Invalid handle',
    { $07 } 'Memory control blocks destroyed',
    { $08 } 'Insufficient memory',
    { $09 } 'Invalid memory block address',
    { $0E } 'Reserved',
    { $0F } 'Invalid drive specification',
    { $10 } 'Attempt to remove current dir.',
    { $11 } 'Not same device',
    { $12 } 'No more files',
    { $13 } 'Disk write-protected',
    { $14 } 'Unknown unit',
    { $15 } 'Drive not ready',
    { $17 } 'Disk data error (CRC)',
    { $18 } 'Bad request structure length',
    { $19 } 'Seek error',
    { $1A } 'Unknown media type',
    { $1B } 'Sector not found',
    { $1D } 'Write fault',
    { $1E } 'Read fault',
    { $1F } 'Disk not formatted',
    { $20 } 'File sharing violation',
    { $21 } 'File locking violation',
    { $22 } 'Invalid disk change',
            'Unknown Dos error'
  );



Function SmartDrvInstalled : Boolean; Assembler;
Asm
        push	bp
	mov	ax,4A10h
	mov	bx,0
	int	2Fh			{; ??INT Non-standard interrupt}
	cmp	ax,0BABEh
        jne	@Exit
        mov	bx,1
@Exit:
        mov     ax,bx
        pop	bp
End;

Function Win386 : Boolean; Assembler;
Asm
  { Check to see If we are running in Windows Enhanced }
  mov ax, 1600h
  int 2fh
  mov ah, False
  cmp al, 00h
  je  @NotEnhWin
  cmp al, 80h
  je  @NotEnhWin
  cmp al, 01h
  je  @NotEnhWin
  cmp al, 0FFh
  je  @NotEnhWin
  mov ah, True
@NotEnhWin:
  mov al, ah
End;


Procedure AbsRead(Drive:Byte; Var P : TControlPacket); Assembler;
Asm
  MOV   AL, Drive
  PUSH  DS
  LDS   BX, P
  MOV   CX, 0FFFFh     { Extended format DOS 4+ ,  Partition > 32 MB }
  INT   25h
  POPF                 { DOS leaves Flags on Stack }
  POP   DS
End;

Procedure AbsWrite(Drive:Byte; Var P : TControlPacket); Assembler;
Asm
  MOV   AL, Drive
  PUSH  DS
  LDS   BX, P
  MOV   CX, 0FFFFh
  INT   26h
  POPF
  POP   DS
End;

Procedure GetCountryInfo(Var CI); Assembler;
Asm
  PUSH  DS
  MOV   AX, 3800h
  LDS   DX, CI
{$IFNDEF WINDOWS}
  INT	21h
{$ELSE}
  CALL	DOS3CALL
{$ENDIF}
  POP   DS
End;


Function GetFatType(DP : PDeviceParams) : TFat;  { 3-8-94 }
Var
  Clusters, TotalSectors : Word;
Begin
  With DP^ Do Begin
    TotalSectors := Sectors;
    If TotalSectors = 0 Then
      TotalSectors := HugeSectors;
    Clusters := (TotalSectors-GetSystemSectors(DP)) Div Sec_Cluster;
  End;
  If Clusters < 4095 Then
    GetFatType := Fat12
  Else
    GetFatType := Fat16;
End;


Procedure DosSectorToPhysSector(DP:PDeviceParams; DS:Longint; Var PS:TPhysSector);
Begin
  With DP^ Do Begin
    PS.FirstSector := DS Mod SectorsTrack;
    PS.Head := (DS Div SectorsTrack) Mod Heads;
    PS.Track := DS Div (LongInt(SectorsTrack) * Heads);
  End;
End;

Function ClusterToDosSector(DP:PDeviceParams; Cluster:Word) : LongInt;
Begin
  With DP^ Do
    ClusterToDosSector := (Cluster-2)*LongInt(Sec_Cluster)+GetSystemSectors(DP);
End;

Function GetSystemSectors(DP:PDeviceParams) : Word;
{ Returns systemsectors (sectors ocupied by Partition, Boot, Fat and RootDir }
Begin
  With DP^ Do
    GetSystemSectors := HiddenSectors+ResSectors+FatSectors*Fats+RootDirEnt
       Div (BytesSector Div SizeOf(DirEntryRec));
End;

Function DosSector(DP:PDeviceParams; Track, Head, Sector : Word) : LongInt;
{ Converts Track, Head, Sector -> DosSector }
Begin
  With DP^ Do
    DosSector := Head*SectorsTrack+Track*SectorsTrack*Heads+Sector;
End;

Function DosSectorToCluster(DP:PDeviceParams; DS:LongInt) : Word;
{ Converts DosSector to Cluster }
Begin
  With DP^ Do
    DosSectorToCluster := (DS-GetSystemSectors(DP)) Div Sec_Cluster + 2;
End;

Procedure GetError; Assembler;
Asm
      	PUSH	AX
      	MOV	AH, 59h
      	XOR	BX, BX
{$IFNDEF WINDOWS}
        INT	21h
{$ELSE}
        CALL	DOS3CALL
{$ENDIF}
      	CMP	AL, 0
      	JE	@GE1
       	MOV	ExtendedDosError, AL
@GE1:   POP	AX
End;

Procedure SetDefaultDrive(Var Drive : Byte); Assembler;
Asm
        MOV	AH, 0Eh
        LES	DI, Drive
        MOV	DL, ES:[DI]
{$IFNDEF WINDOWS}
        INT	21h
{$ELSE}
       	CALL	DOS3CALL
{$ENDIF}
        MOV	ES:[DI], AL			{ No of Logical drives LASTDRIVE}
End;

Procedure GetFatInfo(Var DP: DriveRec; Drive :Byte); Assembler;
Asm
        MOV	AH, 1Ch				{ Returns DOS}
        MOV	DL, Drive			{ extend errorcode }
	INT	21h
	MOV	AH, [BX]
	LDS	DI, DP
	CMP	AL, 0FFh
	JNE	@GFI1
	CALL	GetError
	JMP	@GFI2
@GFI1:	MOV	BYTE PTR [DI], AL		{ Sector / Cluster}
	MOV	WORD PTR [DI+1], CX		{ Bytes / Sector}
	MOV	WORD PTR [DI+3], DX             { Cluster   }
	MOV	BYTE PTR [DI+5], AH		{ Media ID }
	MOV	ExtendedDosError, 0
@GFI2:
End;

Function GetDefaultDrive : Byte; Assembler;
Asm
	MOV	AH, 19h
{$IFNDEF WINDOWS}
	INT	21h
{$ELSE}
	CALL	DOS3CALL
{$ENDIF}
End;

Function DiskFree(Drive : Byte) : LongInt; Assembler;
Asm
	MOV	AH, 36h				{ AX Sector / Cluster }
	MOV	DL, Drive			{ BX free clusters    }
{$IFNDEF WINDOWS}
	INT	21h
{$ELSE}
	CALL	DOS3CALL
{$ENDIF}
	CMP	AX, -1				{ CX Bytes / Sector   }
	JNE	@DF1
	CALL	GetError
	MOV	DX, -1
	JMP	@DF2
@DF1:	MUL	CX
	MUL	BX
	MOV	ExtendedDosError, 0
@DF2:
End;

Function DiskSize(Drive : Byte) : LongInt; Assembler;
Asm
	MOV	AH, 36h			{ AX Sector / Cluster}
	MOV	DL, Drive		{ BX free clusters   }
{$IFNDEF WINDOWS}
	INT	21h
{$ELSE}
        CALL	DOS3CALL
{$ENDIF}
	CMP	AX, -1			{ CX Bytes / Sector  }
	JNE	@DS1			{ DX Max Clusters    }
	CALL	GetError
	MOV	DX, -1
	JMP	@DS2
@DS1:	MOV	BX, DX
	MUL	CX
	MUL	BX
	MOV	ExtendedDosError, 0
@DS2:
End;

Function MemAvailable : LongInt; Assembler;
Asm
	MOV	AH, 48h
	MOV	BX, 0FFFFh
	INT	21h
	MOV	AX, 10h
	XOR	DX, DX
	MUL	BX
End;

Function GetClusterSize(Drive : Byte) : Word; Assembler;
Asm
	PUSH	DS
	MOV	AH, 1Ch
	MOV	DL, Drive
{$IFNDEF WINDOWS}
	INT	21h
{$ELSE}
        CALL    DOS3CALL
{$ENDIF}
	MUL	CX
	POP	DS
End;

{Init. TrackLayout with (1,512, 2,512, 3,512  and so on  (no interleave) }
Procedure InitTrackLayout(Var DP : DeviceParams);
Type
  L = Record
    Lo : Word;
    Hi : Word;
  End;

Var
  T : LongInt;
Begin
  T := $02000001;
  With DP Do Begin
    SectorCount := SectorsTrack;
    For T := T To T+SectorsTrack-1 Do
      Move(T, TrackLayout[2*L(T).Lo-1], 4);
  End;
End;

Function GetBootDrive : Byte;  Assembler;
{ Returns Boot Drive A=1, B=2, C=3}
Asm
	MOV	AX, 3305h
{$IFNDEF WINDOWS}
	INT	21h
{$ELSE}
        CALL    DOS3CALL
{$ENDIF}
	CMP	AL, 0FFh
	MOV	AL, 0
	JE      @GB1
	MOV	AL, DL
@GB1:
End;

Function RemovableDevice(Drive : Byte) : Byte; Assembler;
{ Returns 00h Removable, 01h Fixed, 0Fh Invalid }
Asm
	MOV	AX, 4408h
	MOV	BL, Drive
{$IFNDEF WINDOWS}
	INT	21h
{$ELSE}
	CALL	DOS3CALL
{$ENDIF}
End;

Function GetDeviceInfo(Drive : Byte) : Word; Assembler;
{
  Bit 15: 1 ASSIGNed or SUBSTed drive
  Bit 12: 1 Device is local, 0 device is remote
  Bit 09: 1 Device is Network drive
}
Asm
	MOV	AX, 4409h
	MOV	BL, Drive
	MOV     ExtendedDosError, 0
{$IFNDEF WINDOWS}
	INT	21h
{$ELSE}
	CALL	DOS3CALL
{$ENDIF}
        JNC     @GDI
        CALL    GetError
@GDI:   MOV     AX, DX
End;

Procedure GenIoctlReq(Drive:Byte; Func:Word; Var ParamBlock); Assembler;
{ OS/2 in DOS-box do not support function 440Dh  (He he)

 On entry:
	AX	440Dh
	BL	Drive number (0=default, 1=A, etc.)
        CH	08h (Major code)
	CL	Minor code:
			40h = Set device parameters
			60h = Get device parameters
			41h = Write track on logical device
			61h = Read track on logical device
			42h = Format and verify track on logical device
			62h = Verify track on logical device
	DS:DX	Pointer to parameter block
}
Asm
	MOV     ExtendedDosError, 0
        PUSH    DS
	MOV	AX, 440Dh
	MOV	BX, Word PTR Drive
	MOV	CX, Func
	LDS	DX, ParamBlock
{$IFNDEF WINDOWS}
	INT	21h
{$ELSE}
	CALL	DOS3CALL
{$ENDIF}
        POP     DS
	JNC	@NoErr
	CALL	GetError
@NoErr:
End;
Function GetLogicalDrive(Drive : Byte): Word;            Assembler;
{ Function 440Eh (68-14)   IOCTL: Get Logical Drive                    DOS 3.2

    Returns the drive letter used most recently for block devices that
    have more than one logical drive letter.

       On entry:      AH         44h
                      AL         0Eh
                      BL         Drive number (0=default, 1=A, etc.)

       Returns:       AL         00h if only one letter is assigned to the
                                          block device
                                 Drive letter used most recently (1 = A,
                                          2 = B, etc.)
                      AX         Error code, if CF is set }
Asm
	MOV	AX, 440Eh
	MOV	BL, Drive
	MOV	ExtendedDosError, 0
{$IFNDEF WINDOWS}
	INT	21h
{$ELSE}
	CALL	DOS3CALL
{$ENDIF}
	JNC	@GLD1
	CALL	GetError
@GLD1:

End;
Function SetLogicalDrive(Drive : Byte): Word;            Assembler;
{Function 440Fh (68-15)   IOCTL: Set Logical Drive                    DOS 3.2

    Sets the drive letter used most recently to refer to a device that has
    more than one drive letter.

       On entry:      AH         44h
                      AL         0Fh
                      BL         Drive number (0=default, 1=A, etc.)

       Returns:       AL         00h of only one letter is assigned to the
                                          block device
                                 Highest letter assigned to block device
                                          (1 = A, 2 = B, etc.)
                      AX         Error code if CF is set }
Asm
	MOV	AX, 440Fh
	MOV	BL, Drive
 	MOV	ExtendedDosError, 0
{$IFNDEF WINDOWS}
	INT	21h
{$ELSE}
	CALL	DOS3CALL
{$ENDIF}
	JNC	@SLD1
	CALL	GetError
@SLD1:
End;
Function QueryIOCTL(Drive: Byte; Func : Word) : Boolean; Assembler;
Asm
	MOV	AX, 4411h
	MOV	BL, Drive
	MOV	CX, Func
        MOV     BH, True
	MOV	ExtendedDosError, 0
{$IFNDEF WINDOWS}
	INT	21h                             { DOS 5+ Only }
{$ELSE}
	CALL	DOS3CALL
{$ENDIF}
        JNC	@QI
	CALL	GetError
	MOV	BH, False
@QI:
        MOV	AL, BH
End;

{Converts exdended DOS errors }
Function ExtendedError(n :Byte) : String;
Var
  idx : Byte;
Begin
  Case n Of
    $02..$09 : idx := n - 2;
    $0E..$15 : idx := n - 6;
    $17..$1B : idx := n - 7;
    $1D..$22 : idx := n - 8;
  Else
    idx := 27;
  End;
  ExtendedError := StrPas(ExtendedErrorMsg[idx]);
End;

{ Converts Runtime errors to dos errors}
Function IoError(n : Byte) : String;
Var
  idx : Byte;
Begin
  Case n Of
    $02..$03 : Idx := n - 2;
  End;
  IoError := StrPas(ExtendedErrorMsg[idx]);
End;

End.

