{$S-,R-,I-}
Unit Parsecom;
Interface

Uses
  {$IFDEF Windows}
   WinDos,
   Dos2Win;
  {$ELSE}
   Dos;
  {$ENDIF}

Const
  NoOfParamCt = 20;
  ParamCt : Byte = 0;

Type
  FileT = Array[1..NoOfParamCt] Of Byte;
Var
  ParamString : Array[0..NoOfParamCt] Of ^String;
  FileNo : FileT;

Procedure SplitCommandTail;

Implementation

Procedure SplitCommandTail;
Const
  i : Byte = 1;
  n : Byte = 1;
  Forced : Boolean = False;

Var
  CommandTail : ^String;
  s, CT  : String;
  Dir : DirStr;
  Name : NameStr;
  Ext : ExtStr;
  LenCT : Byte;
  j : Byte;
Begin
{$IFDEF WINDOWS}
  CT := '';
  For j := 1 To ParamCount Do
    CT := CT + ParamStr(j) + ' ';
{$ELSE}
  CommandTail := Ptr(PrefixSeg,$0080);
  CT := CommandTail^;
{$ENDIF}
  LenCT := Length(CT);
  FSplit(Fexpand(ParamStr(0)), Dir, Name, Ext);
  GetMem(ParamString[0], Succ(Length(Dir+Name+Ext)));
  ParamString[0]^ := Dir+Name+Ext;
  s := GetEnv(Name);
  If s <> '' Then
    CT := s + ' ' + CT;
  FillChar(FileNo, SizeOf(FileNo), 0);
  While i < Length(CT) Do Begin
    Inc(ParamCt);
    While (CT[i]=' ') And (i<=Length(CT)) Do Inc(i);
    s := '';
    If CT[i] <> '/' Then
      While (CT[i]<>' ') And (CT[i] <> '/') And
	(i<=Length(CT)) Do Begin
	s := s + UpCase(CT[i]);
	Inc(i);
      End
    Else
      Repeat
	s := s + UpCase(CT[i]);
	Inc(i);
      Until (CT[i] In[' ', '/']) Or (i > Length(CT));
    If s <> '' Then Begin
      If (s[1] <> '/') Then Begin
	If (i-Length(s) > Length(CT)-LenCT) And Not Forced Then Begin
	  FillChar(FileNo, SizeOf(FileNo), 0);
	  n := 1;
	  Forced := True;
	End;
	FileNo[n] := ParamCt;
	Inc(n);
      End;
      If s[1] = '.' Then s := s + '\';
      GetMem(ParamString[ParamCt], Length(s)+1);
      ParamString[ParamCt]^ := s;
    End
    Else
      Dec(ParamCt);
  End;
End;

Begin
  SplitCommandTail;
End.
