/* $RCSfile: dir.h $$Revision: 1.2 $$Date: 92/11/10 10:39:19 $
 *
 *    (C) Copyright 1987, 1990 Diomidis Spinellis.
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * [ Marc Pawlowsky, November 1992 ]
 * Modified for Metawares High C compiler.
 * Removed use of cdecl, and added inclusion of stat.h.
 * 
 * Revision 4.0.1.1  91/06/07  11:22:10  lwall
 * patch4: new copyright notice
 * 
 * Revision 4.0  91/03/20  01:34:20  lwall
 * 4.0 baseline.
 * 
 * Revision 3.0.1.1  90/03/27  16:07:08  lwall
 * patch16: MSDOS support
 * 
 * Revision 1.1  90/03/18  20:32:29  dds
 * Initial revision
 *
 *
 */

/*
 * defines the type returned by the directory(3) functions
 */

#ifndef __DIR_INCLUDED
#define __DIR_INCLUDED

#ifdef __HIGHC__
    #include <stat.h>
#endif

/*Directory entry size */
#ifdef DIRSIZ
#undef DIRSIZ
#endif
#define DIRSIZ(rp)	(sizeof(struct direct))

/*
 * Structure of a directory entry
 */
struct direct	{
	ino_t	d_ino;			/* inode number (not used by MS-DOS) */
	int	d_namlen;		/* Name length */
	char	d_name[13];		/* file name */
};

struct _dir_struc {			/* Structure used by dir operations */
	char *start;			/* Starting position */
	char *curr;			/* Current position */
	struct direct dirstr;		/* Directory structure to return */
};

typedef struct _dir_struc DIR;		/* Type returned by dir operations */

#ifdef __HIGHC__
  DIR *opendir(char *filename);
#else
  DIR *cdecl opendir(char *filename);
#endif

struct direct *readdir(DIR *dirp);
long telldir(DIR *dirp);
void seekdir(DIR *dirp,long loc);
void rewinddir(DIR *dirp);
void closedir(DIR *dirp);

#endif /* __DIR_INCLUDED */
