/*                                TForm 1.0
	A simple text formatting program that replaces a single ASCII value
	with any number of other ASCII chars.  Features to be added in v2:
		1) search for multiple char (and replace)
		2) support char cmd line args
		3) allow option of outputfile or overwrite
		4) be able to search and replace EOF (right!)
		5) prompt before change option

	Bill Menees -- Cup of Fungus Software -- 11/3/93
*/

#include <stdio.h>
#include <stdlib.h>
#define TEMPNAME "1$2$3$4$.5$6"

void main(int argc, char *argv[])
{
	int ch, fromnum, i;
	char buffer[20];
	FILE *textin, *textout;

	if(argc<4) {
		printf("TForm 1.0 - A simple text formatter and character search and replace.\n");
		printf("Bill Menees -- (c) Cup of Fungus Software -- 11/3/93\n");
		printf("\nYou pass TForm a filename to format, the ASCII code of the char to\n");
		printf("replace, and any number of characters to replace it with.\n");
		printf("Primarily intended to be used from a batch file.  Output is in file\n");
		printf("%s which can then be copied over the input file and deleted.\n", TEMPNAME);
		printf("\n---Handy ascii values:---\n");
		printf("Tab=09, Linefeed=10, Formfeed=12, CarriageReturn=13, Space=32;\n");
		printf("'0'=48, ..., '9'=57; 'A'=65, ..., 'Z'=90; 'a'=97, ..., 'z'=122;\n");
		printf("\nSPECIAL VALUE FOR DELETION: -1\n");
		printf("\nUsage: tform filename fromnumber tonumber(s)\n");
		printf("\nExample: \"tform test.txt 13 -1\" will delete\n");
		printf("all carriage returns in the file test.txt.\n");
		exit(1); /* too few args */
	}

	if((textin=fopen(argv[1],"rb"))==NULL) {
		printf("Unable to open input file %s\n", argv[1]);
		exit(2);
	}
	if((textout=fopen(TEMPNAME,"wb"))==NULL) {
		printf("Unable to open temporary output file\n");
		exit(3);
	}

	fromnum=atoi(argv[2]);
	while((ch=fgetc(textin))!=EOF) {	/* won't be able to trap EOF this way */
		if(ch!=fromnum) fputc(ch, textout);
		else for(i=3;i<argc;i++)
				if((atoi(argv[i])>-1) && (atoi(argv[i])<256)) fputc(atoi(argv[i]), textout);
	}
	fclose(textin);
	fclose(textout);
 /*	sprintf(buffer, "del %s", argv[1]);
	system(buffer);
	rename(TEMPNAME, argv[1]);  if uncommented new will overwrite old */
	exit(0);
}
