import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;
import java.io.*;
import com.jpackages.jflashplayer.*;

/**
 * Example code using JFlashPlayer
 * Copyright (c) 2001-2007
 * Company: VersaEdge Software, LLC
 */

public class Example1 extends JFrame implements FlashPanelListener {  
  // handle to main FlashPanel
  FlashPanel flashPanel;

  // FlashPanelListener event method from Flash
  public void FSCommand(String command, String arg) {
    System.out.println("java FSCommand " + command + " " + arg);

    if (command.equals("javaLink")) {
      try {
        Runtime.getRuntime().exec("explorer " + arg);
      } catch (Exception e) {}
    }
    else if (command.equals("javaExecute")) {
      JOptionPane.showMessageDialog(this, "Flash events can be passed along to java");
    }
    
  }

  public Example1() {
    // initialize GUI
    try {
      jbInit();
      initJFlash();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  // display a welcome flash animation in a JDialog
  private static void showWelcome() {
    // if the required flash version is not available, try to install one
    // Flash.ocx is not provided.  See documentation on where you can locate it.
    try {
      if (!FlashPanel.hasFlashVersion("6")) {
        boolean b = FlashPanel.installFlash(new File("Flash9b.ocx"));
        System.out.println("installed flash: " + b);
      }
    } catch (JFlashLibraryLoadFailedException e) {
      System.out.println(e);
    }

    // before constructing a FlashPanel, specify the required flash version for the flash animation
    FlashPanel.setRequiredFlashVersion("5");
    // create an alternate image to display on any errors
    Image imageWelcome = getImageOfString("Welcome", Color.blue);
    // construct a FlashPanel displaying the welcome.swf flash animation
    FlashPanel welcomePanel = new FlashPanel(new File("example/welcome.swf"), imageWelcome);
    // disable animation looping
    welcomePanel.setLoop(false);
    JPanel jPanelWelcome = new JPanel(new BorderLayout());
    jPanelWelcome.add(welcomePanel, BorderLayout.CENTER);
    jPanelWelcome.setPreferredSize(new Dimension(200, 150));
    JOptionPane.showMessageDialog(null, jPanelWelcome, "Welcome To JFlashPlayer", JOptionPane.PLAIN_MESSAGE);
  }

  // initialize the main FlashPanel
  private void initJFlash() {
    // create an alternate image to display on any errors
    Image image1 = getImageOfString("No Flash", Color.black);

    // construct a FlashPanel displaying the Movie.swf flash animation
    flashPanel = new FlashPanel(new File("example/Movie.swf"), image1, true);
    this.getContentPane().add(flashPanel, BorderLayout.CENTER);
    flashPanel.addFlashPanelListener(this);
  }

  // Swing GUI components
  JPanel jPanel1 = new JPanel();
  BorderLayout borderLayout1 = new BorderLayout();
  JButton jButtonPlay = new JButton();
  JButton jButtonBack = new JButton();
  JButton jButtonForward = new JButton();
  JButton jButtonRewind = new JButton();
  JButton jButtonBG = new JButton();
  JCheckBox jCheckBoxLoop = new JCheckBox();
  JButton jButtonStop = new JButton();
  JButton jButton1 = new JButton();
  JButton jButton2 = new JButton();
  JButton jButtonCallFlash = new JButton();

  private void jbInit() throws Exception {
    this.setTitle("JFlashPlayer Example");
    this.setSize(400, 420);
    this.addWindowListener(new Example1_this_windowAdapter(this));
    jPanel1.setPreferredSize(new Dimension(10, 90));
    this.getContentPane().setLayout(borderLayout1);
    jButtonPlay.setText("Play");
    jButtonPlay.addActionListener(new Example1_jButtonPlay_actionAdapter(this));
    jButtonBack.setText("Back");
    jButtonBack.addActionListener(new Example1_jButtonBack_actionAdapter(this));
    jButtonForward.setText("Forward");
    jButtonForward.addActionListener(new Example1_jButtonForward_actionAdapter(this));
    jButtonRewind.setText("Rewind");
    jButtonRewind.addActionListener(new Example1_jButtonRewind_actionAdapter(this));
    jButtonBG.setText("Background");
    jButtonBG.addActionListener(new Example1_jButtonBG_actionAdapter(this));
    jCheckBoxLoop.setEnabled(true);
    jCheckBoxLoop.setSelected(true);
    jCheckBoxLoop.setText("Loop");
    jCheckBoxLoop.addActionListener(new Example1_jCheckBoxLoop_actionAdapter(this));
    jButtonStop.setText("Stop");
    jButtonStop.addActionListener(new Example1_jButtonStop_actionAdapter(this));
    jButton1.setText("Current Frame?");
    jButton1.addActionListener(new Example1_jButton1_actionAdapter(this));
    jButton2.setText("Set Frame");
    jButton2.addActionListener(new Example1_jButton2_actionAdapter(this));
    jButtonCallFlash.setText("Call Flash");
    jButtonCallFlash.addActionListener(new Example1_jButtonCallFlash_actionAdapter(this));
    this.getContentPane().add(jPanel1, BorderLayout.NORTH);
    jPanel1.add(jButtonPlay, null);
    jPanel1.add(jButtonStop, null);
    jPanel1.add(jButtonBack, null);
    jPanel1.add(jButtonForward, null);
    jPanel1.add(jButtonRewind, null);
    jPanel1.add(jButtonBG, null);
    jPanel1.add(jCheckBoxLoop, null);
    jPanel1.add(jButton1, null);
    jPanel1.add(jButton2, null);
    jPanel1.add(jButtonCallFlash, null);
  }

  void this_windowClosing(WindowEvent e) {
    this.dispose();
  }

  // creates an Image displaying a String s of Color c
  static Image getImageOfString(String s, Color c) {
      BufferedImage myDemoImage = new BufferedImage(300,200,BufferedImage.TYPE_INT_ARGB);
      Graphics2D mygD = (Graphics2D)myDemoImage.getGraphics();
      mygD.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      mygD.setColor(c);
      Font DemoTopFont = new Font("Dialog",Font.BOLD,60);
      mygD.setFont(DemoTopFont);
      mygD.drawString(s,20,120);

      return myDemoImage;
  }

  void jButtonPlay_actionPerformed(ActionEvent e) {
    flashPanel.play();
    System.out.println("isPlaying: " + flashPanel.isPlaying());
  }

  void jButtonBack_actionPerformed(ActionEvent e) {
    flashPanel.back();
  }

  void jButtonForward_actionPerformed(ActionEvent e) {
    flashPanel.forward();
  }

  void jButtonRewind_actionPerformed(ActionEvent e) {
    flashPanel.rewind();
  }

  void jButtonBG_actionPerformed(ActionEvent e) {
    Color c = JColorChooser.showDialog(this, "Choose Background", flashPanel.getBackground());
    flashPanel.setBackground(c);

  }

  void jCheckBoxLoop_actionPerformed(ActionEvent e) {
    flashPanel.setLoop(this.jCheckBoxLoop.isSelected());
  }

  void jButtonStop_actionPerformed(ActionEvent e) {
    flashPanel.stop();
  }


  //Main method
  public static void main(String[] args) {
    try {
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    
    // show a welcome flash animation
    showWelcome();

    Example1 frame = new Example1();

    //Center the window
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = frame.getSize();
    if (frameSize.height > screenSize.height) {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width) {
      frameSize.width = screenSize.width;
    }
    frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    frame.setVisible(true);

  }

  // display the current frame index information
  void jButton1_actionPerformed(ActionEvent e) {
	  System.out.println("at frame #" + (flashPanel.getCurrentFrame() + 1) + " of " + flashPanel.getTotalFrames());
  }

  // set the currently displayed frame index
  void jButton2_actionPerformed(ActionEvent e) {
    String s = (String) JOptionPane.showInputDialog(this, "", "Jump to Frame #", JOptionPane.QUESTION_MESSAGE);

    try {
      long index = Long.parseLong(s);
      index--;
      flashPanel.setCurrentFrame(index);
    } catch (Exception ex) {
    }
  }


  // call actions in Flash
  void jButtonCallFlash_actionPerformed(ActionEvent e) {
    // Set the flash variable execute to true
    flashPanel.setVariable("execute", "true");

    // Call the frame actions for the first frame in the main timeline
    // the action defined in this frame is to stop the flash movie only if execute is true
    flashPanel.callFrame(0);

    // Set the flash variable execute to true
    flashPanel.setVariable("execute", "false");
  }

}

class Example1_this_windowAdapter extends java.awt.event.WindowAdapter {
  Example1 adaptee;

  Example1_this_windowAdapter(Example1 adaptee) {
    this.adaptee = adaptee;
  }
  public void windowClosing(WindowEvent e) {
    adaptee.this_windowClosing(e);
  }
}

class Example1_jButtonPlay_actionAdapter implements java.awt.event.ActionListener {
  Example1 adaptee;

  Example1_jButtonPlay_actionAdapter(Example1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButtonPlay_actionPerformed(e);
  }
}

class Example1_jButtonBack_actionAdapter implements java.awt.event.ActionListener {
  Example1 adaptee;

  Example1_jButtonBack_actionAdapter(Example1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButtonBack_actionPerformed(e);
  }
}

class Example1_jButtonForward_actionAdapter implements java.awt.event.ActionListener {
  Example1 adaptee;

  Example1_jButtonForward_actionAdapter(Example1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButtonForward_actionPerformed(e);
  }
}

class Example1_jButtonRewind_actionAdapter implements java.awt.event.ActionListener {
  Example1 adaptee;

  Example1_jButtonRewind_actionAdapter(Example1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButtonRewind_actionPerformed(e);
  }
}

class Example1_jButtonBG_actionAdapter implements java.awt.event.ActionListener {
  Example1 adaptee;

  Example1_jButtonBG_actionAdapter(Example1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButtonBG_actionPerformed(e);
  }
}

class Example1_jCheckBoxLoop_actionAdapter implements java.awt.event.ActionListener {
  Example1 adaptee;

  Example1_jCheckBoxLoop_actionAdapter(Example1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jCheckBoxLoop_actionPerformed(e);
  }
}

class Example1_jButtonStop_actionAdapter implements java.awt.event.ActionListener {
  Example1 adaptee;

  Example1_jButtonStop_actionAdapter(Example1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButtonStop_actionPerformed(e);
  }
}

class Example1_jButton1_actionAdapter implements java.awt.event.ActionListener {
  Example1 adaptee;

  Example1_jButton1_actionAdapter(Example1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton1_actionPerformed(e);
  }
}

class Example1_jButton2_actionAdapter implements java.awt.event.ActionListener {
  Example1 adaptee;

  Example1_jButton2_actionAdapter(Example1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton2_actionPerformed(e);
  }
}

class Example1_jButtonCallFlash_actionAdapter implements java.awt.event.ActionListener {
  Example1 adaptee;

  Example1_jButtonCallFlash_actionAdapter(Example1 adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButtonCallFlash_actionPerformed(e);
  }
}
