=begin

  Copyright (c) 2009 Infosoft Global Private Limited
 
=end
# Contains the error messages for the error codes
# Contains method to help build the error message 
class Fusioncharts::Exporter::ErrorHandler
    @@err_messages={
    "E100"=> "Insufficient Data.",
    "E101" => "Width/height not provided.",
    "E102" => "Insufficient export parameters.",
    "E400" => "Bad Request.",
    "E401"=> "Unauthorized Access.",
    "E403"=> "Access Forbidden.",
    "E404" => "Export Resource not found.",
    "E507" => "Insufficient Storage.",
    "E508" => "Server Directory does not exist.",
    "W509" => "File already exists.",
    "W510" => "Export handler's Overwrite setting is on. Trying to overwrite.",
    "E511" => "Overwrite forbidden. File cannot be overwritten.",
    "E512" => "Intelligent File Naming is Turned off",
    "W513" => " Background color not specified. Taking White (FFFFF) as default background color."
    }
    
  #Gets the error message for a particular code, returns nil if not found  
  def self.get_error_message(error_code)
    err_message = @@err_messages[error_code.to_s]
    return err_message
  end    
  
 
  # Sets the errors in flash object. These flash messages can later be output in error view page
  # This method should ideally be called only once in the program execution. When an error occurs and the program halts and wants to show the error
    def self.set_flash_err(error_codes,flash,is_html,meta,fileName=nil)
        if(flash[:notice]==nil)
          flash[:notice]=""
        end
        if(flash[:error]==nil)
          flash[:error]=""
        end
         err_notice_msgs=  Fusioncharts::Exporter::ErrorHandler.build_error_response(error_codes, is_html)
         #print "Notice"+err_notice_msgs["notice"]
         #print "Error"+err_notice_msgs["error"]
         flash[:notice]+=err_notice_msgs["notice"]
         
         if(!err_notice_msgs["error"].empty?) 
           # This means error has occured, hence statusCode=0
           flash[:error]+=err_notice_msgs["error"]
           flash[:error]+=(is_html ? "<br>" : "&")+"statusCode=0"
           # Values for width and height are 0 in case of error. FileName is empty.
           width ="0"
           height="0"
           displayPath=""
         else 
           # status code =1
           flash[:error]+=(is_html ? "<br>" : "&")+"statusCode=1"
           # Values for width and height in case of success. FileName is path to the file on server.
          displayPath =Fusioncharts::Exporter::Properties.HTTP_URI.gsub!(/\/$/, '') + "/" +fileName
          width= meta [ 'width' ]
          height = meta [ 'height' ]
         end
            # Whether success or failure, add file URI , width and height and DomId when status success
            flash[:error]+=(is_html ? "<br>" : "&")+"fileName="+displayPath
            flash[:error]+= (is_html ? "<br>" : "&")+"width=" +width
		        flash[:error]+= (is_html ? "<br>" : "&")+"height=" +height
            # Pass back the DOMId in any case
            flash[:error]+= (is_html ? "<br>" : "&")+"DOMId=" +meta['DOMId']
       end
    # Builds the error response message
  def self.build_error_response(error_codes, is_html)
   error_code_arr = error_codes.split(",")
   err_msg=""
   notice_msg = ""
    err_flash ={}
    0.upto(error_code_arr.length-1) do |i|
        error_message = Fusioncharts::Exporter::ErrorHandler.get_error_message(error_code_arr[i])
        
        if(error_message == nil or error_message.empty?)
         error_message = "Unknown Error!"   
       end
       
       if(error_code_arr[i].index("E")!=nil and error_code_arr[i].index("E")>=0)
         #This is an error
         #print "Error Message="+error_message
        err_msg+=error_message
      else
        # This is just a warning/notice
        #print "Error Message="+error_message
       notice_msg+=error_message
       end
     end
     err_msg=err_msg.empty? ? (is_html ? "<br>" : "&")+"statusMessage=successful":(is_html ? "<br>" : "&")+"statusMessage="+err_msg
     notice_msg=notice_msg.empty? ? notice_msg:(is_html ? "<br>" : "&")+"notice="+notice_msg
     err_flash = {"error"=>err_msg,"notice"=>notice_msg}
    return err_flash
  end     
  
end