unit FMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  StdCtrls, Buttons, ComCtrls, OleCtrls, Menus, Types, ExtCtrls, Spin, ZylGPS;

type

  TfrmMain = class(TForm)
    gbLat: TGroupBox;
    btnTransmit: TBitBtn;
    cmbLat: TComboBox;
    lblDegree: TLabel;
    lblMinute: TLabel;
    lblSecond: TLabel;
    gbLong: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    cmbLong: TComboBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    ZylGPS: TZylGPS;
    efLatDeg: TSpinEdit;
    efLatMin: TSpinEdit;
    efLatSec: TSpinEdit;
    efLongDeg: TSpinEdit;
    efLongMin: TSpinEdit;
    efLongSec: TSpinEdit;
    efHeading: TSpinEdit;
    efSpeed: TSpinEdit;
    efAltitude: TSpinEdit;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure btnTransmitClick(Sender: TObject);
  private
    { Private declarations }

  public
    { Public declarations }
 
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  cmbLat.ItemIndex := 0;
  cmbLong.ItemIndex := 0;
  ZylGPS.Open();
end;

procedure TfrmMain.btnTransmitClick(Sender: TObject);
begin
  ZylGPS.Latitude_Degree := efLatDeg.Value;
  ZylGPS.Latitude_Minute := efLatMin.Value;
  ZylGPS.Latitude_Second := efLatSec.Value;
  if cmbLat.Text = 'North' then
    ZylGPS.Latitude_Direction := North
  else
    ZylGPS.Latitude_Direction := South;
  ZylGPS.Longitude_Degree := efLongDeg.Value;
  ZylGPS.Longitude_Minute := efLongMin.Value;
  ZylGPS.Longitude_Second := efLongSec.Value;
  if cmbLong.Text = 'East' then
    ZylGPS.Longitude_Direction := East
  else
    ZylGPS.Longitude_Direction := West;
  ZylGPS.Altitude := efAltitude.Value;
  ZylGPS.Heading := efHeading.Value;
  ZylGPS.Speed := efSpeed.Value;

  ZylGPS.Transmit();
end;

procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ZylGPS.Close();
end;

end.
