////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Copyright 1999-2005, Hitek Software LLC
//http://www.sharewarejustice.com
//This source code is subject to change without any prior notice.  
//The source code is subject to a non-disclosure agreement. 
//No part of this source code may be reproduced, transmitted to other Shareware Developers or any other person, without the written permission of Hitek Software LLC.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Net;

namespace Tracker
{
    class Tracker
    {        
        static void Main(string[] args)
        {
            try
            {
                String authorid = "testAut";
                String authorpwd = "pwd";
                String mode = "install";
                String program = "Test Software";
                String version = "1.0";
                String key = "aaaa-bbbb-cccc";
                String key2 = "xxxx-yyyy-zzzz";
  		
                //collect data to be posted for GET method
                //The GET method is used all 3 modes: install, register, and usage 		
                CollectData cd = new CollectData();
                String parString = cd.GetParameterString(cd.GET, authorid, authorpwd, mode, program, version, key, key2);
                Console.WriteLine("Url String = " + parString);
                
                // post data using GET method
                PostData pd = new PostData();
                pd.GetMethod(parString);
                Console.WriteLine("Status = " + pd.status);
                Console.WriteLine("Data Line = " + pd.dataLine);
  		
                //POST method is used only for register or usage mode 		
                if(args[2]=="register"||args[2]=="usage")		
                {	
                    //collect data to be posted for POST method
                    cd = new CollectData();
                    parString = cd.GetParameterString(cd.POST, authorid, authorpwd, mode, program, version, key, key2);
                    Console.WriteLine("Url String = " + parString);
	
                    // post data using POST method
                    pd = new PostData();
                    pd.PostMethod(parString);
                    Console.WriteLine("Status = " + pd.status);
                    Console.WriteLine("Data Line = " + pd.dataLine);
                }
            }
            catch (Exception e)
            {
                Console.WriteLine("Error = " + e.Message);
                Environment.Exit(1);
            }
        }
    }
}
