<?php
// Amortization Schedule Calculator
// ------------------------------------------------------------------------
// Copyright (c) 2005, Amortization-Calc.com
// ------------------------------------------------------------------------
// This file is part of "Amortization Schedule Calculator" software
// ------------------------------------------------------------------------

//====================================
function loan_summary($principal, $interest_rate, $start_year, $start_month, $term, $month_names, $currency_char = '$', $decimals = 2, $dec_point = '.', $thousands_sep = ','){
	$r['principal']   = $principal;
	$r['rate']        = $interest_rate;
	$r['term']        = $term;
	$r['periods']     = $term * 12;
	$r['payment']     = $principal * $r['rate'] / 100 / 12 / (1 - pow((1 + $r['rate'] / 12 / 100), -$r['periods']));
	$r['total']       = $r['payment'] * $r['periods'];
	$r['interest']    = $r['total'] - $r['principal'];
	$r['start_date']  = get_date($start_year, $start_month, 'M, Y', $month_names);
	$r['end_date']    = get_date($start_year, $start_month + $r['periods'] - 1, 'M, Y', $month_names);
	$r['principal_p'] = $principal / $r['total'] * 100;
	$r['interest_p']  = $r['interest'] / $r['total'] * 100;

	$r['principal_p_raw'] = $r['principal_p'];
	$r['interest_p_raw']  = $r['interest_p'];

	$r['principal']   = $currency_char.number_format($r['principal'], $decimals, $dec_point, $thousands_sep);
	$r['rate']        = number_format($r['rate'], $decimals, $dec_point, $thousands_sep).'%';
	$r['payment']     = $currency_char.number_format($r['payment'], $decimals, $dec_point, $thousands_sep);
	$r['total']       = $currency_char.number_format($r['total'], $decimals, $dec_point, $thousands_sep);
	$r['interest']    = $currency_char.number_format($r['interest'], $decimals, $dec_point, $thousands_sep);
	return $r;
}
	
//====================================
function amortization_array($principal, $interest_rate, $start_year, $start_month, $term, $group_by = 'M, Y', $month_names){
	$periods  = $term * 12;
	$balance  = $principal;
	$interest = $interest_rate / 100 / 12;
    $payment  = $principal * $interest / (1 - pow((1 + $interest), -$periods));

	for($period = 0; $period < $periods; $period++){
		$date = get_date($start_year, $start_month + $period, $group_by, $month_names);
		$results[$date]['date']       = $date;
		$results[$date]['year']       = substr($date, -4);
		$results[$date]['interest']  += $balance * $interest;
		$results[$date]['principal'] += $payment - $balance * $interest;
		$results[$date]['balance']    = $balance = $balance - $payment + $balance * $interest;

		if($results[$date]['balance'] < 0) $results[$date]['balance'] = 0;
	}
	return $results;
}

//====================================
function format_numbers($numbers, $currency_char = '$', $decimals = 2, $dec_point = '.', $thousands_sep = ','){
	foreach($numbers as $number=>$void){
		$numbers[$number]['interest']  = $currency_char . number_format($numbers[$number]['interest'], $decimals, $dec_point, $thousands_sep);
		$numbers[$number]['principal'] = $currency_char . number_format($numbers[$number]['principal'], $decimals, $dec_point, $thousands_sep);
		$numbers[$number]['balance']   = $currency_char . number_format($numbers[$number]['balance'], $decimals, $dec_point, $thousands_sep);
	}
	return $numbers;
}

//====================================
function get_date($year, $month, $group_by = 'M, Y', $month_names = array(1=>'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec')){
	$year  = $year + intval($month / 12);
	$month = $month % 12;
	if(!$month){
		$month = 12;
		$year -= 1;
	}
	return str_replace(array('M', 'Y'), array($month_names[$month], $year),$group_by);
}

//====================================
function get_request_var($varname = '', $defaultval = '') {
	global $smarty;
	if($varname){
		if(isset($_POST[$varname])){
			$var = $_POST[$varname];
		} elseif(isset($_GET[$varname])) {
			$var = $_GET[$varname];
		}
	} elseif(count($_POST)) {
		$var = $_POST;
	} elseif(count($_GET)) {
		$var = $_GET;
	}
	$smarty->load_filter('output', 'correctoutput');
	if(isset($var)){
		/* assign variable to Smarty */
		if(isset($smarty)){
			if(get_magic_quotes_gpc()){
				$smarty->assign($varname, array_stripslashes($var));
			} else {
				$smarty->assign($varname, $var);
			}
		}

		/* adding slashes if magic quotes feature is turned off */
		if(!get_magic_quotes_gpc()) $var = array_addslashes($var);

		return $var;
	} else {
		$smarty->assign($varname, $defaultval);
		return $defaultval;
	}
}

//====================================
function array_addslashes($var) {
if(is_array($var)){
	return array_map('array_addslashes', $var);
} else {
	return addslashes($var);
}
}

//====================================
function array_stripslashes($var){
	if(is_array($var)){
		return array_map("array_stripslashes", $var);
	}
	else{
		return stripslashes($var);
	}
}
?>
