<%
  headerTitle = "Association of Shareware Professionals: Sample PAD Import Form"
  headerIndex = true
  headerSiteMap = true
  headerKeywords = "[standard]"
  headerPrivateNotes = "Check to make sure the FAQ is current.  Mentions asp.pad_support."
  headerDescription = "A sample Active Server Page showing how to import a PAD (Portable Application Description) file"
  headerSource = "text"
  headerMaintainer = "PAD maintainer"
  headerMaintainDays = 90
  headerContents = ""
  headerObsolete = false
  headerAuxiliary = false
%>
<!--#include FILE="../Header.asp"-->
<H1>Example: Utilizing Online PAD Data</H1>
<P>Is your PAD document online? Prefill fields now!<P>

<!--
Here we have a basic request form, the user enters the URL to the PAD file they wish to open and merge with your form. Here we are simply recalling this same page using the POST method. We also do a Request and see if a URL was passed and then stuff the value in the edit field. That way if they mistyped the URL they won't have to enter the entire string in again, they can just fix the typo.
-->
<FORM NAME="FETCH" ACTION="paddemo.asp" METHOD=GET>
URL to XML file:  <p>
	<INPUT TYPE=SUBMIT value="Retrieve" >&nbsp;<INPUT TYPE="text" NAME="XMLURL" size=55 
	value="<%=request("XMLURL")%>">
 </FORM>
<hr>
<%
'Here we declare several root variables to access the data directly from the XML file
DIM objCompanyRoot,objProgramRoot, objDescriptionRoot, objWebInfoRoot, objPermissionsRoot

'Here we declare the xml object that we will be using to store the PAD file
DIM objXML

'Declare and set the server object
set objXML = Server.CreateObject("Microsoft.XMLDOM")

'If you don't set async to false you will not be able to retrieve documents that reside on other domains
objXML.async=false
'Some newer versions of the XML parser also require the following line.  You may need to try this page with and without this line.
objXML.setProperty "ServerHTTPRequest", true

'''''   if we don't have a URL then load the empty one. This allows us 
'''''   to use the same form for "new" entries. Otherwise simply set 
'''''   the URL variable to the URL that was sent
if request("XMLURL")="" then
   URL=Server.MapPath("empty.xml")
else   
set url=request("XMLURL")
end if

'''''   Here is where we try to load the URL, if successful it 
'''''   will continue, otherwise it will move to the ELSE part 
'''''   of the code.

if objXML.load(""+url+"") then
	Set objCompanyRoot=objXML.documentElement.selectSingleNode("Company_Info")
	Set objProgramRoot=objXML.documentElement.selectSingleNode("Program_Info")
	Set objDescriptionRoot=objXML.documentElement.selectSingleNode("Program_Descriptions")	
	Set objWebInfoRoot=objXML.documentElement.selectSingleNode("Web_Info")
	Set objPermissionsRoot=objXML.documentElement.selectSingleNode("Permissions")
%>
<P>
<!--
'''''   For each form field you will need to fetch the data 
'''''   out of the PAD file for the appropriate tag. Below is 
'''''   a simple form that shows several examples of how 
'''''   the data might be extracted and manipulated. The 
'''''   simplest is of course just filling in an edit field with 
'''''   the value of the tag needed. You'll also some other 
'''''   ways of building data so that you get the results you need.
-->
<FORM METHOD="POST" ACTION="paddemoresponse.asp">
<font size=+2><u>Company Info</u></font><br>
<table border=0 bgcolor="#ffffcc" >
<tr><td>
<!-- 
'''''   Here is the simplest way, fetch the data and put it into the value field.
'''''   We want the Company_Name, this tag is a subset of the Company_Info
'''''   tag. Above we assigned the Company_Info root to the objCompanyRoot 
'''''   variable. Here we simply use this var and pass the Company_Name 
'''''   string as the parameter for the selectSingleNode method, resulting in 
'''''   the Company Name used in the PAD file.
-->
Company&nbsp;Name:</td><td><INPUT TYPE="text" NAME="Company_Name" SIZE=45  value="<%response.write(objCompanyRoot.selectSingleNode("Company_Name").text)%>">
</td></tr>
<!-- 
'''''   Here we want to query the value of the ASP_Member tag and set the correct
'''''   radio button value for the field. In this case the answer is a simple Y/N result.
'''''   We first look at the .text value and if it is "Y" then we write "checked" out to our
'''''   HTML document, we then look to see if it is "N" and do the same if it is a match.
'''''   Otherwise we write nothing to the document. There are other ways to do this, such
'''''   as assigning the node value to a variable and using the variable to perform the match.
'''''   On the server side that would be quicker to perform as it is only looking up the node
'''''   value once instead of twice.
-->

<tr><td>ASP&nbsp;Member</td><td>
<INPUT TYPE="radio" NAME="ASP_Member" VALUE="Y" 
<%
if not objCompanyRoot.selectSingleNode("ASP_Member") is Nothing then
if objCompanyRoot.selectSingleNode("ASP_Member").text="Y" then
response.write("Checked")
end if
end if
%>
> Y&nbsp;&nbsp;
<INPUT TYPE="radio" NAME="ASP_Member" VALUE="N" 
<%
if not objCompanyRoot.selectSingleNode("ASP_Member") is Nothing then
if objCompanyRoot.selectSingleNode("ASP_Member").text="N" then
response.write("Checked")
end if
end if 
%>
> N
</td></tr>
<tr><td>
Company&nbsp;WebSite&nbsp;URL:</td><td><INPUT TYPE="text" NAME="Company_WebSite_URL" SIZE=45  value="<%response.write(objCompanyRoot.selectSingleNode("Company_WebSite_URL").text)%>">
</td></tr>
<tr><td colspan=2><font size=+1>Contact Info</font><br><center><table border=0 bgcolor="#FFFFEA" >
<tr><td>
Author&nbsp;First&nbsp;Name:</td><td><INPUT TYPE="text" NAME="Author_First_Name" SIZE=45  value="<%response.write(objCompanyRoot.selectSingleNode("Contact_Info/Author_First_Name").text)%>">
</td></tr>
<tr><td>
Author&nbsp;Last&nbsp;Name:</td><td><INPUT TYPE="text" NAME="Author_Last_Name" SIZE=45  value="<%response.write(objCompanyRoot.selectSingleNode("Contact_Info/Author_Last_Name").text)%>">
</td></tr>
<tr><td>
Author&nbsp;Email:</td><td><INPUT TYPE="text" NAME="Author_Email" SIZE=45  value="<%response.write(objCompanyRoot.selectSingleNode("Contact_Info/Author_Email").text)%>">
</td></tr>
</table></center></td></tr>
<tr><td colspan=2><font size=+1>Support Info</font><br><center><table border=0 bgcolor="#FFFFEA" >
<tr><td>
Support&nbsp;Email:</td><td><INPUT TYPE="text" NAME="Support_Email" SIZE=45  value="<%response.write(objCompanyRoot.selectSingleNode("Support_Info/Support_Email").text)%>">
</td></tr>
<tr><td>
General&nbsp;Email:</td><td><INPUT TYPE="text" NAME="General_Email" SIZE=45  value="<%response.write(objCompanyRoot.selectSingleNode("Support_Info/General_Email").text)%>">
</td></tr>
</table></center></td></tr>
</table><hr height=10>

<font size=+2><u>Program Info</u></font><br>
<table border=0 bgcolor="#ffffcc" >
<tr><td>
Program&nbsp;Name:</td><td><INPUT TYPE="text" NAME="Program_Name" SIZE=45  value="<%response.write(objProgramRoot.selectSingleNode("Program_Name").text)%>">
</td></tr>
<tr><td>
Program&nbsp;Version:</td><td><INPUT TYPE="text" NAME="Program_Version" SIZE=45  value="<%response.write(objProgramRoot.selectSingleNode("Program_Version").text)%>">
</td></tr>
<tr><td>
Program&nbsp;Release&nbsp;Month/Day/Year:</td><td><INPUT TYPE="text" NAME="Program_Release_Month" SIZE=3 maxlength="2" value="<%response.write(objProgramRoot.selectSingleNode("Program_Release_Month").text)%>">/<INPUT TYPE="text" NAME="Program_Release_Year" SIZE=3 maxlength="4" value="<%response.write(objProgramRoot.selectSingleNode("Program_Release_Day").text)%>">/<INPUT TYPE="text" NAME="Program_Release_Year" SIZE=5 maxlength="4" value="<%response.write(objProgramRoot.selectSingleNode("Program_Release_Year").text)%>">
</td></tr>
<tr><td>
Full&nbsp;Release&nbsp;Date:</td><td><INPUT TYPE="text" NAME="Program_Release_Date" SIZE=15 maxlength="2" value="<%response.write(objProgramRoot.selectSingleNode("Program_Release_Month").text+"/"+objProgramRoot.selectSingleNode("Program_Release_Day").text+"/"+objProgramRoot.selectSingleNode("Program_Release_Year").text)%>">
</td></tr>
<tr><td>
Program&nbsp;Cost&nbsp;Dollars:</td><td><INPUT TYPE="text" NAME="Program_Cost_Dollars" SIZE=10  value="<%response.write(objProgramRoot.selectSingleNode("Program_Cost_Dollars").text)%>">
</td></tr>
<tr><td>
<!--
'''''   Listboxes can be done several ways. You could search for the item and set the SELECTED option
'''''   like we did with the Radio Buttons or in this case just automatically add it as a selected option 
'''''   at the top of the list.
-->
Program&nbsp;Type</td><td><SELECT NAME="Program_Type" Size="0" DATAFLD="Program_Type">
<Option selected><%response.write(objProgramRoot.selectSingleNode("Program_Type").text)%>
<option>Shareware<option>Freeware<option>Adware<option>Demo<option>Commercial<option>Postcardware<option>Crippleware<option>Data Only</SELECT>
<SPAN DATAFLD="Program_Type"></SPAN>
</td></tr>
<tr><td>
Program&nbsp;Release&nbsp;Status</td><td><SELECT NAME="Program_Release_Status" Size="0">
<Option selected><%response.write(objProgramRoot.selectSingleNode("Program_Release_Status").text)%>
<option>Major Update<option>Minor Update<option>New Release<option>Beta<option>Alpha<option>Media Only</SELECT>
</td></tr>
<tr><td>
Program&nbsp;Install&nbsp;Support</td><td><SELECT NAME="Program_Install_Support" Size="0">
<Option selected><%response.write(objProgramRoot.selectSingleNode("Program_Install_Support").text)%>
<option>Install and Uninstall<option>Install Only<option>No Install Support<option>Uninstall Only</SELECT>

</td></tr>
<tr><td>
<!--
'''''   Multi-select listboxes require more work. You have to see if each item appears 
'''''   in the tags assigned text. For this we retrieve the value of the tag and assign it to
'''''   a variable. Then for each item we look to see if it appears in the list and add 
'''''   SELECTED to the OPTION tag if the item does exist. See note below about adding
'''''   a comma to the end of any tag contents.
-->
<!--
'when getting the items append a comma to the end so that the search will look for
'the extact string. this will keep "OS/2" from being selected when only "OS/2 Warp" 
'has been selected
-->
<%
oslist=objProgramRoot.selectSingleNode("Program_OS_Support").text+","
%>

Program&nbsp;OS&nbsp;Support</td><td><SELECT NAME="Program_OS_Support" Size="5" Multiple>
<option 
<% if instr(oslist,"Win 3.1x,")>0 then
response.write("selected")
end if %>
>Win 3.1x
<option 
<% if instr(oslist,"Win95,")>0 then
response.write("selected")
end if %>
>Win95
<option 
<% if instr(oslist,"Win98,")>0 then
response.write("selected")
end if %>
>Win98
<option
<% if instr(oslist,"WinNT 3.x,")>0 then
response.write(" selected")
end if %>
>WinNT 3.x
<option
<% if instr(oslist,"WinNT 4.x,")>0 then
response.write(" selected")
end if %>
>WinNT 4.x
<option
<% if instr(oslist,"Windows2000,")>0 then
response.write(" selected")
end if %>
>Windows2000
<option
<% if instr(oslist,"Windows CE,")>0 then
response.write(" selected")
end if %>
>Windows CE
<option
<% if instr(oslist,"Unix,")>0 then
response.write(" selected")
end if %>
>Unix
<option
<% if instr(oslist,"Linux,")>0 then
response.write(" selected")
end if %>
>Linux
<option
<% if instr(oslist,"MS-DOS,")>0 then
response.write(" selected")
end if %>
>MS-DOS
<option
<% if instr(oslist,"OS/2,")>0 then
response.write(" selected")
end if %>
>OS/2
<option<% if instr(oslist,"OS/2 Warp,")>0 then
response.write(" selected")
end if %>
>OS/2 Warp
<option
<% if instr(oslist,"OS/2 Warp 4,")>0 then
response.write(" selected")
end if %>
>OS/2 Warp 4
<option
<% if instr(oslist,"MAC 68k,")>0 then
response.write(" selected")
end if %>
>MAC 68k
<option
<% if instr(oslist,"Mac PPC,")>0 then
response.write(" selected")
end if %>
>Mac PPC
<option
<% if instr(oslist,"Palm OS 1.0,")>0 then
response.write(" selected")
end if %>
>Palm OS 1.0
<option
<% if instr(oslist,"Palm OS 2.0,")>0 then
response.write(" selected")
end if %>
>Palm OS 2.0
<option
<% if instr(oslist,"Palm OS 2.1,")>0 then
response.write(" selected")
end if %>
>Palm OS 2.1
<option
<% if instr(oslist,"Palm OS 3.0,")>0 then
response.write(" selected")
end if %>
>Palm OS 3.0
<option
<% if instr(oslist,"Palm OS 3.1,")>0 then
response.write(" selected")
end if %>
>Palm OS 3.1
<option
<% if instr(oslist,"Palm OS 3.2,")>0 then
response.write(" selected")
end if %>
>Palm OS 3.2
<option
<% if instr(oslist,"Not Applicable,")>0 then
response.write(" selected")
end if %>
>Not Applicable
</SELECT>
</td></tr>
<tr><td>
Program&nbsp;System&nbsp;Requirements:</td><td><INPUT TYPE="text" NAME="Program_System_Requirements" SIZE=45 maxlength="80" value="<%response.write(objProgramRoot.selectSingleNode("Program_System_Requirements").text)%>">
</td></tr>
<tr><td>
Possible&nbsp;Program&nbsp;Categories:</td><td><INPUT TYPE="text" NAME="Program_Categories" SIZE=45  value="<%response.write(objProgramRoot.selectSingleNode("Program_Categories").text)%>">
</td></tr>

<tr><td>
<!--
'''''   Say we only want one file size and are never sure if an author actually fills in all
'''''   of the fields. We can perform a text and output what we like first and then stop
'''''   after we get the results we want. In this example we would like to use MB first, 
'''''   then Kilobytes and then Bytes. Output something special if there are no values!
'''''   
'''''   For each value we enter the K, MB or Bytes text, this isn't necessary, just 
'''''   depends on how you want your form to act.
'''''   
'''''   Notice how we use the TRIM function here, this helps us validate to make sure that
'''''   somehow the author did not enter just spaces into these fields.
-->
File&nbsp;Size:</td><td><INPUT TYPE="text" NAME="File_Size_Bytes" SIZE=10 
 value="
<% 
if trim(objProgramRoot.selectSingleNode("File_Info/File_Size_MB").text)<>"" then
   response.write(trim(objProgramRoot.selectSingleNode("File_Info/File_Size_MB").text)+"MB")
else if trim(objProgramRoot.selectSingleNode("File_Info/File_Size_K").text)<>"" then
   response.write(trim(objProgramRoot.selectSingleNode("File_Info/File_Size_K").text)+"K")
else if trim(objProgramRoot.selectSingleNode("File_Info/File_Size_Bytes").text)<>"" then
   response.write(trim(objProgramRoot.selectSingleNode("File_Info/File_Size_Bytes").text)+"Bytes") 
else response.write("-0") 
end if
end if
end if   
%>
">
</td></tr>
</table><hr height=10>

<font size=+2><u>Program Descriptions</u></font><br>
<table border=0 bgcolor="#ffffcc" >
<tr><td>
<font size=+2><u>English</u></font><br>
<table border=0 bgcolor="#ffffea">
<tr><td>
Keywords:</td><td><INPUT TYPE="text" NAME="Keywords" SIZE=45 maxlength="250" value="<%response.write(objDescriptionRoot.selectSingleNode("English/Keywords").text)%>">
</td></tr>
<tr><td>
Char&nbsp;Desc&nbsp;45:</td><td><INPUT TYPE="text" NAME="Char_Desc_45" SIZE=45 maxlength="45" value="<%response.write(objDescriptionRoot.selectSingleNode("English/Char_Desc_45").text)%>">
</td></tr>
<tr><td>
Char&nbsp;Desc&nbsp;450</td><td><TEXTAREA NAME="Char_Desc_450" ROWS=5 COLS=50 >
<%response.write(objDescriptionRoot.selectSingleNode("English/Char_Desc_450").text)%>
</TEXTAREA>
</td></tr>
</table>
</td></tr>
</table>
<hr height=10>

<font size=+2><u>Web Info</u></font><br>
<table border=0 bgcolor="#ffffcc" >
<tr><td colspan=2><font size=+1>Application URLs</font><br><center>
<table border=0 bgcolor="#FFFFEA" >
<tr><td>
Application&nbsp;Info&nbsp;URL:</td><td><INPUT TYPE="text" NAME="Application_Info_URL" SIZE=45  value="<%response.write(objWebInfoRoot.selectSingleNode("Application_URLs/Application_Info_URL").text)%>">
</td></tr>
<tr><td>
Application&nbsp;Order&nbsp;URL:</td><td><INPUT TYPE="text" NAME="Application_Order_URL" SIZE=45  value="<%response.write(objWebInfoRoot.selectSingleNode("Application_URLs/Application_Order_URL").text)%>">
</td></tr>
<tr><td>
Application&nbsp;Screenshot&nbsp;URL:</td><td><INPUT TYPE="text" NAME="Application_Screenshot_URL" SIZE=45  value="<%response.write(objWebInfoRoot.selectSingleNode("Application_URLs/Application_Screenshot_URL").text)%>">
</td></tr>
<tr><td>
Application&nbsp;Icon&nbsp;URL:</td><td><INPUT TYPE="text" NAME="Application_Icon_URL" SIZE=45  value="<%response.write(objWebInfoRoot.selectSingleNode("Application_URLs/Application_Icon_URL").text)%>">
</td></tr>
<tr><td>
Application&nbsp;XML&nbsp;File&nbsp;URL:</td><td><INPUT TYPE="text" NAME="Application_XML_File_URL" SIZE=45  value="<%response.write(objWebInfoRoot.selectSingleNode("Application_URLs/Application_XML_File_URL").text)%>">
</td></tr>
</table></center></td></tr>
<tr><td colspan=2><font size=+1>Download URLs</font><br><center><table border=0 bgcolor="#FFFFEA" >
<tr><td>
Primary&nbsp;Download&nbsp;URL:</td><td><INPUT TYPE="text" NAME="Primary_Download_URL" SIZE=45  value="<%response.write(objWebInfoRoot.selectSingleNode("Download_URLs/Primary_Download_URL").text)%>">
</td></tr>
<tr><td>
Secondary&nbsp;Download&nbsp;URL:</td><td><INPUT TYPE="text" NAME="Secondary_Download_URL" SIZE=45  value="<%response.write(objWebInfoRoot.selectSingleNode("Download_URLs/Secondary_Download_URL").text)%>">
</td></tr>
<tr><td>
Additional&nbsp;Download&nbsp;URL&nbsp;1:</td><td><INPUT TYPE="text" NAME="Additional_Download_URL_1" SIZE=45  value="<%response.write(objWebInfoRoot.selectSingleNode("Download_URLs/Additional_Download_URL_1").text)%>">
</td></tr>
<tr><td>
Additional&nbsp;Download&nbsp;URL&nbsp;2:</td><td><INPUT TYPE="text" NAME="Additional_Download_URL_2" SIZE=45  value="<%response.write(objWebInfoRoot.selectSingleNode("Download_URLs/Additional_Download_URL_2").text)%>">
</td></tr>
</table></center></td></tr>
</table><hr height=10>

<P ALIGN="CENTER"><INPUT TYPE="submit" VALUE="Submit Form"><INPUT TYPE="reset" VALUE="Reset Form"></P>
</FORM>
<%
else
response.write("<p><B>Sorry but we could not find the file you were pointing us to: </b>"+request("XMLURL") )
end if
%>

<!--#include FILE="../Footer.asp"-->
