/*
 * Decompiled with CFR 0.152.
 */
package zipsnap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;
import zipsnap.ErrorWarningHandler;

public class FileIO {
    private static final int bufferSize = 0x100000;
    public static final char neutralSeparatorChar = '/';

    private static FileIOResult renameFileDir(boolean isDir, File sourceFile, File targetFile) {
        if (!sourceFile.exists()) {
            return new FileIOResult(false, "Source " + (isDir ? "directory" : "file") + " does not exist.");
        }
        if (isDir != sourceFile.isDirectory()) {
            return new FileIOResult(false, "Source is not a " + (isDir ? "directory." : "file."));
        }
        if (targetFile.exists() && !targetFile.equals(sourceFile)) {
            return new FileIOResult(false, "Target is an existing " + (targetFile.isDirectory() ? "directory." : "file."));
        }
        boolean success = false;
        String exceptionMessage = null;
        try {
            success = sourceFile.renameTo(targetFile);
        }
        catch (Exception e) {
            exceptionMessage = ErrorWarningHandler.getExceptionMessage(e);
        }
        if (success) {
            return new FileIOResult(true, null);
        }
        if (exceptionMessage == null) {
            return new FileIOResult(false, (isDir ? "Directory" : "File") + " rename was unsuccessful.");
        }
        return new FileIOResult(false, "Java exception encountered during " + (isDir ? "directory" : "file") + " rename:\n" + exceptionMessage);
    }

    public static FileIOResult renameFile(File sourceFile, File targetFile) {
        return FileIO.renameFileDir(false, sourceFile, targetFile);
    }

    public static FileIOResult renameDir(File sourceDir, File targetDir) {
        return FileIO.renameFileDir(true, sourceDir, targetDir);
    }

    private static FileIOResult setFileDirTime(boolean isDir, File file, long time) {
        if (!file.exists()) {
            return new FileIOResult(false, (isDir ? "Directory" : "File") + " does not exist.");
        }
        if (isDir != file.isDirectory()) {
            return new FileIOResult(false, "Specified " + (isDir ? "directory" : "file") + " is not a " + (isDir ? "directory." : "file."));
        }
        boolean success = false;
        String exceptionMessage = null;
        try {
            success = file.setLastModified(time);
        }
        catch (Exception e) {
            exceptionMessage = ErrorWarningHandler.getExceptionMessage(e);
        }
        if (success) {
            return new FileIOResult(true, null);
        }
        if (exceptionMessage == null) {
            return new FileIOResult(false, "Setting of last-modified time of " + (isDir ? "directory" : "file") + " was unsuccessful.");
        }
        return new FileIOResult(false, "Java exception encountered during setting of last-modified time of " + (isDir ? "directory:\n" : "file:\n") + exceptionMessage);
    }

    public static FileIOResult setFileTime(File file, long time) {
        return FileIO.setFileDirTime(false, file, time);
    }

    public static FileIOResult setDirTime(File dir, long time) {
        return FileIO.setFileDirTime(true, dir, time);
    }

    public static FileIOResult createDir(File dir) {
        boolean success = false;
        String exceptionMessage = null;
        try {
            success = dir.mkdirs();
        }
        catch (Exception e) {
            exceptionMessage = ErrorWarningHandler.getExceptionMessage(e);
        }
        if (success) {
            return new FileIOResult(true, null);
        }
        if (exceptionMessage == null) {
            return new FileIOResult(false, "Directory creation was unsuccessful.");
        }
        return new FileIOResult(false, "Java exception encountered during directory creation:\n" + exceptionMessage);
    }

    public static FileIOResult getDirContents(File dir, List<File> files, List<File> dirs) {
        if (!dir.exists()) {
            return new FileIOResult(false, "Directory does not exist.");
        }
        if (!dir.isDirectory()) {
            return new FileIOResult(false, "Specified directory is not a directory.");
        }
        File[] listFiles = dir.listFiles();
        if (listFiles == null) {
            return new FileIOResult(false, "Failed to list contents of directory.");
        }
        for (File f : listFiles) {
            if (f.isDirectory()) {
                dirs.add(f);
                continue;
            }
            files.add(f);
        }
        Collections.sort(files);
        Collections.sort(dirs);
        return new FileIOResult(true, null);
    }

    private static FileIOResult deleteFileDir(boolean isDir, File file) {
        if (!file.exists()) {
            return new FileIOResult(false, (isDir ? "Directory" : "File") + " does not exist.");
        }
        if (isDir != file.isDirectory()) {
            return new FileIOResult(false, "Specified " + (isDir ? "directory" : "file") + " is not a " + (isDir ? "directory." : "file."));
        }
        boolean success = false;
        String exceptionMessage = null;
        try {
            success = file.delete();
        }
        catch (Exception e) {
            exceptionMessage = ErrorWarningHandler.getExceptionMessage(e);
        }
        if (success) {
            return new FileIOResult(true, null);
        }
        if (exceptionMessage == null) {
            return new FileIOResult(false, "Deleting of " + (isDir ? "directory" : "file") + " was unsuccessful.");
        }
        return new FileIOResult(false, "Java exception encountered during deleting of " + (isDir ? "directory:\n" : "file:\n") + exceptionMessage);
    }

    public static FileIOResult deleteFile(File file) {
        return FileIO.deleteFileDir(false, file);
    }

    public static FileIOResult deleteDir(File dir) {
        return FileIO.deleteFileDir(true, dir);
    }

    public static FileIOResult deleteDirTree(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<File> dirs = new ArrayList<File>();
        FileIOResult getDirContentsResult = FileIO.getDirContents(dir, files, dirs);
        if (!getDirContentsResult.success) {
            return new FileIOResult(false, getDirContentsResult.errorMessage);
        }
        StringBuilder errorMessages = new StringBuilder();
        for (File f : files) {
            FileIOResult deleteFileResult = FileIO.deleteFile(f);
            if (deleteFileResult.success) continue;
            errorMessages.append("\nFailed to delete file \"" + f.getPath() + "\":\n" + deleteFileResult.errorMessage);
        }
        for (File d : dirs) {
            FileIOResult deleteDirTreeResult = FileIO.deleteDirTree(d);
            if (deleteDirTreeResult.success) continue;
            errorMessages.append("\nFailed to delete directory \"" + d.getPath() + "\":\n" + deleteDirTreeResult.errorMessage);
        }
        FileIOResult deleteDirResult = FileIO.deleteDir(dir);
        if (!deleteDirResult.success) {
            errorMessages.append("\nFailed to delete directory \"" + dir.getPath() + "\":\n" + deleteDirResult.errorMessage);
        }
        return new FileIOResult(deleteDirResult.success, errorMessages.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileIOResult copyFile(File sourceFile, File targetFile) {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        StringBuilder errorMessages = new StringBuilder();
        try {
            bis = new BufferedInputStream(new FileInputStream(sourceFile));
        }
        catch (Exception e) {
            errorMessages.append("\nUnable to open source file for reading:\n" + ErrorWarningHandler.getExceptionMessage(e));
            FileIOResult fileIOResult = new FileIOResult(false, errorMessages.toString());
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
            return fileIOResult;
        }
        File targetParentDir = targetFile.getParentFile();
        if (!targetParentDir.exists()) {
            FileIO.createDir(targetParentDir);
        }
        if (!targetParentDir.isDirectory()) {
            errorMessages.append("\nUnable to create parent directory of target file.");
            FileIOResult fileIOResult = new FileIOResult(false, errorMessages.toString());
            return fileIOResult;
        }
        try {
            bos = new BufferedOutputStream(new FileOutputStream(targetFile));
        }
        catch (Exception e) {
            errorMessages.append("\nUnable to open target file for writing:\n" + ErrorWarningHandler.getExceptionMessage(e));
            FileIOResult e4 = new FileIOResult(false, errorMessages.toString());
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e5) {
                    // empty catch block
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e6) {
                    // empty catch block
                }
            }
            return e4;
        }
        byte[] byteBuffer = new byte[0x100000];
        try {
            int byteCount;
            while ((byteCount = bis.read(byteBuffer, 0, 0x100000)) != -1) {
                ((BufferedOutputStream)bos).write(byteBuffer, 0, byteCount);
            }
        }
        catch (Exception e) {
            errorMessages.append("\nUnable to copy data from source file to target file:\n" + ErrorWarningHandler.getExceptionMessage(e));
            FileIOResult fileIOResult = new FileIOResult(false, errorMessages.toString());
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e7) {
                    // empty catch block
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e8) {
                    // empty catch block
                }
            }
            return fileIOResult;
        }
        try {
            bis.close();
            bis = null;
        }
        catch (Exception e) {
            errorMessages.append("\nUnable to close source file after reading:\n");
            errorMessages.append(ErrorWarningHandler.getExceptionMessage(e));
        }
        try {
            bos.close();
            bos = null;
        }
        catch (Exception e) {
            errorMessages.append("\nUnable to close target file after writing:\n");
            errorMessages.append(ErrorWarningHandler.getExceptionMessage(e));
        }
        FileIOResult setFileTimeResult = FileIO.setFileTime(targetFile, sourceFile.lastModified());
        if (!setFileTimeResult.success) {
            errorMessages.append("\nUnable to set last-modified time of target file:\n");
            errorMessages.append(setFileTimeResult.errorMessage);
        }
        FileIOResult fileIOResult = new FileIOResult(setFileTimeResult.success, errorMessages.toString());
        return fileIOResult;
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComputeFileCRC32Result computeFileCRC32(File file) {
        if (file.isDirectory()) {
            return new ComputeFileCRC32Result(true, null, 0L);
        }
        BufferedInputStream bis = null;
        try {
            StringBuilder errorMessages = new StringBuilder();
            try {
                bis = new BufferedInputStream(new FileInputStream(file));
            }
            catch (Exception e) {
                errorMessages.append("\nUnable to open file for reading:\n" + ErrorWarningHandler.getExceptionMessage(e) + "\nAssuming file CRC-32 checksum of 0.");
                ComputeFileCRC32Result computeFileCRC32Result = new ComputeFileCRC32Result(false, errorMessages.toString(), 0L);
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                return computeFileCRC32Result;
            }
            byte[] byteBuffer = new byte[0x100000];
            CRC32 crc32 = new CRC32();
            try {
                int byteCount;
                while ((byteCount = bis.read(byteBuffer, 0, 0x100000)) != -1) {
                    crc32.update(byteBuffer, 0, byteCount);
                }
            }
            catch (Exception e) {
                errorMessages.append("\nUnable to read data from file to compute checksum:\n" + ErrorWarningHandler.getExceptionMessage(e) + "\nAssuming file CRC-32 checksum of 0.");
                ComputeFileCRC32Result computeFileCRC32Result = new ComputeFileCRC32Result(false, errorMessages.toString(), 0L);
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                return computeFileCRC32Result;
            }
            try {
                bis.close();
                bis = null;
            }
            catch (Exception e) {
                errorMessages.append("\nUnable to close file after reading:\n");
                errorMessages.append(ErrorWarningHandler.getExceptionMessage(e));
            }
            ComputeFileCRC32Result computeFileCRC32Result = new ComputeFileCRC32Result(true, errorMessages.toString(), crc32.getValue());
            return computeFileCRC32Result;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static String nativeToNeutral(String path) {
        return path.replace(File.separatorChar, '/');
    }

    public static String neutralToNative(String path) {
        return path.replace('/', File.separatorChar);
    }

    public static String trimTrailingSeparator(String path) {
        if (path.endsWith(File.separator)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static class ComputeFileCRC32Result {
        public boolean success = false;
        public String errorMessage = null;
        public long checksum;

        ComputeFileCRC32Result(boolean success, String errorMessage, long checksum) {
            this.success = success;
            this.errorMessage = errorMessage;
            this.checksum = checksum;
        }
    }

    public static class FileIOResult {
        public boolean success = false;
        public String errorMessage = null;

        FileIOResult(boolean success, String errorMessage) {
            this.success = success;
            this.errorMessage = errorMessage;
        }
    }
}

