/*
 * Decompiled with CFR 0.152.
 */
package zipsnap;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringManipulator {
    private static final String defaultRegexDelim = "[\\s]++";

    public static Token[] tokenize(String in, String regexDelim, boolean includeDelimiters) {
        if (in == null) {
            return null;
        }
        Matcher delimiterMatcher = regexDelim == null ? Pattern.compile(defaultRegexDelim).matcher(in) : Pattern.compile(regexDelim).matcher(in);
        ArrayList<Token> tokens = new ArrayList<Token>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            delimiterMatcher.region(i, in.length());
            if (delimiterMatcher.lookingAt()) {
                if (buffer.length() > 0) {
                    tokens.add(new Token(buffer.toString(), false));
                    buffer = new StringBuilder();
                }
                if (includeDelimiters) {
                    tokens.add(new Token(delimiterMatcher.group(), true));
                }
                i += delimiterMatcher.group().length() - 1;
                continue;
            }
            buffer.append(in.charAt(i));
        }
        if (buffer.length() > 0) {
            tokens.add(new Token(buffer.toString(), false));
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    public static String substring(String in, String format, char rangeChar, char delimChar) {
        int len = in.length();
        if (len == 0) {
            return in;
        }
        String[] tokens = format.split("[\\" + delimChar + "]++");
        StringBuilder out = new StringBuilder();
        Pattern nonZeroIntegerPattern = Pattern.compile("\\s*([\\+\\-]?[1-9][0-9]*)\\s*");
        for (int i = 0; i < tokens.length; ++i) {
            String[] entries = tokens[i].split("[\\" + rangeChar + "]++");
            int[] indices = new int[entries.length];
            for (int j = 0; j < entries.length; ++j) {
                String entry = entries[j];
                if (!nonZeroIntegerPattern.matcher(entry).matches()) {
                    return null;
                }
                indices[j] = Integer.parseInt(entry);
            }
            if (indices.length == 1) {
                indices[0] = StringManipulator.normalizeIndex(len, indices[0]);
                out.append(in.charAt(indices[0] - 1));
                continue;
            }
            if (indices.length == 2) {
                indices[0] = StringManipulator.normalizeIndex(len, indices[0]);
                indices[1] = StringManipulator.normalizeIndex(len, indices[1]);
                int delta = indices[0] <= indices[1] ? 1 : -1;
                int k = indices[0];
                while (!(delta > 0 ? k > indices[1] : k < indices[1])) {
                    out.append(in.charAt(k - 1));
                    k += delta;
                }
                continue;
            }
            if (indices.length == 3) {
                indices[0] = StringManipulator.normalizeIndex(len, indices[0]);
                indices[2] = StringManipulator.normalizeIndex(len, indices[2]);
                if ((indices[2] - indices[0]) * indices[1] < 0) continue;
                int k = indices[0];
                while (!(indices[1] > 0 ? k > indices[2] : k < indices[2])) {
                    out.append(in.charAt(k - 1));
                    k += indices[1];
                }
                continue;
            }
            return null;
        }
        return out.toString();
    }

    private static int normalizeIndex(int len, int index) {
        int newIndex = index;
        if (newIndex < 0) {
            newIndex += len + 1;
        }
        if (newIndex < 1) {
            newIndex = 1;
        }
        if (newIndex > len) {
            newIndex = len;
        }
        return newIndex;
    }

    public static String formattedLong(long n) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setGroupingUsed(true);
        try {
            return nf.format(n);
        }
        catch (Exception e) {
            return n + "";
        }
    }

    public static String formattedDouble(double n) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setGroupingUsed(true);
        try {
            return nf.format(n);
        }
        catch (Exception e) {
            return n + "";
        }
    }

    public static String centerJustify(Object o, int width) {
        int i;
        String s = o + "";
        int len = s.length();
        int totalSpace = width - len;
        if (totalSpace <= 0) {
            return s;
        }
        StringBuilder t = new StringBuilder();
        int leadingSpace = totalSpace / 2;
        for (i = 0; i < leadingSpace; ++i) {
            t.append(' ');
        }
        t.append(s);
        for (i = 0; i < totalSpace - leadingSpace; ++i) {
            t.append(' ');
        }
        return t.toString();
    }

    public static String leftJustify(Object o, int width) {
        String s = o + "";
        int len = s.length();
        int totalSpace = width - len;
        if (totalSpace <= 0) {
            return s;
        }
        StringBuilder t = new StringBuilder();
        for (int i = 0; i < totalSpace; ++i) {
            t.append(' ');
        }
        t.append(s);
        return t.toString();
    }

    public static String rightJustify(Object o, int width) {
        String s = o + "";
        int len = s.length();
        int totalSpace = width - len;
        if (totalSpace <= 0) {
            return s;
        }
        StringBuilder t = new StringBuilder(s);
        for (int i = 0; i < totalSpace; ++i) {
            t.append(' ');
        }
        return t.toString();
    }

    public static String repeat(Object o, int n) {
        String s = o + "";
        StringBuilder t = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            t.append(s);
        }
        return t.toString();
    }

    public static String initialCase(String s) {
        Token[] tokens = StringManipulator.tokenize(s, "[\\s\\p{Punct}]++", true);
        StringBuilder t = new StringBuilder();
        for (Token token : tokens) {
            if (token.val.isEmpty()) continue;
            if (token.isDelimiter) {
                t.append(token.val);
                continue;
            }
            t.append(token.val.toUpperCase().charAt(0));
            t.append(token.val.toLowerCase().substring(1));
        }
        return t.toString();
    }

    public static String abbreviate(String s) {
        Token[] tokens = StringManipulator.tokenize(s, "[\\s\\p{Punct}]++", true);
        StringBuilder t = new StringBuilder();
        for (Token token : tokens) {
            if (token.val.isEmpty()) continue;
            if (token.isDelimiter) {
                t.append(token.val);
                continue;
            }
            t.append(token.val.charAt(0));
        }
        return t.toString();
    }

    public static String removeExtraWhitespace(String s) {
        Token[] tokens = StringManipulator.tokenize(s, defaultRegexDelim, true);
        StringBuilder t = new StringBuilder();
        for (Token token : tokens) {
            if (token.val.isEmpty()) continue;
            if (token.isDelimiter) {
                t.append(' ');
                continue;
            }
            t.append(token.val);
        }
        return t.toString();
    }

    public static String removeWhitespace(String s) {
        String[] tokens = s.split(defaultRegexDelim);
        StringBuilder t = new StringBuilder();
        for (String token : tokens) {
            t.append(token);
        }
        return t.toString();
    }

    public static String removePunctuation(String s) {
        String[] tokens = s.split("[\\p{Punct}]++");
        StringBuilder t = new StringBuilder();
        for (String token : tokens) {
            t.append(token);
        }
        return t.toString();
    }

    public static String spaceOutWords(String s) {
        StringBuilder t = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLowerCase(c) && i + 1 < s.length() && Character.isUpperCase(s.charAt(i + 1))) {
                t.append(c);
                t.append(' ');
                continue;
            }
            if (Character.isUpperCase(c) && i - 1 >= 0 && Character.isUpperCase(s.charAt(i - 1)) && i + 1 < s.length() && Character.isLowerCase(s.charAt(i + 1))) {
                t.append(' ');
                t.append(c);
                continue;
            }
            t.append(c);
        }
        return t.toString();
    }

    public static String invertCase(String s) {
        StringBuilder t = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLowerCase(c)) {
                t.append(Character.toUpperCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                t.append(Character.toLowerCase(c));
                continue;
            }
            t.append(c);
        }
        return t.toString();
    }

    public static class Token {
        public String val;
        public boolean isDelimiter;

        public Token(String val, boolean isDelimiter) {
            this.val = val;
            this.isDelimiter = isDelimiter;
        }
    }
}

