
<%
'************* IMAGE UPLOAD SCRIPT ***************

'============== The File Uploader Class ================
Class TheFileUploader

	Public TheFiles
	Public TheFileData

	Private Sub Class_Initialize()
		Set TheFiles = Server.CreateObject("Scripting.Dictionary")
	End Sub

	Public Default Sub BeginFileUpload()

		Dim theFileName,theFileToSave,newFileName,tester1,tester2,tempFilesEnd,beginByte,endByte,tempByte,FileBreak,z,tempFile,newStartByte,FilesEnd,tempFileName

		'Start binary sequence at first byte...
		beginByte = 1

		'Gets the total number of bytes for the file sent by at HTTP form POST...and uses that to read in all binary info sent from the client
		'Note - TheFileData is a "SafeArray" of binary file data
		TheFileData = Request.BinaryRead(Request.TotalBytes)
		'Alternate method of getting byte size....
		'TheFileData = Request.BinaryRead(Request.ServerVariables("HTTP_Content_Length"))

		'Gets the first html header info AFTER the "delimiter" in the HTML header,
		'which usually in the form ("-----------------------------7d631c102604f4\n")
		'After this block in the HTML Header, the content-disposition starts
		endByte = InstrB(beginByte, TheFileData, StringToByte("--"))
		endByte = InstrB(1, TheFileData, StringToByte(vbNewLine))
		'endByte = InstrB(beginByte, TheFileData, StringToByte(Chr(13)))

		'If no carriage return found in byte array, then exit...as file upload is not valid
		If (endByte-beginByte) <= 0 Then
			Exit Sub
		end if

		'Gets and stores the hyphenated preamble to the beginning and end of the html header and file byte data for each file uploaded.
		'Note: This block of characters should be exactly the same at the beginning and end of the byte block sent to the server,
		'and before each new file uploaded. Used below to loop through each file and save to disk.
		FileBreak = MidB(TheFileData,beginByte,endByte-beginByte)
		'Example of the byte block seen at the end of a set of file uploads ("-----------------------------7d631c102604f4--")
		FilesEnd = FileBreak & StringToByte("--")
		'Store the starting position number where the first FileBreak string data actually begins in the form data for the first file.
		z = InstrB(1,TheFileData,FileBreak)


		'TESTING...(displays ALL BINARY FILE DATA AND HTML HEADER INFO FOR ALL FILES IN THE HTML PAGE VIEW)
		'Do Until z = InstrB(1,TheFileData,FilesEnd)
			'Response.Write(ByteToString(MidB(TheFileData,z,1)))
			'z = z + 1
		'Loop
		'TESTING...
		'tester1 = Request.BinaryRead(Request.TotalBytes)
		'tester2 = Request.BinaryRead(Request.ServerVariables("HTTP_Content_Length"))
		'Response.Write("<br />Request.TotalBytes1: " & Request.TotalBytes)
		'Response.Write("<br />Request.TotalBytes2: " & Request.ServerVariables("HTTP_Content_Length"))
		'Response.Write("<br />TypeName(tester1): " & TypeName(tester1))
		'Response.Write("<br />TypeName(tester2): " & TypeName(tester2))
		'Response.Write("<br />vbNewLine: " & vbNewLine)
		'Response.Write("<br />endByte: " & endByte)
		'Response.Write("<br />z: " & z & "<br />")
		'Response.End()


		'Loop through the data block till you reach the file end preamble string (which hopefully is always the same)
		Do Until z = InstrB(1,TheFileData,FilesEnd)

			'Now get the form file control "name" from the html header data...
			'Note: Make sure you get the first name value after content-disposition value in the html header...
			tempByte = InstrB(InstrB(z,TheFileData,StringToByte("Content-Disposition")),TheFileData,StringToByte("name="))

			'Get form field "name" attribute value, beginning AFTER the first double quote
			beginByte = tempByte + 6
			endByte = InstrB(beginByte,TheFileData,StringToByte(Chr(34)))
			theFileName = ByteToString(MidB(TheFileData,beginByte,endByte-beginByte))

			'Check if the "filename" exists (absolute path for the file uploaded from the user's desktop)
			tempFile = InstrB(z,TheFileData,StringToByte("filename="))
			beginByte = tempFile + 10
			endByte = InstrB(beginByte,TheFileData,StringToByte(Chr(34)))
			tempFileName = ByteToString(MidB(TheFileData,beginByte,endByte-beginByte))
			'Get the delimiter at the end of this file, and move onto next one
			tempFilesEnd = InstrB(endByte,TheFileData,FileBreak)

			'TESTING...
			'Response.Write("<hr />theFileName: " & theFileName)
			'Response.Write("<br />tempFile: " & tempFile)
			'Response.Write("<br />tempFileName: " & tempFileName)
			'Response.Write("<br />tempFilesEnd: " & tempFilesEnd & "<hr />")

			If ((tempFile <> 0) and (tempFile < tempFilesEnd) and (tempFileName <> "")) Then

				Set theFileToSave = New SaveFile

				'Save file name after last backslash in the filename...
				theFileToSave.FileName = Right(tempFileName,Len(tempFileName)-InStrRev(tempFileName,"\"))

				'Response.Write("<br />NewFileName: " & Right(tempFileName,Len(tempFileName)-InStrRev(tempFileName,"\")))

				'Get the content-type of the site (MIME type)
				tempByte = InstrB(endByte,TheFileData,StringToByte("Content-Type:"))
				beginByte = tempByte + 14
				'Note: After the content-type, the file data begins, and a line-break should appear there
				endByte = InstrB(beginByte,TheFileData,StringToByte(vbNewLine))
				theFileToSave.ContentType = ByteToString(MidB(TheFileData,beginByte,endByte-beginByte))

				'Response.Write("<br />ContentType: " & ByteToString(MidB(TheFileData,beginByte,endByte-beginByte)))

				'Now get the files actual binary data...
				beginByte = endByte + 4
				endByte = InstrB(beginByte,TheFileData,FileBreak) - 2
				theFileToSave.FileData = MidB(TheFileData,beginByte,endByte-beginByte)
				If (theFileToSave.FileSize > 0) Then
					'Add file to dictionary object as name-value pair (and then go get next file)
					TheFiles.Add LCase(theFileName),theFileToSave
				End If

			End If

			'Go to end of this file, and start at next one...
			z = InstrB(z + LenB(FileBreak),TheFileData,FileBreak)

		Loop
	End Sub

	'Takes a string (or ANSI character code) and converts each letter/number into a BYTE, and concatenates them as a series of bytes, which forms a mutil-byte pattern that can be used for searching for a sepcific byte pattern in a byte array elsewhere.
	Private Function StringToByte(theString)
		Dim x
		StringToByte = null
		For x = 1 to Len(theString)
		   StringToByte = StringToByte & ChrB(AscB(Mid(theString,x,1)))
		Next
	End Function

	'Converts byte data back to string of characters
	Private Function ByteToString(theByte)
		Dim x
		ByteToString =""
		For x = 1 to LenB(theByte)
		   ByteToString = ByteToString & Chr(AscB(MidB(theByte,x,1))) 
		Next
	End Function

	'Close objects when terminating the class instance
	Private Sub Class_Terminate()
		If IsObject(TheFiles) Then
			TheFiles.RemoveAll()
			Set TheFiles = Nothing
		End If
	End Sub

End Class
'==========================================================


'===================== Uploaded File Class =================
Class SaveFile

	Public ContentType
	Public FileName
	Public FileData

	Public Property Get FileSize()
		FileSize = LenB(FileData)
	End Property

	Public Sub SaveToDisk(thePath)
		Dim theFile,theTextFile
		If (thePath = "" or FileName = "") then
			Exit Sub
		End If
		If (Mid(thePath, Len(thePath)) <> "\") then
			thePath = thePath & "\"
		End If
		Set theFile = Server.CreateObject("Scripting.FileSystemObject")
		If (Not theFile.FolderExists(thePath)) then
			Exit Sub
		End If
		Set theTextFile = theFile.CreateTextFile(thePath & FileName, True)
		theTextFile.Write BufferContent(FileData)
		theTextFile.Close
		Set	theTextFile = Nothing
		Set	theFile = Nothing
	End Sub

	Function BufferContent(theStream)
		Dim theArray(64),c
		Call ClearString(theArray)
		For c = 1 To LenB(theStream)
			Call AddString(theArray,Chr(AscB(MidB(theStream,c,1))))
		Next
		BufferContent = GetStringArray(theArray)
	End Function

	Sub ClearString(theArray)
		Dim c
		For c = 0 to 64
			theArray(c) = ""
		Next
	End Sub

	Sub AddString(theArray,theString)
		Dim temp
		Dim x
		theArray(0) = theArray(0) & theString
		If Len(theArray(0)) > 64 Then
			x=0
			temp=""
			Do
				temp=theArray(x) & temp
				theArray(x) = ""
				x = x + 1
			Loop until theArray(x) = ""
			theArray(x) = temp
		End If
	End Sub

	Function GetStringArray(theArray)
		Dim temp
		Dim x
		temp = ""
		For x = 0 to 64
			If theArray(x) <> "" Then
				temp = theArray(x) & temp
			End If
		Next
		GetStringArray = temp
	End Function

End Class
'=======================================================
%>

